#include "lib_at25df021.h"

// Generic SPI commands
void spi_write_bytes(uint8_t spi_command, uint8_t *data_ptr, uint8_t data_len)
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(spi_command);
  while(data_len--) hal_spi_master_read_write(*data_ptr++);
  SPI_CHIP_SELECT = 1;
}
void spi_read_bytes(uint8_t spi_command, uint8_t *data_ptr, uint8_t data_len)
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(spi_command);
  while(data_len--) *data_ptr++ = hal_spi_master_read_write(0);
  SPI_CHIP_SELECT = 1;
}
void spi_write_bytes_at_address(uint8_t spi_command, uint8_t *addr_ptr, uint8_t *data_ptr, uint8_t data_len)
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(spi_command);
  hal_spi_master_read_write(addr_ptr[2]);
  hal_spi_master_read_write(addr_ptr[1]);
  hal_spi_master_read_write(addr_ptr[0]);
  while(data_len--) hal_spi_master_read_write(*data_ptr++);
  SPI_CHIP_SELECT = 1;
}
void spi_read_bytes_at_address(uint8_t spi_command, uint8_t *addr_ptr, uint8_t *data_ptr, uint8_t data_len)
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(spi_command);
  hal_spi_master_read_write(addr_ptr[2]);
  hal_spi_master_read_write(addr_ptr[1]);
  hal_spi_master_read_write(addr_ptr[0]);
  while(data_len--) *data_ptr++ = hal_spi_master_read_write(0);
  SPI_CHIP_SELECT = 1;
}

// AT25-spesific commands
uint8_t at25_wait_until_ready()
{
  uint8_t status;
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(AT25_READ_STATUS_REGISTER);
  while(((status = hal_spi_master_read_write(0)) & 0x01) != 0);
  SPI_CHIP_SELECT = 1;
  if((status & 0x20) == 0) return FLASH_OPERATION_OK;
  else return FLASH_OPERATION_FAILED;
}
uint8_t at25_read_byte(uint8_t block_num_64k, uint16_t address_in_block)
{
  uint8_t address[3], read_byte;
  address[2] = block_num_64k;
  address[1] = address_in_block >> 8;
  address[0] = (uint8_t)address_in_block;
  spi_read_bytes_at_address(AT25_READ_ARRAY, address, &read_byte, 1);
  at25_wait_until_ready();
  return read_byte;  
}
uint8_t at25_read_bytes(uint8_t block_num_64k, uint16_t address_in_block, uint8_t *data_ptr, uint8_t data_len)
{
  uint8_t address[3];
  address[2] = block_num_64k;
  address[1] = address_in_block >> 8;
  address[0] = (uint8_t)address_in_block;
  spi_read_bytes_at_address(AT25_READ_ARRAY, address, data_ptr, data_len);
  return at25_wait_until_ready();
}

void at25_block_erase_4kb(uint8_t block_num_4k)
{
  uint8_t address[3] = {0x00, 0x00, 0x00};
  address[2] = block_num_4k << 4;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_BLOCK_ERASE_4KB, address, NULL, 0);
  at25_wait_until_ready();
}
void at25_block_erase_32kb(uint8_t block_num_32k)
{
  uint8_t address[3] = {0x00, 0x00, 0x00};
  address[2] = block_num_32k << 1;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_BLOCK_ERASE_32KB, address, NULL, 0);
  at25_wait_until_ready();
}

void at25_block_erase_64kb(uint8_t block_num_64k)
{
  uint8_t address[3] = {0x00, 0x00, 0x00};
  address[2] = block_num_64k;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_BLOCK_ERASE_64KB, address, NULL, 0);
  at25_wait_until_ready();
}

void at25_chip_erase()
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(AT25_CHIP_ERASE);
  SPI_CHIP_SELECT = 1;
}

uint8_t at25_program_byte(uint8_t block_num_64k, uint16_t address_in_block, uint8_t data_byte)
{
  uint8_t address[3];
  address[2] = block_num_64k;
  address[1] = address_in_block >> 8;
  address[0] = (uint8_t)address_in_block;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_BYTE_PAGE_PROGRAM, address, &data_byte, 1);
  return at25_wait_until_ready();
}

uint8_t at25_program_bytes(uint8_t block_num_64k, uint16_t address_in_block, uint8_t *data_ptr, uint8_t data_len)
{
  uint8_t address[3];
  address[2] = block_num_64k;
  address[1] = address_in_block >> 8;
  address[0] = (uint8_t)address_in_block;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_BYTE_PAGE_PROGRAM, address, data_ptr, data_len);
  return at25_wait_until_ready();
}

//uint8_t at25_program_page(uint8_t *address, uint8_t *data_ptr);

void at25_write_enable()
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(AT25_WRITE_ENABLE);
  SPI_CHIP_SELECT = 1;
}

void at25_write_disable()
{
  SPI_CHIP_SELECT = 0;
  hal_spi_master_read_write(AT25_WRITE_DISABLE);
  SPI_CHIP_SELECT = 1;
}

void at25_protect_sector(uint8_t block_num_64k)
{
  uint8_t address[3] = {0x00, 0x00, 0x00};
  address[2] = block_num_64k << 4;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_PROTECT_SECTOR, address, NULL, 0);
}
void at25_unprotect_sector(uint8_t block_num_64k)
{
  uint8_t address[3] = {0x00, 0x00, 0x00};
  address[2] = block_num_64k << 4;
  at25_write_enable();
  spi_write_bytes_at_address(AT25_UNPROTECT_SECTOR, address, NULL, 0);
}

uint8_t at25_read_status_register()
{
  uint8_t status_reg;
  spi_read_bytes(AT25_READ_STATUS_REGISTER, &status_reg, 1);
  return status_reg;
}

void at25_read_manufacturer_and_device_id(uint8_t *data_ptr)
{
  spi_read_bytes(AT25_READ_MANUFACTURER_AND_DEVICE_ID, data_ptr, 4);
}

void at25_write_status_register();
void at25_deep_power_down();
void at25_resume_from_deep_power_down();