#ifndef __AT25DF021_CONTROL__
#define __AT25DF021_CONTROL__
#include <stdint.h>
#include "reg24le1.h"
#include "hal_spi.h"

#define SPI_CHIP_SELECT P00

#define AT25_READ_ARRAY                       0x03
#define AT25_BLOCK_ERASE_4KB                  0x20
#define AT25_BLOCK_ERASE_32KB                 0x52
#define AT25_BLOCK_ERASE_64KB                 0xD8
#define AT25_CHIP_ERASE                       0x60
#define AT25_BYTE_PAGE_PROGRAM                0x02
#define AT25_WRITE_ENABLE                     0x06
#define AT25_WRITE_DISABLE                    0x04
#define AT25_PROTECT_SECTOR                   0x36
#define AT25_UNPROTECT_SECTOR                 0x39
#define AT25_READ_STATUS_REGISTER             0x05
#define AT25_WRITE_STATUS_REGISTER            0x01
#define AT25_READ_MANUFACTURER_AND_DEVICE_ID  0x9F
#define AT25_DEEP_POWER_DOWN                  0xB9
#define AT25_RESUME_FROM_DEEP_POWER_DOWN      0xAB

enum {FLASH_OPERATION_OK, FLASH_OPERATION_FAILED};


void spi_write_bytes(uint8_t spi_command, uint8_t *data_ptr, uint8_t data_length);
void spi_read_bytes(uint8_t spi_command, uint8_t *data_ptr, uint8_t data_length);

void spi_write_bytes_at_address(uint8_t spi_command, uint8_t *addr_ptr, uint8_t *data_ptr, uint8_t data_len);
void spi_read_bytes_at_address(uint8_t spi_command, uint8_t *addr_ptr, uint8_t *data_ptr, uint8_t data_len);

uint8_t at25_read_byte(uint8_t block_num_64k, uint16_t address_in_block);
uint8_t at25_read_bytes(uint8_t block_num_64k, uint16_t address_in_block, uint8_t *data_ptr, uint8_t data_len);
void at25_block_erase_4kb(uint8_t block_num);
void at25_block_erase_32kb(uint8_t block_num);
void at25_block_erase_64kb(uint8_t block_num);
void at25_chip_erase();
uint8_t at25_program_byte(uint8_t block_num_64k, uint16_t address_in_block, uint8_t data_byte);
uint8_t at25_program_bytes(uint8_t block_num_64k, uint16_t address_in_block, uint8_t *data_ptr, uint8_t data_len);
uint8_t at25_program_page(uint8_t *address, uint8_t *data_ptr);
void at25_write_enable();
void at25_write_disable();
void at25_protect_sector(uint8_t block_num);
void at25_unprotect_sector(uint8_t block_num);

uint8_t at25_read_status_register();
void at25_write_status_register();
void at25_read_manufacturer_and_device_id(uint8_t *data_ptr);
void at25_deep_power_down();
void at25_resume_from_deep_power_down();

#endif