#include "lib_m24c32.h"

uint8_t m24c32_write_byte(uint16_t address, uint8_t databyte)
{
  xdata uint8_t data_string[3];
  data_string[0] = (uint8_t)(address >> 8);
  data_string[1] = (uint8_t)(address);
  data_string[2] = databyte;
  return hal_w2_write_bytes(M24C32_I2C_ADDRESS, data_string, 3);
}
uint8_t m24c32_write_bytes(uint16_t address, uint8_t *data_ptr, uint8_t data_len)
{
  xdata uint8_t data_string[34], i;
  data_string[0] = (uint8_t)(address >> 8);
  data_string[1] = (uint8_t)(address);
  for( i = 0; i < data_len; i++ ) data_string[i+2] = data_ptr[i];
  return hal_w2_write_bytes(M24C32_I2C_ADDRESS, data_string, data_len + 2);
}
uint8_t m24c32_read_byte(uint16_t address)
{
  uint8_t tx_string[2], return_data;
  tx_string[0] = (uint8_t)(address >> 8);
  tx_string[1] = (uint8_t)(address);
  hal_w2_write_and_read_bytes(M24C32_I2C_ADDRESS, tx_string, 2, &return_data, 1);
  return return_data;
}
uint8_t m24c32_read_bytes(uint16_t address, uint8_t *data_ptr, uint8_t data_len)
{
  uint8_t tx_string[2];
  tx_string[0] = (uint8_t)(address >> 8);
  tx_string[1] = (uint8_t)(address);
  return hal_w2_write_and_read_bytes(M24C32_I2C_ADDRESS, tx_string, 2, data_ptr, data_len);
}
void m24c32_wait_until_ready()
{
  while(!hal_w2_test_address(M24C32_I2C_ADDRESS));
}
