#/*********************** (c) 2003 STMicroelectronics *************************
#
# Project: AC Induction motor drive Software Library
#
# VERSION: Prototype 0
#
# AUTHOR:	Consumer & Micro Group
#			Microcontroller Division Applications
#
# DESCRIPTION: GNU Makefile for COSMIC ST7 C-Compiler
#
#*****************************************************************************/


# NAME OF APPLICATION:
APPLI_NAME = PMACMOTOR
MAKEFILE = PMACMOTOR.mak
MEMORY_SIZE = 32K


# C-COMPILER:

COMPILER = cxst7


# OPTIONC FOR C-COMPILER:
C_OPTIONS = +modms -l +debug +strict +split -i ..\..\source -co ..\..\object\cosmic

CC = $(COMPILER) $(C_OPTIONS)


# LINKER:

LINKER = clnk

# OPTIONS FOR LINKER:

LINK_OPTIONS = -o ..\..\object\cosmic\$(APPLI_NAME).st7 -m ..\..\object\cosmic\$(APPLI_NAME).map


# FORMATER:

HEX = chex


# OPTIONS FOR FORMATER:

HEXOPTIONS = -o ..\..\object\cosmic\$(APPLI_NAME).s19


# ELF/DWAF FORMATER:

ELFCONV = cvdwarf.exe



#/*****************************************************************************
#
# LIST OF C-SOURCE FILES
#
# ****************************************************************************/
# C-SOURCE FILE LIST: (don't change this keyword!)

C_SRC = \
        main.c \
        acmotor.c \
        pwmart.c \
        mtc.c \
        sci.c \
		  ports.c \
		  adc.c \
		  ST7_Misc.c \
        vector.c

# END (don't delete this keyword!)


# ASSEMBLER SOURCE FILE LIST:

ASM_SRC =


# LIBRARY SOURCE FILE LIST:

LIBS =


# LIST OF DIRCTORIES TO BE SEARCHED:

vpath %.c ..\..\source
vpath %.h ..\..\source
vpath %.h C:\COSMIC\ST7\lib 
vpath %.o ..\..\object\cosmic
vpath %   ..\..\config\cosmic


# LOCATION OF INCLUDE FILES. DO NOT LEAVE THIS VARIABLE EMPTY
# if you do not need it, remove it or comment it

INCDIR = ..\..\source


DEP = $(APPLI_NAME).dep


# LIST OF OBJECT FILES:

OBJ_LIST = $(patsubst %.c, %.o,$(C_SRC)) \
	$(patsubst %.asm, %.o,$(ASM_SRC))


# RULE FOR BUILDING THE TARGET:

$(APPLI_NAME).st7 : $(OBJ_LIST) $(LIBS) $(MEMORY_SIZE).lkf
	@command.com /c ECHO Linking object files ...
	@$(LINKER) $(LINK_OPTIONS) $(MEMORY_SIZE).lkf


# RULE FOR MAKING THE HEX FILES

$(APPLI_NAME).s19 : $(APPLI_NAME).st7
	@command.com /c ECHO generate elf format file ...
	@$(ELFCONV) ..\..\object\cosmic\$(APPLI_NAME).st7
	@command.com /c ECHO generate s19 file...
	@$(HEX) $(HEXOPTIONS) ..\..\object\cosmic\$(APPLI_NAME).st7



#/*****************************************************************************
#
# LIST OF DEPENDENCIES 
#
#
# ****************************************************************************/
# RULES FOR MAKING THE OBJECT FILES: (don't change this keyword!)

main.o: main.c lib.h ports.h adc.h pwmart.h Sci.h mtc.h acmotor.h config.h Mainparam.h ST7FMC2N6.h
	 $(CC) ..\..\source\main.c

mtc.o: mtc.c lib.h mtc.h MTCparam.h mtc_bits.h ST7FMC2N6.h pwmart.h config.h
	 $(CC) ..\..\source\mtc.c

acmotor.o: acmotor.c lib.h mtc.h PMACparam.h acmotor.h pwmart.h
	 $(CC) ..\..\source\acmotor.c

sci.o: Sci.c ST7FMC2N6.h Sci.h
	 $(CC) ..\..\source\sci.c

pwmart.o: pwmart.c lib.h ST7FMC2N6.h pwmart.h
	 $(CC) ..\..\source\pwmart.c

ports.o : ports.c lib.h ports.h ST7FMC2N6.h pwmart.h
	 $(CC) ..\..\source\ports.c

adc.o : adc.c lib.h ST7FMC2N6.h
	 $(CC) ..\..\source\adc.c

ST7_Misc.o : ST7_Misc.c ST7_Misc.h ST7FMC2N6.h lib.h
	 $(CC) ..\..\source\ST7_Misc.c

vector.o: vector.c
	 $(CC) ..\..\source\vector.c 
	 

# END OBJECT FILE RULES (don't delete this keyword!)


# RULE FOR BUILDING PROJECT:

build:
	gmake -f $(APPLI_NAME).mak $(APPLI_NAME).s19


# RULE FOR REBUILDING PROJECT:

rebuild:
	gmake -f $(APPLI_NAME).mak clean


# RULE FOR CLEANING THE APPLICATION:

.PHONY: clean
clean:
	@command.com /c ECHO delete object files ...
	if exist ..\..\object\cosmic\*.o del ..\..\object\cosmic\*.o
	if exist ..\..\object\cosmic\*.ls del ..\..\object\cosmic\*.ls
	if exist ..\..\object\cosmic\*.elf del ..\..\object\cosmic\*.elf
	if exist ..\..\object\cosmic\*.st7 del ..\..\object\cosmic\*.st7
	if exist ..\..\object\cosmic\*.map del ..\..\object\cosmic\*.map
	gmake -f $(APPLI_NAME).mak $(APPLI_NAME).s19

#/**************** END OF FILE *** (c) 2003  STMicroelectronics **************/