#**************** (c) 2003  STMicroelectronics ********************************
# PROJECT  : 3-phase AC induction motor drive Software Library
#
# COMPILER : METROWERKS
#
# VERSION :  proto 1
#
# AUTHOR :	V. Onde / Microcontroller Division Applications
# 			Consumer & Micro Group
#
# DESCRIPTION :  Makefile for Metrowerks ST7 C-Compiler
# *****************************************************************************
# THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
# SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
# WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
# *****************************************************************************

# ---------------------------- PROJECT NAME -----------------------------------
PROJECT = pmacmotor


# ------------------------ TOOLS PATHS DEFINITION -----------------------------
TOOLS_PATH = C:\Metrowerks\CodeWarrior_STM_V1.1\Prog

# ---------------------------- COMMANDS DEFINITION ----------------------------
COMP = $(TOOLS_PATH)\Cst7.exe
LINK = $(TOOLS_PATH)\Linker.exe
BURN = $(TOOLS_PATH)\Burner.exe

# ------------------------------- COMPILER OPTIONS ----------------------------
# Basic
#COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst
# Highest density code
COMPOPTIONS = -N -Cc -Ml -F7 -Lasm=%n.lst -Os -Ou -Of -Ol0 -OnPMNC -Or
# Lowest debug complexity
#COMPOPTIONS = -N -Cc -Ml -F7 -Lm -Lasm=%n.lst -Os -Onu -Onf -Ol0 -Onbt -Onca -Oncn -One -Ont=

# -------------------------- EXECUTABLE COMMAND DEFINES -----------------------
ENV = default.env
CC  = $(COMP) $(COMPOPTIONS)    

# ----------------------------- OBJECT FILES LIST -----------------------------
OBJ_LIST  = main.o mtc.o acmotor.o sci.o pwmart.o ports.o adc.o ST7_Misc.o

# -------------------------------- LINK ---------------------------------------
# -B forces linker to produce executable file with same name than abs file
$(PROJECT).abs : $(ENV) $(OBJ_LIST) $(PROJECT).prm
    $(LINK) -B $(PROJECT).prm

# --------------------------- APPLICATION FILES -------------------------------
main.o : $(ENV) main.c lib.h ports.h adc.h pwmart.h sci.h mtc.h acmotor.h \
			config.h MainParam.h ST7FMC2N6.h
    $(CC) main.c
    
mtc.o : $(ENV) mtc.c lib.h mtc.h MTCparam.h mtc_bits.h ST7FMC2N6.h pwmart.h config.h
    $(CC) mtc.c

acmotor.o : $(ENV) acmotor.c lib.h mtc.h PMACparam.h acmotor.h pwmart.h
    $(CC) acmotor.c

sci.o : $(ENV) sci.c ST7FMC2N6.h Sci.h  
    $(CC) sci.c 

pwmart.o : $(ENV) pwmart.c lib.h ST7FMC2N6.h pwmart.h
    $(CC) pwmart.c 

ports.o : $(ENV) ports.c lib.h ports.h ST7FMC2N6.h pwmart.h
    $(CC) ports.c

adc.o : $(ENV) adc.c adc.h lib.h ST7FMC2N6.h
    $(CC) adc.c

ST7_Misc.o : $(ENV) ST7_Misc.c ST7_Misc.h lib.h ST7FMC2N6.h
    $(CC) ST7_Misc.c

#**** (c) 2003  ST Microelectronics ***************** END OF FILE *************