/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase PMAC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  MTCParam.h
VERSION :  Release 1.0.0

CREATION DATE :    //  :

AUTHOR :	Microcontroller Division Applications
			Consumer & Micro Group

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Contains the PMAC Motor control library parameters
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef MTC_PRM
#define MTC_PRM

#include "config.h"

	#define MTC_CLOCK	((u32)16000000) 	/* Resolution: 1Hz */


///////////////////////////// Motor Pole pairs ////////////////////////////////
	#define	POLE_PAIR_NUM 	((u8)2) /* Number of motor's poles pair */

///////////////////////////// Hall Sensor Settings ////////////////////////////
        #define HALL_SENSOR_NUM 1 /* Number of Hall Sensors */ 
        
//////////////////////////////// Speed Sensor /////////////////////////////////
	#define	PULSE_PER_REV	((u8) ( HALL_SENSOR_NUM * 2 * POLE_PAIR_NUM)) /* Number of pulses per revolution given by tachogenerator */
	#define	ROTOR_SPEED_FACTOR	((u32) ( POLE_PAIR_NUM * ( MTC_CLOCK * 10 ) / PULSE_PER_REV ) )
	#define	SPEED_OVERFLOW		((u16) ( ROTOR_SPEED_FACTOR / 0xFFFF ))
	#define SPEED_FIFO_SIZE 	((u8)(4 * HALL_SENSOR_NUM))
	
///////////////////////////// PWM Frequency ///////////////////////////////////
	#define CENTER_ALIGNED  	2   // Definitions of PWM patterns type
	#define EDGE_ALIGNED    	1

	#define PATTERN_TYPE	CENTER_ALIGNED


	#ifdef PWM_10BIT
		#define PWM_MCP0 ((u16)640)
		u8 OFFSET @0x0a;	// Trick to access OFFSET constant in assembly with immediate adressing mode
	#else
	#ifdef PWM_9BIT
		#define PWM_MCP0 ((u16)512)
		u8 OFFSET @0x08;	// Trick to access OFFSET constant in assembly with immediate adressing mode
	#endif
	#endif
        
        #define REP_RATE ((u8)3)	/* This defines the number of update interrupts per half PWM period */
        
        // Prescaler ratio defines PWM frequency in a rough way:
	// 0 -> 15.66kHz, 12.5 kHz (depending on CMP0 value)
	// 1 -> 7.8kHz
	// 3 -> 3.9kHz
	// 7 -> 1.95kHz
	#define PWM_PRSC ((u8)0)
	
	#if  (PATTERN_TYPE == CENTER_ALIGNED)
		#define PWM_FREQ ((u16) (MTC_CLOCK * 2 / (u32)(PATTERN_TYPE * PWM_MCP0 *(PWM_PRSC+1)*(REP_RATE+1)))) 
		// Resolution: 1Hz 
	#else	
		#define PWM_FREQ ((u16) (MTC_CLOCK * 2 / (u32)(PATTERN_TYPE * (PWM_MCP0+1) *(PWM_PRSC+1)*(REP_RATE+1)))) 
		// Resolution: 1Hz 
	#endif
	
	#define STATOR_FREQ_RESOL ((u16) (((u32) PWM_FREQ * 10 ) / 256) )	/* To convert freq Cmd into appropriate unit */

////////////////////////////// Deadtime Value /////////////////////////////////
	#define DEADTIME	((u8)4)



////////////////////// Other Settings not modified by GUI /////////////////////
	#define PHASE_SHIFT	((s8)85)		// (85/256) * 360 = 120 degrees
	#define MAX_RATIO		((u8)7)    // Max MTIM prescaler ratio defining the lowest expected speed feedback
        
        #define L6386_POLARITY	((u8)0x3F)		/* Positive logic for L6386D drivers: PWM low state = Switch OFF */
	#define NEGATIVE_POLARITY	((u8)0x00)	/* Negative logic level: PWM low state = Switch ON */
	
	#define DRIVERS_POLARITY L6386_POLARITY


                                                       
// PMAC Tables 
#if (HALL_SENSOR_NUM == 3)
	const u16 PhaseVal[]={0,10923,21845,32768,43691,54613};
#endif
#if (HALL_SENSOR_NUM == 2)
	const u16 PhaseVal[]={0,16384,32768,49152};
#endif 
#if (HALL_SENSOR_NUM == 1)
	const u16 PhaseVal[]={0,32768};
#endif
#endif	/* MTC_PRM */

/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/

