/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase PMAC motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  ACMParam.h
VERSION :  Release 1.0.0

CREATION DATE :    //  :

AUTHOR :	Microcontroller Division Applications
			Consumer & Micro Group

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Contains the PMAC Motor control library parameters
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/
#ifndef ACM_PRM
#define ACM_PRM   

///////////////////////// Sinewave frequency Range //////////////////////////////
	#define HIGHEST_FREQ	((u16)5000)	/* Sinewave Max Frequency (max theorical: 65535) */
	#define LOWEST_FREQ	((u16)5) /* Sinewave Min Frequency */

///////////////////////////// General Start-Up conditions //////////////////////////////
	#define	VOLT_SLEWRATE ((u8)20)   /* Slope of startup voltage */
	#define STARTUP_STATOR_FREQ ((u16) 50) /* Frequency of the Asyncronous phase of starup must be major or equal than LOWEST_FREQ*/
	#define CLOSEDLOOP_MIN_FREQ ((u16) 20) /* Minimum frequency to validate closed loop */
        #define INIT_START_VOLTAGE 50
        #define STATOR_VOLTAGE ((u8) 255) /* Start up max value of stator voltage */
	#define START_TIMEOUT	((u16)5000)  	/* Resolution: 1ms */
	
///////////////////////////// Closed Loop Target Frequency ////////////////////
	#define TARGET_FREQ_CL 1500
	
//////////////////////////////// Phase Angle //////////////////////////////////
	#define PHASE_ANGLE_RV3 /* If defined the Phase angle is read by RV3  */
	
	#ifdef PI_PARAM_TUNING
		#ifdef PHASE_ANGLE_RV3
			#error "PI_PARAM_TUNING can't be enabled together with PHASE_ANGLE_RV3!"
		#endif
	#endif
	
	#define PHI_MIN	(u8) 22
	#define PHI_MAX (u8) 22
	#define PHI_LOWFREQ   500
	#define PHI_HIGHFREQ  2500

	#define coeff_phase	((s32)(PHI_MAX-PHI_MIN)*256)/((s32)(PHI_HIGHFREQ-PHI_LOWFREQ))
	
///////////////////////////////// Alignment Phase /////////////////////////////	
	//#define ALIGNMENT_PHASE /* Remark alignment isn't required */
	#define ALIGNMENT_DUTY  128 /* Final value of duty during alignment */
				    /* The alignment duration is ALIGNMENT_DUTY * 10ms */
				    
	#define SLEW_LIMIT	((u8)10)	/* Voltage and frequency increment/decrement 
						rate in ms */  
						
///////////////////////////////// V/f curve ///////////////////////////////////
// IMPORTANT CAUTION: if "VF_OFFSET + HIGHFREQ_LIMIT * VF_COEFF" value is
// greater than 0xFFFF, user should modify data type of variable Buffer inside
// ACM_VoltageMaxAllowed function; by default, it is set as U16     

	#define V_F_LIM // Uncomment to enable V/F limitation

	#define  V_MAX ((u8)255)
	#define  V_MIN ((u8)50)
	#define VF_LOWFREQ_LIMIT ((u16)200)	// Resolution: 0.1Hz
	#define VF_HIGHFREQ_LIMIT ((u16)1200)	// Resolution: 0.1Hz
	// NOTA: multiplication by 256 is here to keep sufficient accuracy
	#define VF_COEFF ((u16) ( (u16)256 * ( V_MAX - V_MIN ) ) / ( VF_HIGHFREQ_LIMIT - VF_LOWFREQ_LIMIT ) )
	#define VF_OFFSET ((u16) VF_COEFF * VF_LOWFREQ_LIMIT )


/* ------------------- ACM_GetPIParam constants ------------------------ */
#define  PI_PROP_LOWSPD      	((u8)200)
#define  PI_PROP_HIGHSPD	((u8)200)

#define  PI_INT_LOWSPD      	((u8)10)
#define  PI_INT_HIGHSPD		((u8)10)

#define  PI_LOWFREQ_LIMIT       ((u16)250)
#define  PI_HIGHFREQ_LIMIT      ((u16)1000)   

#define  PI_PROP_COEFF  ((u16) ( (u16)256 * ( PI_PROP_LOWSPD - PI_PROP_HIGHSPD ) ) / ( PI_HIGHFREQ_LIMIT - PI_LOWFREQ_LIMIT ) )
#define  PI_PROP_OFFSET ((u16) PI_PROP_COEFF * PI_LOWFREQ_LIMIT )    
/* NOTA: multiplication by 256 is here to keep sufficient accuracy */

#define  PI_INT_COEFF  ((u16) ( (u16)256 * ( PI_INT_HIGHSPD - PI_INT_LOWSPD ) ) / ( PI_HIGHFREQ_LIMIT - PI_LOWFREQ_LIMIT ) )
#define  PI_INT_OFFSET ((u16) PI_INT_COEFF * PI_LOWFREQ_LIMIT )
/* NOTA: multiplication by 256 is here to keep sufficient accuracy */

#define	REG_LOOP_TIME	((u8)10)

#endif	/* ACM_PRM */

/*** (c) 2004 STMicroelectronics ****************** END OF FILE **************/

