/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : 3-phase PMAC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  mtc.h
VERSION :  Release 1.0.0

CREATION DATE : 

AUTHOR :	Microcontroller Division Applications
			Consumer & Micro Group

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#ifndef ACM_H
#define ACM_H  
/*****************************************************************************/

#include "config.h"

/* Public Constants -------------------------------------------------------- */
	#ifdef PI_PARAM_TUNING
		extern u8	Kp, Ki;
	#endif
/* Public Variables -------------------------------------------------------- */

/* Public type definition -------------------------------------------------- */
typedef enum
{
START_ONGOING,
START_OK,
START_FAIL
} StartStatus_t;
 
 
/* Public Functions prototypes --------------------------------------------- */
void ACM_Init(void);
void ACM_InitSoftStart(void);
StartStatus_t ACM_SoftStart(void);
BOOL ACM_SoftStartOL(u8 TargetVoltage); 
void ACM_InitSpeedReg(u16 FreqRef); 
u8 ACM_SpeedRegulation(u16 RifFreq,u16 currFreq);
void ACM_GetPIParam(u16 StatorFrequency); 
u8 ACM_VoltageMaxAllowed(u16 StatorFrequency);
/* Public  macros ---------------------------------------------------------- */

#endif
/** (c) 2004  STMicroelectronics ***************************** END OF FILE ***/