/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : 3-phase PMAC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  mtc.h
VERSION :  Release 1.5

CREATION DATE : 

AUTHOR :	Microcontroller Division Applications
			Consumer & Micro Group

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/

#ifndef MTC_AC_H
#define MTC_AC_H  
/*****************************************************************************/   

//#include "MTCParam.h"  

/* Public Constants -------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

/* Public type definition -------------------------------------------------- */
typedef enum
{
CLOCKWISE_DIRECTION,
COUNTERCLOCKWISE_DIRECTION
} Direction_t;

extern u16 Shift_Phase;
 
/* Public Functions prototypes --------------------------------------------- */

void	MTC_ResetPeripheral(void);
void	MTC_InitPeripheral(void);
void	MTC_InitSineGen(void);
BOOL	MTC_UpdateSine(u8 NewVoltage, u16 NewFrequency);
u16	MTC_GetStatorFreq(void);
u8	MTC_GetVoltage(void);
u16	MTC_GetRotorFreq(void);
BOOL 	MTC_ValidSpeedInfo( u16 MinRotorFreq );
void 	MTC_InitTachoMeasure(void);
void 	MTC_StartTachoFiltering(void); 
void	MTC_Toggle_Direction(void);
void	MTC_Set_ClockWise_Direction(void);
void	MTC_Set_CounterClockWise_Direction(void);
Direction_t	MTC_GetRotationDirection(void);
void 	MTC_StartBraking( u16 DutyCycle);
void 	MTC_Brake(void);
void 	MTC_StopBraking(void);

BOOL 	MTC_CheckEmergencyStop(void);
void 	MTC_ClearEmergencyStop(void);

void 	MTC_EnableMCOutputs(void);
void 	MTC_DisableMCOutputs(void);    

/* -------------------------- Tacho functions ---------------------------- */
u32 	GetLastTachoPeriod(void);
u32 	GetAvrgTachoPeriod(void);

#endif
/** (c) 2004  STMicroelectronics ***************************** END OF FILE ***/