/**************** (c) 2004  STMicroelectronics **********************
     
PROJECT  : 3-phase PMAC induction motor drive Software Library
COMPILER : COSMIC / METROWERKS

MODULE  :  mtc_bits.h
VERSION :  Release 1.0.0

CREATION DATE : April 2004

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Motor control hardware registers mapping
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/
#ifndef MTC_BITS_H
#define MTC_BITS_H

/* ----------------- Motor Control peripheral dedicated macros ------------- */
#define SET_MTC_PAGE(x) AffBit(MCFR,MCFR_RPGS,x)	/* Set active page of MTC peripheral */
#define ToCMPxH(CMP,Value)         ( CMP = (u8)(Value >> 5 ) )
#define ToCMPxL(CMP,Value)         ( CMP = (u8)(Value << 3 ) )

/*---------------------------------------------------------------------------*/
/*--- MTC peripheral bitfields definition -----------------------------------*/
/*---------------------------------------------------------------------------*/

/* MCRC: MTC Control Register C bit definition */
#define VREF_EXT	((u8)7)		/* Threshold voltage set by external MCVREF pin */
#define VREF_3V5	((u8)6)		/* 3.5V internal threshold voltage */
#define VREF_2V5	((u8)5)		/* 2.5V internal threshold voltage */
#define VREF_2V	((u8)4)		/* 2V internal threshold voltage */
#define VREF_1V5	((u8)3)		/* 1.5V internal threshold voltage */
#define VREF_1V	((u8)2)		/* 1V internal threshold voltage */
#define VREF_0V6	((u8)1)		/* 0.6V internal threshold voltage */
#define VREF_0V2	((u8)0)		/* 0.2V internal threshold voltage */


/* MPHST: MTC Phase State register bit definition */
#define MCO0		((u8)0x01)     	/* MCO0 Channel ON */
#define MCO1		((u8)0x02)     	/* MCO1 Channel ON */
#define MCO2		((u8)0x04)     	/* MCO2 Channel ON */
#define MCO3		((u8)0x08)     	/* MCO3 Channel ON */
#define MCO4		((u8)0x10)     	/* MCO4 Channel ON */
#define MCO5		((u8)0x20)     	/* MCO5 Channel ON */

#define MCIA		((u8)0x00)     	/* MCIA Input selected */
#define MCIB		((u8)0x40)     	/* MCIB Input selected */
#define MCIC		((u8)0x80)     	/* MCIC Input selected */
#define ENCODER	((u8)0xC0)     	/* Encoder mode selection mask */


/* MDFR: MTC Feedback Register */
#define D_FILT_1SMPL	((u8)0x00)		/* 1 D Event Sample Needed */
#define D_FILT_2SMPL	((u8)0x10)		/* 2 Consecutive D Event Samples Needed */
#define D_FILT_3SMPL	((u8)0x20)		/* 3 Consecutive D Event Samples Needed */
#define D_FILT_4SMPL	((u8)0x30)		/* 4 Consecutive D Event Samples Needed */
#define D_FILT_5SMPL	((u8)0x40)		/* 5 Consecutive D Event Samples Needed */
#define D_FILT_6SMPL	((u8)0x50)		/* 6 Consecutive D Event Samples Needed */
#define D_FILT_7SMPL	((u8)0x60)		/* 7 Consecutive D Event Samples Needed */
#define D_FILT_8SMPL	((u8)0x70)		/* 8 Consecutive D Event Samples Needed */
#define D_FILT_9SMPL	((u8)0x80)		/* 9 Consecutive D Event Samples Needed */
#define D_FILT_10SMPL	((u8)0x90)	/* 10 Consecutive D Event Samples Needed */
#define D_FILT_11SMPL	((u8)0xA0)	/* 11 Consecutive D Event Samples Needed */
#define D_FILT_12SMPL	((u8)0xB0)	/* 12 Consecutive D Event Samples Needed */
#define D_FILT_13SMPL	((u8)0xC0)	/* 13 Consecutive D Event Samples Needed */
#define D_FILT_14SMPL	((u8)0xD0)	/* 14 Consecutive D Event Samples Needed */
#define D_FILT_15SMPL	((u8)0xE0)	/* 15 Consecutive D Event Samples Needed */
#define D_FILT_16SMPL	((u8)0xF0)	/* 16 Consecutive D Event Samples Needed */

#define D_WINDOW_5us	((u8)0x00)		/* D Window Filter 5us */
#define D_WINDOW_10us	((u8)0x01)	/* D Window Filter 10us */
#define D_WINDOW_15us	((u8)0x02)	/* D Window Filter 15us */
#define D_WINDOW_20us	((u8)0x03)	/* D Window Filter 20us */
#define D_WINDOW_25us	((u8)0x04)	/* D Window Filter 25us */
#define D_WINDOW_30us	((u8)0x05)	/* D Window Filter 30us */
#define D_WINDOW_35us	((u8)0x06)	/* D Window Filter 35us */
#define D_WINDOW_40us	((u8)0x07)	/* D Window Filter 40us */
#define D_WINDOW_60us	((u8)0x08)	/* D Window Filter 60us */
#define D_WINDOW_80us	((u8)0x09)	/* D Window Filter 80us */
#define D_WINDOW_100us	((u8)0x0A)	/* D Window Filter 100us */
#define D_WINDOW_120us	((u8)0x0B)	/* D Window Filter 120us */
#define D_WINDOW_140us	((u8)0x0C)	/* D Window Filter 140us */
#define D_WINDOW_160us	((u8)0x0D)	/* D Window Filter 160us */
#define D_WINDOW_180us	((u8)0x0E)	/* D Window Filter 180us */
#define D_WINDOW_200us	((u8)0x0F)	/* D Window Filter 200us */


/* MCFR: MTC D Event Filter Register */
#define CURRENT_FILT_1SMPL	((u8)0x00)		/* 1 Current Sample Needed */
#define CURRENT_FILT_2SMPL	((u8)0x08)		/* 2 Consecutive Current Samples Needed */
#define CURRENT_FILT_3SMPL	((u8)0x10)		/* 3 Consecutive Current Samples Needed */
#define CURRENT_FILT_4SMPL	((u8)0x18)		/* 4 Consecutive Current Samples Needed */
#define CURRENT_FILT_5SMPL	((u8)0x20)		/* 5 Consecutive Current Samples Needed */
#define CURRENT_FILT_6SMPL	((u8)0x28)		/* 6 Consecutive Current Samples Needed */
#define CURRENT_FILT_7SMPL	((u8)0x30)		/* 7 Consecutive Current Samples Needed */
#define CURRENT_FILT_8SMPL	((u8)0x38)		/* 8 Consecutive Current Samples Needed */

#define CURRENT_WINDOW_OFF	((u8)0x00)		/* Current Blanking Window OFF */
#define CURRENT_WINDOW_0us5	((u8)0x01)	/* Current Blanking Window 0.5us */
#define CURRENT_WINDOW_1us	((u8)0x02)		/* Current Blanking Window 1us */
#define CURRENT_WINDOW_1us5	((u8)0x03)	/* Current Blanking Window 1.5us */
#define CURRENT_WINDOW_2us 	((u8)0x04)	/* Current Blanking Window 2us */
#define CURRENT_WINDOW_2us5	((u8)0x05)	/* Current Blanking Window 2.5us */
#define CURRENT_WINDOW_3us	((u8)0x06)		/* Current Blanking Window 3us */
#define CURRENT_WINDOW_3us5	((u8)0x07)	/* Current Blanking Window 3.5us */


/* MPRSR: MTC Prescaler and Sampling Register Masks definition */
#define SMPL_50K		((u8)0x00) 	/* Sampling frequency in current Mode */
#define SMPL_40K	   ((u8)0x10) 	/* Sampling frequency in current Mode */
#define SMPL_33K3		((u8)0x20) 	/* Sampling frequency in current Mode */
#define SMPL_25K		((u8)0x30) 	/* Sampling frequency in current Mode */
#define SMPL_20K		((u8)0x40) 	/* Sampling frequency in current Mode */
#define SMPL_18K1		((u8)0x50) 	/* Sampling frequency in current Mode */
#define SMPL_15K4		((u8)0x60) 	/* Sampling frequency in current Mode */
#define SMPL_12K5		((u8)0x70) 	/* Sampling frequency in current Mode */
#define SMPL_10K		((u8)0x80) 	/* Sampling frequency in current Mode */
#define SMPL_6K25		((u8)0x90) 	/* Sampling frequency in current Mode */
#define SMPL_3K13		((u8)0xA0) 	/* Sampling frequency in current Mode */
#define SMPL_1K56		((u8)0xB0) 	/* Sampling frequency in current Mode */
#define SMPL_1K25		((u8)0xC0) 	/* Sampling frequency in current Mode */
#define SMPL_961		((u8)0xD0) 	/* Sampling frequency in current Mode */
#define SMPL_625		((u8)0xD0) 	/* Sampling frequency in current Mode */
#define SMPL_390		((u8)0xF0) 	/* Sampling frequency in current Mode */


/* MPAR: MTC Parity Register */
#define TACHO_RISING	((u8)0x40)		/* Speed Sensor, Rising edge sensitive */
#define TACHO_FALLING	((u8)0x80)	/* Speed Sensor, Falling edge sensitive */
#define TACHO_BOTH_EDGE	((u8)0xC0)	/* Speed Sensor, both edge sensitive */


/* MPOL: MTC Polarity Register bit definition */
#define ALL_ACTIVE_HIGH	((u8)0x3F)	/* All switch drivers having positive logic inputs */


/* MDTG: MTC Dead Time Generator Register bit definition*/
#define PCN		((u8)0x07)		/* PWM Channel number/motor select */
#define DTE		((u8)0x06)		/* Dead Time Generator Enable */


/* MPWME: MTC PWM Enable Register bit definition*/
#define DG		((u8)0x07)		/* Debug option	*/
#define MPWMW	((u8)0x06)		/* PWM W output control bit */
#define MPWMV	((u8)0x05)		/* PWM W output control bit */
#define MPWMU	((u8)0x04)		/* PWM W output control bit */

#define DG_MSK		((u8)0x80)		/* Debug option	Mask */
#define MPWMW_MSK	((u8)0x40)		/* PWM W output control bit Mask */
#define MPWMV_MSK	((u8)0x20)		/* PWM W output control bit Mask */
#define MPWMU_MSK	((u8)0x10)		/* PWM W output control bit Mask */

#define T_OFF_2us5		((u8)0x00)	/* 2.5us Min Off Time in current mode */
#define T_OFF_5us			((u8)0x01)	/* 5us Min Off Time in current mode */
#define T_OFF_7us5		((u8)0x02)	/* 7.5us Min Off Time in current mode */
#define T_OFF_10us		((u8)0x03)	/* 10us Min Off Time in current mode */
#define T_OFF_12us5		((u8)0x04)	/* 12.5us Min Off Time in current mode */
#define T_OFF_15us		((u8)0x05)	/* 15us Min Off Time in current mode */
#define T_OFF_17us5		((u8)0x06)	/* 17.5us Min Off Time in current mode */
#define T_OFF_20us		((u8)0x07)	/* 20us Min Off Time in current mode */
#define T_OFF_22us5		((u8)0x08)	/* 22.5us Min Off Time in current mode */
#define T_OFF_25us		((u8)0x09)	/* 25us Min Off Time in current mode */
#define T_OFF_27us5		((u8)0x0A)	/* 27.5us Min Off Time in current mode */
#define T_OFF_30us		((u8)0x0B)	/* 30us Min Off Time in current mode */
#define T_OFF_32us5		((u8)0x0C)	/* 32.5us Min Off Time in current mode */
#define T_OFF_35us		((u8)0x0D)	/* 35us Min Off Time in current mode */
#define T_OFF_37us5		((u8)0x0E)	/* 37.5us Min Off Time in current mode */
#define T_OFF_40us		((u8)0x0F)	/* 40us Min Off Time in current mode */

/* MCONF: MTC Configuration register */
#define MCONF_SOI 3	/* Sampling Out Flag */
#define MCONF_SOI_OR (1 << MCONF_SOI)

#define MCONF_SOM 2	/* Sampling Out Mask */
#define MCONF_SOM_OR (1 << MCONF_SOM)

#define MCONF_XT16 1	/* Peripheral Input frequency selection bit 1 */
#define MCONF_XT16_OR (1 << MCONF_XT16)

#define MCONF_XT8 0  /* Peripheral Input frequency selection bit 0 */
#define MCONF_XT8_OR (1 << MCONF_XT8)

/* MZFR: MTC Z Event Filter Register */
#define Z_FILT_1SMPL	((u8)0x00)		/* 1 Z Event Sample Needed */
#define Z_FILT_2SMPL	((u8)0x10)		/* 2 Consecutive Z Event Samples Needed */
#define Z_FILT_3SMPL	((u8)0x20)		/* 3 Consecutive Z Event Samples Needed */
#define Z_FILT_4SMPL	((u8)0x30)		/* 4 Consecutive Z Event Samples Needed */
#define Z_FILT_5SMPL	((u8)0x40)		/* 5 Consecutive Z Event Samples Needed */
#define Z_FILT_6SMPL	((u8)0x50)		/* 6 Consecutive Z Event Samples Needed */
#define Z_FILT_7SMPL	((u8)0x60)		/* 7 Consecutive Z Event Samples Needed */
#define Z_FILT_8SMPL	((u8)0x70)		/* 8 Consecutive Z Event Samples Needed */
#define Z_FILT_9SMPL	((u8)0x80)		/* 9 Consecutive Z Event Samples Needed */
#define Z_FILT_10SMPL	((u8)0x90)		/* 10 Consecutive Z Event Samples Needed */
#define Z_FILT_11SMPL	((u8)0xA0)		/* 11 Consecutive Z Event Samples Needed */
#define Z_FILT_12SMPL	((u8)0xB0)		/* 12 Consecutive Z Event Samples Needed */
#define Z_FILT_13SMPL	((u8)0xC0)		/* 13 Consecutive Z Event Samples Needed */
#define Z_FILT_14SMPL	((u8)0xD0)		/* 14 Consecutive Z Event Samples Needed */
#define Z_FILT_15SMPL	((u8)0xE0)		/* 15 Consecutive Z Event Samples Needed */
#define Z_FILT_16SMPL	((u8)0xF0)		/* 16 Consecutive Z Event Samples Needed */

#define Z_WINDOW_5us		((u8)0x00)		/* Z Window Filter 5us */
#define Z_WINDOW_10us	((u8)0x01)		/* Z Window Filter 10us */
#define Z_WINDOW_15us	((u8)0x02)		/* Z Window Filter 15us */
#define Z_WINDOW_20us	((u8)0x03)		/* Z Window Filter 20us */
#define Z_WINDOW_25us	((u8)0x04)		/* Z Window Filter 25us */
#define Z_WINDOW_30us	((u8)0x05)		/* Z Window Filter 30us */
#define Z_WINDOW_35us	((u8)0x06)		/* Z Window Filter 35us */
#define Z_WINDOW_40us	((u8)0x07)		/* Z Window Filter 40us */
#define Z_WINDOW_60us	((u8)0x08)		/* Z Window Filter 60us */
#define Z_WINDOW_80us	((u8)0x09)		/* Z Window Filter 80us */
#define Z_WINDOW_100us	((u8)0x0A)		/* Z Window Filter 100us */
#define Z_WINDOW_120us	((u8)0x0B)		/* Z Window Filter 120us */
#define Z_WINDOW_140us	((u8)0x0C)		/* Z Window Filter 140us */
#define Z_WINDOW_160us	((u8)0x0D)		/* Z Window Filter 160us */
#define Z_WINDOW_180us	((u8)0x0E)		/* Z Window Filter 180us */
#define Z_WINDOW_200us	((u8)0x0F)		/* Z Window Filter 200us */


#endif
/*** (c) 2004  STMicroelectronics ****************** END OF FILE ***/