/**************** (c) 2004  STMicroelectronics ********************************
     
PROJECT  : 3-phase PMAC induction motor drive Software Library
COMPILER : COSMIC or METROWERKS

MODULE  :  vector.c
VERSION :  Release 1.0.0

CREATION DATE : 

AUTHOR :	Microcontroller Division Applications

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :
Sept 04 V1.0.1: Add SCI interrupt vector;
Add vector declaration for Metrowerks compiler.

*******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. ST MICROELECTRONICS
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
******************************************************************************/

#include "config.h"		/* AC motor library configuration keys */

// Interrupt service routines prototypes

void Dummy_Interrupt(void);
void ART_Interrupt (void);
//void AVD_Interrupt (void);
#ifdef ENABLE_RS232
	void SCI_IT_Routine (void);
#endif
//void TIMB_Interrupt (void);
//void TIMA_Interrupt (void);
//void SPI_Interrupt (void);
void MTC_C_D_IT (void);
void MTC_R_Z_IT (void);
void MTC_U_CL_SO_IT (void);
void PORTS_ei2_Interrupt (void);
void PORTS_ei1_Interrupt (void);
void PORTS_ei0_Interrupt (void);
//void MCC_Interrupt (void);
void MCES_SE_IT (void);
//void TRAP_Interrupt (void);
#if defined ( __HIWARE__)	/* test for HIWARE Compiler */
	extern void _Startup();		/* startup routine */  
	#pragma CONST_SEG .myVectorTable
#elif defined ( __CSMC__ )			/* test for Cosmic Compiler */
	extern void _stext(void);
#endif



// Interrupt service routines vector table (unused vectors point to Dummy int (iret)

void (*const _vectab[])() = {
		ART_Interrupt,
		Dummy_Interrupt,		// AVD_Interrupt,
		#ifdef ENABLE_RS232
			SCI_IT_Routine,
		#else 
			Dummy_Interrupt,
		#endif
		Dummy_Interrupt,		// TIMB_Interrupt,
		Dummy_Interrupt,		// TIMA_Interrupt,
		Dummy_Interrupt,		// SPI_Interrupt,
		MTC_C_D_IT,
		MTC_R_Z_IT,
		MTC_U_CL_SO_IT,
		PORTS_ei2_Interrupt,
		PORTS_ei1_Interrupt,
		PORTS_ei0_Interrupt,
		Dummy_Interrupt,		// MCC_Interrupt,
		MCES_SE_IT,
		Dummy_Interrupt,		// TRAP_Interrupt,
#if defined ( __HIWARE__)	/* test for HIWARE Compiler */
		_Startup,		/* Reset Vector */
		};
#pragma DATA_SEG DEFAULT             

#elif defined ( __CSMC__ )			/* test for Cosmic Compiler */
		_stext
	       };
#endif

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif

/*-----------------------------------------------------------------------------
ROUTINE NAME : Dummy_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Empty Interrupt Service Routine

COMMENTS     : all the non-connected interrupt vectors are connected to this
				empty function
-----------------------------------------------------------------------------*/ 
void Dummy_Interrupt(void)
{
}

/*** (c) 2004 STMicroelectronics ****************** END OF FILE ***/