/*********************************************************************
*               SEGGER MICROCONTROLLER SYSTEME GmbH                  *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (C) 2002   SEGGER Microcontroller Systeme GmbH               *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : LED.c (for STR71x and IAR compiler)
Purpose : LED interface for STR710-EVAL board
--------  END-OF-HEADER  ---------------------------------------------
*/

#define LED_C
#include "LED.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

/****** SFRs used for LED-Port **************************************/

#define __IOPORT0_BASE   0xE0003000

#define __GPIO0_PC0 *(volatile unsigned short*)(__IOPORT0_BASE + 0x00)
#define __GPIO0_PC1 *(volatile unsigned short*)(__IOPORT0_BASE + 0x04)
#define __GPIO0_PC2 *(volatile unsigned short*)(__IOPORT0_BASE + 0x08)
#define __GPIO0_PD  *(volatile unsigned short*)(__IOPORT0_BASE + 0x0C)

/****** Assign LEDs to Ports ****************************************/

#define _LEDPORT_PC0  __GPIO0_PC0
#define _LEDPORT_PC1  __GPIO0_PC1
#define _LEDPORT_PC2  __GPIO0_PC2
#define _LEDPORT      __GPIO0_PD

#define _LED0_BIT  3    // LD3 on EVAL board
#define _LED1_BIT  2    // LD4 on EVAL board

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       LED_Init()
*/

void LED_Init(void) {
  /* Setup port mode: output, push-pull */
  _LEDPORT_PC0 |=  ((1 << _LED0_BIT) | (1 << _LED1_BIT));
  _LEDPORT_PC1 &= ~((1 << _LED0_BIT) | (1 << _LED1_BIT));
  _LEDPORT_PC2 |=  ((1 << _LED0_BIT) | (1 << _LED1_BIT));
  /* Initially switch off LEDs */ 
  _LEDPORT     &= ~((1 << _LED0_BIT) | (1 << _LED1_BIT));
}

/*********************************************************************
*
*       LED switching routines
*/

void LED_SetLED0(void) {
  _LEDPORT  |=  (1 << _LED0_BIT);   // Switch on LED 0
}

void LED_ClrLED0(void) {
  _LEDPORT  &= ~(1 << _LED0_BIT);   // Switch off LED 0
}

void LED_ToggleLED0(void) {
  _LEDPORT  ^=  (1 << _LED0_BIT);   // Toggle LED 0
}

void LED_SetLED1(void) {
  _LEDPORT  |=  (1 << _LED1_BIT);   // Switch on LED1
}

void LED_ClrLED1(void) {
  _LEDPORT  &= ~(1 << _LED1_BIT);   // Switch off LED1
}

void LED_ToggleLED1(void) {
  _LEDPORT  ^=  (1 << _LED1_BIT);   // Toggle LED1
}

/****** EOF *********************************************************/

