/********************************************************
*        SEGGER MICROCONTROLLER SYSTEME GmbH
*  Solutions for real time microcontroller applications
*********************************************************
File        : Main.c
Purpose     : Skeleton program for embOS
--------------END-OF-HEADER----------------------------*/
#include "RTOS.H"

OS_STACKPTR int Stack0[128], Stack1[128]; /* Stack-space */
OS_TASK TCB0, TCB1;               /* Task-control-blocks */
        
        
void Task0(void) {
  while (1) {
    OS_Delay (10);
  }
}

void Task1(void) {
  while (1) {
    OS_Delay (50);
  }
}
        
/********************************************************
*
*                    main
*
********************************************************/
        
int main(void) {
/*ensure no C library functions that uses semihosting SWIs are linked */
#pragma import(__use_no_semihosting_swi)
  OS_IncDI();
  OS_InitKern();        /* initialize OS */
  OS_InitHW();          /* initialize Hardware for OS */
  /* You need to create at least one task here ! */
  OS_CREATETASK(&TCB0, "HP Task", Task0, 100, Stack0);
  OS_CREATETASK(&TCB1, "LP Task", Task1,  50, Stack1);
  OS_SendString("Start project will start multitasking !\n");
  OS_Start();           /* Start multitasking */
}
