; /********************************************************
; *        SEGGER MICROCONTROLLER SYSTEME GmbH
; *  Solutions for real time microcontroller applications
; *********************************************************
; File        : RTOSVect.s
; Purpose     : Interrupt vector handling for embOS_ARM_ADS12
; --------------END-OF-HEADER----------------------------*/

        AREA |C$$code|, CODE, READONLY
        
        IMPORT OS_irq_handler                  ; RTOSINIT.C

        EXPORT IRQ_Handler
        EXPORT OS_IRQ_SERVICE
        PRESERVE8        

        CODE32                                 ; Always ARM mode on interrupt

; *****************************************************
; *
; *          Defines for Flag (PSR) register
; *
; *****************************************************

IRQ_MODE  EQU 0x12            ; Interrupt Request mode
SVC_MODE  EQU 0x13            ; SVC mode (Supervisor)
I_FLAG    EQU 0x80            ; interrupt disable flag


; *****************************************************
; *
; *          Interrupt service routine
; *
; *****************************************************
;
; This routine should be activated by a IRQ. IRQ on the
; ARM 7/9 will jump to 18h, where a jump to this routine
; should be located.
;
; Note: in the MSR instructions,
; c   means control field:        bits 0..7  (mode, T, F, I)
; x   means extension field       bits 8..15
; s   means status    field       bits 16..23
; f   means flag      field       bits 24..31

OS_IRQ_SERVICE
IRQ_Handler
;
; Save temp. registers
;        
        STMDB   SP!,{R0-R3,R12,LR}               ; push
;
; push SPSR (req. if we allow nested interrupts)
;
        MRS     R0, SPSR                         ; load SPSR
        STMDB   SP!,{R0}                         ; push SPSR_irq on IRQ stack
;
; Switch to supervisor mode (svc mode)
;
        MSR     CPSR_c, #SVC_MODE| I_FLAG        ; Write CPSR: MODE = SVC, interrupt disabled
        STMDB   SP!, {LR}                        ; push LR_svc on SVC stack
        BL      OS_irq_handler                   ; Call "C" interrupt handler in RTOSINIT.c
        LDMIA   SP!, {LR}                        ; pop LR_svc from svc stack
;
; Switch back to IRQ mode
;
        MSR     CPSR_c, #IRQ_MODE| I_FLAG        ; Write CPSR: MODE = IRQ, interrupt disabled
;
; pop SPSR
;        
        LDMIA   SP!, {R1}                        ; pop SPSR_irq from IRQ stack
        MSR     SPSR_cxfs, R1
;
; Restore temp registers
;
        LDMIA   SP!, {R0-R3,R12,LR}              ; pop
        SUBS    PC, LR, #4                       ; RETI

        END

