#ifndef _DK3200_IAP_H_
#define _DK3200_IAP_H_

#include "rs232.h"

/////////////////// Macros

// Returns the number of flash selected (0 == primary/main, 1 == secondary/boot)
#define SELECTED_FLASH ((mainForm->rbMain->Checked==TRUE)?(PRIMARY_FLASH):(SECONDARY_FLASH))
// Returns the number of sector selected
#define SELECTED_SECTOR ((BYTE) mainForm->cbSector->ItemIndex)
// Returns the name of the segment in form of FS0..FS7 (primary), CSBOOT0..CSBOOT4 (secondary)
#define SEGMENT_NAME (((mainForm->rbMain->Checked==TRUE)?("FS"):("CSBOOT"))+AnsiString(mainForm->cbSector->ItemIndex))
// Returns the size (in bytes) of a primary or secondary flash sector.
#define SEGMENT_SIZE ((mainForm->rbMain->Checked==TRUE)?(0x8000):(0x2000))
// Returns the basic offset of the segment, depending on current memory map configuration
#define SEGMENT_BASIC_OFFSET (0x8000+((mainForm->rbMain->Checked==TRUE)?(0):((mainForm->cbSector->ItemIndex)*0x2000)))

/////////////////// Constants

#define ST_VENDOR_ID        0x0483
#define ST_PRODUCT_ID       0x0000
#define PRIMARY_FLASH_VM    0x92
#define SECONDARY_FLASH_VM  0x8C
#define PRIMARY_FLASH       0
#define SECONDARY_FLASH     1

/////////////////// External variables

extern int comm_port_open;
extern int esc_pressed;
extern int test_runs;

/////////////////// Functions' headers

void OnError(char *pszMsg);

int sprintf_2hex(char *dest, BYTE c);
void RenderBinaryDataToHexaString(char *bin_buffer, int bin_buffer_length, char *hexastring);

int ParseHexaDataToBin(char *hexastring, char *bin_buffer, int *bytes_parsed);
int ParseHexaStringToBinAndAscii(char *hexastring, char *bin_buffer, char *ascii_buffer, int *bytes_parsed);

int LoadFileToBuffer(char *filename, char *buffer, int buffer_size, int *bytes_loaded);

int initCommPort();
int deinitCommPort();

int SendCommand_DK3200(char *command, int command_length, char *result_buffer, int result_buffer_size, int *bytes_received, int TX_RETRIES=10);

int ResetBoard();
int SetPage(BYTE page);
int SetVM(BYTE vm);
int SelectFlash(BYTE flash, BYTE sector);

int ReadFlash(int offset, BYTE *buffer, int nBytes);
int WriteFlash(int offset, BYTE *buffer, int nBytes);

int DownloadSector(int flash, int sector, int offset, int sector_size, AnsiString seg_name);
int ProgramSector(int flash, int sector, int offset, int sector_size, char *filename);
int VerifySector(int flash, int sector, int offset, int sector_size, char *filename);
int SectorErase(int flash, int sector, int offset);
int BlankCheck(int flash, int sector, int offset, int sector_size);

#endif
