
#ifndef __RS232_H__
#define __RS232_H__

#include <stdio.h>
#include <mem.h>
#include <winbase.h>

class RS232 {
   private:
      HANDLE Comdrv;
      DWORD Baudrate(long baudrate);
   public:
      int Open(char *name,int Insize,int Outsize,long baudrate);
      int Close(void);
      int Clear(void);
      int ClearIn(void);
      int Length(void);
      DWORD ModemStatus(void);
      int Read(char *buffer,int len);
      int Write(char *buffer,int len);
};

DWORD RS232::Baudrate(long baudrate)
{
   switch (baudrate)
   {  case 110    : return CBR_110;
      case 300    : return CBR_300;
      case 600    : return CBR_600;
      case 1200   : return CBR_1200;
      case 2400   : return CBR_2400;
      case 4800   : return CBR_4800;
      case 9600   : return CBR_9600;
      case 14400  : return CBR_14400;
      case 19200  : return CBR_19200;
      case 38400  : return CBR_38400;
      case 56000  : return CBR_56000;
      case 57600  : return CBR_57600;
      case 115200 : return CBR_115200;
      case 128000 : return CBR_128000;
      case 256000 : return CBR_256000;
   }
   return baudrate;
}

DWORD RS232::ModemStatus(void)
{
   DWORD stat;
   if(GetCommModemStatus(Comdrv,&stat))
      return stat;
   return 0L;
}

int RS232::Length(void)
{
   COMSTAT comstate;
   DWORD   error;
   ClearCommError(Comdrv,&error,&comstate);
   if(error==0)
      return (int)comstate.cbInQue;
   return -1;
}

int RS232::Open(char *name,int Insize,int Outsize,long baudrate)
{
   COMMTIMEOUTS commtmout;
   DCB          comdcb;
   Comdrv = CreateFile(name,GENERIC_READ+GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
   if(Comdrv==INVALID_HANDLE_VALUE)
      return 0;
   SetCommMask(Comdrv,EV_RXCHAR);
   SetupComm(Comdrv,Insize,Outsize);
   commtmout.ReadIntervalTimeout=0xFFFFFFFF;
   commtmout.ReadTotalTimeoutMultiplier=0;
   commtmout.ReadTotalTimeoutConstant=0;
   commtmout.WriteTotalTimeoutMultiplier=0;
   commtmout.WriteTotalTimeoutConstant=5000;
   SetCommTimeouts(Comdrv,&commtmout);
   GetCommState(Comdrv,&comdcb);
   char comm_params[100];
   sprintf(comm_params,"%s: baud=%d parity=N data=8 stop=1",name,baudrate);
   BuildCommDCB(comm_params,&comdcb);
   SetCommState(Comdrv,&comdcb);
   return 1;
}

int RS232::Close(void)
{
   if (CloseHandle(Comdrv))
      return 1;
   return 0;
}

int RS232::Read(char *buffer,int len)
{
   DWORD nread;
   if (ReadFile(Comdrv,buffer,len,&nread,NULL))
      return (int)nread;
   return -1;
}

int RS232::Write(char *buffer,int len)
{
   DWORD nwrite;
   if (WriteFile(Comdrv,buffer,len,&nwrite,NULL))
      return (int)nwrite;
   return -1;
}

int RS232::Clear(void)
{
   if (PurgeComm(Comdrv,PURGE_TXCLEAR|PURGE_RXCLEAR))
      return 1;
   return 0;
}

int RS232::ClearIn(void)
{
   if (PurgeComm(Comdrv,PURGE_RXCLEAR))
      return 1;
   return 0;
}

#pragma pack()
#endif

