/////////////////////////////////////////////////////////////////////////////
// test_form.cpp
//
// Test of data transfers over RS232 link
//
// Author: Marian Ilecko
//
// Copyright (c)2003 ST Microelecronics
// All rights reserved.
//
//---------------------------------------------------------------------------
// This example demo code is provided as is and has no warranty,
// implied or otherwise.  You are free to use/modify any of the provided
// code at your own risk in your applications with the expressed limitation
// of liability (see below) so long as your product using the code contains
// at least one uPSD products (device).
//
// LIMITATION OF LIABILITY:   NEITHER STMicroelectronics NOR ITS VENDORS OR
// AGENTS SHALL BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF USE, LOSS OF DATA,
// INTERRUPTION OF BUSINESS, NOR FOR INDIRECT, SPECIAL, INCIDENTAL OR
// CONSEQUENTIAL DAMAGES OF ANY KIND WHETHER UNDER THIS AGREEMENT OR
// OTHERWISE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "test_form.h"
#include "RS232_demo.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TtestForm *testForm;
//---------------------------------------------------------------------------

/////////////////// Global variables declaration
//
extern int stop_test;
extern int test_runs;


//---------------------------------------------------------------------------
//              MAIN FORM CONSTRUCTOR AND MISCELLANEOUS FUNCTIONS
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
__fastcall TtestForm::TtestForm(TComponent* Owner)
   : TForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TtestForm::FormClose(TObject *Sender, TCloseAction &Action)
{
   stop_test = 1;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//              BUTTON FUNCTIONALITY IMPLEMENTATION
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TtestForm::btEndTestClick(TObject *Sender)
{
   stop_test = 1;
   btStartAgain->Enabled = 1;
   btEndTest->Enabled = 0;
}
//---------------------------------------------------------------------------

void __fastcall TtestForm::btClearLogClick(TObject *Sender)
{
   logMemo->Clear();
}
//---------------------------------------------------------------------------

void __fastcall TtestForm::btStartAgainClick(TObject *Sender)
{
   mainForm->btTest->Click();
}
//---------------------------------------------------------------------------

void __fastcall TtestForm::btSaveLogClick(TObject *Sender)
{
   SaveDialog1->FileName = "RS232_test_"+Now().FormatString("d-mmm-yyyy_hh-mm-ss");
   if(SaveDialog1->Execute())
      logMemo->Lines->SaveToFile(SaveDialog1->FileName);
}
//---------------------------------------------------------------------------

void __fastcall TtestForm::FormKeyPress(TObject *Sender, char &Key)
{
   if(test_runs)
      stop_test = 1;
   else testForm->Close();
}
//---------------------------------------------------------------------------

