
 /*---------------------------------------------------------------------------

                        *** LCD IO with copy buffer ***

               v1.0 - Copyright (c) Petr PFEIFER 2003, MPG Prague
                          USB/IAP project source file

  v1.1 - May 2004 - added delay in BusyCheck routine for slow LCD device.
                  - delay_ms() changed to account for faster operation of
				    Turbo device.



                     Copyright (c) 2003 ST Microelectronics
         This example demo code is provided as is and has no warranty,
     implied or otherwise.  You are free to use/modify any of the provided
    code at your own risk in your applications with the expressed limitation
    of liability (see below) so long as your product using the code contains
                      at least one uPSD products (device).

    LIMITATION OF LIABILITY:   NEITHER STMicroelectronics NOR ITS VENDORS OR
   AGENTS SHALL BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF USE, LOSS OF DATA,
       INTERRUPTION OF BUSINESS, NOR FOR INDIRECT, SPECIAL, INCIDENTAL OR
       CONSEQUENTIAL DAMAGES OF ANY KIND WHETHER UNDER THIS AGREEMENT OR
         OTHERWISE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
  --------------------------------------------------------------------------*/



//-- Includes ----------------------------------------------------------------

#include "upsd3300.h"
#include "lcd_io.h"

//-- Variables ---------------------------------------------------------------

// LCD Display copy buffer

xdata DISPLAY LCD_reg _at_ LCD_BASE_ADDR;    // XDATA address for display

xdata char LCD_buffer[LCD_ColNumBuf*LCD_RowNum];   // IAP&D Memory
unsigned char LCDDisp_XPos,LCDDisp_YPos;     // Actual cursor position

static idata uchar Cursor_LCD;

void delay_ms(count)
{
int i;
while(count--)
for(i=0;i<2000;i++) i++; // May 2004 - was 500, changed to 2000 since init of
                         //            LCD did not work properly with 500 for
						 //            the Turbo processor.
                         //          - this function was not tested for
						 //            accuracy of delay time.
}


// User design CG data
static uchar code cg_data[] =
 {

  0x1F,
  0x1F,
  0x1F,
  0x1F,
  0x1F,
  0x1F,
  0x1F,
  0x1F,

  -1
 }
  ;



//-- Functions ----------------------------------------------------------------


// ============================   BusyCheck    ============================ 
void BusyCheck(void)                         // wait until BF is cleared
 {
  unsigned char i;
  while (LCD_reg.LCD_CMD_RD & BF_BIT);
  //	Add some delay for the slow LCD device - Do NOT Remove
  for (i=0; i<10; i++) i++;  // Add Delay 
 }

// ============================   SetUserCG   ============================ 

void SetUserCG(unsigned char *data_ptr)      // initialize user character pattern
 {
  BusyCheck();                               // Check display ability to comm.
  LCD_reg.LCD_CMD_WR = CG_ADDR;              // | (8*0);
                                         //start custom char.set from character #0
  while (*data_ptr != -1)
   {
    BusyCheck();
    LCD_reg.LCD_RAM_WR = *data_ptr++;
   }
 }

 // ============================    htoa_lo    ============================ 
char htoa_lo(unsigned char byte)           // converts low nibble of unsigned byte
 {
  byte = byte & 0x0F;                        // keep lower nibble only
  if (byte <= 0x09)
  return(byte + 0x30);
  else
  return (byte + 0x37);
 }

// =============================    htoa_hi    ============================= 
char htoa_hi(unsigned char byte)            // converts hi nibble of unsigned byte
 {
  byte = byte & 0xF0;                        // keep upper nibble only
  byte = byte >> 4;
  if (byte <= 0x09)                          // (0-F hex) to ascii
  return(byte + 0x30);
  else
  return (byte + 0x37);
 }

// =========================    MirrorBufferInit    =========================

void MirrorBufferInit(void){
  int i;
                                             // Initialize mirror buffer
  for (i=0;i<LCD_ColNumBuf*LCD_RowNum;i++)   // Clear IAP&D display memory
   {
    LCD_buffer[i]=' ';
   }
  LCDDisp_XPos = 0;                          // Cursor position at home
  LCDDisp_YPos = 0;

                                           //add user character at the end of line
  LCD_buffer[LCD_ColNum+0] = 13;
  LCD_buffer[LCD_ColNum+1] = 10;          //new line indicator for WinApp terminal

  LCD_buffer[LCD_ColNumBuf+LCD_ColNum+0] = 0;
  LCD_buffer[LCD_ColNumBuf+LCD_ColNum+1] = 0;// END OF STRING

//please see LCD_IO.H for more details about the buffer
}




// ============================   lcd_init    ============================

void initLCD(void)                           // initialize LCD module per specs
 {

  delay_ms(15);
  LCD_reg.LCD_CMD_WR = 0x30;
  delay_ms(4);
  LCD_reg.LCD_CMD_WR = 0x30;
  delay_ms(1);
  LCD_reg.LCD_CMD_WR = 0x30;
  delay_ms(1);

  LCD_reg.LCD_CMD_WR = 0x38;                 // 8 bits, 2 lines, 5 x 7 font
  delay_ms(4);                               // delay 4 ms
  BusyCheck();
  LCD_reg.LCD_CMD_WR = 0x0C;                 //Display on, Cursor off, Non-Blink
  BusyCheck();
  LCD_reg.LCD_CMD_WR = 0x01;                 //Clear display
  BusyCheck();
  LCD_reg.LCD_CMD_WR = 0x02;                 //Cursor home
  BusyCheck();
  LCD_reg.LCD_CMD_WR = 0x06;                 //Cursor inc, no shift/cursor move

  SetUserCG(&cg_data);                       //set user desfined character

  Cursor_LCD = DD_ADDR;                      //Display from 1st row, 1st column
  BusyCheck();
  LCD_reg.LCD_CMD_WR = Cursor_LCD;

  MirrorBufferInit();
}


// ============================   lcd_clear    ============================ 
void lcd_clear(void)                         // clear all characters from display
 {
  BusyCheck();
  LCD_reg.LCD_CMD_WR = 0x01;
  Cursor_LCD = DD_ADDR;

  MirrorBufferInit();

}

// ============================   putch_LCD    ============================ 
void putch_LCD(unsigned char ch)
 {

  BusyCheck();
  LCD_reg.LCD_RAM_WR = ch;

  if (LCDDisp_XPos<LCD_ColNum)
   {
    LCD_buffer[LCDDisp_YPos*LCD_ColNumBuf+LCDDisp_XPos]=ch;
   }
  if (LCDDisp_XPos<=LCD_ColNum)
   {
    LCDDisp_XPos++;
   }

 }




// ============================   printfLCD    ============================ 

void printfLCD(uchar *chr_ptr, ...)
 {

  unsigned char *var_ptr=&chr_ptr+1;
  unsigned char var;

  while (*chr_ptr != NULL)
   {
    BusyCheck();
    if (*chr_ptr == '\r')
     {
      chr_ptr++;
      Cursor_LCD &= 0xC0;                   //return to position 0 at current line
      LCD_reg.LCD_CMD_WR = Cursor_LCD;

      LCDDisp_XPos=0;
     }
    else
    if (*chr_ptr == '\n')
     {
      chr_ptr++;
      Cursor_LCD ^= 0x40;                    //goto next line
      Cursor_LCD &= 0xC0;                    //return to position 0
      LCD_reg.LCD_CMD_WR = Cursor_LCD;

      LCDDisp_XPos = 0;
      LCDDisp_YPos = (LCDDisp_YPos < (LCD_RowNum-1)) ? (LCDDisp_YPos+1) : 0;
     }
    else
    if (*chr_ptr == '%')
     {
      chr_ptr++;
      if (*chr_ptr == 'd')                   // display 1 digit decimal 0-9
       {
        chr_ptr++;
        var = *var_ptr++;
        putch_LCD((var & 0x0F)+'0');
       }
      else
      if (*chr_ptr == 'x')                   // display 1 byte hex 00-FF
       {
        chr_ptr++;
        var = *var_ptr++;
        putch_LCD(htoa_hi(var));           //LCD_reg.LCD_RAM_WR = Bin2Hex(var>>4);
        putch_LCD(htoa_lo(var));         //LCD_reg.LCD_RAM_WR = Bin2Hex(var&0x0F);
       }
      else
      if (*chr_ptr == 'w')                   // display 1 word hex 0000-FFFF
       {
        chr_ptr++;
        var = *var_ptr++;
        putch_LCD(htoa_hi(var));           //LCD_reg.LCD_RAM_WR = Bin2Hex(var>>4);
        putch_LCD(htoa_lo(var));         //LCD_reg.LCD_RAM_WR = Bin2Hex(var&0x0F);
        var = *var_ptr++;                  //LCD_reg.LCD_RAM_WR = Bin2Hex(var>>4);
        putch_LCD(htoa_hi(var));         //LCD_reg.LCD_RAM_WR = Bin2Hex(var&0x0F);
        putch_LCD(htoa_lo(var));         //LCD_reg.LCD_RAM_WR = Bin2Hex(var&0x0F);
       }
      else
      if (*chr_ptr == 'c')                   // Display 1 character
       {
        chr_ptr++;
        var = *var_ptr++;                  //LCD_reg.LCD_RAM_WR = Bin2Hex(var>>4);
        putch_LCD(var);
       }

      else
       {
        putch_LCD(*chr_ptr++);               // Out character to LCD Display RAM
       }

     }
    else
     {
      putch_LCD(*chr_ptr++);                 // Out character to LCD Display RAM
     }
   }
 }



