
 /*---------------------------------------------------------------------------
                  Copyright (c) 2002,2003 ST Microelectronics
         This example demo code is provided as is and has no warranty,
     implied or otherwise.  You are free to use/modify any of the provided
    code at your own risk in your applications with the expressed limitation
    of liability (see below) so long as your product using the code contains
                      at least one uPSD products (device).

    LIMITATION OF LIABILITY:   NEITHER STMicroelectronics NOR ITS VENDORS OR
   AGENTS SHALL BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF USE, LOSS OF DATA,
       INTERRUPTION OF BUSINESS, NOR FOR INDIRECT, SPECIAL, INCIDENTAL OR
       CONSEQUENTIAL DAMAGES OF ANY KIND WHETHER UNDER THIS AGREEMENT OR
         OTHERWISE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
  --------------------------------------------------------------------------*/


#include "turbolite_hardware.h"                   // extended registers in uPSD

#ifndef _LCD_H_
#define _LCD_H_

typedef unsigned char uchar;

#define LCD_ColNum 16                        // Display - Number of columns
#define LCD_ColNumBuf 18         // Display - Number of columns in buffer (+13/10)
#define LCD_RowNum 2                         // Display - Number of rows
#define LCD_BUFFER_SIZE LCD_ColNumBuf*LCD_RowNum
// The buffer size is LCD_RowNum*LCD_ColNumBuf.
// LCD_ColNum determines number of display(able) characters,
// LCD_ColNumBuf line size in buffer.
// LCD_ColNumBuf-LCD_ColNum characters canm be used for user-characters
// at the end of line ...

typedef xdata struct LCD_display_st
 {
  unsigned char LCD_CMD_WR;                          //   LCD_BASE+0x00
  unsigned char LCD_CMD_RD;                          //           +0x01
  unsigned char LCD_RAM_WR;                          //           +0x02
  unsigned char LCD_RAM_RD;                          //           +0x03
 }
    DISPLAY;

// Read Only from Command register
#define  BF_BIT  0x80                        // Busy flag

// Write Only to Command register
#define DD_ADDR 0x80                         // set DDRAM address
#define CG_ADDR 0x40                         // set CGRAM address

// Prototypes
void initLCD(void);                          // initialize LCD module per specs
void printfLCD(unsigned char *chr_ptr, ...);

void lcd_clear(void);
char htoa_lo(unsigned char byte);
char htoa_hi(unsigned char byte);

void delay_ms(count);

#endif
