/*------------------------------------------------------------------------------
TurboLite_hardware.h

Version:
April 2004 Version 0.2 - Edited comments and added other memory map settings.

Dependencies: None

Description:
This header file contains the hardware specific defines for the uPSD Turbo
processor being used.

*******************************************************************************
Important Note: These values must be modified for the specific target hardware.
Some of the parameters are used in the startup code (see Startup.a51 file) to 
set up the BUSCON register and may be used by drivers to set up timers, 
prescalers, etc. 
*******************************************************************************


Copyright (c) 2004 STMicroelectronics Inc.

This example demo code is provided as is and has no warranty,
implied or otherwise.  You are free to use/modify any of the provided
code at your own risk in your applications with the expressed limitation
of liability (see below) so long as your product using the code contains
at least one uPSD product (device).

LIMITATION OF LIABILITY:   NEITHER STMicroelectronics NOR ITS VENDORS OR 
AGENTS SHALL BE LIABLE FOR ANY LOSS OF PROFITS, LOSS OF USE, LOSS OF DATA,
INTERRUPTION OF BUSINESS, NOR FOR INDIRECT, SPECIAL, INCIDENTAL OR
CONSEQUENTIAL DAMAGES OF ANY KIND WHETHER UNDER THIS AGREEMENT OR
OTHERWISE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
------------------------------------------------------------------------------*/

#ifndef _TurboLite_hardware_H_
#define _TurboLite_hardware_H_


//Hardware specific settings
#define FREQ_OSC  		40000		// uPSD MCU Oscillator Freq. in KHz (not MHz)
#define uPSD_5V         1           // uPSD_5V = 1  --> 5V device
                                    // uPSD_5V = 0  --> 3V device    


// Memory map settings:
// These settings must match up with the settings in the associated PSDsoft
// project for proper execution of the code.

#define PSD_REG_ADDR 	0x0200		// uPSD PSD Register I/O base addr
									// (this is the CSIOP setting)
#define LCD_BASE_ADDR	0x0300		// LCD base address 

#define XMEM_BASE_ADDR  0x2000			// XDATA base address (set by PSDsoft config for RS0)
#define XMEM_LENGTH     0x2000			// XDATA length 8KB

#define uPSD_MAIN_SECTOR_SIZE	0x8000	// Main Sector size = 32KB
#define uPSD_BOOT_SECTOR_SIZE	0x2000	// Boot Sector size = 8KB
#define uPSD_MAIN_SECTORS		0x08	// Number of Main sectors = 8
#define uPSD_BOOT_SECTORS		0x04	// Number of Boot sectors = 4

#endif



