
#ifndef _FLASHCODE_
#define _FLASHCODE_

// ---------------------------------------------------------------------------------------------------
// Misc definitions 

#define RAM_ERROR_LIMIT 0x0050
#define MEM_ERROR_LIMIT 0x50

//#define LCD_LINE_LENGTH 0x000F		// length of single line on lcd display

#define SWAP_MASK  0xC0 			// 8xx specific

#define unswapped_fs0_addr	0x8000
#define unswapped_fs0_page	0x00

// ---------------------------------------------------------------------------------------------------
// Flash parameters, adresses and constants

// Flash/EEPROM parameters

#define NVM_DATA_POLL 0x80		// flash/eeprom status "data poll" bit at DQ7   
#define NVM_DATA_TOGGLE 0x40	// flash/eeprom status "toggle poll" bit at DQ6
#define NVM_ERROR  0x20 		// flash/eeprom status "error" bit at DQ5   
#define MAX_EEPROM_RETRY 0x0FFF // Maximum number of attemps to check status after
								// a write opertaion to EEPROM  

#define EEPROM_TIME 0x00FF     	//  eprom timeout in multiples of rti 6.66ms

#define NVM_DATA_POLL     0x80	// flash status "data poll" bit at DQ7   
#define NVM_DATA_TOGGLE   0x40	// flash status "toggle poll" bit at DQ6
#define NVM_ERROR         0x20 	// flash status "error" bit at DQ5   

// Addresses to use to invoke embedded algorithm in FLASH memory. Modify these addresses.
// It is advised to pick a Flash memory address that is common to all memory pages.
	
#define	FLASH_COMMON_XAAA (volatile unsigned char xdata *) 0x9AAA 
#define	FLASH_COMMON_X555 (volatile unsigned char xdata *) 0x9555 

// Addresses to use to invoke embedded algorithm in FLASH boot memory. Modify these addresses.
// It is advised to pick a Flash memory address that is common to all memory pages.

#define	FLASH_BOOT_XAAA (volatile unsigned char xdata *) 0x0AAA 
#define	FLASH_BOOT_X555 (volatile unsigned char xdata *) 0x0555 

//Note: Please edit the addresses shown to match your system memory map

// ---------------------------------------------------------------------------------------------------
// Flash Memory management routines

// Select which functions within psd834f2.c that you would like to include into your
// compile session by defining the associated compiler directive. defined = include, 
// not defined = do not include

// Module: flash_write_with_poll
// Programs a single byte, checks status using polling method.
#define _F_W_W_P

// Module: flash_write_with_toggle
// Programs a single byte, checks status using toggle method.
//#define _F_W_W_T

// Module: flash_erase_bulk
// Erases the entire Flash memory (all sectors).
#define _F_E_B

// Module: flash_reset
// Resets the main Flash memory to Read Array mode.
//#define _F_R

// Module: flash_read_id
// Reads the Flash Identifier byte from main Flash memory. 
//#define _F_R_I

// Module: flash_read_sector_protect
// Reads individual Flash sector protection status.
//#define _F_R_S_P

// Module: flash_boot_write_with_poll
// Programs a single byte, checks status using polling method.
#define _F_B_W_W_P

// Module: flash_boot_write_with_toggle
// Programs a single byte, checks status using toggle method.
//#define _F_B_W_W_T

// Module: flash_boot_erase_bulk
// Erases the Flash boot memory (all sectors).
#define _F_B_E_B

// Module: flash_boot_reset
// Resets the Flash boot memory to Read Array mode.
//#define _F_B_R

// Module: flash_boot_read_id
// Reads the Flash Identifier byte from boot Flash memory. 
//#define _F_B_R_I

// Module: flash_boot_read_sector_protect
// Reads Flash boot sector protection status and PSD security bit.
//#define _F_B_R_S_P

// Header definitions
unsigned char flash_write_with_toggle(unsigned char *addr,unsigned char dat);
unsigned char flash_write_with_poll(volatile unsigned char xdata *addr, unsigned char dat);
unsigned char flash_boot_write_with_poll(volatile unsigned char xdata *addr, unsigned char dat);
unsigned char flash_erase_sector(volatile unsigned char xdata* addr);
unsigned char flash_boot_erase_sector(volatile unsigned char xdata* addr);
unsigned char flash_boot_write_with_poll(volatile unsigned char xdata *addr, unsigned char dat);
unsigned char flash_boot_write_with_toggle(volatile unsigned char *addr, unsigned char dat);
void flash_reset();
void flash_boot_reset();

// ---------------------------------------------------------------------------------------------------

#endif

