/**
  ******************************************************************************
  * @file    lcd_driver.h
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    07/07/2010
  * @brief   This file contains exported variables and protoypes for lcd_driver.c            
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LCD_H
#define __LCD_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x.h"

/** @addtogroup lcd_driver
  * @{
  */  

/** @defgroup lcd_driver_Exported_Types
  * @{
  */ 
/**
  * @}
  */ 

/** @defgroup lcd_driver_Exported_Constants
  * @{
  */ 

#define LCD_R01             0x01
#define LCD_R02             0x02
#define LCD_R03             0x03
#define LCD_R04             0x04
#define LCD_R05             0x05
#define LCD_R0A             0x0A
#define LCD_R0B             0x0B
#define LCD_R0D             0x0D
#define LCD_R0E             0x0E
#define LCD_R0F             0x0F
#define LCD_R16             0x16
#define LCD_R17             0x17
#define LCD_R1E             0x1E
#define LCD_R30             0x30
#define LCD_R31             0x31
#define LCD_R32             0x32
#define LCD_R33             0x33
#define LCD_R34             0x34
#define LCD_R35             0x35
#define LCD_R36             0x36
#define LCD_R37             0x37
#define LCD_R3A             0x3A
#define LCD_R3B             0x3B

/* For SPI Data Configuration */
#define INDEX_DATA1          0x70 
#define INDEX_DATA2          0x72 

#define SPI_TFT_CS_HIGH()    GPIO_SetBits(GPIOA, GPIO_Pin_4)
#define SPI_TFT_CS_LOW()     GPIO_ResetBits(GPIOA, GPIO_Pin_4)
#define TFT_RESET_HIGH()     GPIO_SetBits(GPIOC, GPIO_Pin_1)
#define TFT_RESET_LOW()      GPIO_ResetBits(GPIOC, GPIO_Pin_1)


/*------------------LCD Slideshow parameters ---------------------------------*/
#define MAX_SLIDESHOW_IMAGE_COUNT   (uint8_t)2

/* SRAM Image Address with image Header information */
#define SRAM_IMAGE1_ADDR             (uint32_t)0x68000000
#define SRAM_IMAGE2_ADDR             (uint32_t)0x68025884
#define IMAGE_SIZE                   (uint32_t)76866 
#define LCD_BANNER_IMAGES            (uint8_t)52

/* SRAM Image Address with image Header information removed */
#define SRAM_IMAGE1                 (uint32_t)0x68000042
#define SRAM_IMAGE2                 (uint32_t)0x680258C6

/* Frame Rate control Parameters */
/* Frame rate should not be set more than 40 Hertz */
/* Banner mode, maximum recommended frame rate    : 19Hertz */
/* Slideshow mode, maximum recommended frame rate : 40Hertz */

#define FRAME_RATE                   (uint32_t)19  /* In Hertz */

/* Slide show time should not be more than 60 sec */
#define SLIDESHOW_TIME_GAP           (uint32_t)1 /* In seconds */


/*------------------- LCD Sync parameters-------------------------------------*/

/* For QVGA Resolution LCD; there are 320 pixels per 1 LCD line */
#define LCD_HORZ_LINE            (uint16_t)320 /* Number of pixels in one line */
#define LCD_VERT_FRAME           (uint16_t)240 /* Number of lines in one frame */

#define LCD_FRAME_FRONT_PORCH    (uint8_t)2
#define LCD_FRAME_BACK_PORCH     (uint8_t)4
#define LCD_FRAME_BACK_PORCH_START (uint16_t)(LCD_FRAME_FRONT_PORCH+LCD_VERT_FRAME)
#define LCD_FRAME_END              (uint16_t)(LCD_FRAME_BACK_PORCH_START+\
                                              LCD_FRAME_BACK_PORCH)

#define LCD_LINE_FRONT_PORCH      (uint8_t)9
#define LCD_LINE_BACK_PORCH       (uint8_t)20


#define TFT_HSYNC_GPIO_PORT_CLOCK       RCC_APB2Periph_GPIOC
#define TFT_HSYNC_GPIO_PIN              GPIO_Pin_6
#define TFT_HSYNC_GPIO_PORT             GPIOC

#define TFT_VSYNC_GPIO_PORT_CLOCK       RCC_APB2Periph_GPIOA
#define TFT_VSYNC_GPIO_PIN              GPIO_Pin_8
#define TFT_VSYNC_GPIO_PORT             GPIOA


/* Image source is of 16bit data width , for LCD line display
Increment Image data source by (LCD_HORZ_LINE*2) = 320*2 =640 for QVGA */
#define IMG_SRC_LINE_SIZE          (uint16_t)(LCD_HORZ_LINE*2)    

/* HSYNC and VSYNC toggle */
#define TFT_HSYNC_HIGH              (GPIOC->BSRR = GPIO_Pin_6)
#define TFT_HSYNC_LOW               (GPIOC->BRR  = GPIO_Pin_6)
#define TFT_VSYNC_HIGH              (GPIOA->BSRR = GPIO_Pin_8)
#define TFT_VSYNC_LOW               (GPIOA->BRR  = GPIO_Pin_8)


/* LCD Display Modes */
typedef enum 
{
  LCD_BannerMode = 0x01,
  LCD_SlideShowMode,
}LCD_DisplayMode_Typedef; 



/**
  * @}
  */ 


/** @defgroup lcd_driver_Exported_Variables
  * @{
  */ 
extern __IO uint32_t ImageSourceAddrCounter;
extern __IO uint32_t ImageSourceAddress;
extern uint16_t DummyDisplayBuffer[LCD_HORZ_LINE];
extern __IO uint8_t NOR_ImageIndex ;
extern uint8_t volatile DMAComplete;
extern const uint32_t NORImageFileAddrMap[52];
/**
  * @}
  */ 


/** @defgroup lcd_driver_Exported_Functions
  * @{
  */ 

void LCD_Init(void);
void LCD_FSMCConfig(void);
void LCD_AgingModeDisplay(void);
void LCD_ImageDisplay(void);
void LCD_HysncVsyncMode(void);
void CopyToInternalFlash(void);
uint32_t PrepareInternalFlashDataForDisplay(void);
void LCD_WriteReg(uint8_t LCD_Reg, uint16_t LCD_RegValue);
void LCD_CtrlLinesConfig(void);
void LCD_CtrlLinesWrite(GPIO_TypeDef* GPIOx, uint16_t CtrlPins, BitAction BitVal);
void LCD_SPIConfig(void);
void DMA_InterruptConfig(void);
void LCD_DriverConfig(void);
uint32_t ExternalSRAMCheckBitmapFiles(void);
void FSMC_SRAM_Init(void);
void CopyStartupImagesToExtSRAM(void);
void FSMC_SRAM_WriteBuffer(uint16_t* pBuffer, uint32_t WriteAddr, uint32_t NumHalfwordToWrite);
void CopyNewImageToExtSRAM(u32 src_address,u32 dest_address);
/**
  * @}
  */ 
#endif /* __LCD_H */

/**
  * @}
  */ 

/**
  * @}
  */ 
/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
