/**
  ******************************************************************************
  * @file    backlight_control.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    07/07/2010
  * @brief   This file includes the STLD40DPUR based backlight driver for  Liquid
             Crystal Display Module (CT05350DW0000T).      
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 

/* Includes ------------------------------------------------------------------*/
#include "backlight_control.h"



/** @defgroup BACKLIGHT_CONTROL
  * @brief This file is the backlight control for TFT-lCD.
  * @{
  */ 

/** @defgroup BACKLIGHT_CONTROL_Private_TypesDefinitions
  * @{
  */ 
/**
  * @}
  */ 



/** @defgroup BACKLIGHT_CONTROL_Private_Defines
  * @{
  */ 

/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Private_Macros
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Private_Variables
  * @{
  */
ADC_InitTypeDef ADC_InitStructure;  
/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Private_FunctionPrototypes
  * @{
  */ 
static void LCD_BacklightGPIOConfig(void);
static void LCD_BacklightADC_Config(void);
static void LCD_BacklightTimerConfig(void);
static void LCD_BacklightADC_GPIOConfig(void);
/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Private_Functions
  * @{
  */ 

/**
  * @brief  LCD_BacklightConfiguration.
  *         PB6 is used as enable pin for Backlight Driver
  *         PWM is output on PB6 .PWM duty cycle is varied in 
  *         response to pontentiometer RV1 rotation
  *         Configure GPIO , ADC and Timer for Backlight control
  * @param  None
  * @retval None
  * 
  */
void LCD_BacklightConfiguration(void)
{
  
  /*GPIO configuration for PWM generation for Backlight Control -------------*/
   LCD_BacklightGPIOConfig();    
  
  /*Timer configuration for PWM generation for Backlight Control -------------*/
   LCD_BacklightTimerConfig();
   
   /*ADC Configuration for Backlight control by Potentiometer RV1-------------*/
   LCD_BacklightADC_Config();
   
  /* Enable Backlight Timer -------------------------------------------------*/
   TIM_Cmd(TIM4, ENABLE);  
  
}

/**
  * @brief  LCD_BacklightGPIOConfig
  *         Configure PB6 for Backlight control
  * @param  None
  * @retval None
  * 
  */
static void LCD_BacklightGPIOConfig(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;
  
  /* Enable backlight controller enable Port Clock----------------------------*/
  RCC_APB2PeriphClockCmd(LCD_BL_GPIO_PORT_CLOCK | RCC_APB2Periph_AFIO, ENABLE);
  
  /* Enable backlight controller enable Port Clock---------------------------*/
  GPIO_InitStructure.GPIO_Pin =  LCD_BL_GPIO_PIN;
  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;; 
  GPIO_Init(LCD_BL_GPIO_PORT, &GPIO_InitStructure); 
  
}

/**
  * @brief  LCD_BacklightTimerConfig
  *         Configure Timer for PWM output on PB6 for Backlight control
  *         PWM duty cycle is varied in response to pontentiometer RV1 rotation
  * @param  None
  * @retval None
  * 
  */
static void LCD_BacklightTimerConfig(void)
{
  TIM_OCInitTypeDef  TIM_OCInitStructure;
  TIM_TimeBaseInitTypeDef  TIM_TimeBaseStructure;
  
  /*Clock for Backlight Timer -----------------------------------------------*/    
  RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM4, ENABLE);
   
  /* Intilaize Backlight Timer -----------------------------------------------*/
  TIM_DeInit(TIM4);
  TIM_TimeBaseStructure.TIM_Period = LCD_BL_TIMER_PERIOD;
  TIM_TimeBaseStructure.TIM_Prescaler =0;
  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
  TIM_TimeBaseInit(TIM4, &TIM_TimeBaseStructure);
  
   /* Intialize Backlight Timer PWM for 50% Dutycle---------------------------*/
  TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_PWM1;
  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
  TIM_OCInitStructure.TIM_Pulse = (LCD_BL_TIMER_PERIOD+1)/2; 
  TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_Low;
  TIM_OCInitStructure.TIM_OCIdleState = TIM_OCIdleState_Reset;
  TIM_OC1Init(TIM4, &TIM_OCInitStructure); 
  TIM_ARRPreloadConfig(TIM4, ENABLE);    
          
}

/**
  * @brief  LCD_BacklightADC_Config
  *         Configuration for ADC to control TFT-LCD Backlight using 
  *         STM32103E-EVAL potentiometer RV1
  * @param  None
  * @retval None
  * 
  */
static void LCD_BacklightADC_Config(void)
{ 
  
   /*ADC input GPIO Configuration----------------------------------------------*/     
  LCD_BacklightADC_GPIOConfig();     
        
  /*Clock for ADC ------------------------------------------------------------*/    
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_ADC1, ENABLE);
  
  /* ADC1 configuration ------------------------------------------------------*/
  ADC_DeInit(ADC1);
  ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
  ADC_InitStructure.ADC_ScanConvMode = DISABLE;
  ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;
  ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
  ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
  ADC_InitStructure.ADC_NbrOfChannel = 1;
  ADC_Init(ADC1, &ADC_InitStructure);

  /* ADC1 regular channel14 configuration ------------------------------------*/ 
  ADC_RegularChannelConfig(ADC1, ADC_Channel_14, 1, ADC_SampleTime_239Cycles5);
  
  /* Enable ADC1 -------------------------------------------------------------*/
  ADC_Cmd(ADC1, ENABLE);
  
  /* Enable ADC1 reset calibaration register--------------------------------- */   
  ADC_ResetCalibration(ADC1);
  
  /* Check the end of ADC1 reset calibration register------------------------ */
  while(ADC_GetResetCalibrationStatus(ADC1));

  /* Start ADC1 calibaration------------------------------------------------- */
  ADC_StartCalibration(ADC1);
  
  /* Check the end of ADC1 calibration ---------------------------------------*/
  while(ADC_GetCalibrationStatus(ADC1));
     
  /* Start ADC1 Software Conversion ------------------------------------------*/ 
  ADC_SoftwareStartConvCmd(ADC1, ENABLE);   
}

/**
  * @brief  LCD_BacklightADC_GPIOConfig.
  *         Configuration of RV1 potnetiometer pin for ADC input
  * @param  None
  * @retval None
  * 
  */
static void LCD_BacklightADC_GPIOConfig(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;  
  
  /* Enable backlight controller ADC input Port Clock------------------------*/
  RCC_APB2PeriphClockCmd(LCD_BLCTRL_GPIO_PORT_CLOCK, ENABLE);  
  
  /* Configure PC.04 (ADC Channel14) as analog input for Potentiometer RV1----*/
  GPIO_InitStructure.GPIO_Pin = LCD_BLCTRL_GPIO_PIN;
  GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
  GPIO_Init(LCD_BLCTRL_GPIO_PORT, &GPIO_InitStructure);
  
}


/**
  * @}
  */ 

/**
  * @}
  */ 

/**
  * @}
  */


/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
