/**
******************************************************************************
* @file    main.c
* @author  MCD Application Team
* @version V1.0.0
* @date    07/07/2010
* @brief   Main program body
******************************************************************************
* @copy
*
* THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
* TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
* DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
* FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
* CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*
* <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
*/ 

/* Includes ------------------------------------------------------------------*/
#include "main.h"


/** @addtogroup STM32F10x_LCD_Drive
* @{
*/

/** @defgroup STM32F10x_LCD_Drive_MAIN
* @brief This file is the FSMC TFT driver demo main file
* @{
*/ 

/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_TypesDefinitions
* @{
*/ 
/**
* @}
*/ 



/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_Defines
* @{
*/ 

/**
* @}
*/ 


/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_Macros
* @{
*/ 
/**
* @}
*/ 


/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_Variables
* @{
*/

static __IO uint32_t TimingDelay = 0;

/**
* @}
*/ 


/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_FunctionPrototypes
* @{
*/ 

static void RCC_Configuration(void);

/**
* @}
*/ 


/** @defgroup STM32F10x_LCD_Drive_MAIN_Private_Functions
* @{
*/ 


/**
* @brief  main
*         Main routine for STM32F10x_LCD_Drive Demo
* @param  None
* @retval None
*/


int main(void)
{   
  /* Configure  System clock */
  RCC_Configuration();
  
  /* Initialize the Demo */
  Demo_Init();
  
  while (1)
  {
  }
}

/**
* @brief  Demo_Init
*         Initialize the demonstration application.
* @param  None
* @retval None
*/
void Demo_Init(void)
{
      
  /*Copy images from external NOR memory to external SRAM*/
  CopyStartupImagesToExtSRAM();
  
   /* Configure LCD Backlight Driver with dimming control */
  LCD_BacklightConfiguration();
  
  /*Check for succesful data copy from external NOR to external SRAM*/
  if(ExternalSRAMCheckBitmapFiles() == 0)
  {     
    /*Configure Key button for switching LCD display Modes*/
    /* There are two LCD display modes : Banner mode & SlideShow Mode*/
    /* Default Mode is banner mode and pressing the key once,mode changes
       to slideshow mode and next key press changes again to banner mode*/
   STM_EVAL_PBInit(BUTTON_KEY,BUTTON_MODE_EXTI);
    
    /* Initialize the LCD lines and LCD registers*/
   LCD_Init();  
    
    /* Configure the FSMC LCD Driver as per TFT-LCD data requirements*/
    LCD_DriverConfig();
  }   
  
  
}

/**
* @brief  Delay
*         Inserts a delay time.
* @param  nCount: specifies the delay time length (time base 1 us).
* @retval None
*/
void Delay(u32 nCount)
{
  TimingDelay = nCount;
  
  /* Setup SysTick Timer for 1 msec interrupts  */
  if (SysTick_Config(SystemCoreClock / 1000))
  { 
    /* Capture error */ 
    while (1);
  }
}


/**
* @brief  Decrement_TimingDelay
*         Decrements the TimingDelay variable..
* @param  None
* @retval None
*/
void Decrement_TimingDelay(void)
{
  if (TimingDelay != 0x00)
  {
    TimingDelay--;
  }
}


/**
* @brief  RCC_Configuration.
*         Clock configuration for the FSMC TFT Driver
* @param  None
* @retval None 
*/
static void RCC_Configuration(void)
{
  
  /* Setup the microcontroller clock system setting through SystemInit()
  function which is called from startup file (startup_stm32f10x_xx.s)
  before to branch to application main. To reconfigure the default setting
  of SystemInit() function, refer to system_stm32f10x.c file */
  
	SystemInit();

  /* PCLK1 = HCLK/4 */
  RCC_PCLK1Config(RCC_HCLK_Div4);  
}


#ifdef USE_FULL_ASSERT
/**
* @brief  assert_failed
*         Reports the name of the source file and the source line number
*         where the assert_param error has occurred.
* @param  File: pointer to the source file name
* @param  Line: assert_param error line source number
* @retval None
*/
void assert_failed(u8* file, u32 line)
{
  /* User can add his own implementation to report the file name and line number,
  ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  
  LCD_Clear();
  LCD_DisplayString(Line0, "   Assert Function  ");
  
  /* Infinite loop */
  while (1)
  {
  }
}
#endif


/**
* @}
*/ 

/**
* @}
*/ 

/**
* @}
*/


/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
