/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  BUZ_drv.c
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : STM / CMG

******************************************************************************/
 
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS xxx IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
    
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
 
#include "io72264.h"   /* ST72264 memory and registers mapping  */
#include "BUZ_drv.h"
#include "Lib_bits.h"



/*   Music note coding  -----------------------------------------------------
		     SI0     DO     RE     MI     FA     SOL    LA     SI    */
const int   Note[]={0x0F86,0x0EE4,0x0D4A,0x0BC8,0x0B20,0x09E8,0x08E1,0x07C3, 
/*		     DO2    MUTE */
		    0x0774,0x0044};

const char  DutyTime[]={0x0A,0x09,0x08,0x07,0x07,0x06,0x05,0x05,0x04,0x88};

volatile char DutyCycle=10; /* DutyCycle in % [00..99]  define the music volume level  */




/****************************************************************************** 
Name:   TIMERB_Init
Description: Timer B initialization for the PWM mode
Parameters:  Nothing
******************************************************************************/

void TIMERB_Init( void )
{    
	TBCR1=0x04;  /*OLVL1=0  and OLVL2=1 */ 
	TBCR2=0x90;  /*OC1E=1, PWM=1 , CC10=01 Ftimer= Fcpu/4 = 2MHz. */
 
	TBOC2R = 0x0000;    
	TBOC1R = 0x0001;  
            
}

/****************************************************************************** 
Name:   TIMERB_Disable
Description: Disable Timer B
Parameters:  Nothing
******************************************************************************/
 
void TIMERB_Disable (void )
{
	TBCR2=0x00;
}

/****************************************************************************** 
Name:   Wait_Poll
Description: A delay routine using a polling method
Parameters:  Input (note_code:Duration)    100ms * 'Duration' = delay time
******************************************************************************/  
void Wait_Poll( char note_code )   
{
	char duration ; 	
	duration= ( note_code >> 4 )& 0x0F ;   	
	for ( duration; duration > 0 ; duration --) 
	{
	   #asm 	               
	    PUSH A
	    PUSH X 
	    PUSH Y
	              	LD Y,#2
		 Tbwt1:
	  		LD X,#255
		 Tbwt2: 
		 	LD A,#240 
		 	
		 Tbwt3: DEC A
		        JRNE Tbwt3 
		        		        
		        DEC X
		        JRNE Tbwt2
		        
		        DEC Y
		        JRNE Tbwt1
	    POP Y
	    POP X
	    POP A 	    
	#endasm 
	} 

}  

/****************************************************************************** 
Name:  Play_Note
Description: Playing a single note : Change the PWM duty cycle & Frequency
Parameters:  Input (note_code:Duration)    
******************************************************************************/   
 
void Play_Note ( char note_code )   
{
	TBOC2R= Note[note_code& 0x0F];
	TBOC1R= DutyCycle*DutyTime[note_code&0x0F];
	Wait_Poll(note_code);
}

/****************************************************************************** 
Name:  Play_Score
Description: Playing a Music Score and light-on one led
Parameters:  Input (note_code: Duration , Led to light-on )    
******************************************************************************/   
void Play_Score (char * Music,char leds)
{
	char i=0; 
	
	while  (Music[i] != _END_)  
	{
		ClrBit(PADR,3);	/* PA3=0  */
		ClrBit(PADR,2);	/* PA2=0  */
		ClrBit(PCDR,3);	/* PC3=0  */
		SetBit(PCDR,2);	/* PC2=1  */
		PBDR=leds;	/* Push Digit leds on PBDR ==> show mode on leds */
		
		TIMERB_Init();
		
		if ( Music[i] < _VOLd )	Play_Note( Music[i]); /* play music */	
		if ( Music[i] == _VOLd)	DutyCycle--;
		if ( Music[i] > _VOLd ) DutyCycle++; 
	
		TIMERB_Disable();
		ClrBit(PCDR,2);  /* All outputs Off */
  
		i++; 
	}
}

/* End of BUZ_drv.c   */