
/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  Flash_Iap.c
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : STM/CMG

******************************************************************************/ 
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS xxx IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
    
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/


#include "Flash_Iap.h"
#include "io72264.h"



/****************************************************************************** 
Name:   IAP_RAM
Description: Reprogramming of 16 bytes buffer contained at @A2..B2 in RAM
	     in XFLASH address contained at @A0..A1 in RAM 
Parameters:  Nothing
******************************************************************************/


void IAP_RAM(void)
{
	while (ValBit(FCSR,PGM)) {}; /* Wait the End of previous programming phase */ 
	SetBit (FCSR,LAT);           /* Copy 16 data byte from RAM Buffer to EEPROM */ 
	#asm
	PUSH A
	PUSH X
	LD X,#15
	Latchloading:
			LD A,($A2,X)
			LD ([$A0.w],X),A
			DEC X
			JRPL Latchloading
	POP X
	POP A
	#endasm   
	
	SetBit(FCSR,PGM);		/* Start Programming  */
	while (ValBit(FCSR,PGM)) {}; 	/* wait the End of previous programming phase */
     
}


/* End of Flash_iap.c   */
