/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  I2c_drv.h
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : CMG

****************************************************************************** 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS xxx IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
    
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ST7 I2C single master peripheral software driver.
                Polling software strategy.  
                No errors management

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-



******************************************************************************/

/* PREPROCESSING SYSTEM DECLARATIONS *****************************************/
/* MODEL => #define system_define value                                      */
#ifndef I2CM_DRV_H
#define I2CM_DRV_H

/* MACRO FUNCTION DECLARATIONS ***********************************************/
/* MODEL => #define macro_name macro                                         */

/* PUBLIC DECLARATIONS *******************************************************/
/* List of all the variables/constant defined in this module and used in     */
/* another one.                                                              */
/* MODEL => type_name var_name;                                              */

/* FUNCTION DESCRIPTIONS *****************************************************/
/* Description of all the functions defined in this module.                  */
/* MODEL => [static] type_name var_name;  or #define                         */


void I2Cm_Int      (void);

void I2Cm_Start    (void);
void I2Cm_Stop     (void);
void I2Cm_Ack      (void);
void I2Cm_nAck     (void);

void I2Cm_Init     (void);

void I2Cm_SetAddr  (char /* i2c_addr */);

void I2Cm_TxData   (char /* i2c_data */);
char I2Cm_RxData   (char /* last */);

void I2Cm_Tx (char* /* buff_add */, char /* sub_add */, char /* nb */, char /* dest_add */);
void I2Cm_Rx (char* /* buff_add */, char /* sub_add */, char /* nb */, char /* dest_add */);

#endif

/************* (c) 2000 STMicroelectronics ****************** END OF FILE ***/
