
/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  Main.c
VERSION  :  V 1.0
CREATION DATE :  01/09/01
AUTHOR   : STM

******************************************************************************/

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS xxx IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
    
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/  




#include "io72264.h"	/* ST72264 memory and registers mapping */
#include "BUZ_drv.h"	/* Buzzer driver software  */
#include "I2c_drv.h"	/* I2C driver software with 24C08  */
#include "Spi_drv.h" 	/* SPI driver software with M95040 */
#include "Lib_bits.h"	/* Bits library  */   

/*****************************************************************************/

#define rim() _asm("rim\n")	/*Authorize & Inhibit interrupts */
#define sim() _asm("sim\n")     

/*****************************************************************************/

                                             
/* Exported Constants  */ 


/* Two music score notes used for the IAP demonstration feature  */

const  char SCORE1[64]  ={//"Star war"// 
			_VOLi, _VOLi , _VOLi , _VOLi ,_VOLi, _VOLi , _VOLi, _VOLi ,
			_M m , _DO m , _SOL m, _FA q , _MI q , _RE q, _DO2 m, _SOL m, 
			_FA q, _MI q , _RE q , _DO2 m, _SOL m, _FA q, _MI q , _FA q ,
			_RE m, _RE m , _M c  , _DO m , _SOL m, _FA q, _MI q , _RE q ,
			_DO2 m,_SOL m, _FA q , _MI q , _RE q ,_DO2 m, _SOL m, _FA q ,
			_MI q, _FA q , _RE m , _RE m , _M c  ,_DO m , _FA c , _MI c ,
			_RE c, _DO c , _M sq , _DO qp, _RE q , _DO q, _SI0 c, _DO c ,
			_RE c, _M q  , _M m  ,_VOLd, _VOLd , _VOLd, _VOLd , _END_ } ;   

const  char SCORE2[64] ={//"Au clair de la lune ..." 
			_VOLi, _VOLi , _VOLi , _VOLi ,_VOLi, _VOLi , _VOLi, _VOLi ,
			_M m , _DO c , _M sq , _DO c , _M sq , _DO c ,_RE c , _MI m ,
			_RE m, _M sq , _DO c , _MI c , _RE c , _M sq , _RE c, _DO m ,
			_M m , _DO c , _M sq , _DO c , _M sq , _DO c ,_RE c , _MI m ,
			//hymne de la joie
			_VOLi, _VOLi , _VOLi, _VOLi, _VOLd, _VOLd , _VOLd ,		     
			_M m , _MI c , _M sq , _MI c , _DO c , _RE m, _M sq ,_RE c ,
			_MI c, _FA c , _M sq , _FA cp, _MI c , _M sq, _MI cp,_M c  ,
			_DO c, _RE c , _MI c , _DO c , _RE m , _M sq, _RE c , _MI c,
			_END_};    
			

 
/* Table used to display data on 7-seg display  [A .. Z]  */
    
const  char ALPHA[27]=	{ 119,124,57,94,121,113,253,118,6,30,244,56,212,55,63,115,
			  103,80,109,120,62,62,29,246,114,200,0  };
/* Table used to display digits on 7-seg display [0 .. 9]  */

const  char DIGIT[10]=	{63,6,91,79,102,109,125,7,127,111}; 

const char SEQUENCE[40] ={ 1,2,4,8,16,32,64,128,128,64,32,16,8,4,2,1,
			   129,66,36,24,24,36,66,129,129,195,231,255,
			   255,231,195,129,255,0,255,0,255,0,255,0};  


/* Global  Variables */
 
volatile char Mode;	  	/* Internal variable for mode selection, Circular Buffer */
volatile char Base_Time;   	/* Period base for the Timer A  */
volatile char Counter;	  	/* Base_time x 10  */
volatile char Counter_x10; 	/* Base_time x 100 */
volatile char Counter_x100;	/* Base_time x 1000 */
                    
volatile char Mode_Safe[4]; 	/* Used to store critical data in EEPROM */

volatile char Program;		/* Used for the IAP demo */
volatile char Test @ 0xE000; 	/* Used for the IAP demo */ 
volatile int  StartAdd	@0xA0;  /* Start Address for IAP programming */
volatile char RamBuffer[16] @0xA2; /* 32 Byte Buffer for IAP programming */ 


    
/****************************************************************************** 
Name:   main
Description: main program routine
Parameters:  Nothing
******************************************************************************/
       
       
void    main(void)     
{

 sim();      	/* Disable all interrupts */
 Base_Time=35;	/* Set the base time of timer A to 35 millisecond; */
 ST7_Init();	/* ST7  Initialization  */ 

 I2Cm_Init();	/* IC Initialization */
 Start_Safe();   /* Download  mode & counters vars from EEPROM
		   if the Last reset is caused by LVD else go in a HALT mode*/
 TIMERA_Init(Base_Time); /* Timer A initialization */
	
 /* These two lines are useful for the IAP demo */	
 FCSR=0x56;	/* Unlock FCSR with the 1st RASS Key */
 FCSR=0xAE;	/* Unlock FCSR with the 2nd RASS Key */ 
 
 rim();		/* Enable Interrupts */   

 while (1) /* Begining of the Main mode var selection using an infinite loop  */
 {        
   switch (Mode)
    {  
	case 1: /* Display " START" message on 7-Segments Leds */  
	   	Data_Display( "  START  %", (char)1,(char) 1 ); 
		break;			
	case 2: /* Display "LUD" message and wait till TEST button is pushed*/ 
		Data_Display( "LVD%",(char) 2, (char)2 ); 
		break;			
	case 3: /* Run the Low Voltage Detector ( LVD ) Demo*/  
		LVD_Demo((char)3,(char)2);
		break;				
	case 4: /* Display "AUD and CSS " message and wait till TEST button is pushed*/
		Data_Display( "AVD CSS %",(char) 4, (char)4 ); 
		break;			
	case 5: /* Run the Auxiliary Voltage Detector(AVD)& Clock Security System(CSS) Demo*/  
		AVD_CSS_Demo((char)5,(char)4 );
		break;				
	case 6: /* Display "HIO" message and wait till TEST button is pushed*/
		Data_Display( "HIO%",(char) 6, (char)8 );
		break;				
	case 7: /* Run the HIGH INPUT/OUTPUT  Demo*/
		HIGH_IO_Demo((char)7,(char)8);
		break;				
	case 8: /* Display "IAP" message and wait till TEST button is pushed*/
		Data_Display( "IAP%",(char)8, (char)16 );
		break;			
	case 9: /* Run the In Application Programming  Demo*/
		IAP_Demo();
		Mode++;  /* If the Programming was successful move to the next Step */
		break;  
	case 10: /* Display a " DONE " message */
		Data_Display( " DONE %",(char)10, (char)16 );
		break; 						
	case 11: /* Display " Concurrent IT " message and Prepare to the next Step */
		Data_Display( " CONCURRENT IT %",(char) 11, (char)32 );
		TIMERA_Disable(); /* Disable TimerA interrput to run Intterupts Demo */
		Mode++;
		break;	
	case 12: /* LED 5 will light-on and we can Start Interrupt Demo ( Buzzer) */
		ClrBit(PADR,3);		/* PA3=0  */
		ClrBit(PADR,2);		/* PA2=0  */
		SetBit(PCDR,2);		/* PC2=1  */
		ClrBit(PCDR,3);		/* PC3=0  */
		PBDR=32;  
		break ;
		 			 		
	case 13: /* Display " NESTED IT " message and set Interrupts priorities */
		TIMERA_Init(Base_Time);  /* Init Timer A to display the message */
		Data_Display( " NESTED IT %",(char) 13, (char)64 );
		TIMERA_Disable(); /* Disable TimerA to run Interrupt Demo */
		ISPR0=0xF3; /* Set software priority of EI0 to level=3 and EI1 to 2 */
		Mode++;
		break; 
	case 14: /* LED 6 will light-on and we can Start Interrupt Demo ( Buzzer) */
		ClrBit(PADR,3);		/* PA3=0    */
		ClrBit(PADR,2);		/* PA2=0    */
		SetBit(PCDR,2);		/* PC2=1    */
		ClrBit(PCDR,3);		/* PC3=0    */
		PBDR=64;
		break ;
	case 15: /* Clear Software priorities and Display a " FINISH" message */
 		ISPR0=0xFF;	/*  Reset software priority : Concurrent IT are applied  */
		TIMERA_Init(Base_Time); /* Enable Timer A Interrupt */
		Data_Display( "  FINISH  %",(char)15, (char)128);
		break;
	}  /* End Switch */
 }/* End While */
}/* End Main program  */
 


/****************************************************************************** 
Name:   ST7_Init
Description: ST7 initialization routine
Parameters:  Nothing
******************************************************************************/

void ST7_Init(void)
{ 
	
	MISCR1=0x90;	/* ei0 & ei1 External interrupts on falling edge, */
			/*MCO disable, No Slow  mode : Fosc2= Fcpu=8MHz	*/
	PADDR=0x8F; 	/* Port A configuration   */
	PAOR =0x0F;	/*PAOR =0x2F  HS:PA7,IC:PA6&4,7-seg:PA2&3, ICC:PA0&1,HS: open drain */
	PADR |=0x80;	/* PADR7= 1 in open drain floating*/  
	SetBit(PAOR,5);   /* From now DEMO button will generate an Interrput EI0 */
	
	PBDDR=0xFF ;	/* PB7:0  push-pull output  */
	PBOR =0xFF ;	/* Data display     */
	
	PCDDR=0x0E;	/* Port C configuration ;  */
	PCOR =0x0D;	/*PCOR =0x0D;  ADC input:PC5&4, Leds:PC2,Buzzer:PC1,Ei1:PC0 */
} 

/****************************************************************************** 
Name:   Start_Safe
Description: Checks the source of the Last Reset and runs the right procedure
Parameters:  Nothing
******************************************************************************/

void Start_Safe(void)
{

   if ( ValBit(SICSR,4)) /* Check if the last reset is due to the AVD */
   
   {      
	I2Cm_Rx(Mode_Safe,0x00,4,0xA0); /* Download the last mode executed  */
	Mode=Mode_Safe[0];/*Store counters from  External EEPROM when AVD demo was selected */
	Counter=Mode_Safe[1];                    
	Counter_x10=Mode_Safe[2];                  
	Counter_x100=Mode_Safe[3];                   
	ClrBit(SICSR,4);  /* Clear the AVDF flag  */
    }
    else   /* The last reset is done by external source ( RESET button)  */
    {
	Mode=0;     /* Prepare MCU to enter Halt mode  */
	Counter=0;  /* Reset all counters  */  
	Counter_x10=0;
	Counter_x100=0;
        _asm("HALT");  /*  Set the ST7 in a halt mode until an External IT */
    };
	 
 SetBit(SICSR,6);   /* Enable AVD Interrupt */
}

/****************************************************************************** 
Name:   TimerA_Init
Description: Init TimerA and generates and interrupt each (period)ms, max = 65ms
Parameters:  Nothing 
******************************************************************************/

void TIMERA_Init(char btime)
{
	TASR;		/* Clear flag  */
	TAOC2LR=0x00;
	TAOC2HR=0x00;	/* disable function */
	TACR2=0x08;	/* Ftimer =Fcpu/8 */       
	TACR1=0x40;	/* Output compare is the only interrupt enabled */      
	TAOC1R=(btime*1000);  /* if  Fcpu=8MHz */
} 

   
/****************************************************************************** 
Name:   TimerA_Disable
Description: Disable Timer A
Parameters:  Nothing 
******************************************************************************/

void TIMERA_Disable(void)      
{
	TASR;          /* Clear flag */
	TAOC2LR=0x00;
	TAOC2HR=0x00;  /* Disable function */
	TACR1=0x00;    /* Clear CR1 */
} 

/****************************************************************************** 
Name:   TimerA_Delay
Description: Waiting loop using Interrupt wait routine
Parameters:  input ( 8 bit data information) 
******************************************************************************/

void TIMERA_Delay ( char time_p )   
{
	for (time_p; time_p> 0 ; time_p --) 
	{
		Counter=0;  
		while ( Counter != 9) {}; 
	};
} 


/****************************************************************************** 
Name:   Multiplexing
Description: Display Digits on the 7-segments Displays and Leds using multiplexing
Parameters:  mils,tens, units, leds
******************************************************************************/

void Multiplexing ( char mils, char tens, char units,char leds )
{
	unsigned int temp;    	/* Temporary variable */

	ClrBit(PADR,3);		/* PA3=0 */
	ClrBit(PADR,2);		/* PA2=0 */
	ClrBit(PCDR,2);		/* PC2=0 */
	SetBit(PCDR,3);		/* PC3=1 */
	PBDR=mils;		/* Push mils on PBDR  ==> 7-seg mils */
	
	for (temp=0x4FF;temp>0;temp--) {}; /* Waiting loop */
	
	SetBit(PADR,3);		/* PA3=1 */
	ClrBit(PCDR,3);		/* PC3=0 */
	PBDR=tens;		/* Push tens on PBDR  ==> 7-seg tens */

	for (temp=0x4FF;temp>0;temp--) {};	/* waiting loop */        

	ClrBit(PADR,3);		/* PA3=0  */
	SetBit(PADR,2);		/* PA2=1  */
	PBDR=units;		/* Push units on PBDR ==> 7-seg units */
	
	for (temp=0x4FF;temp>0;temp--) {};  /* waiting loop  */  

	ClrBit(PADR,2);		/* PA2=0  */
	SetBit(PCDR,2);		/* PC2=1  */
	PBDR=leds; 		/* Push Leds on PBDR ==> led Raw */

	for (temp=0xFF;temp>0;temp--) {};  /* Waiting loop */ 

	ClrBit(PCDR,2);		/* PC2=0   */ 
	}  
        
  
/****************************************************************************** 
Name:   Data_Display
Description: Displays texts data on 7-segments and leds 
Parameters:  message , level, leds
******************************************************************************/

void Data_Display( char  *message ,char level,char leds )
{
  char i=0;
  char first, second,third; 
  
  while ( (message[i+2]!='%') & ( Mode == level)) 
  {
   Counter=0;        /* Reset counters */
   Counter_x10=0; 
   Counter_x100=0;
   
   first=message[i]-65;        
   second=message[i+1]-65;  
   third=message[i+2]-65;
   
   if ( (first < 0) | ( first > 25)   ) first=26;
   if ( (second< 0) | ( second > 25) ) second=26;
   if ( (third < 0) | ( third > 25) ) third=26;

   while ( Counter_x10 < 2  )  
   Multiplexing( ALPHA[first], ALPHA[second],ALPHA[third],leds );
   i++;  
  } 
    
 }
 
/****************************************************************************** 
Name:   LVD_Demo
Description: Read main voltage and display its value on 7-Seg
Parameters:  level, leds 
******************************************************************************/

void LVD_Demo (char level, char leds)
{

int temp;
char quo,rem;

	while ( Mode == level ) 
	{
		ADCCSR=0x25;  /*  Channel 5 and ADC on  */ 
		while (!(ADCCSR & 0x80)) {};  /* wait for ADC complete */
		ADCCSR=0;
		temp=ADCDLR;
		temp|=ADCDHR<<2;
		quo  = (((24.6*1023)/temp)/10);
		rem = ((int)((24.6*1023)/temp)%10);
		Multiplexing(DIGIT[0],DIGIT[quo]+128,DIGIT[rem],leds);
	};
}

/****************************************************************************** 
Name:   AVD_CSS_Demo
Description: AVD and CSS demo function : Displays a decimal counter
Parameters:  level , leds
******************************************************************************/
        
void AVD_CSS_Demo( char level,char leds )
{         
 while ( Mode == level)
 {      
  Multiplexing(DIGIT[Counter_x100], DIGIT[Counter_x10],DIGIT[Counter],leds );  
 }       
}


/****************************************************************************** 
Name:   HIGH_IO_Demo
Description: Read the current driven the High efficiency led 
	     and display its value on 7-Seg 
Parameters:  level, leds 
******************************************************************************/
void  HIGH_IO_Demo ( char level, char leds )
{       
unsigned int temp,temp1,Voltage;
char quo,rem; 
        
	while ( Mode == level ) 
	{ 
		PADR&=~(0x80);		/* switch on Led  */
		ADCCSR=0x24; 			/*  Channel 4 and ADC on  */ 
		while (!(ADCCSR & 0x80)) {};  	/*  Wait for ADC complete */
		temp=ADCDLR;
		temp|=ADCDHR<<2;   		/* 10 bit data voltage   */
		/*..........Main voltage value.........................*/
		ADCCSR=0x25; //  Channel 5 and ADC on   
		while (!(ADCCSR & 0x80)) {};  /* wait for ADC complete */
		ADCCSR=0;
		temp1=ADCDLR;
		temp1|=ADCDHR<<2;
		quo  = (((24.6*1023)/temp1)/10);
		rem = ((int)((24.6*1023)/temp1)%10);
		/*....................................................*/
		Voltage=10*quo+rem; /* Main voltage value */
		quo = (  (((1023-temp)*(Voltage/10.24))/10) / 10);
		rem = ( (int) (((1023-temp)*(Voltage/10.24))/10) % 10);
		Multiplexing(DIGIT[0],DIGIT[quo],DIGIT[rem],leds);  
		PADR|=0x80;/*  switch off led  */
	};
}
 


   


/****************************************************************************** 
Name:   IAP_Demo
Description: Checks the source of the Last Reset and runs the right procedure
Parameters:  Nothing
******************************************************************************/


void IAP_Demo (void)
{
	char i;
	Program=Test;   /* Test the first programmed Row */
	
	if ( Program == 1)  
	/*  Download the first music score from EEPROM 	 */
	{
		
		Data_Display( "SCORE O SCORE O%",(char) 9, (char)16 );
		SPI_Init(); 
		for ( i=0; i<4; i++)
		{ 
			StartAdd=0xE010+ 16*i;
			SPI_Rx( RamBuffer,16,128+16*i,(char)0);
			TIMERA_Delay (1);	
			sim();
			if (_fctcpy ('b')) IAP_RAM();
			rim();
		}
		SPI_Disable();
		Buffer_Seed(2);
		sim();
		if (_fctcpy ('b')) IAP_RAM();
		rim();
	}

	if ( Program == 2)
	/*  Download the second music score from EEPROM 	 */
	{
		Data_Display( "SCORE I SCORE I%",(char) 9, (char)16 );
		SPI_Init();
		for ( i=0; i<4; i++)
		{ 
			StartAdd=0xE010+ 16*i ;
			SPI_Rx( RamBuffer,16,64+16*i,(char)0);
			TIMERA_Delay (1);	
			sim();
			if (_fctcpy ('b')) IAP_RAM();
			rim();
		}
		SPI_Disable();
		Buffer_Seed(1);
		sim();
		if (_fctcpy ('b')) IAP_RAM();
		rim();
	}  
	if ( Program == 0xFF ) 
	/* Transfert music scores from ST7 to the external EEPROM*/
	{
	     	
	     	Data_Display( "TRANSFER  TRANSFER%",(char) 9, (char)16 );
	     	SPI_Init();
		for (i=0;i<8;i++)
		{ 
		  		  
		  SPI_Tx(SCORE1+i*16,16,64+i*16,(char)0);
		  TIMERA_Delay (1);
		  	
		}
		SPI_Disable();
		Buffer_Seed(1);
		sim();
		if (_fctcpy ('b')) IAP_RAM();
		rim();
	} 
}

/****************************************************************************** 
Name:   Buffer_Seed
Description: Full RamBuffer with a value
Parameters:  char (value)
******************************************************************************/

void Buffer_Seed(char value)
{
 char i;
 StartAdd=0xE000;
 for (i=0; i< 16; i++)
 RamBuffer[i]=value;

}	

/****************************************************************************** 
Name:   Leds_Sequence
Description: Runs a lighting sequence on Leds
Parameters:  nothing
******************************************************************************/

void Leds_Sequence ( void)
{
	
unsigned char i; 

	TIMERB_Disable();   /*  Disable Buzzer in The Nested Interrupts Demo */

	ClrBit(PADR,3);		/* PA3=0 */
	ClrBit(PADR,2);		/* PA2=0 */
	ClrBit(PCDR,3);		/* PC3=0 */
	SetBit(PCDR,2);		/* PC2=1     Enables Leds as Output */
        
        for ( i= 0 ; i<40 ; i++)
        {
			
		PBDR=SEQUENCE[i];  /* lit leds with the music score. */
		Wait_Poll(0x20);
	}	  
        ClrBit(PCDR,2);		/* PC2=0     Disable Leds as Output  */ 

}



/******************************************************************************
                            
                            INTERRUPTS SERVICE ROUTINES

*******************************************************************************/


/****************************************************************************** 
Name:   Inter_0
Description: External Interrupt 0 service routine
Parameters:  Nothing
******************************************************************************/

@interrupt void Inter_0(void)  /* Problem with NMI*/
{ 

	
	switch (Mode)
	{
		case 2: /* Run the LVD Demo  */
	      		Mode=3;
	      		break;
	 	case 4: /* Run the AVD Demo */
	 		Mode=5;
	 		break;
	 	case 6: /* Run the High I/O Demo */
	 		Mode=7;
	 		break;
	 	case 8 : /* Run the IAP Demo  */
	        	Mode=9;
	        	break;
	 	case  13: /* Concurrent Interrupt Demo  */
	 		Leds_Sequence();	 		
	 		break;
	 	case 14 : /* Nested Interrupt Demo   */
	        	Leds_Sequence();
	 		break; 
	 	default :  /* Any other state   */
			
			break;
	}
	
} 

/****************************************************************************** 
Name:   Inter_1
Description: External Interrupt 1 service routine
Parameters:  Nothing
******************************************************************************/

@interrupt void Inter_1(void) 
{ 

switch (Mode)
	{
		case 2: /* Skips the LVD Demo  */
	      		Mode=4;
	      		break;
	 	case 4: /* Skips the AVD Demo */
	 		Mode=6;
	 		break;
	 	case 6: /* Skips the High I/O Demo */
	 		Mode=8;
	 		break;
	 	case 8 : /* Skips the IAP Demo  */
	        	Mode=11;
	        	break;
	 	case  12: /* Concurrent Interrupt Demo  */
	 		Play_Score(SCORE1,(char)32);
	 		Mode++;
	 		break;
	 	case 14 : /* Nested Interrupt Demo   */
	        	Play_Score(SCORE1,(char)64);
	        	Mode++;
	 		break; 
	 	case 15 : /* Set Mode to 1 ( Ring Variable)  */
	 		Mode =1;
	        	break;
	 	default :  /* Any other state   */
			Mode++;/* Increment mode value to switch to another mode */
			Counter=0;/* Reset all counters  */
			Counter_x10=0;
			Counter_x100=0;
			break;
	}
}
 
/****************************************************************************** 
Name:   TimerA_rt
Description: TimerA  service routine ( This timer is used for Time counting)
Parameters:  Nothing
******************************************************************************/
 
@interrupt void TimerA_rt(void)
{  
if ( TASR&0x40 )   /* Test Output compare 1 Flag    */
 { 
 	Counter++; /* Increment counter   */
	if ( Counter > 9 ) 
	{  
		Counter=0;
		Counter_x10++;	/*  Increment Counter_x10 when counter reach 9  */
	}; 
	if ( Counter_x10 > 9 )
	{
		Counter_x10=0;
		Counter_x100++;/*  Increment Counter_x100 when counter reach 99 */
	}; 
	if ( Counter_x100 > 9)    Counter_x100=0;
		
		TAOC1R += (Base_Time*1000);/* Update the Output compare value  */
 }   
else  TAOC2LR;   
}

/****************************************************************************** 
Name:   AVD
Description: AVD service routine ( stores critical data in EEPROM using IC ) 
Parameters:  Nothing
******************************************************************************/


@interrupt void Avd(void) 
{         
	Mode_Safe[0]= Mode;		/* Save mode in 0x00 EEPROM   */
	Mode_Safe[1]= Counter;		/* Save counter in 0x01 EEPROM  */
	Mode_Safe[2]= Counter_x10;	/* Save counter_x10 in 0x02 EEPROM  */
	Mode_Safe[3]= Counter_x100;	/* Save counter_x100 in 0x03 EEPROM  */                        
	I2Cm_Tx(Mode_Safe,0x00,4,0xA0); /* Transmit the  mode_safe To the external EEPROM */
	
}       


/*** (c) 2001  STMicroelectronics ************* END OF FILE ******************/
 

 
 
 
