/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  SPI_drv.c
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : STM/CMG

******************************************************************************

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. SGS-THOMSON 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ST7 SPI peripheral software driver for a communication between an ST7 
                and an ST95040 EEPROM.
			 Three basic routines are defined :   
			- a SPI peripheral initialisation routine to define
                          the communication mode.
                        - a transmission routine which sends the bytes of 
                          the buffer.
  			  "array"  1: select the upper part of the memory
                          "Sub_add" defines the first EEPROM memory address 
                          where data are sent.  
                          "Nb" defines the number of bytes to transmit, and 
                          "*buff_add" is the first address of the buffer.

                        - a reception routine which puts the received bytes
                          from the EEPROM to the buffer.
 			 "array"  1: select the upper part of the memory
                          "Sub_add" defines the first EEPROM memory address 
                          where data are read.
                          "Nb" defines the number of octet to receive, and 
                          "*buff_add" is the first address of the buffer.
                         - a SPI peripheral disable routine to switch off
                          the communication mode.                         

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 -  V1.0  - 

******************************************************************************/

/* ExTERNAL DECLARATIONS *****************************************************/
/* List of all the variables defined in another module and used in this one. */
/* MODEL => #include {file_name}.h                                           */
#include "io72264.h"                 
#include "Lib_bits.h"                 
#include "Spi_drv.h"


/* SPI possible speeds ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/ 
/* The application is validated on a ST72511, using a 8MHz fcpu clock.          */
//  #define SPI_SPEED   0x7c  /* fcpu/2 transmission & reception.   */ 
    #define SPI_SPEED   0x5c  /* fcpu/8 transmission & reception.   */
//  #define SPI_SPEED   0x5d  /* fcpu/16 transmission & reception.  */
//  #define SPI_SPEED   0x7e  /* fcpu/32 transmission & reception.  */
//  #define SPI_SPEED   0x5e  /* fcpu/64 transmission & reception.  */
//  #define SPI_SPEED   0x5f  /* fcpu/128 transmission & reception. */
                                      
/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Init
INPUT/OUTPUT : None.
DESCRIPTION  : SPI peripheral initialisation routine.
COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SPI_Init (void)
{
	SetBit(PBDDR,3);
	SetBit(PBOR,3);	// PB3 push-pull output
	SetBit(PBDR,3);
	SPISR=3; // Master select internal mode 
	SPICR=SPI_SPEED;	// fcpu/16 transmission & reception.
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Disable
INPUT/OUTPUT : None.
DESCRIPTION  : SPI peripheral disable routine.
COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SPI_Disable (void)
{

	SPICR=0x00;
	SPISR=0x00;
	ClrBit(PBDR,3); 
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Tx
INPUT/OUTPUT : Buffer @, Number of data bytes to transmit, 1st @ EEPROM memory, 1 : upper part of the memory
DESCRIPTION  : Transmit data buffer via SPI.
COMMENTS     : 
-----------------------------------------------------------------------------*/ 
void SPI_Tx (char *buff_add,char Nb,char Sub_add,char array)
{        
char i;

ClrBit(PBDR,3); // Tie to low E2PROM S pin.
//Write_enable
	SPIDR=1		;// Send write into status register instruction
	while(ValBit(SPISR,7)==0) {}; // Wait for SPIF bit to go up (data sent).
	SPIDR; //Second step to clear the SPIF bit            
// Write into status register ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	SPIDR=0xF0 ; //New value of status register
	while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
	SPIDR; //Second step to clear the SPIF bit
	SetBit(PBDR,3); 
// Send write enable instruction ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	for(i=0;i<Nb;i++)
	{
		ClrBit(PBDR,3); // Tie to low E2PROM S pin.
		SPIDR=0x06;  //Second step to clear the SPIF bit.
		while(ValBit(SPISR,7)==0) {} ; //Wait for SPIF bit to go up (data sent). 	
		SPIDR; //Second step to clear the SPIF bit
		SetBit(PBDR,3);
		
		ClrBit(PBDR,3); // Tie to low E2PROM S pin.
		if ( array == 1) SPIDR=0x0A;
		else SPIDR=0x02;//  The value is sent when put into the SPIDR.
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		SPIDR;	//Second step to clear the SPIF bit
		
		SPIDR=Sub_add+i;
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		SPIDR; //Second step to clear the SPIF bit 
		
		SPIDR=*(buff_add+i);
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		SPIDR; 	//Second step to clear the SPIF bit
		SetBit(PBDR,3);
		
		do
		{  
			// Send read status register instruction ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	
			ClrBit(PBDR,3); // Tie to low E2PROM S pin.
			SPIDR=0x05; 
			while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
			SPIDR ;	//Second step to clear the SPIF bit
			// Generate 8 clock pulses ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			SPIDR=0x1;
			while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
			SPIDR ; //Second step to clear the SPIF bit
			SetBit(PBDR,3);
		} while(ValBit(SPIDR,0)==1);
			
		}
}
        

/*-----------------------------------------------------------------------------
ROUTINE NAME : SPI_Rx
INPUT/OUTPUT : Buffer @, Number of data bytes to receive / None.
DESCRIPTION  : Receive in data buffer via SPI.
COMMENTS     : Least significant bit first.
-----------------------------------------------------------------------------*/ 
void SPI_Rx (char *buff_add,char Nb,char Sub_add,char array)
{
char i;

	for(i=0;i<Nb;i++)
	{   
		ClrBit(PBDR,3); //Tie to low E2PROM S pin.
		if (array==1) SPIDR=0x0B;
		else SPIDR=0x03; // The value is sent when put into the SPIDR.
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		SPIDR; 	//Second step to clear the SPIF bit
		// Send read memory address ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		SPIDR=Sub_add+i;
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		SPIDR;	//Second step to clear the SPIF bit
		//Generate 8 clock pulses ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		SPIDR=0x01;// Send dummy value to generate the clock.
		while(ValBit(SPISR,7)==0) {} ;// Wait for SPIF bit to go up (data sent).
		*(buff_add+i)=SPIDR;
		SetBit(PBDR,3);
   }
}
/*** (c) 2001  STMicroelectronics ****************** END OF FILE ***/










