/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL BOARD
COMPILER : (COSMIC)
MODULE   :  SPI_drv.h
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : STM/CMG

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ST7 SPI peripheral software driver for a communication between an ST7 
                and an ST95040 EEPROM.
			Three basic routines are defined :   
			- a SPI peripheral initialisation routine to define
                          the communication mode.
                        - a transmission routine which sends the bytes of 
                          the buffer.
  			"array"  1: select the upper part of the memory
                          "Sub_add" defines the first EEPROM memory address 
                          where data are sent.  
                          "Nb" defines the number of bytes to transmit, and 
                          "*buff_add" is the first address of the buffer.

                        - a reception routine which puts the received bytes
                          from the EEPROM to the buffer.
 			  "array"  1: select the upper part of the memory
                          "Sub_add" defines the first EEPROM memory address 
                          where data are read.
                          "Nb" defines the number of octet to receive, and 
                          "*buff_add" is the first address of the buffer.
                         - a SPI peripheral disable routine to switch off
                          the communication mode.                         

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 -  V1.0  - 

******************************************************************************/

/* PREPROCESSING SYSTEM DECLARATIONS *****************************************/
/* MODEL => #define system_define value                                      */
#ifndef SPI_DRV_H
#define SPI_DRV_H


void SPI_Init    (void);
void SPI_Tx      (char* /*buff_add*/,char /*Nb*/, char /*Sub_add*/,char array /*upper part*/);
void SPI_Rx      (char* /*buff_add*/,char /*Nb*/, char /*Sub_add*/,char array /*upper part*/);
void SPI_Disable (void);
#endif

/*** (c) 2001  STMicroelectronics ****************** END OF FILE ***/
