/**************** (c) 2001  STMicroelectronics ********************************
     
PROJECT  : ST7FOPTIONS-EVAL Board
COMPILER : (COSMIC)
MODULE   :  io72264.h
VERSION  :  V 1.0
CREATION DATE :  01/11/01
AUTHOR   : STM/CMG

******************************************************************************/
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

    THE SOFTWARE INCLUDED IN THIS xxx IS FOR GUIDANCE ONLY. STMicroelectronics 
    SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL 
    DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
    
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/ 
/*	IO DEFINITIONS FOR ST72264
 *	Copyright (c) 2001 by COSMIC Software
 */
  
  
  
/*	PORTS section
 */
@tiny volatile	char PCDR    @0x00;	/* Port C Data Register */
@tiny volatile	char PCDDR   @0x01;	/* Port C Data Direction */
@tiny volatile	char PCOR    @0x02;	/* Port C Option register */
@tiny volatile	char PBDR    @0x04;	/* Port B Data Register */
@tiny volatile	char PBDDR   @0x05;	/* Port B Data Direction */
@tiny volatile	char PBOR    @0x06;	/* Port B Option Register */
@tiny volatile	char PADR    @0x08;	/* Port A Data Register */
@tiny volatile	char PADDR   @0x09;	/* Port A Data Direction */
@tiny volatile	char PAOR    @0x0a;	/* Port A Option register */

/*	Interrupt Controller section 
 */                                            
@tiny volatile	char ISPR0   @0x1c;	/* Interrupt Software Priority Reg. 0 */
@tiny volatile	char ISPR1   @0x1d;	/* Interrupt Software Priority Reg. 1 */
@tiny volatile	char ISPR2   @0x1e;	/* Interrupt Software Priority Reg. 2 */
@tiny volatile	char ISPR3   @0x1f;	/* Interrupt Software Priority Reg. 3 */
                            
/*	Miscellaneous section
 */
@tiny volatile	char MISCR1  @0x20;	/* Miscellaneous Register 1 */

/*	SPI section
 */
@tiny volatile	char SPIDR   @0x21;	/* SPI Data Register    */
@tiny volatile	char SPICR   @0x22;	/* SPI Control Register */
@tiny volatile	char SPISR   @0x23;	/* SPI Status Register  */

/*	System section
 */
@tiny volatile	char WDGCR   @0x24;	/* Watchdog Control Register       */
@tiny volatile	char SICSR   @0x25;	/* System Integrity Control/Status */
@tiny volatile	char MCCSR   @0x26;	/* Main Clock Controller Register  */ 

/*	I2C section
 */
@tiny volatile	char I2CCR   @0x28;	/* I2C Control Register       */
@tiny volatile	char I2CSR1  @0x29;	/* I2C Status Register 1      */
@tiny volatile	char I2CSR2  @0x2a;	/* I2C Status Register 2      */
@tiny volatile	char I2CCCR  @0x2b;	/* I2C Clock Control Register */
@tiny volatile	char I2COAR1 @0x2c;	/* I2C Own Address Register 1 */
@tiny volatile	char I2COAR2 @0x2d;	/* I2C Own Address Register 2 */
@tiny volatile	char I2CDR   @0x2e;	/* I2C Data Register          */

/*	TIMER A section
 */
@tiny volatile	char TACR2   @0x31;	/* Control Register 2       */
@tiny volatile	char TACR1   @0x32;	/* Control Register 1       */
@tiny volatile	char TASR    @0x33;	/* Status Register          */
@tiny volatile	int  TAIC1R  @0x34;	/* Input Capture 1 Register */
@tiny volatile	char TAIC1HR @0x34;	/* Input Capture 1 High     */
@tiny volatile	char TAIC1LR @0x35;	/* Input Capture 1 Low      */
@tiny volatile	int  TAOC1R  @0x36;	/* Output Compare 1 Register*/
@tiny volatile	char TAOC1HR @0x36;	/* Output Compare 1 High    */
@tiny volatile	char TAOC1LR @0x37;	/* Output Compare 1 Low     */
@tiny volatile	int  TACR    @0x38;	/* Counter Register         */
@tiny volatile	char TACHR   @0x38;	/* Counter High             */
@tiny volatile	char TACLR   @0x39;	/* Counter Low              */
@tiny volatile	int  TAACR   @0x3a;	/* Alternate Counter Register */
@tiny volatile	char TAACHR  @0x3a;	/* Alternate Counter High     */
@tiny volatile	char TAACLR  @0x3b;	/* Alternate Counter Low      */
@tiny volatile	int  TAIC2R  @0x3c;	/* Input Capture 2 Register   */
@tiny volatile	char TAIC2HR @0x3c;	/* Input Capture 2 High       */
@tiny volatile	char TAIC2LR @0x3d;	/* Input Capture 2 Low        */
@tiny volatile	int  TAOC2R  @0x3e;	/* Output Compare 2 Register  */
@tiny volatile	char TAOC2HR @0x3e;	/* Output Compare 2 High    */
@tiny volatile	char TAOC2LR @0x3f;	/* Output Compare 2 Low     */

/*	Miscellaneous section
 */
@tiny volatile	char MISCR2  @0x40;	/* Miscellaneous Register 2 */

/*	TIMER B section
 */
@tiny volatile	char TBCR2   @0x41;	/* Control Register 2 */
@tiny volatile	char TBCR1   @0x42;	/* Control Register 1 */
@tiny volatile	char TBSR    @0x43;	/* Status Register */
@tiny volatile	int  TBIC1R  @0x44;	/* Input Capture 1 Register */
@tiny volatile	char TBIC1HR @0x44;	/* Input Capture 1 High */
@tiny volatile	char TBIC1LR @0x45;	/* Input Capture 1 Low */
@tiny volatile	int  TBOC1R  @0x46;	/* Output Compare 1 Register */
@tiny volatile	char TBOC1HR @0x46;	/* Output Compare 1 High */
@tiny volatile	char TBOC1LR @0x47;	/* Output Compare 1 Low */
@tiny volatile	int  TBCR    @0x48;	/* Counter Register */
@tiny volatile	char TBCHR   @0x48;	/* Counter High */
@tiny volatile	char TBCLR   @0x49;	/* Counter Low */
@tiny volatile	int  TBACR   @0x4a;	/* Alternate Counter Register */
@tiny volatile	char TBACHR  @0x4a;	/* Alternate Counter High */
@tiny volatile	char TBACLR  @0x4b;	/* Alternate Counter Low */
@tiny volatile	int  TBIC2R  @0x4c;	/* Input Capture 2 Register */
@tiny volatile	char TBIC2HR @0x4c;	/* Input Capture 2 High */
@tiny volatile	char TBIC2LR @0x4d;	/* Input Capture 2 Low */
@tiny volatile	int  TBOC2R  @0x4e;	/* Output Compare 2 Register */
@tiny volatile	char TBOC2HR @0x4e;	/* Output Compare 2 High */
@tiny volatile	char TBOC2LR @0x4f;	/* Output Compare 2 Low */     

/*	SCI section
 */
@tiny volatile	char SCISR   @0x50;	/* SCI Status Register */
@tiny volatile	char SCIDR   @0x51;	/* SCI Data Register */
@tiny volatile	char SCIBRR  @0x52;	/* SCI Baud Rate Register */
@tiny volatile	char SCICR1  @0x53;	/* SCI Control Register 1 */
@tiny volatile	char SCICR2  @0x54;	/* SCI Control Register 2 */
@tiny volatile	char SCIERPR @0x55;	/* SCI Receive Prescaler */
@tiny volatile	char SCIETPR @0x56;	/* SCI Transmit Prescaler */

/*	In-Circuit Debugging section 
 */                                            
@tiny volatile	char ICDDR   @0x60;	/* IC Debugging Control Register */
@tiny volatile	char ICDSR   @0x61;	/* IC Debugging Status Register  */
@tiny volatile	int  ICDBK1  @0x62;	/* IC Debugging Breakpoint 1 Register */
@tiny volatile	char ICDBK1H @0x62;	/* IC Debugging Breakpoint 1 High */
@tiny volatile	char ICDBK1L @0x63;	/* IC Debugging Breakpoint 1 Low */
@tiny volatile	int  ICDBK2  @0x64;	/* IC Debugging Breakpoint 2 Register */
@tiny volatile	char ICDBK2H @0x64;	/* IC Debugging Breakpoint 2 High */
@tiny volatile	char ICDBK2L @0x65;	/* IC Debugging Breakpoint 2 Low */

/*	ADC section 
 */
@tiny volatile	char ADCDLR  @0x6f;	/* ADC Data Low Register */
@tiny volatile	char ADCDHR  @0x70;	/* ADC Data High Register */
@tiny volatile	char ADCCSR  @0x71;	/* ADC Control/Status Register */

/*	Flash Programming 
 */
@tiny volatile 	char FCSR    @0x72; 	/* Flash control register*/