# (c) 2000  STMicroelectronics ******************************
#
#PROJECT : ST7265 5in1 Demo with DFU feature
#
#VERSION :  V 1.0
#
#CREATION DATE :  15/07/2002
#
#AUTHOR : MICROCONTROLLER DIVISION / ST Rousset
#
#-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
#
# Modify from the 5in1 demo
#
#************************* EXECUTABLE COMMAND DEFINES *************************/

ENV = 	default.env
CC  =   $(COMP) $(FLAGS) -DDFU_DEMO_FLASH_ONLY

#************************** OBJECT FILES DEFINES ******************************

OBJ_LIST   = 	descript.o Appli.o MAL_Func.o \
		main.o map_7265.o Int_7265.o \
		usb_ep1.o usb_ep2.o usb_lib.o usb_int.o \
		User_usb.o BOT.o MSL.o RBC.o \
		dfu.o dfu_desc.o dfu_var.o app_usb.o usb_eps.o AppTable.o \
		MAL.o MAL_init.o MAL_MMC.o MAL_SMC.o MAL_Map.o \
		DTC_Func.o MMC_DTC.o SMC_DTC.o SMC_Mass.o SMC_ECC.o \
		CFC_DTC.o MAL_CFC.o \
		MS_DTC.o MAL_MS.o MS_Mass.o

               
#******************************************************************************
DFU_5in1.abs : 	$(ENV) $(OBJ_LIST) DFU_5in1.prm
		$(LINK) DFU_5in1.prm
#******************************************************************************

#*** BURNING ***

	$(BURN) -f Burner.cmd

# -----------------------
# APPLI			--------------------------------------------------------
# -----------------------

Appli.o :	$(ENV) Appli.c Appli.h descript.h
			$(CC) Appli.c 

descript.o :	$(ENV) descript.c descript.h
			$(CC) descript.c   
				
ui.o :		$(ENV) ui.c Appli.h descript.h
			$(CC) ui.c 

MAL_Func.o:	MAL_Func.c MAL_Func.h MConfig.h
	$(CC) MAL_Func.c


# -----------------------
# MAIN ---------------------------------------------------------------
# -----------------------

main.o :	$(ENV) main.c main.c map_7265.h dfu.h
			$(CC) main.c

# -----------------------
# DFU			--------------------------------------------------------
# -----------------------
dfu.o:	$(ENV) dfu.c dfu.h mcu_conf.h usb_def.h usb_reg.h usb_lib.h user_usb.h app_usb.h flashing.h usb_eps.h
	$(CC) dfu.c

dfu_desc.o:	$(ENV) dfu_desc.c dfu.h
	$(CC) dfu_desc.c

app_usb.o:	$(ENV) app_usb.c
	$(CC) app_usb.c

AppTable.o:	$(ENV) AppTable.c
	$(CC) AppTable.c
#	$(ASM) AppTable.asm -ml -l

dfu_var.o:	$(ENV) dfu_var.asm
	$(ASM) dfu_var.asm -ml -l

# -----------------------
# USB			--------------------------------------------------------
# -----------------------

map_7265.o :	$(ENV) map_7265.c CondComp.h map_7265.h
				$(CC) map_7265.c

Int_7265.o :	$(ENV) Int_7265.c Int_7265.h CondComp.h hidef.h descript.h MAL_Func.h
			$(CC) Int_7265.c



usb_lib.o: usb_lib.c usb_reg.h usb_def.h usb_libs.h mcu_conf.h map_7265.h usb_lib.h user_usb.h usb_eps.h
	$(CC) usb_lib.c

usb_int.o: usb_int.c usb_reg.h usb_def.h usb_lib.h usb_libs.h mcu_conf.h map_7265.h usb_eps.h
	$(CC) usb_int.c

usb_ep1.o: usb_ep1.c usb_reg.h usb_def.h usb_lib.h mcu_conf.h map_7265.h usb_eps.h
	$(CC) usb_ep1.c

usb_ep2.o: usb_ep2.c usb_reg.h usb_def.h usb_lib.h mcu_conf.h map_7265.h usb_eps.h
	$(CC) usb_ep2.c



# -----------------------
# MICRO			--------------------------------------------------------
# -----------------------
usb_eps.o: usb_eps.h usb_eps.c
	$(CC) usb_eps.c

User_usb.o :	$(ENV) User_usb.c User_usb.h CondComp.h hidef.h descript.h dfu.h
				$(CC) User_usb.c

   
# -----------------------
# CLASS LAYER     --------------------------------------------------------------
# -----------------------

BOT.o :		$(ENV) BOT.c BOT.h CondComp.h hidef.h descript.h SenseDat.h \
		User_usb.h 
	$(CC) BOT.c
		
MSL.o:		$(ENV) MSL.c
	$(CC) MSL.c

RBC.o :		$(ENV) RBC.c RBC.h CondComp.h hidef.h descript.h SenseDat.h \
		User_usb.h 
	$(CC) RBC.c
		
# -----------------------
# MAL LAYER     ----------------------------------------------------------------
# -----------------------
MAL.o: MAL.c MSL.h MAL.h MAL_Func.h MConfig.h
	$(CC) MAL.c

MAL_init.o:	MAL_init.c MAL_Map.h
	$(CC) MAL_init.c

MAL_MMC.o:	MAL_MMC.c MSL.h MAL.h MConfig.h MAL_Map.h
	$(CC) MAL_MMC.c

MAL_SMC.o:	MAL_SMC.c MSL.h MAL.h MConfig.h MAL_Map.h SMC_Mass.h
	$(CC) MAL_SMC.c

MAL_CFC.o:	MAL_CFC.c MSL.h MAL.h MConfig.h MAL_Map.h
	$(CC) MAL_CFC.c
	
MAL_MS.o:	MAL_MS.c MSL.h MAL.h MConfig.h MAL_Map.h
	$(CC) MAL_MS.c

MAL_Map.o:	MAL_Map.c
	$(CC) MAL_Map.c

# -----------------------
# DTC LAYER     -----------------------------
# -----------------------

DTC_Func.o:	DTC_Func.c Map_7265.h MAL_Map.h DTC_Func.h
	$(CC) DTC_Func.c

MMC_DTC.o:	MMC_DTC.c
	$(CC) MMC_DTC.c

CFC_DTC.o:	CFC_DTC.c
	$(CC) CFC_DTC.c
	
MS_DTC.o:	MS_DTC.c MS_DTC_Search_end.hex MS_DTC_end.hex \
		MS_DTC_Format_end.hex MS_DTC_Read_ff_end.hex \
		MS_DTC_Upld_end.hex MS_DTC_Dwld_end.hex
	$(CC) MS_DTC.c

SMC_DTC.o:	SMC_DTC.c smc_dtc_code0_end.hex smc_dtc_download_end.hex \
		smc_dtc_format_end.hex smc_dtc_maprange_end.hex \
		smc_dtc_mapzone_end.hex smc_dtc_play_end.hex \
		smc_dtc_upload_end.hex smc_dtc_play_read_end.hex
	$(CC) SMC_DTC.c

SMC_Mass.o:	SMC_Mass.c Map_7265.h MAL_Map.h MAL_SMC.h \
		SMC_Mass.h DTC_Func.h SMC_DTC.h
	$(CC) SMC_Mass.c

SMC_ECC.o:	SMC_ECC.c Map_7265.h MAL_Map.h SMC_Mass.h
	$(CC) SMC_ECC.c
	
MS_Mass.o:	MS_Mass.c Map_7265.h MAL_Map.h MAL_MS.h \
		MS_Mass.h DTC_Func.h MS_DTC.h
	$(CC) MS_Mass.c

#********** (c) 2000   STMicroelectronics *************** END OF FILE *********

