/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef BOT_H
#define BOT_H 

//  BOT Status
#define BOT_STATUS_GOOD 	0x00
#define BOT_STATUS_FAIL 	0x01
#define BOT_STATUS_PHASE 	0x02

// BOTStateMachine selector
#define BOT_READY   		1	 				// Default state waiting CSW 
#define BOT_DATA_IN   		(BOT_READY+1)		// receiving parameters for the request
#define BOT_DATA_OUT    	(BOT_READY+2)		// sending parameters for the request
#define BOT_SDATA_IN		(BOT_READY+3)		// receiving stream data with DTC
#define BOT_SDATA_OUT		(BOT_READY+4)		// sending stream data with DTC
#define BOT_CSW_SEND		(BOT_READY+5)		// waiting to send a CSW
#define BOT_WAIT_CSW_SENT	(BOT_READY+6)		// waiting for CSW to be sent
#define BOT_ABORT			(BOT_READY+7)		// endpoint is STALLed
#define BOT_WAIT_REQUEST_SENSE	(BOT_READY+8)	// CBW Error

extern void BOT_Action(void);
extern void BOT_POLLING(void);
extern char Wait_Data(void);
extern void BOT(char);
extern void Send_Data(char *, unsigned long);
extern void Send_CSW(void);
extern void BOT_Init(void);
  
#endif

/**************** (c) 2000  STMicroelectronics **********************/
