/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef RBC_EXE_H
#define RBC_EXE_H

//  RBC Status              	
#define RBC_STATUS_GOOD 		0x00
#define RBC_STATUS_FAIL 		0x01
#define RBC_STATUS_PHASE 		0x02

#define LENGTH_INQUIRY_PAGE00		96
#define LENGTH_INQUIRY_PAGE80		16
#define LENGTH_INQUIRY_PAGE83		41

//  Current_Operation values
#define RBC_OP_IDLE		0x00
#define RBC_OP_READ		0x01
#define RBC_OP_WRITE	0x02
#define RBC_OP_VERIFY	0x04
#define RBC_OP_USB		0x0F		// Mask
#define RBC_OP_FORMAT	0x10
#define RBC_OP_FORMAT0	0x20

// RBC command structures
typedef struct _CMD_INQUIRY {
	unsigned char	Op_code;
	unsigned char	Evpd:1;			// Bit 0
	unsigned char	CmdDt:1;		// Bit 1
	unsigned char	Reserved:6;		// Bit 2-7
	unsigned char	Page;
	unsigned char	Reserved1;
	unsigned char	Allocation_Length;
	unsigned char	Control;
} CMD_INQUIRY;

typedef struct _CMD_MODE_SELECT6 {
	unsigned char	Op_code;

	unsigned char	SP:1;				// Bit 0. Save Page
	unsigned char	Reserved0:3;		// Bit 1-3.
	unsigned char	PF:1;				// Bit 4. Page Format
	unsigned char	Reserved1:3;		// Bit 5-7

	unsigned char	Reserved2;
	unsigned char	Reserved3;
	unsigned char	Para_Length;
	unsigned char	Control;
} CMD_MODE_SELECT6;

typedef struct _CMD_MODE_SENSE6 {
	unsigned char	Op_code;

	unsigned char	Reserved0:3;		// Bit 0-2
	unsigned char	DBD:1;				// Bit 3
	unsigned char	Reserved1:3;		// Bit 4-7

	unsigned char	PC_Page;
	unsigned char	Reserved;
	unsigned char	Para_Length;
	unsigned char	Control;
} CMD_MODE_SENSE6;

typedef struct _CMD_MODE_SENSE10 {
	unsigned char	Op_code;

	unsigned char	Reserved0:3;		// Bit 0-2
	unsigned char	DBD:1;				// Bit 3
	unsigned char	Reserved1:3;		// Bit 4-7

	unsigned char	PC_Page;
	unsigned char	Reserved[4];
	unsigned short	Para_Length;
	unsigned char	Control;
} CMD_MODE_SENSE10;

typedef struct _CMD_PRENVENT_REMOVAL {
	unsigned char	Op_Code;
	unsigned char	Reserved[3];
	unsigned char	Reserved_Prevent;
	unsigned char	Control;
} CMD_PRENVENT_REMOVAL;

typedef struct _CMD_READ_CAPACITY {
	unsigned char	Op_Code;
	unsigned char	Reserved[8];
	unsigned char	Control;
} CMD_READ_CAPACITY;

typedef struct _CMD_START_STOP {
	unsigned char	Op_Code;
	unsigned char	Immed:1;			// Bit 0
	unsigned char	Reserved0:7;		// Bit 1-7
	unsigned char	Reserved[2];
	unsigned char	Power_Control;
	unsigned char	Control;
} CMD_START_STOP;

typedef struct _CMD_REQUEST_SENSE {
	unsigned char	Op_code;
	unsigned char	Reserved[3];
	unsigned char	Length;
	unsigned char	Control;
} CMD_REQUEST_SENSE;

typedef struct _CMD_READ10 {
	unsigned char	Op_code;
	unsigned char	Reserved0;
	unsigned long	Block_Address;
	unsigned char	Reserved1;
	unsigned short	Length;
	unsigned char	Control;
} CMD_READ10;

typedef struct _CMD_WRITE10 {
	unsigned char	Op_code;
	unsigned char	Reserved0;		// Assume FUA bit is 0
	unsigned long	Block_Address;
	unsigned char	Reserved1;
	unsigned short	Length;
	unsigned char	Control;
} CMD_WRITE10;

typedef struct _CMD_VERIFY10 {
	unsigned char	Op_code;
	unsigned char	Reserved0;
	unsigned long	Block_Address;
	unsigned char	Reserved1;
	unsigned short	Length;
	unsigned char	Control;
} CMD_VERIFY10;

typedef union _RBC_CMD {
	unsigned char bRBC_Cmd[16];
	CMD_INQUIRY		Cmd_Inquiry;
	CMD_MODE_SELECT6	Cmd_MSelect6;
	CMD_MODE_SENSE6		Cmd_MSense6;
	CMD_MODE_SENSE10	Cmd_MSense10;
	CMD_PRENVENT_REMOVAL	Cmd_Prevent;
	CMD_READ_CAPACITY	Cmd_Capacity;
	CMD_START_STOP		Cmd_StartStop;
	CMD_REQUEST_SENSE	Cmd_ReqSense;
	CMD_READ10		Cmd_Read10;
	CMD_WRITE10		Cmd_Write10;
	CMD_VERIFY10		Cmd_Verify10;
} tRBC_CMD;

#define	RBC_Cmd			sRBC_CMD.bRBC_Cmd
#define CMD_Inquiry		sRBC_CMD.Cmd_Inquiry
#define CMD_MSelect6		sRBC_CMD.Cmd_MSelect6
#define CMD_MSense6		sRBC_CMD.Cmd_MSense6
#define CMD_MSense10		sRBC_CMD.Cmd_MSense10
#define CMD_Prevent		sRBC_CMD.Cmd_Prevent
#define CMD_RCapacity		sRBC_CMD.Cmd_Capacity
#define CMD_StartStop		sRBC_CMD.Cmd_StartStop
#define CMD_ReqSense		sRBC_CMD.Cmd_ReqSense
#define CMD_Read		sRBC_CMD.Cmd_Read10
#define CMD_Write		sRBC_CMD.Cmd_Write10
#define CMD_Verify		sRBC_CMD.Cmd_Verify10

extern tRBC_CMD	sRBC_CMD;

///////////////////////////////////
extern char RBC_Process(unsigned char lun);
extern void RBC_Init(void);
extern void RBC_Reset(void);
extern unsigned int RBC_Finish(void);

extern char RBC_Test_Ready();
extern char RBC_Request_Sense();
extern char RBC_Inquiry(CMD_INQUIRY *pCmd);
extern char RBC_Mode_Sense6(CMD_MODE_SENSE6 *pCmd);
extern char RBC_Mode_Select6(CMD_MODE_SELECT6 *pCmd);
extern char RBC_Mode_Sense10(CMD_MODE_SENSE10 *pCmd);
extern char MAL_Prevent_Removal();
extern char MAL_Format();
#ifdef	RBC_TEST
extern char MAL_Read_Capacity();
extern char MAL_Read( );
extern char MAL_Write( );
extern char MAL_Verify( );
#endif
extern char MAL_Mode_Select6(char);
extern char Medium_Information();
extern char MAL_Mode_Sense6(char, unsigned long);
extern char MAL_Start_Stop(char);

typedef struct _SENSE_DATA {
/*
	unsigned char	Valid:1;					// default = 0x0
	unsigned char	Response_Code:7;			// default = 0x70
*/
	unsigned char	Resp_Code;
// 0:	0x70
	unsigned char	Segment_Number;				// default = 0x00
// 1:	0x00
/*
	unsigned char	FileMark:1;					// reserved, default = 0x0
	unsigned char	End_of_Medium:1;			// reserved, default = 0x0
	unsigned char	Incorrect_Length:1;			// logical block length did not match the medium. default = 0x0
	unsigned char	Reserved:1;					// default = 0x0
	unsigned char	Sense_Key:4;				// application related
*/
	unsigned char	Sense_Key;
// 2:	0000????b
	DWORD	Information;				// reserved, default = 0x00000000
// 3:	0x00000000
	unsigned char	Additional_sense_length;	// sizeof(SENSE_DATA) - 7, default = 0x0c
// 7:	0x0c
	DWORD	Cmd_Information;			// reserved, default = 0x00000000
// 8:	0x00000000
	unsigned char	ASC;						// Additional Sense Code, applicatoin related
// 12:	0x??
	unsigned char	ASCQ;						// Additional Sense Code Qualifier, application related
// 13:	0x??
	unsigned char	FRUC;						// Field Replaceable Unit Code, reserved
// 14:	0x00
/*
	unsigned char	SKSV:1;
	unsigned char	TBD:7;
*/
	unsigned char	TBD;
// 15:	0x00
	unsigned int	Sense_Key_Specific;
// 16:	0x0000
	unsigned char	ASB[2];						// Additional Sense Bytes, reserved
// 18:	0x00, 0x00
} SENSE_DATA;

#endif
/**************** (c) 2000  STMicroelectronics **********************/
