/*
STMicroelectronics CONFIDENTIAL
***************************************************************************************
COPYRIGHT 2001 STMicroelectronics

Source File Name : MAL_CFC.C  
Code size        :
Author(Initial)  : Roopa Iyer / Phone- 6134/roopa-natarajan.iyer@st.com
Author (Initial) : 
Group            : IPDF - CMG -IPSW
Address          : Sector 16A Plot No 2 & 3, Institutional Area Noida UP
Date First Issued:
********************************Documentation******************************************
Description :

This MAL_CFC.C file is the source code for the DTC-CF card project.
It contains all the functions written in C and optimised Assembly.

********************************Revision History***************************************
_______________________________________________________________________________________
Date : 			Release:0.0     	Modification:   	Initial:   
_______________________________________________________________________________________
*/

#include "map_7265.h"
#include "define.h"
#include "hidef.h"
#include "dtc_func.h"
#include "Mconfig.h"
#include "cfc_dtc.h"
#include "mal_map.h"
#include "mal_cfc.h"
#include "MAL.h"  
#include "MSL.h"

//#include "atacmd.h"

/* Global Variables declarations, used by MAL - remove while integration */

/*                        
BYTE MAL_Errorno ;      
BYTE MAL_Mediano ;                         
BYTE MAL_Progress ;
WORD  MAL_Block_Numbers;
DWORD MAL_Block_Address;
DWORD MAL_Capacity;
                          */

/* Following are the Global variables used by CFC-MAL */

#pragma DATA_SEG MAL_RAM
static unsigned char CFC_State ;                                 
static unsigned char DTC_Int_Wait ;                                                    
//static unsigned char DTC_CFC_Current_Func;                       

static unsigned char IT_Type ;           // BETTER TO USE GLOBAL VARIABLES FOR ISR !!!!
static unsigned int  Blocks_Transferred ; // BETTER TO USE GLOBAL VARIABLES FOR ISR !!!!
static unsigned char Card_Status ;           // BETTER TO USE GLOBAL VARIABLES FOR ISR !!!!

static DWORD LBA_Address ;
static BYTE CFC_Status ;
static int Delay, SubDelay ;
static unsigned long Local_Capacity ;

extern unsigned char DTC_Code_Number;
              
/**************************************************************/

/*	Functions starts NOW */
#pragma CODE_SEG CFC_CODE

/******************************************************************************
Routine name  : CFC_Init 
Argument      : void
Return        : void  
Variable      : 
Purpose       : To Initialise the CFC - Only ST7 part
SubComponents : 
******************************************************************************/
                                   
unsigned char CFC_Init ()                   
{               
	Enable_DTC_Int() ;	/* Enable DTC Interrupt */
	DTC_Int_Wait = 1 ;      /* Global Flag To Indicate Interrupt Arrival */
	
	/* Configure PE2 as Open Drain Output to generate CE (CE1)
	   CE2 will be permanently tied high 
	   At start, CE1 should be high and will be driven low by
	   ST7 just before the commencement of a Read/ Write cycle */
	
	PEDDR |= 0x04 ;
	PEOR  &= 0xFB ;  /* Open Drain O/P PE2 */
	PEDR  |= 0x04 ;  /* CE1 = Open Drain Output - Pullup to VDDF */	
	
	/* At Power On, the CFC gets reset if the RESET pin is 
	   left open. After Power On, the minimum time required to
	   detect a valid RESET and latch the BSY bit high, is 
	   [ ( 25 MicroSecs + 400 NanoSecs) -> ATA Specs ]
	   The wait for BSY bit to get cleared, should start only 
	   after this time */
	
	/* Assuming that ST7 is operating at 6 MHz */
	/* 1 Count ~= 1 Clock Cycle, For 50 MicroSecs */

/*	
	for ( Delay = 0 ; Delay < 10000 ; Delay ++ ) 
	{
		asm nop ;
		asm nop ;                            
		for ( SubDelay = 0 ; SubDelay < 100 ; SubDelay ++ ) ;
		asm nop ;
		asm nop ;                            
	}                 
	
	Card_Status = CFC_Test_Ready () ;
	
	asm nop ;

	return Card_Status ;
*/
	return MAL_GOOD ;

}                           
/********************************************************************
Routine name  : CFC_Test_Ready
Argument      : void 
Return        : BOOL  FALSE   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To Read single block from CFC
SubComponents : 
*********************************************************************/

BOOL CFC_Test_Ready (void)
{                   
        /* Assert CE1 low for reading Status Reg. of CFC */
        PEDR &= 0xFB ;

        DTC_Load_Code (CFC_DTC_Test_Ready) ; 
		DTC_Code_Number = CFC_DTC_TEST_READY;
	DTC_Process (CFC_DTC_INIT) ;	
	Wait_DTC_IT () ;                      
	
//	PEDR |= 0x04 ;
	
	MAL_Error = Buffer_Param[0] ;
	
	CFC_State = CARD_ACTIVE_STATE ;
	
	return MAL_Error ;
	
}
/********************************************************************
Routine name  : CFC_CheckResetSignature 
Argument      : void 
Return        : BYTE  0x00   Request Failed
 		      0x01   Request Passed		
Variable      : 
Purpose       : To Read the Device Reset Register Values
SubComponents : 
*********************************************************************/

BYTE CFC_CheckResetSignature (void)
{                   
        /* Assert CE1 low for reading Status Reg. of CFC */
        
	PEDR &= 0xFB ;
        
        DTC_Load_Code (CFC_DTC_Test_Ready) ;
	DTC_Code_Number = CFC_DTC_TEST_READY;
	DTC_Process (CFC_DTC_INIT) ;	/* INIT CFC */
	Wait_DTC_IT () ;                      
	
	PEDR |= 0x04 ;
	
	return 1 ;
} 
/********************************************************************
Routine name  : CFC_Read_Capacity
Argument      : void 
Return        : BOOL  FALSE   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To Read the Device Capacity
SubComponents : 
*********************************************************************/

BOOL CFC_Read_Capacity (void)
{                                                  
	EnableInterrupts;	

// for testing 	

	for ( Delay = 0 ; Delay < 10 ; Delay ++ ) 
	{
		asm nop ;
		asm nop ;                            
		for ( SubDelay = 0 ; SubDelay < 10 ; SubDelay ++ ) ;
		asm nop ;
		asm nop ;                            
	}                 
	
	CFC_Status = CFC_Test_Ready () ;
	
	if ( CFC_Status == 0x00 )
	{
		asm nop ;

		// CFC_Init () ;
        
		PEDR &= 0xFB ;
        
	        DTC_Load_Code (CFC_DTC_Read_Capacity) ;
			DTC_Code_Number = CFC_DTC_READ_CAPACITY;
		DTC_Process (CFC_DTC_INIT) ;	/* Read CFC Capacity */
		Wait_DTC_IT () ;                      
	
		PEDR |= 0x04 ;               

		MAL_Error = Buffer_Param[0] ;
	
		MAL_Capacity &= 0x0000 ;
		Local_Capacity &= 0x0000 ;	
	
		Local_Capacity |= Buffer_Param[10] ;	
		Local_Capacity <<= 24 ; 
		Local_Capacity |= Buffer_Param[9] ;	
		Local_Capacity <<= 16 ; 
		Local_Capacity |= Buffer_Param[12] ;	
		Local_Capacity <<= 8 ;                    
		Local_Capacity |= Buffer_Param[11] ;			
	
		MAL_Capacity = Local_Capacity ;
	
		if ( MAL_Error == 0x00 )
		{
			return MAL_GOOD ;
		}
		else
		{
			return MAL_Error ;
		}
	}                 
	else
	{
		return CFC_Status ;
	}
} 

/********************************************************************
Routine name  : CFC_Read
Argument      : void 
Return        : BOOL  FALSE   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To Read multiple blocks from CFC
SubComponents : 
*********************************************************************/

BOOL CFC_Read (void)
{                                       
	MAL_Block_Finish = 0 ;		     
	
	if ( CFC_State == CARD_ACTIVE_STATE )
	{
		CFC_Status = CFC_Test_Ready () ;
		
		if ( CFC_Status == 0x00 )
		{
			/* To set the USB to the Upload Mode */
			_MAL_BufMgr_Upload();		
			PEDR &= 0xFB ;
	       		CFC_State = DTC_CFC_READ_STATE ;      	
	       	}
      	}
	
	if ( CFC_State == DTC_CFC_READ_STATE )
	{
		LBA_Address = MAL_Block_Address ;
        
		Buffer_Param[14] = ( (BYTE) LBA_Address ) ;
        	Buffer_Param[15] = ( (BYTE) (LBA_Address  >> 8) ) ;
       		Buffer_Param[16] = ( (BYTE) (LBA_Address >> 16) ) ;
        	Buffer_Param[17] = ( (BYTE) (((LBA_Address >> 24) & 0x0F)|0xE0) ) ;        
       		Buffer_Param[18] = READ_SEC ;      /* Read Sector(s) command */
        	
       		if ( ( MAL_Block_Numbers & 0xFF00 ) )
	       	{
       	        	Buffer_Param[13] = 0 ; /* 256 Sectors */
		}
		else
	       	{       
			Buffer_Param[13] =  MAL_Block_Numbers  ;
	       	}       	
			       	
	       	Enable_DTC_Int() ;

		DTC_Load_Code (CFC_DTC_Read) ;
		DTC_Code_Number = CFC_DTC_READ;
		DTC_Process (CFC_DTC_INIT) ;	/* Read CFC Capacity */

		return MAL_GOOD ;
	}
	else
	{
		return CFC_Status ;
	}
		
} 
/********************************************************************
Routine name  : CFC_Write
Argument      : void 
Return        : BOOL  FALSE   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To Write multiple blocks of CFC
SubComponents : 
*********************************************************************/

BOOL CFC_Write (void)
{                                       
	MAL_Block_Finish = 0 ;
	
	if ( CFC_State == CARD_ACTIVE_STATE )
	{
		CFC_Status = CFC_Test_Ready () ;
		
		if ( CFC_Status == 0x00 )
		{                       
			/* To set the USB to the Download Mode */
 			_MAL_BufMgr_Download();		
	        	PEDR &= 0xFB ;
       			CFC_State = DTC_CFC_WRITE_STATE ;      	
	      	}       
	}
	
	if ( CFC_State == DTC_CFC_WRITE_STATE )
	{
		LBA_Address = MAL_Block_Address ;
	        
        	Buffer_Param[14] = ( (BYTE) LBA_Address ) ;
	        Buffer_Param[15] = ( (BYTE) (LBA_Address  >> 8) ) ;
        	Buffer_Param[16] = ( (BYTE) (LBA_Address >> 16) ) ;
	       	Buffer_Param[17] = ( (BYTE) (((LBA_Address >> 24) & 0x0F)|0xE0) ) ;        
	       	Buffer_Param[18] = WRITE_SEC ;      /* Write Sector(s) command */
        	
        	if ( ( MAL_Block_Numbers & 0xFF00 ) )
        	{
	        	Buffer_Param[13] = 0 ; /* 256 Sectors */
       		}
       		else
	       	{       
       			Buffer_Param[13] =  MAL_Block_Numbers  ;
	       	}       	          
		       	
	       	Enable_DTC_Int() ;

        	DTC_Load_Code (CFC_DTC_Write) ;
			DTC_Code_Number = CFC_DTC_WRITE;
		DTC_Process (CFC_DTC_INIT) ;

		return MAL_GOOD ;
	}
	else
	{
		return CFC_Status ;
	}
} 

/********************************************************************
Routine name  : CFC_sRead
Argument      : void 
Return        : BOOL  FALSE   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To Read single block from CFC
SubComponents : 
*********************************************************************/

BOOL CFC_sRead (void)
{                   
	/* To set the USB to the Upload Mode */
	
	   _MAL_BufMgr_Upload();	

//	EP2TXR = (EP2TXR & 0x04) | 0x02; // NAK on Xmit, Keep DTOG
//	CNT2TXR = 64;		// Set Xmit counter
//	CNT2RXR = 64;		// Set Recv counter
//	USB_BUFSR = 0x01;		// Clear Buffer status
//	USB_BUFSR = 0;
//	EP2RXR = (EP2RXR & 0x04) | 0x42;	// NAK on Recv & switch to UPLOAD mode
	
        /* Assert CE1 low for reading Status Reg. of CFC */
        PEDR &= 0xFB ;

	LBA_Address = MAL_Block_Address ;
		        
        Buffer_Param[14] = ( (BYTE) LBA_Address ) ;
        Buffer_Param[15] = ( (BYTE) (LBA_Address  >> 8) ) ;
        Buffer_Param[16] = ( (BYTE) (LBA_Address >> 16) ) ;
        Buffer_Param[17] = ( (BYTE) (((LBA_Address >> 24) & 0x0F)|0xE0) ) ;        
        Buffer_Param[18] = READ_SEC ;      /* Read Sector(s) command */
        
        DTC_Load_Code (CFC_DTC_sRead) ; 
	DTC_Process (CFC_DTC_INIT) ;	
	Wait_DTC_IT () ;                      
	
	PEDR |= 0x04 ;
	
	MAL_Error = Buffer_Param[0] ;
	
	if ( MAL_Error != MAL_GOOD )
	{
		return FALSE ;
	}
	else
	{       
		/* Increment the Block Address by 1 sector */
		MAL_Block_Address = MAL_Block_Address + 1 ;  
		/* Make Block Numbers = 0 */
		MAL_Block_Numbers = 0 ;
		return TRUE ;
	}
}
/********************************************************************
Routine name  : CFC_sWrite
Argument      : void 
Return        : BOOL  False   Request Failed
 		      TRUE    Request Passed		
Variable      : 
Purpose       : To write single block to CFC
SubComponents : 
*********************************************************************/

BOOL CFC_sWrite (void)
{                   
	/* To set the USB to the Download Mode */
        _MAL_BufMgr_Download();	
	
//	EP2TXR = (EP2TXR & 0x04) | 0x02;	/* NAK on Xmit, Keep DTOG */
//	CNT2RXR = 64;	/* Set Recv counter */
//	USB_BUFSR = 0x01;	/* Clear Buffer status */
//	USB_BUFSR = 0;
//	EP2RXR = (EP2RXR & 0x04) | 0x82;	/* NAK on Recv & switch to DOWNLOAD mode */	

        /* Assert CE1 low for reading Status Reg. of CFC */
        PEDR &= 0xFB ;

	LBA_Address = MAL_Block_Address ;
		        
        Buffer_Param[14] = ( (BYTE) LBA_Address ) ;
        Buffer_Param[15] = ( (BYTE) (LBA_Address  >> 8) ) ;
        Buffer_Param[16] = ( (BYTE) (LBA_Address >> 16) ) ;
        Buffer_Param[17] = ( (BYTE) (((LBA_Address >> 24) & 0x0F)|0xE0) ) ;        
        Buffer_Param[18] = WRITE_SEC ;  /* Write Sector(s) command */
        
        DTC_Load_Code (CFC_DTC_sWrite) ; 
	DTC_Process (CFC_DTC_INIT) ;	
	Wait_DTC_IT () ;                      
	
	PEDR |= 0x04 ;
	
	MAL_Error = Buffer_Param[0] ;
	
	if ( MAL_Error != MAL_GOOD )
	{
		return FALSE ;
	}
	else
	{       
		/* Increment the Block Address by 1 sector */
		MAL_Block_Address = MAL_Block_Address + 1 ;  
		/* Make Block Numbers = 0 */
		MAL_Block_Numbers = 0 ;
		return TRUE ;
	}
}
/*-----------------------------------------------------------------------------
ROUTINE NAME : Wait_DTC_IT
INPUT/OUTPUT : None
DESCRIPTION  : None
-----------------------------------------------------------------------------*/
#pragma NO_OVERLAP
void Wait_DTC_IT (void)
{
 while (DTC_Int_Wait)    // wait for the DTC interrupt
 asm NOP;
 DTC_Int_Wait = 1;      
}

/*******************************************************************************
Routine name  : CFC_DTC_Int
Argument      : void 
Return        : void 
Variable      : 
Purpose       : DTC interrupt function 
SubComponents : 
*******************************************************************************/
#pragma NO_OVERLAP
void CFC_DTC_Int ()
{
//	unsigned char IT_Type ;       // Type of IT from FCISTATUS 
//	unsigned int Blocks_Transferred ; // BETTER TO USE GLOBAL VARIABLES !!!!!!!!

	IT_Type = DTCSTATUS & 0x03;   // FCISTATUS read and clear
	DTC_Int_Wait = 0;
 
    	if ( ( CFC_State == DTC_CFC_READ_STATE ) ||  ( CFC_State == DTC_CFC_WRITE_STATE ) )
	{
		MAL_Error = Buffer_Param[0] ;
		
		if ( ( MAL_Error == MAL_GOOD ) && ( Buffer_Param[13] == 0 ) && ( IT_Type == 0x01 ) )
		{
			if ( MAL_Block_Numbers & 0xFF00 ) 
			{
				MAL_Block_Numbers = MAL_Block_Numbers - 256 ;
				MAL_Block_Address = MAL_Block_Address + 255 ;                         
			}
			else
			{
				MAL_Block_Address = ( ( MAL_Block_Address + MAL_Block_Numbers ) - 1 );
				MAL_Block_Numbers = 0 ;
			}
		}
		else if ( IT_Type == 0x02 )
		{
			Blocks_Transferred = MAL_Block_Numbers - Buffer_Param[13] ;
			MAL_Block_Address = ( ( MAL_Block_Address + Blocks_Transferred ) - 1 ) ;
			MAL_Block_Numbers = MAL_Block_Numbers - Blocks_Transferred ;
			CFC_State == CARD_ACTIVE_STATE ;
//			No_DTC_Int () ; // Disable DTC interrupt
                                                        
			IT_Type = 0x00 ;                                                        
		        MAL_Finish(FALSE) ; 
			PEDR |= 0x04 ;          
			return ;
		}

		if ( ( MAL_Block_Numbers != 0 ) && ( IT_Type == 0x01 ) ) 
		{
			if ( CFC_State == DTC_CFC_READ_STATE )
			{                     
				IT_Type = 0x00 ;
				CFC_Read () ; 
				return ;
			}
			if ( CFC_State == DTC_CFC_WRITE_STATE )
			{                       
				IT_Type = 0x00 ;
				CFC_Write () ; 
				return ;
			}		       
		}
		else if ( ( MAL_Block_Numbers == 0 ) && ( IT_Type == 0x01 ) ) 
		{
			CFC_State = CARD_ACTIVE_STATE ;
			IT_Type = 0x00 ;                        
			//No_DTC_Int () ; // Disable DTC interrupt
			MAL_Error = MAL_GOOD ;
		        MAL_Finish(TRUE) ; 
       			PEDR |= 0x04 ;     
       			return ;
		}
	}
}                                     

unsigned char CFC_Format(void)
{
	return MAL_GOOD;
}

unsigned char CFC_Verify(void)
{
	return MAL_GOOD;
}

unsigned char CFC_Check_Write_Protect(void)
{
	return 0;
}
                
#pragma NO_OVERLAP                
void CFC_Break(void)
{       
	// Stop the DTC execution despite its state
	Stop_DTC () ;
	PEDR |= 0x04 ; // Deselect Card Enable 

	if (MAL_State != MAL_IDLE) 
	{
		MAL_Finish(FALSE);
		MAL_State = MAL_IDLE;
		//DTC_Current_Func = 0;
	}
}


#pragma NO_RETURN
void MAL_CFC_Funcs(void)
{
	// IMPORTANT: The sequence of this jump table can not be changed
	// New line can be appended at the end of the table
	asm {
		jp	CFC_Init				// 0
		jp	CFC_Read				// 1
		jp	CFC_Write				// 2
		jp	CFC_Verify				// 3
		jp	CFC_Format				// 4
		jp	CFC_Read_Capacity		// 5
		jp	CFC_Check_Write_Protect		// 6
		jp	CFC_Break				// 7
//		jp	MMC_DTC_Int				// 8

	}
}

/************ END of FILE ******************************************/


