/**************** (c) 2001  STMicroelectronics **********************

PROJECT : ST7265 USB Mass Storage - SMC

VERSION :  V1.0 Beta2

CREATION DATE :  20/03/2001

AUTHOR : MICROCONTROLLER DIVISION / Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/
#include "Map_7265.h"
#include "MConfig.h"
#include "MAL_Map.h"
#include "MAL.h"
#include "DTC_Func.h"

#pragma DATA_SEG DTC_RAM
extern unsigned char DTC_RAM[256];	// RAM DTC

#pragma DATA_SEG MAL_RAM
#pragma CODE_SEG DTC_FUNC

/*-----------------------------------------------------------------------------
ROUTINE NAME : DTC_Load_Code
INPUT/OUTPUT : None
DESCRIPTION  : DTC initialization
-----------------------------------------------------------------------------*/
#pragma NO_ENTRY
void DTC_Load_Code(unsigned char *DTC_Code)
{
	DTCCTRL |= DTC_LOAD;		// Start the ram load processes
	asm {
		ld		DTC_Code:1, A
		ld		DTC_Code, X
		clr		X
load_code:
		ld		A, ([DTC_Code.w],X)	// 7cy
		ld		(DTC_RAM,X), A		// 5cy
		inc		X					// 3cy
		jrne	load_code			// 3cy
	}

//	char count;
//	count = 0;
//	do {
//		DTC_RAM[count] = DTC_code[count];
//		count++;
//	} while (count);

	DTCCTRL &= (~DTC_LOAD);		// Stop the ram load processus
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : DTC_Process
INPUT/OUTPUT : DTC_PC/None
DESCRIPTION  : None
-----------------------------------------------------------------------------*/
void DTC_Process(char DTC_PC)
{
	//extern void select(void);
	asm	{
		LD		DTCPC, A
		//CALL	select
		BSET	DTCCTRL, #1
		BRES	DTCCTRL, #1
		BSET	DTCCTRL, #0
	}
/*	The following lines are same as above assembly lines
	DTCPC    = DTC_PC;		// FCIPC <= DTC_PC_add

	SELECT();	// Chip select for the media

	DTCCTRL  |= DTC_INIT;	// Enable DTC PC Initialization
	DTCCTRL  &= (~DTC_INIT);// Disable DTC PC Initialization
	DTCCTRL  |= DTC_START;	// Initialize the load sequence
*/
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : DTC_Wait_Stop
INPUT/OUTPUT : None
DESCRIPTION  : None
-----------------------------------------------------------------------------*/
#pragma NO_OVERLAP
unsigned char DTC_Wait_Stop()
{
	unsigned char DTC_Status;
	unsigned char Time1, Time2;

	// This function should be called on shorter DTC functions
	// Sometime the DTC does not stop itself when it finished
	// We use the Timeout variable to count the time and
	// and return a success status when the time is up

	// This loop is about 30ms
	for (Time1 = 30; Time1; Time1--)
		for (Time2 = 255; Time2; Time2--) {
			DTC_Status = DTCSTATUS & 0x03;
			if (DTC_Status)
				goto time_up;
		}

	asm nop;

time_up:
	//DESELECT();				// Chip deselect

	DTCCTRL  &= ~DTC_START;	// Force DTC to stop
	return DTC_Status;
}

/*** (c) 1999   STMicroelectronics *************** END OF FILE *************/
