/**************** (c) 2001  STMicroelectronics **********************

PROJECT : ST7265 USB Mass Storage - SMC

VERSION :  V1.0 Beta2

CREATION DATE :  20/03/2001

AUTHOR : MICROCONTROLLER DIVISION / Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef DTC_FUNC_H
#define DTC_FUNC_H

extern void DTC_Load_Code();
extern void DTC_Process(char DTC_PC);
extern unsigned char DTC_Wait_Stop();

#define No_DTC_Int()	{ DTCCTRL &= ~(DTC_ERROREN | DTC_STOPEN); }
#define Enable_DTC_Int()	{ DTCCTRL |= DTC_ERROREN | DTC_STOPEN; }
#define Stop_DTC()		{ DTCCTRL  &= ~DTC_START;	}

/********************************************/
/*       Mask bits DTCCTRl Register         */
/********************************************/
// DTC Control Register (DTCCTRl)
#define DTC_ERROREN	 0x10		// Interrupt Error enabled
#define DTC_STOPEN	 0x08		// Interrupt Stop enabled
#define DTC_LOAD     0x04		// Load ram fci
#define DTC_INIT     0x02		// Init signal
#define DTC_START    0x01		// Start signal

#define DTC_ERROR    0x01		// ERROR
#define DTC_STOP     0x00		// STOP

#endif
