/*-*-*-*-*-*-*-*-*-*-* (C) 2000 STMicroelectronics *-*-*-*-*-*-*-*-*-*-*-*-*-*

PROJECT  : ST7265 Media Access Library
COMPILER : ST7 C

MODULE  :  MAL.c
VERSION :  V 1.0 Beta

CREATION DATE :  16/03/2001

AUTHOR : Liang Ping
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

DESCRIPTION : All functions except those with individual one

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

Modification:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#include "define.h"
#include "MAP_7265.h"
#include "Mconfig.h"		// Media configuration
#include "MSL.h"
#include "MAL.h"
#include "MAL_Func.h"

/*-*-*-*-*-*-*-*-*-*-*-*-*-* Variable declaration *-*-*-*-*-*-*-*-*-*-*-*-*-*/
// Golbal variables, seen outside
#pragma DATA_SEG SHORT MAL_RAM0	// Frequently used variable
unsigned short	MAL_Block_Numbers;
unsigned short	MAL_Block_Finish;
unsigned long	MAL_Block_Address;
unsigned char	MAL_Mediano;
unsigned char	OLD_MAL_Mediano;

unsigned char DTC_Code_Number;

#if ALLOW_OUT_RANGE
char Mal_Addr_Out_Range;
#endif

#pragma DATA_SEG MAL_RAM
unsigned char	MAL_Error;
unsigned char	MAL_State;
unsigned long	MAL_Capacity;
static BYTE MAL_Media_Slot;			// Bitmap for slot activation
static BYTE MAL_Slot_Status;		// Bitmap for slot status

extern WORD	MAL_Table[];
extern DWORD	Medium_Capacity[MAX_LUN+1];	// the last addres of the medium

extern void select(void);
extern void deselect(void);

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* Code Segments *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#pragma CONST_SEG MAL_CONST
const unsigned char Bit_Mask[8] =
	{ 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 };

#pragma CODE_SEG MAL_CODE

#pragma NO_ENTRY
unsigned char MAL_Call(char Index, char iFunc)
{
	asm TRAP;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Functions relate to the Reading and Writing
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void _MAL_BufMgr_Upload(void)
{
	if (BUFMGR_UPLOAD_MODE)
		return;
	EP2TXR = (EP2TXR & 0x04) | 0x02; // NAK on Xmit, Keep DTOG
	CNT2TXR = 64;		// Set Xmit counter
	CNT2RXR = 64;		// Set Recv counter
	BUFSR = 0x01;		// Clear Buffer status
	BUFSR = 0;
	EP2RXR = (EP2RXR & 0x04) | 0x42;	// NAK on Recv & switch to UPLOAD mode
}

void _MAL_BufMgr_Download(void)
{
	if (BUFMGR_DOWNLOAD_MODE)	// return if already in download mode
		return;
	EP2TXR = (EP2TXR & 0x04) | 0x02;	/* NAK on Xmit, Keep DTOG */
	CNT2RXR = 64;	/* Set Recv counter */
	BUFSR = 0x01;	/* Clear Buffer status */
	BUFSR = 0;
	EP2RXR = (EP2RXR & 0x04) | 0x82;	/* NAK on Recv & switch to DOWNLOAD mode */
}

void _MAL_BufMgr_Normal(void)
{
	if (BUFMGR_NORMAL_MODE)		// return if already in normal mode
		return;
	while (BUFSR & 0x06);		/* Wait both buffer are empty */
	EP2RXR = (EP2RXR & 0x04) | 0x02;	/* NAK on Recv & switch to NORMAL mode */
	EP2TXR = (EP2TXR & 0x04) | 0x02; 	/* NAK on Xmit, Keep DTOG */
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
static char _MAL_Address_OutRange()
{
	unsigned long range = Medium_Capacity[MAL_Mediano];
	if (MAL_Block_Address >= range)
		return 2;
	if (MAL_Block_Address + MAL_Block_Numbers > range)
		return 4;
	return 0;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//#pragma	NO_OVERLAP
void _MAL_INC_Block_Param(unsigned char delta)
{
	MAL_Block_Numbers -= delta;
	MAL_Block_Address += delta;
	MAL_Block_Finish += delta;

#if ALLOW_OUT_RANGE
	// Check the range
	Mal_Addr_Out_Range = _MAL_Address_OutRange() | ((Mal_Addr_Out_Range >> 1) & 0x01);
#endif
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//#pragma	NO_OVERLAP
void _MAL_DEC_Block_Param(unsigned char delta)
{
	MAL_Block_Numbers += delta;
	MAL_Block_Address -= delta;
	MAL_Block_Finish += delta;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MAL_Init(void)
{
	MAL_HW_Init();
	MAL_Port_Init();
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Test_Ready()
{
	unsigned char mask = Bit_Mask[MAL_Mediano];

	if ((MAL_Media_Slot & mask) == 0) {
		if ((MAL_Slot_Status & mask) == 0)
			return MAL_NO_CARD;

		MAL_Media_Slot |= mask;

		SELECT();		// Chip select
		mask = MAL_Call(MAL_Mediano, MAL_INIT);
		DESELECT();		// Chip deselect
		if (mask != MAL_GOOD)
			return mask;

		return MAL_NEW_CARD;
	}

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Read_Capacity(void)
{
	BYTE	MAL_Status;

// Check the medium is ready to be read
	MAL_Status = MAL_Test_Ready();
	if (MAL_Status != MAL_GOOD)
		return MAL_Status;


// To switch between SMC, Flash on baord and MS
	if (OLD_MAL_Mediano != MAL_Mediano)
	{
		// Change the Lookup Table
		OLD_MAL_Mediano = MAL_Mediano;
		SELECT();		// Chip select
		MAL_Status = MAL_Call(MAL_Mediano, MAL_INIT);
		DESELECT();		// Chip deselect
		if (MAL_Status != MAL_GOOD)
			return MAL_Status;
	}

	SELECT();		// Chip select
	MAL_Status = MAL_Call(MAL_Mediano, MAL_READ_CAPACITY);
	DESELECT();		// Chip deselect

	Medium_Capacity[MAL_Mediano] = MAL_Capacity;

	return MAL_Status;
}


/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Start_Stop(BYTE flag)
{
//	SELECT();		// Chip select

	if ((flag & ~0x02) == 0) {
		MAL_Medium_Removing(MAL_Mediano);
		return MAL_GOOD;
	}
	return MAL_Test_Ready();
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Main entry point of the MAL_Read()
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Read(void)
{
	BYTE	Errno;

// Check the medium is ready to be read
	Errno = MAL_Test_Ready();
	if (Errno != MAL_GOOD)
		return Errno;

#if ALLOW_OUT_RANGE
	Mal_Addr_Out_Range = _MAL_Address_OutRange();
#else
	if (_MAL_Address_OutRange())
		return MAL_OUT_RANGE;
#endif

// To switch between SMC, Flash on baord and MS
	if (OLD_MAL_Mediano != MAL_Mediano)
	{
		// Change the Lookup Table
		OLD_MAL_Mediano = MAL_Mediano;
		SELECT();		// Chip select
		Errno = MAL_Call(MAL_Mediano, MAL_INIT);
		DESELECT();		// Chip deselect
		if (Errno != MAL_GOOD)
			return Errno;
	}

	MAL_State = MAL_READING;
	SELECT();		// Chip select
	return MAL_Call(MAL_Mediano, MAL_READ);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Main entry point of the MAL_Write()
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Write(void)
{
	BYTE Errno;

// Check the medium is ready to be written
	Errno = MAL_Test_Ready();
	if (Errno != MAL_GOOD)
		return Errno;
//	if (isWRITE_PROTECT())
//		return MAL_NO_WRITE;
		
#if ALLOW_OUT_RANGE
	Mal_Addr_Out_Range = _MAL_Address_OutRange();
#else
	if (_MAL_Address_OutRange())
		return MAL_OUT_RANGE;
#endif

// To switch between SMC, Flash on baord and MS
	if (OLD_MAL_Mediano != MAL_Mediano)
	{
		// Change the Lookup Table
		OLD_MAL_Mediano = MAL_Mediano;
		SELECT();		// Chip select
		Errno = MAL_Call(MAL_Mediano, MAL_INIT);
		DESELECT();		// Chip deselect
		if (Errno != MAL_GOOD)
			return Errno;
	}

	MAL_State = MAL_WRITING;
	SELECT();		// Chip select
	return MAL_Call(MAL_Mediano, MAL_WRITE);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Main entry point of the MAL_Format()
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
BYTE MAL_Format(void)
{
	BYTE Errno;

// Check the medium is ready to be format
	Errno = MAL_Test_Ready();
	if (Errno != MAL_GOOD)
		return Errno;
	if (isWRITE_PROTECT())
		return MAL_NO_WRITE;

// To switch between SMC, Flash on baord and MS
	if (OLD_MAL_Mediano != MAL_Mediano)
	{
		// Change the Lookup Table
		OLD_MAL_Mediano = MAL_Mediano;
		SELECT();		// Chip select
		Errno = MAL_Call(MAL_Mediano, MAL_INIT);
		DESELECT();		// Chip deselect
		if (Errno != MAL_GOOD)
			return Errno;
	}

	MAL_State = MAL_FORMATTING;
	SELECT();		// Chip select
	return MAL_Call(MAL_Mediano, MAL_FORMAT);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MAL_Finish(unsigned char Result)
{
	MSL_MAL_Finish(Result);
	_MAL_BufMgr_Normal();

	MAL_State = MAL_IDLE;
	DESELECT();		// Chip deselect
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
// Normally, this funciton is called from the user interrupt routine
void MAL_Medium_Removing(BYTE slot)
{
	MAL_Media_Slot &= ~Bit_Mask[slot];
	MAL_Slot_Status &= ~Bit_Mask[slot];	

	if(!MAL_Slot_Status)	// No other cards left
	{
		// Do sth to stop the current operations
		MAL_Error = MAL_NO_CARD;
		MAL_Call(slot, MAL_BREAK);
//		MAL_POWER_OFF;		// Turn off the power for the Medium
	}
}

#pragma NO_ENTRY
void MAL_Medium_Plug(unsigned char slot)
{
	asm {
		ld		X, A
		ld		A, (Bit_Mask, X)
		or		A, MAL_Slot_Status
		ld		MAL_Slot_Status, A
	}
//	MAL_Slot_Status |= Bit_Mask[slot];
}




