/*
STMicroelectronics CONFIDENTIAL
****************************************************************************************
COPYRIGHT 2001 STMicroelectronics

Source File Name : MMC.C  
Code size        :
Author(Initial)  : Alok Mittal / Phone- 6749/alok.mittal@st.com
Author (Initial) : 
Group            : IPDF - CMG -IPSW
Address          : Sector 16A Plot No 2 & 3, Institutional Area Noida UP
Date First Issued:
********************************Documentation*******************************************
Description :

This MAL_MMC.C file is the source code for the DTC-SD card project.
It contains all the functions written in C ( and optimised in Assembly, wherever required )

********************************Revision History****************************************
_______________________________________________________________________________________
Date : 			Release:0.0     	Modification:   	Initial:   

_______________________________________________________________________________________

*/

#include "Map_7265.h"
#include "Mconfig.h"		// Media configuration
#include "define.h"
#include "hidef.h"
#include "lib_bits.h"

//#include "usr_var.h"
//#include "pmu_func.h"
#include "DTC_Func.h"

//#include "pmu_code.h"
#include "mmc_dtc.h"

#include "MAL_Map.h"
#include "MAL_MMC.h"
#include "MAL.h"

// #include "MAL_map.h"

/*	Global Variables declarations, used by MAL - remove while integration */
/*
unsigned long MAL_Block_Address;
unsigned int  MAL_Block_Numbers;
unsigned char MAL_Error;
DWORD	MAL_Capacity;
  */
/*	following are the Global variables used by MMC-MAL		*/

#pragma DATA_SEG MAL_RAM
unsigned char DTC_Status1;
unsigned char Time3, Time4;
unsigned char cmd_temp;
unsigned char err_chk;
unsigned char MMC_IT_Type;	// Type of IT from FCISTATUS 
unsigned char tmp;
unsigned char MMC_state ;                                 
unsigned char MMC_blk_numbers ;
unsigned char Card_Type;
unsigned char hSD_Card_Addr ;
unsigned char lSD_Card_Addr;              
unsigned char BuffNum;
DWORD	Block_Address;

extern unsigned char DTC_Code_Number;

#pragma CONST_SEG MMC_CONST

/**************************************************************/
const unsigned char MMC_INIT_SEQ [CMD_BUFF_SIZE] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff , 64, NO_RESPONSE };
	/*  use SendCMD proc, sned 6 bytes = 0xff, wait 16clks for CMD low ( which will never occur =
	    = 6*8 + 32 = 68+16 = 80 clocks 
	    As CMD is never zero, so DTC stops with error = ignore */

/* CMD0 [31:0] stuff bits - GO_IDLE_STATE resets all cards to idle state */
const unsigned char CMD0_BUFF [CMD_BUFF_SIZE] = { CMD0_START, 0x00, 0x00, 0x00, 0x00, 0x95 ,NID_CLK_CYC, NO_RESPONSE };

/* CMD1 bcr [31:0] OCRwithout busy R3 
SEND_OP_COND asks all cards in idle state to send their operation 
conditions register contents in the response on the CMD line. */
const unsigned char CMD1_BUFF [CMD_BUFF_SIZE] = { CMD1_START, 0x00, 0xff, 0xc0, 0x00, 0x43 , NID_CLK_CYC,R3_RESPONSE_BYTES };

/* CMD2 [31:0] stuff bits, R2, 
ALL_SEND_CID asks any card to send the CID num-bers on the CMD line (any card that is
connected to the host will respond)                 */
const unsigned char CMD2_BUFF [CMD_BUFF_SIZE] = { CMD2_START, 0x00, 0x00, 0x00, 0x00, 0x4D ,NID_CLK_CYC ,R2_RESPONSE_BYTES };
           
/* CMD3 ac [31:16] RCA	[15:0] stuff bits
R1 SET_RELATIVE_ADDR assigns relative address to the card  */
const unsigned char CMD3_BUFF [CMD_BUFF_SIZE] = { CMD3_START, 0x00, 0x02, 0x00, 0x00, 0x9D, NCR_CLK_CYC, R1_RESPONSE_BYTES  };

/* CMD3 bcr [31:0] stuff bits, R6 
SEND_RELATIVE_ADDR ask the card to publish a new relative address (RCA)  */
const unsigned char SD_CMD3_BUFF [CMD_BUFF_SIZE] = { CMD3_START, 0x00, 0x00, 0x00, 0x00, 0x21, NCR_CLK_CYC, R1_RESPONSE_BYTES  };

/* CMD7 ac [31:16] RCA[15:0] stuff bits , R1b
(only from the selected card) SELECT_CARD ,command toggles a card between 
the stand-by and transfer states or between the programming and dis-connect
states. In both cases the card is selected by its own relative address and 
gets deselected by any other address; address 0 deselects all.  */
const unsigned char CMD7_BUFF [CMD_BUFF_SIZE] = { CMD7_START, 0x00, 0x02, 0x00, 0x00, 0x3f, NCR_CLK_CYC, R1b_RESPONSE_BYTES };

/* CMD7 ac [31:16] RCA[15:0] stuff bits , R1b
(only from the selected card) DESELECT_CARD ,command toggles a card between 
the stand-by and transfer states or between the programming and dis-connect
states. In both cases the card is selected by its own relative address and 
gets deselected by any other address; address 0 deselects all.  */
const unsigned char CMD7_BUFF_ADR0 [CMD_BUFF_SIZE] = { CMD7_START, 0x00, 0x00, 0x00, 0x00, 0x83, NCR_CLK_CYC, R1b_RESPONSE_BYTES };

/* CMD9 ac [31:16] RCA [15:0] stuff bits R2 
SEND_CSD addressed card sends its card-spe-cificdata (CSD) on the CMD line. */
const unsigned char CMD9_BUFF[CMD_BUFF_SIZE] = { CMD9_START, 0x00, 0x02, 0x00, 0x00, 0x13, NCR_CLK_CYC, R2_RESPONSE_BYTES };

/* CMD12 ac [31:0] stuff bits, R1b 
STOP_TRANSMISSION forces the card to stop transmission */
const unsigned char CMD12_BUFF[CMD_BUFF_SIZE] = { CMD12_START, 0x00, 0x00, 0x00, 0x00, 0x61, NCR_CLK_CYC, R1b_RESPONSE_BYTES };
     
/* CMD13 ac [31:16] RCA[15:0] stuff bits, R1 
SEND_STATUS addressed card sends its status register. */
const unsigned char CMD13_BUFF[CMD_BUFF_SIZE] = { CMD13_START, 0x00, 0x02, 0x00, 0x00, 0xB1, NCR_CLK_CYC, R1_RESPONSE_BYTES  };

/* CMD16 ac [31:0]= BLOCK LENGTH=512, R1 
SET Block length to 512 bytes= 0x200, card sends its status register. */
const unsigned char CMD16_BUFF[CMD_BUFF_SIZE] = { CMD16_START, 0x00, 0x00, 0x02, 0x00, 0x15, NCR_CLK_CYC, R1_RESPONSE_BYTES  };

/* ACMD41 bcr [31:0]OCR without busy R3 
SD_APP_OP_COND Asks the accessed card to send its operating condition 
register (OCR) con-tentin the response on the CMD line. */         
const unsigned char ACMD41_BUFF[CMD_BUFF_SIZE] = { CMD41_START, 0x00, 0xff, 0x80, 0x00, 0x85, NID_CLK_CYC, R3_RESPONSE_BYTES  };

/* CMD55 ac [31:16] RCA[15:0] stuff bits R1 
APP_CMD Indicates to the card that the next command is an application 
specific command rather than a standard command */
const unsigned char CMD55_BUFF[CMD_BUFF_SIZE] = { CMD55_START, 0x00, 0x00, 0x00, 0x00, 0x65, NCR_CLK_CYC, R1_RESPONSE_BYTES  };

#pragma CODE_SEG MMC_CODE

/*******************************************************************************
Routine name : DTC_MMC_Init
Argument     : void
Return       : void 
Variable     : 
Purpose      : To Initialise the MMC 
SubComponents : 
*******************************************************************************/
//#pragma NO_OVERLAP
unsigned char MMC_Init ()
{               	
	unsigned char temp1;
//	BYTE temp2;
//	unsigned char tries;
	unsigned int wait;            

	//Set MMC CRC Polynomia
	ClrBit(DTCCTRL,6);			// POLY_H = 0
	ClrBit(DTCCTRL,5);			// POLY_LOAD = 0
	SetBit(DTCCTRL,5);			// POLY_LOAD = 1
	DTCCRC_RESERVED = 0x21;		// Write CRC_LSB
	SetBit(DTCCTRL,6);			// POLY_H = 1
	DTCCRC_RESERVED = 0x10;		// Write CRC_MSB
	ClrBit(DTCCTRL,6);			// POLY_H = 0
	ClrBit(DTCCTRL,5);			// POLY_LOAD = 0
 
        No_DTC_Int();

	err_chk = 0; 
	BuffNum = 0 ;
	    
	MMC_IT_Type = 0;
        Card_Type = MMC_CARD;

	
/*  CHK Card Detect !!!!!! in case of SD connector  */
                   
	MMC_state = CARD_IDLE_STATE ; 
        
       DTC_Load_Code(MMC_UpLoad);
       DTC_Code_Number = MMC_DTC_CODE_0;	


	/* Provide 1ms delay at power ON */	    
	/* We require 25000 cyc for 2ms delay at 12MHz */

		for ( wait=0 ; wait<400 ; wait++ )
		 {
	    	  asm NOP           
		 }      
		 
       	 SendCMD ( CMD0_BUFF ); 
       	 
       	 	for ( wait=0 ; wait<400 ; wait++ )
		 {
	    	  asm NOP           
		 }      
	
    
/*  Initialise DTC CARD ports, provide 80 clocks required after Power_On   */
        
       	 SendCMD ( MMC_INIT_SEQ ); 	
  
         SendCMD ( CMD55_BUFF );
	 	if((Buffer_Param[0] != 0x37) || (Buffer_Param[4] != 0x20))
		{	
		 /* No response from MMC card, response from SD card */
                  Card_Type = MMC_CARD;
               	}                     
		else
		{
                  Card_Type = SD_CARD;		
	
		}

/* load CMD1 into buffer_param & use DTC function to issue CMD1 */    

	   temp1 = 0; 	/*	Attempts to check Card Busy ???  */
	
	   do 
	   {   
	
	/* We require 25000 cyc fr 2ms delay at 12MHz */

		for ( wait=0 ; wait<400 ; wait++ )
	 	{
	 	 	  asm NOP           
		}
    
	    
               if (( Card_Type == MMC_CARD ) || ( Card_Type == HITACHI_CARD ) )
                  SendCMD ( CMD1_BUFF ); 	
	       else                       
	       {
	         SendCMD ( CMD55_BUFF );	     
	     	 SendCMD ( ACMD41_BUFF ); 	
	       } 
	  
	  	if ((Buffer_Param[0]&0xfe ) == 0x7e )
	        {
	      	  Card_Type = HITACHI_CARD;
//	      	  DTC_Load_Code(HCHI_UpLoad);
//		  DTC_Code_Number = MMC_DTC_CODE_2;	
	      	  
	        }
	   	  	
		temp1++ ;
         
		   if ( temp1 >= 100 )
		   {
		    MAL_Error = MAL_NO_ACTIVE;   
		    return MAL_NO_CARD; 			/*  Return from This function, as No card Detected */
		   }
	    }
           while  ( !(Buffer_Param[1] & 0x80 )) ; 		/* check the BUSY bit */ 

/*  check Start bit, direction and END Bit */    
/*		if ( !( Buffer_Param[0] & 0xC0 ) &&  ( Buffer_Param[5] & 0x01 == 0x01 ) )
		{
    		
			if((Buffer_Param[2] == 0xFF) && (Buffer_Param[3] == 0xC0))	// SanDisk card
				break;
			if((Buffer_Param[2] == 0xFF) && (Buffer_Param[3] == 0x80))	// Hitachi card
				break;

    	}

  	}	  
*/

	MMC_state = CARD_READY_STATE ;
/************************************************************************/
/* load CMD2 into buffer_param & use DTC function to issue CMD2 */    
	
    SendCMD ( CMD2_BUFF );

 	if ( ( Buffer_Param[0] & 0xC0 ) &&  ((Buffer_Param[16] & 0x01) != 0x01) )
	{
      MAL_Error = MAL_NO_ACTIVE;   
      return MAL_NO_CARD;
	}    

     MMC_state = CARD_IDENTIFICATION_STATE ;
/************************************************************************/                      
/* load CMD3 into buffer_param & use DTC function to issue CMD3  */    
    
    if ( ( Card_Type == MMC_CARD ) || ( Card_Type == HITACHI_CARD  ))
    { 
	   SendCMD ( CMD3_BUFF );

 	   if ( Buffer_Param[0] != CMD3_INDEX ) 
	   {
             MAL_Error = MAL_NO_ACTIVE;   
             return MAL_NO_CARD;
	   }    
    
    	hSD_Card_Addr = 0x00;
	lSD_Card_Addr = 0x02;
    }
    else
    {
		/*	SD card	*/
    	SendCMD ( SD_CMD3_BUFF );

 		if ( Buffer_Param[0] == CMD3_INDEX )
 		{
			hSD_Card_Addr = Buffer_Param[1];
			lSD_Card_Addr = Buffer_Param[2];
		}	
		else
		{
      		MAL_Error = MAL_NO_ACTIVE;   
      		return MAL_NO_CARD;
		}    
    }
    
    
    MMC_state = CARD_STANDBY_STATE ;


    temp1 = MMC_Read_Capacity();

    if ( temp1 != MAL_GOOD ) 
	     return temp1 ;

	     
  	return MAL_GOOD;
}

/*******************************************************************************
Routine name : MMC_Read_Capacity
Argument     : void
Return       : unsigned char 
Variable     : 
Purpose      : To Calculate MMC capacity 
SubComponents : 
*******************************************************************************/
//#pragma NO_OVERLAP
unsigned char MMC_Read_Capacity (void)
{ 

/*        if ( Card_Type == HITACHI_CARD )
        {
	    	  if ( DTC_Code_Number != MMC_DTC_CODE_2 )
	    	  {
	    	    DTC_Load_Code(MMC_UpLoad);
		    DTC_Code_Number = MMC_DTC_CODE_2;	
		  }
		  else
		  {
	           asm NOP
	          }
        }
        else 
*/
        
        if (( DTC_Code_Number != MMC_DTC_CODE_0 ) && ( DTC_Code_Number != MMC_DTC_CODE_1 ))
	{ 
		DTC_Load_Code(MMC_UpLoad);
		DTC_Code_Number = MMC_DTC_CODE_0;
	}
	
	
                        
 if ( MMC_state == CARD_TRANSFER_STATE )
 {     

  /* load CMD7 with Relative address =0 into buffer_param */    
  /*  This is done to bring the MMC in Standby state back from Transfer State */
	SendCMD ( CMD7_BUFF_ADR0 );
        MMC_state = CARD_STANDBY_STATE ;

  }


/************************************************************************/
/* load CMD9 into buffer_param */    
    
  if ( MMC_state == CARD_STANDBY_STATE )
  {
    
     Load_cmd ( CMD9_BUFF );
   
      if ( Card_Type == SD_CARD )
      {
         Buffer_Param[1] = hSD_Card_Addr;
         Buffer_Param[2] = lSD_Card_Addr;

         asm NOP
         MakeCRC7();
      }
      
    DTC_Process(MMC_CMD);		/* use DTC function to issue CMD9 */	
    Wait_DTC_Stop_Fast();     
    asm NOP

 	if ( ( Buffer_Param[0] & 0xC0 ) ||  ((Buffer_Param[16] & 0x01) != 0x01) )
	{
           MAL_Capacity = -1 ; 
           MAL_Error = MAL_NO_ACTIVE;   
           return MAL_CARD_UNKNOWN;
	}    
    
     
     Compute_Capacity();
  
/* load CMD7 into buffer_param */    

    Load_cmd ( CMD7_BUFF );     
    
      if ( Card_Type == SD_CARD )
      {
        Buffer_Param[1] = hSD_Card_Addr;
        Buffer_Param[2] = lSD_Card_Addr;

        MakeCRC7();
        
      }
               
    DTC_Process(MMC_CMD);		/* use DTC function to issue CMD9 */	
    Wait_DTC_Stop_Fast();     
    asm NOP               
    
/*      SendCMD ( CMD7_BUFF );
      asm NOP	*/
      
 	   if ( Buffer_Param[0] != CMD7_INDEX )
 	   {
             MAL_Error = MAL_NO_ACTIVE;   
             return MAL_CARD_UNKNOWN;
	    }    

       MMC_state = CARD_TRANSFER_STATE ;

       SendCMD ( CMD16_BUFF );     /* sets the Block length to 512 Bytes */

       if ( Buffer_Param[0] != CMD16_INDEX )
       {
           MAL_Error = MAL_NO_ACTIVE;   
           return MAL_CARD_UNKNOWN;
       }    


      return MAL_GOOD;
    }
    else              
      return MAL_CARD_UNKNOWN;

//	return MAL_CARD_UNKNOWN;

/************************************************************************/
/*************  Check DSR register implementation ****************/	     
                                                  
//	temp =   Buffer_Param[7] & 0x10 ;	
//	if ( temp )
//	{
//      SetDriver();
//	}
//    else
//	{
      /*  because otherwise Buffer_Param will contain the response from
		SetDriver												*/
		/************  Check Block length  ***************************/	     

//		temp =   Buffer_Param[6] & 0x0f ;		/* filter READ_BL_LEN */

//		temp1 =   Buffer_Param[13] & 0x03 ;		/* filter WRITE_BL_LEN - MSB*/
//		temp1 <<= 2;  							/* make plave for 2 bits */

//		temp2 =   Buffer_Param[14] & 0xC0 ;		/* filter WRITE_BL_LEN - LSB */  
//		temp2 >>= 6;							/*  take to lower 2 LSBs */		 

//		temp1 |= temp2 ;

//		if (( temp != 0x09 ) && ( temp1 != 0x09 ))
//		  { 
//			SetBlockLength();
//		  }
         
//	}
/*************   ***************************/	     


}

/*******************************************************************************
Routine name : Compute_Capacity
Argument     : void 
Return       : void 
Variable     : 
Purpose      : To Calculate the Capacity of MMC 
SubComponents : 
*******************************************************************************/
//#pragma NO_OVERLAP 
void Compute_Capacity (void )
{    

/*

static unsigned int Temp1 ; 
static unsigned int MULT ;
static unsigned long DeviceSize;

		Temp1=0;
		MULT=0; 
		DeviceSize=0;

	asm CLR A  ;        //  done as the values were not getting initiallised to ZERO
    asm LD Temp1, A ; 
    asm LD Temp1:1,A ;       
		


    		Temp1 = Buffer_Param[10] & 0x03 ;
		MULT = Temp1 << 1;
		Temp1 =  Buffer_Param[11] & 0x80;
		Temp1 = Temp1 >> 7;
		MULT += Temp1;
		Temp1 = MULT + 2;
		MULT = 1 << Temp1;
		Temp1 = Buffer_Param[7] & 0x03;
		Temp1 = Temp1 << 8;
		DeviceSize = Temp1 + Buffer_Param[8] ;
		DeviceSize = DeviceSize << 2;
		Temp1 = Buffer_Param[9] & 0xC0;
		Temp1 = Temp1 >> 6;
		DeviceSize += Temp1;
		DeviceSize += 1;
		DeviceSize *= MULT;			//	contains multiple of 512 byte i.e number of sectors
                            
		MAL_Capacity = DeviceSize;
		
*/
unsigned short Capacity;

	asm {
		LD		A, Buffer_Param:10
		AND		A, #0x03
		LD		X, A
		LD		A, Buffer_Param:11
		SLL		A
		RLC		X					// X = number of shifting
		INC		X
		INC		X					// X += 2
		PUSH	X

		LD		A, Buffer_Param:7
		AND		A, #0x03
		LD		X, A
		LD		A, Buffer_Param:8
		LD		Y, Buffer_Param:9
		SLL		Y
		RLC		A
		RLC		X					// 1st shift
		SLL		Y
		RLC		A
		RLC		X					// 2nd shift
		INC		A
		JRNE	size_shift0
		INC		X
size_shift0:
		POP		Y
		CLR		Capacity
		CLR		Capacity:1
size_shift:
		SLL		A
		RLC		X
		RLC		Capacity:1
		RLC		Capacity
		DEC		Y
		JRNE	size_shift
		LD		MAL_Capacity:3, A
		LD		MAL_Capacity:2, X
		LD		A, Capacity:1		
		LD		MAL_Capacity:1, A
		LD		A, Capacity		
		LD		MAL_Capacity, A
	}
}

/*******************************************************************************
Routine name : MMC_Read
Argument     : void
Return       : void 
Variable     : 
Purpose      : To Read the MMC 
SubComponents : 
*******************************************************************************/
#pragma NO_OVERLAP
BYTE MMC_Read (void)
{
//DWORD	Block_Address;
//union array_1_4 *ptr;
//unsigned char tmp;
   
  Block_Address = MAL_Block_Address * 512 ; 	
  MAL_Block_Finish = 0;     // ?????
        
        /*
        if ( Card_Type == HITACHI_CARD )
        {
	      	  DTC_Load_Code(MMC_UpLoad);
		  DTC_Code_Number = MMC_DTC_CODE_2;	
        }                      
        
        else */
        
        if ( DTC_Code_Number != MMC_DTC_CODE_0 ) 
	{
		DTC_Load_Code(MMC_UpLoad);
		DTC_Code_Number = MMC_DTC_CODE_0;
	}

/*
  if ( MMC_state == CARD_STANDBY_STATE )
  {
// load CMD7 into buffer_param 

    Load_cmd ( CMD7_BUFF );        
    
    if ( Card_Type == SD_CARD )
    {	
       Buffer_Param[1] = hSD_Card_Addr;
       Buffer_Param[2] = lSD_Card_Addr;

       MakeCRC7();
    }
               
    DTC_Process(MMC_CMD);
    Wait_DTC_Stop_Fast();     
    asm NOP         
    
 	if ( Buffer_Param[0] != CMD7_INDEX ) 
	{
	      MAL_Error = MAL_NO_ACTIVE;   
	      return MAL_Error;
	}   

	MMC_state = CARD_TRANSFER_STATE;

  }	

*/

   if ( MMC_state == CARD_TRANSFER_STATE  ) 
   {  
/*
         tmp=0;

        
   	   while ( 1 ) 
   	   {
             Load_cmd ( CMD13_BUFF );
   
             if ( Card_Type == SD_CARD )
             {
                Buffer_Param[1] = hSD_Card_Addr;
                Buffer_Param[2] = lSD_Card_Addr;

                asm NOP
                MakeCRC7();
             }
      
              DTC_Process(MMC_CMD);		// use DTC function to issue CMD
              Wait_DTC_Stop_Fast();     
              asm NOP
   	   
   	      if (( Buffer_Param[0] != CMD13_START ) && ( Buffer_Param[3] & 0x01 ))
                 break ;
              else
                asm NOP

	    tmp++ ;
	    	           
              if ( tmp > 30 )
              {
                asm NOP
                return MAL_Error;
              }           
              else
                asm NOP

           }
*/

	   Buffer_Param[0] =  CMD18_START ;
   
//	   ptr = &Buffer_Param[1];
//	   ptr -> Addr =  Block_Address ;

             
           asm {
            LD A, Block_Address
            LD Buffer_Param:1, A
            
            LD A, Block_Address:1
            LD Buffer_Param:2, A
            
            LD A, Block_Address:2
            LD Buffer_Param:3, A
            
            LD A, Block_Address:3
            LD Buffer_Param:4, A
           }

               
	   MakeCRC7 ();              
	   Buffer_Param[6] =  NCR_CLK_CYC ; 
	   Buffer_Param[7] =  R1_RESPONSE_BYTES ;
	   Buffer_Param[8] = ( Card_Type | 0x07);

	   DTC_Process(MMC_CMD);
   	   Wait_DTC_Stop_Fast();     
	   asm NOP               
	
    // if ( ( Buffer_Param[0] ==  CMD18_INDEX ) && ( Buffer_Param[5] & 0x01 == 0x01 ) )
	// && ( Buffer_Param[5] & 0x01 == 0x01 ) )
	     
     if ( Buffer_Param[0] ==  CMD18_INDEX ) 
     {
	 MMC_state = CARD_SEND_DATA_STATE ;
                 
//        if ( err_chk == 0 )
           _MAL_BufMgr_Upload();	// ???????? use while integration 

	//------------------for testing only ---------------------    
   	/*
   	EP2TXR = (EP2TXR & 0x04) | 0x02; // NAK on Xmit, Keep DTOG
	CNT2TXR = 64;		// Set Xmit counter
	CNT2RXR = 64;		// Set Recv counter
	BUFSR = 0x01;		// Clear Buffer status
	BUFSR = 0;
	EP2RXR = (EP2RXR & 0x04) | 0x42;	// NAK on Recv & switch to UPLOAD mode
	//------------------for testing only ---------------------
      */     	
	 
	 if ( MAL_Block_Numbers >= 255 )
         {
           Buffer_Param[0] =  255;	/* max supported   = 255 blocks */ 
           MMC_blk_numbers = 255 ;
         }
         else                         
         {
 	   MMC_blk_numbers =  ( unsigned char )MAL_Block_Numbers ;
     	   Buffer_Param[0] =  MMC_blk_numbers; 
	//	Buffer_Param[0] -= 1;			   /*  decrement done afterwards */
		
         }
                     
       Buffer_Param[1] = Card_Type ;                     
     //  Buffer_Param[1] = 0x01 ;    
                     
   //    if ( BuffNum == 0 )
//          Buffer_Param[3] = BUFF0_PTR;
     //  else                         
       //   Buffer_Param[3] = BUFF1_PTR;
          
       
       Enable_DTC_Int();	// enable DTC interrupts 

      DTC_Process (MMC_DATA_IN_BUF0);	  /*          */	
          
       
    asm NOP 
    return MAL_GOOD;   
    

     }
     else
	  	return MAL_Error;     
 
   }

	return MAL_Error;

}


/****************************************************************************************/

                            
void issue_break ( void )
{                           
    	SendCMD ( CMD12_BUFF );
    	asm NOP               
//        Enable_DTC_Int();	// enable DTC interrupts 
		
//		MMC_Break(1);
//		MMC_Break(1);

		MMC_state = CARD_TRANSFER_STATE ;

   		MAL_Error = MAL_GOOD;
		MAL_Finish(TRUE); 
		
}

/*******************************************************************************
Routine name : MMC_Write
Argument     : void
Return       : void 
Variable     : 
Purpose      : To Write the MMC 
SubComponents : 
*******************************************************************************/
//#pragma NO_OVERLAP
BYTE MMC_Write (void)
{
//DWORD	Block_Address;
//union array_1_4 *ptr;
   
  MAL_Block_Finish = 0;     // ?????
  Block_Address = MAL_Block_Address * 512 ;

/*  	
  if ( Card_Type == HITACHI_CARD )
  {
     DTC_Load_Code(MMC_DnLoad);
     DTC_Code_Number = MMC_DTC_CODE_3;	
   }
  else 
  */
  
  if ( DTC_Code_Number != MMC_DTC_CODE_1 )  
  {
     DTC_Load_Code(MMC_DnLoad);
     DTC_Code_Number = MMC_DTC_CODE_1;
  }
  
/*
  if ( MMC_state == CARD_STANDBY_STATE )
  {

    Load_cmd ( CMD7_BUFF );            
    
    if ( Card_Type == SD_CARD )
    {
       Buffer_Param[1] = hSD_Card_Addr;
       Buffer_Param[2] = lSD_Card_Addr;

       MakeCRC7();
    }
	
    DTC_Process(MMC_CMD);		
    Wait_DTC_Stop_Fast();     
    asm NOP      
    
 	if ( Buffer_Param[0] != CMD7_INDEX ) 
 	{
	      MAL_Error = MAL_NO_ACTIVE;   
	      return MAL_Error;
	}   

	MMC_state = CARD_TRANSFER_STATE;

  }	
*/


   if ( MMC_state == CARD_TRANSFER_STATE  ) 
   {                    
        
        tmp=0;
        
   	   while ( 1 ) 
   	   {
             Load_cmd ( CMD13_BUFF );
   
             if ( Card_Type == SD_CARD )
             {
                Buffer_Param[1] = hSD_Card_Addr;
                Buffer_Param[2] = lSD_Card_Addr;

                asm NOP
                MakeCRC7();
             }
      
              DTC_Process(MMC_CMD);		/* use DTC function to issue CMD9 */	
              Wait_DTC_Stop_Fast();     
              asm NOP
   	   
   	      if (( Buffer_Param[0] != CMD13_START ) && ( Buffer_Param[3] & 0x01 ))
                 break ;
              else
                asm NOP

	    tmp++ ;
	    	           
              if ( tmp > 30 )
              {
                asm NOP
                return MAL_Error;
              }           
              else
                asm NOP

           }
           
	   Buffer_Param[0] =  CMD25_START ;
   
//	   ptr = &Buffer_Param[1];
//	   ptr -> Addr =  Block_Address ;
  
             asm {
            LD A, Block_Address
            LD Buffer_Param:1, A
            
            LD A, Block_Address:1
            LD Buffer_Param:2, A
            
            LD A, Block_Address:2
            LD Buffer_Param:3, A
            
            LD A, Block_Address:3
            LD Buffer_Param:4, A
           }
             
	   MakeCRC7 ();              
	   Buffer_Param[6] =  NCR_CLK_CYC ; 
	   Buffer_Param[7] =  R1_RESPONSE_BYTES ;
	   Buffer_Param[8] = ( Card_Type | 0x07);


	   DTC_Process(MMC_CMD);	
	   Wait_DTC_Stop_Fast();     
	   asm NOP               
   } 
   else
   {
	return MAL_Error;
   }
	

   if ( Buffer_Param[0] ==  CMD25_INDEX ) 
   {

//        if ( err_chk == 0 )
           _MAL_BufMgr_Download(); // ???????? use while integration 


  //  LOAD MMC_WRITE code into the DTC_RAM
/*	if ( DTC_MMC_Current_Func != DTC_MMC_WRITE )
	{
		DTC_Load_Code(DTC_WRITE);
		DTC_MMC_Current_Func = DTC_MMC_WRITE ;
	}
*/     
     MMC_state = CARD_RECEIVE_DATA_STATE ;


     if ( MAL_Block_Numbers >= 255 )
     {
         Buffer_Param[0] =  255;	// max supported   = 255 blocks
         MMC_blk_numbers = 255 ;
     }
     else                         
     {
 	MMC_blk_numbers =  ( unsigned char )MAL_Block_Numbers ;
     	Buffer_Param[0] =  MMC_blk_numbers ; 
		
     }
        
//        err_chk = 0;
	 
	 if ( Card_Type == HITACHI_CARD )
	    Buffer_Param[1] = 0x09;       // hitachi card require Rising edge for Writing     
	 else
	    Buffer_Param[1] = Card_Type ;


	 Buffer_Param[2] = Card_Type | 0x07;     
	     
//        if ( BuffNum == 0 )
//           Buffer_Param[3] = BUFF0_PTR;
  //      else                         
    //       Buffer_Param[3] = BUFF1_PTR;
	 
	 Enable_DTC_Int();	// enable DTC interrupts 

         DTC_Process (MMC_DATA_OUT_BUF0 );

   }    
    
    return MAL_GOOD;
      
}


/*******************************************************************************
Routine name : MMC_DTC_INT
Argument     : void 
Return       : void 
Variable     : 
Purpose      : DTC interrupt function 
SubComponents : 
*******************************************************************************/

#pragma NO_OVERLAP
void MMC_DTC_Int (void)
{

  MMC_IT_Type = DTCSTATUS & 0x03;   // FCISTATUS read and clear status

     if (( DTC_Code_Number != MMC_DTC_CODE_0 ) && ( DTC_Code_Number != MMC_DTC_CODE_1 ))
     { 
		DTC_Load_Code(MMC_UpLoad);
		DTC_Code_Number = MMC_DTC_CODE_0;
     }

     if ( MMC_IT_Type == DTC_STATUS_ERROR_STOP )
     {
        Buffer_Param[0] += 1 ;    // Increment as Already decremented in DTC code  
        BuffNum = ( MMC_blk_numbers-Buffer_Param[0] );                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
        BuffNum &= 0x01 ; 

	MAL_Block_Numbers = Buffer_Param[0] ;     // remaining blocks only
//        MAL_Block_Numbers -= MMC_blk_numbers;
//        MAL_Block_Numbers += Buffer_Param[0];    // +1      

        MAL_Block_Address += MMC_blk_numbers;
        MAL_Block_Address -= Buffer_Param[0];
//	       MAL_Block_Address -= 1;	 

         No_DTC_Int();

         SendCMD ( CMD12_BUFF );
         asm NOP                // stop data transfer
        
         err_chk++; 
          
         if ( err_chk >= 5 )
         {           
       
           err_chk =0;
           BuffNum = 0;

	    if ( MMC_state == CARD_SEND_DATA_STATE )
        	 MAL_Error = MAL_RD_ERR ; 
            else if ( MMC_state == CARD_RECEIVE_DATA_STATE )
	         MAL_Error = MAL_WR_ERR ; 

            MMC_state = CARD_TRANSFER_STATE ;
    
           MAL_Finish(FALSE);
           return ;		
         }
      }
      else if ( MMC_IT_Type == DTC_STATUS_STOP )
      {

                err_chk = 0;       
                BuffNum = 0;

    //_INC_Block_Param(MMC_blk_numbers);
	       MAL_Block_Numbers -= MMC_blk_numbers ;         
    	       MAL_Block_Address += MMC_blk_numbers ;     
	       MAL_Block_Finish += MMC_blk_numbers;

		  No_DTC_Int();
	    	  SendCMD ( CMD12_BUFF );
	    	  asm NOP               

	       if (!( MAL_Block_Numbers ))
	       {
                       MMC_state = CARD_TRANSFER_STATE ;
	    
	   		MAL_Error = MAL_GOOD;
			MAL_Finish(TRUE); 
                
                        return;
                        
     	        }
      
      
      }
         
	if (BuffNum & 0x01) {
		while (BUFSR & 0x06);		// Wait both buffer are empty
		BUFSR = 0x01;				// Clear Buffer status
		BUFSR = 0;
	}
    
    if ( MMC_state == CARD_SEND_DATA_STATE )
    {
         MMC_state = CARD_TRANSFER_STATE ;     // do as CMD12 already issued
         MMC_Read();
    }
    else if ( MMC_state == CARD_RECEIVE_DATA_STATE ) 
    {
    	 MMC_state = CARD_TRANSFER_STATE ;     // do as CMD12 already issued
         MMC_Write();
    }


}                                     


/*******************************************************************************
Routine name : MMC_Break
Argument     : 
Return       : void 
Variable     : 
Purpose      : Stops the Data Transfer by issuing CMD12
SubComponents : 
*******************************************************************************/
#pragma NO_OVERLAP
void MMC_Break (void)
{

/* load CMD12 into buffer_param & use DTC function to issue CMD12  */    
//    SendCMD ( CMD12_BUFF );
    asm NOP               

}                         

/*
void SMC_Break()
{
	// Stop the DTC execution despite its state
	Stop_DTC();
	DESELECT(MAL_Mediano);	// Chip deselect

	if (MAL_State != MAL_IDLE) {
		MAL_Finish(FALSE);
		MAL_State = MAL_IDLE;
		DTC_Current_Func = 0;
	}
}
*/


/*******************************************************************************
Routine name : MakeCRC7
Argument     : void 
Return       : void 
Variable     : 
Purpose      : To Calculate the CRC-7 for Buffer_Param[0] to Buffer_Param[4]
				rotate Left and add STOP bit and 
				place at Buffer_Param[5] , as required by MMC_CMD 
SubComponents : 
*******************************************************************************/
//#pragma NO_OVERLAP
void MakeCRC7 ( void )
{
/*

unsigned char crc;
unsigned char t1;
unsigned char t2;

unsigned char no_of_bits;
unsigned char no_of_bytes ;
unsigned char var;
                  
	crc = 0x00;

	for ( no_of_bytes=0 ; no_of_bytes <= 4 ; no_of_bytes++ )
	{    
		var =  Buffer_Param [no_of_bytes] ;

		for ( no_of_bits =0; no_of_bits <=7 ; no_of_bits++ )
		{
		  t1 = crc & 0x40;			// filter MSB of CRC7 ( 7 bit )

		  t2 = var & 0x80 ;			// filter MSB of byte
		  t2 >>= 1;                 // Bit align MSB with CRC7 ( to D6 )
		
		  t1 ^= t2 ;                // check the Ex-or
                     
     	  crc <<= 1;  
		  crc &= 0x7f ;			// CRC is 7 bit , filter 7 bits
          var <<= 1;              //  shift CRC left by 1

     	  if ( t1 )
		  {
	  		crc^= 0x09;
		  }         
		 
		}
     }          

	crc <<=1 ;				// rotate left to 1 bit, so as to adjust in 
								last byte of CMD packet  

	crc |= 0x01 ;			// include stop bit
							//  CRC variable now hold value of Last byte which
							should be at the end of packet

	Buffer_Param[5] = crc;	//  put at the 6th byte
	
*/	

unsigned char temp;
	asm {
		CLR		X
		LD		A, Buffer_Param
		CALLR	shifting
		LD		A, Buffer_Param:1
		CALLR	shifting
		LD		A, Buffer_Param:2
		CALLR	shifting
		LD		A, Buffer_Param:3
		CALLR	shifting
		LD		A, Buffer_Param:4
		CALLR	shifting
		SCF
		RLC		X
		LD		Buffer_Param:5, X
		RET

shifting:
		LD		temp, A

		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit1
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit1:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit2
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit2:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit3
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit3:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit4
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit4:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit5
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit5:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit6
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit6:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_bit7
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_bit7:
		SLL		temp
		SLL		X
		LD		A, X
		XOR		A, temp
		JRPL	shift_end
		LD		A, X
		XOR		A, #0x09
		LD		X, A
shift_end:
	}

}



/*******************************************************************************
Routine name : SetDriver
Argument     : void 
Return       : void 
Variable     : 
Purpose      : To Set the Driver outputs to Push-Pull 
SubComponents : 
*******************************************************************************/

void SetDriver( void )
{
/* Set DSR regsiter contents to toggle to PP mode */
/* Issue CMD4 		*/
}


/*******************************************************************************
Routine name : SendCMD
Argument     : char* 
Return       : void 
Variable     : 
Purpose      : Copies COMMAND buffer from ROM to RAM, Buffer_Param
			   issues the Command to MMC throuug the DTC,
			   Waits for NID/ NCR CYC
			   Get response in Buffer_param[]	
SubComponents : 
*******************************************************************************/

#pragma NO_OVERLAP
void SendCMD ( unsigned char* array_addr )
{

      No_DTC_Int();

 	for ( cmd_temp=0; cmd_temp <8 ; cmd_temp++ )
	{	
	  Buffer_Param[cmd_temp] =  array_addr[cmd_temp] ;
	}   

   Buffer_Param[8] = ( Card_Type | 0x07);
   
   DTC_Process(MMC_CMD);		/* use DTC function to issue CMD */	
   Wait_DTC_Stop_Fast();      

//    Wait_DTC_IT();     

//   DTC_Process( NID_CLK_CYC );		/*  produce NID clock cycles required by CMD */
//   Wait_DTC_Stop()    
//    asm NOP         

//   DTC_Process ( MMC_CMD1_RESPONSE );          /* get response from MMC */
// 	Wait_DTC_Stop()    
//  	asm NOP                  

}



/*******************************************************************************
Routine name : Load_cmd
Argument     : char* 
Return       : void 
Variable     :  
Purpose      : Copies COMMAND buffer from ROM to RAM, Buffer_Param
SubComponents : 
*******************************************************************************/

#pragma NO_OVERLAP
void Load_cmd ( unsigned char* array_addr )
{
unsigned char cmd_temp;

 	for ( cmd_temp=0; cmd_temp <8 ; cmd_temp++ )
	{	
	  Buffer_Param[cmd_temp] =  array_addr[cmd_temp] ;
	}   

   Buffer_Param[8] = ( Card_Type | 0x07);

}



/*******************************************************************************
Routine name : Init_buffer
Argument     : char* 
Return       : void 
Variable     :  ******* TESTING ONLY *************
Purpose      : Initialises buffer 0/1 to known value 
SubComponents : 
*******************************************************************************/

void Init_buffer ( unsigned char val1, unsigned char* array_addr )
{
     
 WORD temp ;
 
 	for ( temp=0; temp <512 ; temp++ )
	{	
	  array_addr[temp] =  val1 ;
	}   

asm NOP
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : Wait_DTC_Stop
INPUT/OUTPUT : None
DESCRIPTION  : None
-----------------------------------------------------------------------------*/
/*
void Wait_DTC_IT (void)
{
 while (DTC_Int_Wait)    // wait for the DTC interrupt
 asm NOP;
 DTC_Int_Wait = 1;      
}
*/

/*-----------------------------------------------------------------------------
ROUTINE NAME : Wait_DTC_Stop
INPUT/OUTPUT : None
DESCRIPTION  : None
-----------------------------------------------------------------------------*/
#pragma NO_OVERLAP
void Wait_DTC_Stop_Fast()
{
	// This function should be called on shorter DTC functions
	// Sometime the DTC does not stop itself when it finished
	// We use the Timeout variable to count the time and
	// and return a success status when the time is up

	// This loop is about 30ms

	for (Time3 = 30; Time3; Time3--)
		for (Time4 = 255; Time4; Time4--) {
			DTC_Status1 = DTCSTATUS & 0x03;
			if (DTC_Status1)
				goto time_up;
		}

	asm nop;

time_up:                 
//    for (Time1 = 5; Time1; Time1--) ;	/* Provide some delay to avoid problem in Interrupt */
//	MMC_IT_Type = 0;		// initialise again to zero
//	DESELECT(MAL_Mediano);	// Chip deselect
  
    Stop_DTC();
//	DTCCTRL  &= ~DTC_START;	// Force DTC to stop
//	return DTC_Status1;
}   

unsigned char MMC_Format(void)
{
	return MAL_GOOD;
}

unsigned char MMC_Verify(void)
{
	return MAL_GOOD;
}

unsigned char MMC_Check_Write_Protect()
{
	return 0;
}


#pragma NO_RETURN
void MAL_MMC_Funcs(void)
{
	// IMPORTANT: The sequence of this jump table can not be changed
	// New line can be appended at the end of the table
	asm {
		jp	MMC_Init				// 0
		jp	MMC_Read				// 1
		jp	MMC_Write				// 2
		jp	MMC_Verify				// 3
		jp	MMC_Format				// 4
		jp	MMC_Read_Capacity		// 5
		jp	MMC_Check_Write_Protect		// 6
		jp	MMC_Break				// 7
//		jp	MMC_DTC_Int				// 8

	}
}



/************ END of FILE ******************************************/















