/**************** (c) 1999  STMicroelectronics **********************

PROJECT : ST7265

VERSION :

CREATION DATE :

AUTHOR : MICROCONTROLLER DIVISION

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

REM:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/
typedef unsigned char	BYTE;     
//typedef unsigned int	WORD;
typedef unsigned long	DWORD;
                                
/************* Functions prototype declarations  ****************/

//extern unsigned char break_flag;

extern void issue_break ( void );

extern void MMC_test ( void );
extern unsigned char MMC_Init (void);
extern unsigned char MMC_Read_Capacity (void);        

extern unsigned char MMC_init_to_Stby ( void ) ;
extern void Compute_Capacity (void );
extern void MakeCRC7 ( void );    
extern void SetBlockLength (void );
extern void SetDriver( void );
extern BYTE MMC_Read (void);
extern void issue_CMD7 (void);
extern void MMC_DTC_Int (void);
extern void MMC_Write_Interrupt(void );
extern void MMC_Read_Interrupt(void );
extern void MMC_Break(void);
extern void Load_cmd ( unsigned char*  );
extern void SendCMD ( unsigned char* );
extern BYTE MMC_Test_Ready(void); 
extern BYTE MMC_Write (void);
extern void Wait_DTC_IT(void);
extern void Wait_DTC_Stop_Fast(void);

extern void Init_buffer ( unsigned char, unsigned char* );

/************* Different Constant Buffers for COMMANDs declared  *****/
#pragma INTO_ROM
extern const unsigned char MMC_INIT_SEQ[]; 

#pragma INTO_ROM
extern const unsigned char CMD0_BUFF[]; 

#pragma INTO_ROM
extern const unsigned char CMD1_BUFF[]; 

#pragma INTO_ROM
extern const unsigned char CMD2_BUFF[]; 

#pragma INTO_ROM        
extern const unsigned char CMD3_BUFF[]; 

#pragma INTO_ROM
extern const unsigned char SD_CMD3_BUFF [];

#pragma INTO_ROM
extern const unsigned char CMD7_BUFF[]; 

#pragma INTO_ROM
extern const unsigned char CMD9_BUFF[]; 

#pragma INTO_ROM
extern const unsigned char CMD12_BUFF[];

#pragma INTO_ROM
extern const unsigned char CMD13_BUFF[];

#pragma INTO_ROM
extern const unsigned char CMD16_BUFF[];

#pragma INTO_ROM
extern const unsigned char ACMD41_BUFF[];

#pragma INTO_ROM
extern const unsigned char CMD55_BUFF[];
                                                                         
#define TRUE 1
#define FALSE 0
                                                                         
                                                                         
/************* DTC PCR values defined for different functions  *************/
#define MMC_CMD 	0x00

//#define MMC_CHK_DATA_RDY    0x6C
//#define HCHI_DATA_IN_BUF0    0x58
//#define HCHI_DATA_OUT_BUF0   0x58
#define MMC_DATA_IN_BUF0    0x58
#define MMC_DATA_OUT_BUF0   0x58

/************** Constant used for reading the MMC into Buffer Num  */
/*************  Valuse put in ADR1 in DTC code ****/

#define BUFF0_PTR 0x01
#define BUFF1_PTR 0x03

/************  Constants used with DTC_Code_Number    ******************/
#define MMC_DTC_CODE_0	    0x10
#define MMC_DTC_CODE_1	    0x11

//#define MMC_DTC_CODE_2	    0x12
//#define MMC_DTC_CODE_3	    0x13

/********** Following Definations correspond to CMD buffer ***************/
/******  CMD 1st byte = Start bit=0 | Transmit direction=1 | CMD_index  **/
/******  	40 | CMD = 0				1					 CMD	******/

#define CMD_BUFF_SIZE		8

#define   CMD0_INDEX    0 
#define   CMD1_INDEX    1
#define   CMD2_INDEX    2
#define   CMD3_INDEX    3
#define   CMD7_INDEX    7
#define   CMD9_INDEX    9
#define   CMD10_INDEX   10
#define   CMD11_INDEX   11
#define   CMD12_INDEX   12
#define   CMD13_INDEX   13
#define   CMD16_INDEX   16
#define   CMD17_INDEX   17
#define   CMD18_INDEX   18
#define   CMD24_INDEX   24
#define   CMD25_INDEX   25
#define   CMD41_INDEX   41
#define   CMD55_INDEX   55
#define   CMD59_INDEX   59   

#define   CMD0_START    (0x40 | CMD0_INDEX )
#define   CMD1_START    (0x40 | CMD1_INDEX )
#define   CMD2_START    (0x40 | CMD2_INDEX )
#define   CMD3_START    (0x40 | CMD3_INDEX )
#define   CMD7_START    (0x40 | CMD7_INDEX )
#define   CMD9_START    (0x40 | CMD9_INDEX )
#define   CMD10_START   (0x40 | CMD10_INDEX )
#define   CMD11_START   (0x40 | CMD11_INDEX )
#define   CMD12_START   (0x40 | CMD12_INDEX )
#define   CMD13_START   (0x40 | CMD13_INDEX )
#define   CMD16_START   (0x40 | CMD16_INDEX )
#define   CMD17_START   (0x40 | CMD17_INDEX )
#define   CMD18_START   (0x40 | CMD18_INDEX )
#define   CMD24_START   (0x40 | CMD24_INDEX )
#define   CMD25_START   (0x40 | CMD25_INDEX )
#define   CMD41_START   (0x40 | CMD41_INDEX )
#define   CMD55_START   (0x40 | CMD55_INDEX )
#define   CMD59_START   (0x40 | CMD59_INDEX )   

/******* Following CONSTANTS are used in Command Buffer *****************/
#define  NID_CLK_CYC 10   	/* 5-1 = 4  = produce 5 clocks */
#define  NCR_CLK_CYC 128        /* 64-1 = 63 = produce 64 clocks */ 

#define NO_RESPONSE 		0
#define R1_RESPONSE_BYTES   6      /*  6 bytes + 1 = 7bytes shifted in , decrement done afterwards  */
#define R1b_RESPONSE_BYTES  6
#define R2_RESPONSE_BYTES  17   	/*	17 bytes + 1 = 18bytes shifted in, decrement done afterwards */
#define R3_RESPONSE_BYTES   6                                                                       
#define R4_RESPONSE_BYTES   6                                                                       
#define R5_RESPONSE_BYTES   6                                                                       

/********* Constants defined for reference for MMC_state  **********/
/*  Same values taken as in CARD STATUS field 12:9   */

#define CARD_IDLE_STATE 		00
#define CARD_READY_STATE 		01
#define CARD_IDENTIFICATION_STATE 02
#define CARD_STANDBY_STATE 		03

#define CARD_TRANSFER_STATE 	04
#define CARD_SEND_DATA_STATE 	05

#define CARD_RECEIVE_DATA_STATE 06
#define CARD_PROGRAMMING_STATE  07
#define CARD_DISCONNECT_STATE 	08

#define CARD_INACTIVE_STATE 	09
#define CARD_WAIT_IRQ_STATE 	10
              
/*
0 = idle
1 = ready
2 = ident
3 = stby
4 = tran
5 = data
6 = rcv
7 = prg
8 = dis
9-15 = reserved
*/                                   

/**************  CONSTANTS used for checking plug-in loaded in DTC RAM
used with variable  DTC_MMC_Current_Func    ***************/

#define DTC_MMC_IDLE   0
#define DTC_MMC_READ   1
#define DTC_MMC_WRITE  2
#define DTC_MMC_FORMAT 4

/*************** Constants used for DTC STATUS REGISTER   ****************/
#define DTC_STATUS_STOP       0x1
#define DTC_STATUS_ERROR      0x2
#define DTC_STATUS_ERROR_STOP 0x3

/*************** Constants used for Card_Type   ****************/

#define MMC_CARD  	0x09    /* rising edge response */
#define HITACHI_CARD  	0x01    /* Falling edge response */
#define SD_CARD  	0x08    /* rising edge response */
                                                                         
/**************  CONSTANTS used for MAL_ERROR_NO  ***********************/
                     
#define MAL_GOOD	0x00
#define MAL_UNKNOW	0x01
#define MAL_SOFT	0x02
#define MAL_UNSUPPORT	0x03
#define MAL_NO_CARD	0x04
#define MAL_NO_WRITE	0x05
#define MAL_NO_POWER	0x06
#define MAL_NO_ACTIVE	0x07
#define MAL_CARD_UNKNOWN 0x08
#define MAL_NEW_CARD	0x09
#define MAL_BUSY	0x0A
	
#define MAL_RD_ERR	0x10
#define MAL_WR_ERR	0x11
#define MAL_TIMEOUT	0x12
#define MAL_MISS_MATCH	0x13
#define MAL_OUT_RANGE	0x14
	

/********** Union / Structure declaration ***************/
                   
union array_1_4
{ 
  unsigned long Addr;
  unsigned char Addr_array[4];
} ;
 
extern union array_1_4 *ptr;


/******************************    End of File		********************/