/*-*-*-*-*-*-*-*-*-*-* (C) 2000 STMicroelectronics *-*-*-*-*-*-*-*-*-*-*-*-*-*

PROJECT  : ST7265 Media Access Library
COMPILER : ST7 C

MODULE  :  MAL.h
VERSION :  V 0.5

CREATION DATE :  21/12/2000

AUTHOR : Liang Ping
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

DESCRIPTION : All functions and variables export from the MAL

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

Modification:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#ifndef MAL_H
#define MAL_H 

#define ALLOW_OUT_RANGE	0
#if ALLOW_OUT_RANGE
extern char Mal_Addr_Out_Range;
//		+----+----+----+----+----+----+----+----+
//		|    |    |    |    |    |will| now| was|
//		+----+----+----+----+----+----+----+----+
//	bit 0 = 1; the address was out of range
//	bit 1 = 1; the address is out of range now
//	bit 2 = 1; the address will be out of range
#endif

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* VARIABLES *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#pragma DATA_SEG MAL_RAM
extern unsigned char	MAL_Error;
extern unsigned char	MAL_State;
extern unsigned long	MAL_Capacity;

#pragma DATA_SEG SHORT MAL_RAM0	// Frequently used variable
extern unsigned short	MAL_Block_Numbers;
extern unsigned short	MAL_Block_Finish;
extern unsigned long	MAL_Block_Address;
extern unsigned char	MAL_Mediano;
extern unsigned char	OLD_MAL_Mediano;

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-* ERROR CODES *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#define MAL_GOOD	0x00	// No error, operation successes
#define MAL_UNKNOW	0x01	// Unknown error, or error is not categorized
#define MAL_SOFT	0x02	// The software error
#define MAL_UNSUPPORT  	0x03	// Unsupported operation
#define MAL_NO_CARD	0x04	// The medium is not in the slot
#define MAL_NO_WRITE 	0x05	// The medium is write-protected
#define MAL_NO_POWER	0x06	// The medium is in the slot but is not powered
#define MAL_NO_ACTIVE	0x07	// The medium is in the slot but is not in active mode
#define MAL_CARD_UNKNOWN 0x08	// The medium is exist in the slot but its format is unknown
#define MAL_NEW_CARD	0x09	// A new medium is inserted in the slot
#define MAL_BUSY	0x0A	// Another operation is on going
#define MAL_BAD_MEDIUM	0x0B	// The medium can not be used, too many bad blocks or ...
		
#define MAL_RD_ERR	0x10	// Error on read the medium
#define MAL_WR_ERR	0x11	// Error on write the medium
#define MAL_TIMEOUT	0x12	// Access is timeout
#define MAL_MISS_MATCH	0x13	// Verifying data failed
#define MAL_OUT_RANGE	0x14	// The card access is out of range, the address is not exist

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-* MAL STATES -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#define MAL_IDLE	0	// None
#define MAL_READING	1	// MAL_Read()
#define MAL_WRITING	2	// MAL_Write()
#define MAL_VERIFYING	3	// MAL_Verify()
#define MAL_FORMATTING	4	// MAL_Format()
#define MAL_MEM_READING	5	// MAL_mRead()
#define MAL_MEM_WRITING	6	// MAL_mWrite()
#define MAL_COPYING		7	// A special state, see "MAL_SMC.c"

/*-*-*-*-*-*-*-*-*-*-*-* State of Buffer Manager  *-*-*-*-*-*-*-*-*-*-*-*-*-*/
#define BUFMGR_DOWNLOAD_MODE	((EP2RXR & 0x80) != 0)
#define BUFMGR_UPLOAD_MODE		((EP2RXR & 0x40) != 0)
#define BUFMGR_NORMAL_MODE		((EP2RXR & 0xC0) == 0)

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-* FUNCTIONS -*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

extern unsigned char MAL_Test_Ready();
extern char MAL_Read_Capacity();
extern char MAL_Read();
extern char MAL_Write();
extern char MAL_Format();
extern void MAL_Finish(unsigned char Result);

extern void _MAL_BufMgr_Upload(void);
extern void _MAL_BufMgr_Download(void);
extern void _MAL_BufMgr_Normal(void);
extern void _MAL_INC_Block_Param(unsigned char delta);
extern void _MAL_DEC_Block_Param(unsigned char delta);


#endif