/*-*-*-*-*-*-*-*-*-*-* (C) 2000 STMicroelectronics *-*-*-*-*-*-*-*-*-*-*-*-*-*

PROJECT  : ST7265 Media Access Library
COMPILER : ST7 C

MODULE  :  MAL_All.c
VERSION :  V 0.5

CREATION DATE :  04/12/2000

AUTHOR : Liang Ping
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

DESCRIPTION : All functions except those with individual one

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

Modification:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	VARIABLES	VARIABLES	VARIABLES	VARIABLES	VARIABLES	VARIABLES
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#include "define.h"
#include "Map_7265.h"
#include "Mconfig.h"		// Media configuration
#include "MSL.h"
#include "MAL_Map.h"
#include "MAL.h"
#include "SMC_Mass.h"
#include "DTC_Func.h"

/* DEBUGING STUFF
typedef struct record {
	unsigned short address;
	unsigned short number;
} RECORD;
RECORD *pRecord;
int iRecord;
#define POLL_SIZE	512

void debug_copy8M()
{
	if (iRecord == POLL_SIZE)
		return;

	if (pRecord == (RECORD*)0)
		pRecord = (RECORD*)SMC_Lookup_Table1;

	pRecord->address = MAL_Block_Address;
	pRecord->number = MAL_Block_Numbers;
	pRecord++;
	iRecord++;
}
/* DEBUGING STUFF	*/

#define ALLOW_ERROR	1
#define USE_CACHE0	1

/*-*-*-*-*-*-*-*-*-*-*-*-*-* Variable declaration *-*-*-*-*-*-*-*-*-*-*-*-*-*/
#pragma DATA_SEG SHORT MAL_RAM0	// Frequently used variable
// SMC_Wstate keeps track the state of the SMC writing procedure
// Bits definition:
//	bit0	= 0 actions on new cluster
//			= 1 actions on old cluster
//	bit1-0	= 00 MARKing
//			= 01 COPYing
//			= 10 WRITE to new cluster
//			= 11 WRITE to old cluster
//	bit3-2	= 00 PRE actions
//			= 01 POST actions
//			= 10 HOLE actions
//			= 11 HOLE or FULL actions
static unsigned char	SMC_Wstate;		// the state of the SMC writing procedure
#define SMC_OLD_CLUSTER			0x01
#define	SMC_WRITE_FLAG			0x02
#define SMC_PRE_ACTION			0x00
#define SMC_POST_ACTION			0x04
#define SMC_HOLE_ACTION			0x08
#define SMC_FULL_ACTION			0x0C
#define SMC_ERROR_FLAG			0x10
#if ALLOW_OUT_RANGE
#define SMC_OUT_RANGE			(0x20 | SMC_WRITE_FLAG)
#endif

#define SMC_PREMARK			(SMC_PRE_ACTION | !SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// 0
#define SMC_PRECOPY			(SMC_PRE_ACTION | !SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// 1
#define SMC_PRENEWWRITE		(SMC_PRE_ACTION | SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// 2
#define SMC_PREOLDWRITE		(SMC_PRE_ACTION | SMC_WRITE_FLAG | SMC_OLD_CLUSTER)		// 3
#define SMC_POSTMARK		(SMC_POST_ACTION | !SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// 4
#define SMC_POSTCOPY		(SMC_POST_ACTION | !SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// 5
#define SMC_POSTNEWWRITE	(SMC_POST_ACTION | SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// 6
#define SMC_POSTOLDWRITE	(SMC_POST_ACTION | SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// 7
#define SMC_PREHOLEMARK		(SMC_HOLE_ACTION | !SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// 8
#define SMC_PREHOLECOPY		(SMC_HOLE_ACTION | !SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// 9
#define SMC_HOLENEWWRITE	(SMC_HOLE_ACTION | SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// A
#define SMC_HOLEOLDWRITE	(SMC_HOLE_ACTION | SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// B
#define SMC_POSTHOLEMARK	(SMC_FULL_ACTION | !SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// C
#define SMC_POSTHOLECOPY	(SMC_FULL_ACTION | !SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// D
#define SMC_FULLNEWWRITE	(SMC_FULL_ACTION | SMC_WRITE_FLAG | !SMC_OLD_CLUSTER)	// E
#define SMC_FULLOLDWRITE	(SMC_FULL_ACTION | SMC_WRITE_FLAG | SMC_OLD_CLUSTER)	// F

static unsigned char SMC_Cluster_Size;	// Size of a cluster

#define LOOKUP_THRESHOLD	16
static unsigned char SMC_Zone;
static unsigned char SMC_Lookup_Zone0;	// Zone of table0
static unsigned char SMC_Lookup_Zone1;	// Zone of table1
static unsigned char SMC_Lookup_Count0;	// Visit count of table0
static unsigned char SMC_Lookup_Count1;	// Visit count of table1
static unsigned short *SMC_Lookup_pTable;// The pointer of the current table
// When the zone 0 is not in one of two lookup table
// The follow small lookup table keeps the initial few items of zone 0
static unsigned char SMC_Lookup_nCache0;// number of items in zone 0 Cache
									// number of sectors for MBR, PBR, FAT & Root
#if USE_CACHE0
#define CACHE0_NUM			5
#define CACHE0_FREE			3
static unsigned short SMC_Lookup_pCache0[CACHE0_NUM];
// The following array is used to cache the free cluster
// for zone 0 when zone 0 is not in the lookup table area
static unsigned short SMC_Lookup_pFree0[CACHE0_FREE];
#endif // USE_CACHE0

static unsigned short SMC_Paddr;
static unsigned short SMC_Raddr;		// An old physical cluster
static unsigned char SMC_Npage;
static unsigned char SMC_Ppage;

unsigned short	SMC_Laddr;
unsigned long	malPaddr;
unsigned long	malRaddr;
unsigned char	malNpage;

#pragma DATA_SEG MAL_RAM
static unsigned char SMC_4MB;			// The SMC is a 4MB card
static unsigned char DTC_Error;
static unsigned char DTC_Current_Func;
#define DTC_SMC_READ	0x01
#define DTC_SMC_WRITE	0x02
#define DTC_SMC_FORMAT	0x04

static unsigned char SMC_Addr_Bytes;

/*-*-*-*-*-*-*-*-*-*-*-*-*-* Variable declaration *-*-*-*-*-*-*-*-*-*-*-*-*-*/
//unsigned long	malPaddr, malRaddr;
//unsigned char	malNpage;

// Buffer for redundant area
typedef struct _SPARE_AREA {
	union {
		unsigned long	dwReserved;
		unsigned short	wReserved[2];
	} R;
	unsigned char	Data_Status;
	unsigned char	Block_Status;
	unsigned short	Block_Address1;
	unsigned char	ECC2[3];
	unsigned short	Block_Address2;
	unsigned char	ECC1[3];
} SPARE_AREA;
static SPARE_AREA	SMC_Spare;

#pragma CODE_SEG SMC_CODE
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
				Organization of the Lookup Table

  There are two lookup tables, table0 & table1. Table0 always keep the
  information for Zone 0 and the Table1 keeps the information for the current
  working Zone.

  A lookup table is a buffer with 1024 elements. The index of this buffer is
  the logical address and the content of each element is the corresponding
  physical address.
  Assume LUT[x] is the value of xth element:
	LUT[x] < 1024	LUT[x] is the physical address of logicall address x
	LUT[x] >= 1024	(LUT[x] & 1024) is a free physical address and will be
					allocated to the logical address of x.
  NOTE: LUT[x] IS CONVERTED TO DTC ADDRESS FOR FASTING ACCESS
		LUT[x] >> 5 or LUT[x] >> 4 is the real physical cluster address

  Using the lookup table:
  The first 1000 elements of a lookup table are used for mapping the logical
  address to physical address. All the bad physical block addresses are saved
  at the end of this table. Elements start from index 1000 are available to
  use for new allocation.
	x < 1000		LUT[x] is used for mapping
	x >= 1024 - n	LUT[x] is the physical address of a bad physical cluster
					n is the number of bad blocks.
	x >= 1000 & x < 1024 -n
					LUT[x] is the free physical cluster that can be allocated
  When an existing physical cluster is over-written, the free cluster on the
  index 1000 is used. Then the old cluster is erased and put in the location
  of index 1000.

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#pragma NO_ENTRY
void SMC_Convert_Lookup(unsigned short *LUT)
{
	unsigned short	*pLUT;
	asm {
		LD		pLUT:1, A
		LD		pLUT, X

		CLR		Y					// Y counts 256 times
		CALL	convert_table256	// First 256 items
		CALL	convert_table256	// Second 256 items
		CALL	convert_table256	// Third 256 items
									// Forth 256 items
convert_table256:
		LD		X, #1
		LD		X, ([pLUT.w],X)

		LD		A, SMC_Cluster_Size
		CP		A, #32
		JRNE	cvt_less_16MB
		LD		A, [pLUT.w]		// A:X = value	A=HIBYTE, X=LOBYTE
		PUSH	A
		SLL		X
		RLC		A
		JRT		cvt_all
cvt_less_16MB:
		LD		A, [pLUT.w]		// A:X = value	A=HIBYTE, X=LOBYTE
		PUSH	A
		AND		A, #0xFB		// value &= ~0x0400;
cvt_all:
		SLL		X
		RLC		A
		SLL		X
		RLC		A
		SLL		X
		RLC		A
		SLL		X
		RLC		A
		LD		[pLUT.w], A
		INC		pLUT:1

		POP		A				// HIBYTE of the value
		BCP		A, #0x20		// Check the bad block
		JREQ	cvt_next
		INC		X
cvt_next:
		LD		[pLUT.w],X

		INC		pLUT:1
		JRNE	cvt_loop
		INC		pLUT
cvt_loop:
		DEC		Y
		JRNE	convert_table256
	}
/* The following lines are same as the above assembly lines
	unsigned int	Index = 1024;
	do {
		unsigned short value;
		Index--;
		value = *pLUT;
		if (SMC_Cluster_Size == 32)
			*pLUT = value << 5;
		else {
			value &= ~0x0400;
			*pLUT = value << 4;
		}
		if (value & 0x2000)
			*pLUT |= 0x01;		// bad cluster
		pLUT++;
	} while (Index);
*/
}

#define	Map_To_DTC_Addr(Target, zone, addr, page)	\
	{	((_UDWORD*)&Target)->byte[3] = LOBYTE((unsigned int)(addr)) | (unsigned char)(page);	\
		((_UDWORD*)&Target)->byte[2] = HIBYTE((unsigned int)(addr));	\
		if (SMC_Cluster_Size == 32) {	\
			if (zone & 1)	\
				((_UDWORD*)&Target)->byte[2] |= 0x80;	\
			((_UDWORD*)&Target)->byte[1] = (unsigned char)zone >> 1;	\
		}	\
		else	\
			((_UDWORD*)&Target)->byte[1] = 0;	\
		((_UDWORD*)&Target)->byte[0] = 0;		\
	}

#define	Map_DTC_Addr(zone, addr, page)	\
	(SMC_Cluster_Size == 32) ?	\
		/* 11111111				ZZZ:		physical zone				*/ \
		/* 765432109876543210	BBBBBBBBBB: physical cluster address	*/ \
		/* ZZZBBBBBBBBBBPPPPP:	PPPPP:		physical page address		*/ \
		((DWORD)(zone) << 15) | (unsigned int)(addr) | (unsigned char)(page) :	\
		/* 1111														*/ \
		/* 32109876543210	BBBBBBBBBB: physical cluster address	*/ \
		/* BBBBBBBBBBPPPP:	PPPP:		physical page address		*/ \
		(unsigned int)(addr) | (unsigned char)(page);

void SMC_Paddr_To_DTC_Addr(void)
{
	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
}

unsigned short SMC_Get_Free()
{
#ifdef USE_CACHE0
	if (SMC_Lookup_pTable == SMC_Lookup_pCache0)
		return SMC_Lookup_pFree0[0];
#endif
	if (SMC_4MB)
		return SMC_Lookup_pTable[500];
	return SMC_Lookup_pTable[1000];
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Replace SMC_Laddr with SMC_Paddr and set SMC_Raddr on logical address 1000
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_Update_Lookup()
{
#if ALLOW_OUT_RANGE
	if (Mal_Addr_Out_Range & 0x01)
		return;
#endif
	SMC_Lookup_pTable[SMC_Laddr] = SMC_Paddr;

	if (SMC_Wstate & SMC_OLD_CLUSTER) {
	//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Raddr, 0);
		Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Raddr, 0);
		if (DTC_SMC_Erase() != 0x01)		// Erase the dirty cluster of malPaddr
			asm NOP;

#ifdef USE_CACHE0
		if (SMC_Lookup_pTable == SMC_Lookup_pCache0)
			SMC_Lookup_pFree0[0] = SMC_Raddr | 0x8000;
		else
#endif
			if (SMC_4MB)
				SMC_Lookup_pTable[500] = SMC_Raddr | 0x8000;
			else
				SMC_Lookup_pTable[1000] = SMC_Raddr | 0x8000;
	}
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Convert the SMC_Laddr to SMC_Paddr in SMC_Zone
	return TRUE if the logical Cluster of SMC_Laddr exists
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#if USE_CACHE0
void SMC_Copy_Lookup_Cache0()
{
	unsigned short *pW;

	// Copy the first few lookup items of zone0
	// They are PBR, MBR, FAT & ROOT
	asm {
		ld		X, SMC_Lookup_nCache0
		sll		X
		dec		X
copy_cache:
		ld		A, ([SMC_Lookup_pTable.w],X)
		ld		(SMC_Lookup_pCache0,X),A
		dec		X
		jrpl	copy_cache
	}
//	for (index = Lookup_nCache-1; index >= 0; index--)
//		SMC_Lookup_pCache0[index] = SMC_Lookup_pTable[index];

	// Copy the first few free lookup items of zone0
	asm {
		ld		A, SMC_Lookup_pTable:1
		add		A, #0xD0
		ld		pW:1, A
		ld		A, SMC_Lookup_pTable
		adc		A, #0x07
		ld		pW, A
	}
//	pW = SMC_Lookup_pTable+1000;

	asm {
		ld		X, #CACHE0_FREE*2-1
copy_free0:
		ld		A, ([pW.w], X)
		ld		(SMC_Lookup_pFree0,X), A
		dec		X
		jrpl	copy_free0
	}

//	for (index = CACHE0_FREE-1; index >= 0; index--)
//		SMC_Lookup_pFree0[index] = pW[index];
}
#endif // USE_CACHE0

#pragma DATA_SEG DEFAULT_RAM	// After here, all variable will be in non-Zero page

//#pragma NO_OVERLAP
void SMC_Lookup_Update0(unsigned char Zone)
{
	SMC_Lookup_pTable = SMC_Lookup_Table0;
#if USE_CACHE0
	if (SMC_Lookup_Zone0 == 0)
		SMC_Copy_Lookup_Cache0();
#endif
	SMC_Lookup_Count0 = 0;
	SMC_Lookup_Zone0 = Zone;

Lookup_Update:
	malRaddr = 1024;		// number of clusters in the zone
	if (SMC_4MB)
		malRaddr = 512;
	malNpage = SMC_Cluster_Size;
	Map_To_DTC_Addr(malPaddr, Zone, 0, 0);
	DTC_SMC_Map_Zone(SMC_Lookup_pTable);
	SMC_Convert_Lookup(SMC_Lookup_pTable);
}

//#pragma NO_OVERLAP
void SMC_Lookup_Update1(unsigned char Zone)
{
	SMC_Lookup_pTable = SMC_Lookup_Table1;
#if USE_CACHE0
	if (SMC_Lookup_Zone1 == 0)
		SMC_Copy_Lookup_Cache0();
#endif
	SMC_Lookup_Count1 = 0;
	SMC_Lookup_Zone1 = Zone;

	malRaddr = 1024;		// number of clusters in the zone
//	if (SMC_4MB)			// 4MB does not use LOOKUP Table 1
//		malRaddr = 512;
	malNpage = SMC_Cluster_Size;
	Map_To_DTC_Addr(malPaddr, Zone, 0, 0);
	DTC_SMC_Map_Zone(SMC_Lookup_pTable);
	SMC_Convert_Lookup(SMC_Lookup_pTable);
}

BOOL SMC_Log2Phy()
{
#if ALLOW_OUT_RANGE
	if (Mal_Addr_Out_Range & 0x03)
		return FALSE;	// The address is out of range now
#endif

	if (SMC_Zone == SMC_Lookup_Zone0) {		// Hit on table0
		SMC_Lookup_pTable = SMC_Lookup_Table0;
		if (SMC_Lookup_Count0 != LOOKUP_THRESHOLD)
			SMC_Lookup_Count0++;	// increase the visit counter of this table
		if (SMC_Lookup_Count1 != 0)
			SMC_Lookup_Count1--;	// decrease the visit counter of another table
	}
	else if (SMC_Zone == SMC_Lookup_Zone1) {// Hit on table1
		SMC_Lookup_pTable = SMC_Lookup_Table1;
		if (SMC_Lookup_Count1 != LOOKUP_THRESHOLD)
			SMC_Lookup_Count1++;	// increase the visit counter of this table
		if (SMC_Lookup_Count0 != 0)
			SMC_Lookup_Count0--;	// decrease the visit counter of another table
	}
	else {
		// No hit on both table
#ifdef USE_CACHE0
		// The _SMC_Get_Logical_Addr() gurantees it is on zone0 cache
		SMC_Lookup_pTable = SMC_Lookup_pCache0;
#else
		asm nop;	// There must be a bug if we are here
#endif
	}

	SMC_Paddr = SMC_Lookup_pTable[SMC_Laddr];
	return ((SMC_Paddr & 0x8000) == 0);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Mark and add SMC_Zone:SMC_Paddr to end of the lookup table
	SMC_Laddr is the logical cluster number.
	On return: SMC_Zone:SMC_Paddr will be the good cluster form SMC_Laddr
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_Lookup_Map_Bad(void)
{
	unsigned int	temp;
	unsigned short*	pBad;

#if USE_CACHE0
	if (SMC_Lookup_pTable != SMC_Lookup_pCache0) {
		pBad = SMC_Lookup_pTable + 1023;		// the last item
		while (*pBad & 0x0F)
			pBad--;

		temp = *pBad;
		*pBad = SMC_Paddr | 0x0001;
	}
	else {
		// shift the free cluster array
		// SMC_Lookup_pFree0[0] = SMC_Lookup_pFree0[1];
		// SMC_Lookup_pFree0[1] = SMC_Lookup_pFree0[2];
		// .........
		asm {
			clr		X
shift_free0:
			ld		A, (SMC_Lookup_pFree0:2,X)
			ld		(SMC_Lookup_pFree0,X), A
			inc		X
			cp		X, #CACHE0_FREE*2-3
			jrne	shift_free0
		}
		temp = SMC_Lookup_pFree0[0];
	}
#else
	pBad = SMC_Lookup_pTable + 1023;		// the last item
	while (*pBad & 0x0F)
		pBad--;

	temp = *pBad;
	*pBad = SMC_Paddr | 0x0001;
#endif // USE_CACHE0

	SMC_Paddr = temp & 0x7FFF;			// re-allocate a good cluster
										// ASSUME THIS IS A GOOD ONE
}

unsigned char SMC_Read_Capacity(void)
{
	unsigned char	CardID;

	CardID = DTC_SMC_ReadID();

	SMC_4MB = 0;
	MAL_Capacity = 0;
	SMC_Lookup_nCache0 = 0;		// No zone0 cache with card < 64MB
	SMC_Cluster_Size = 16;
	SMC_Addr_Bytes = 3;
	if (CardID == 0xE3 || CardID == 0xE5) {	// 4MB
		SMC_4MB = 1;
		MAL_Capacity = 8000;
	}
	else if (CardID == 0xE6)		// 8MB
		MAL_Capacity = 16000;
	else {
		SMC_Cluster_Size <<= 1;
		if (CardID == 0x73) {		// 16MB
			MAL_Capacity = 32000;
		}
		else if (CardID == 0x75) {	// 32MB
			MAL_Capacity = 64000;
		}
		else if (CardID == 0x76) {	// 64MB
			MAL_Capacity = 128000;
			SMC_Addr_Bytes = 4;
			SMC_Lookup_nCache0 = 4;
		}
		else if (CardID == 0x79) {	// 128MB
			MAL_Capacity = 256000;
			SMC_Addr_Bytes = 4;
			SMC_Lookup_nCache0 = 5;
		}
		else
			return MAL_CARD_UNKNOWN;
	}

	DTC_SMC_Address_bytes = SMC_Addr_Bytes;
	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
static void SMC_INC_Logical_Addr(void)
{
	SMC_Laddr++;
	if (SMC_Laddr >= 1000) {
		SMC_Zone++;
		SMC_Laddr -= 1000;
	}
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_Get_Logical_Addr(void)
{
	unsigned short EndBlock;

	SMC_Zone = 0;
	if (SMC_Cluster_Size == 32) {
		asm {
			LD		A, MAL_Block_Address:3
			LD		X, MAL_Block_Address:2
			LD		Y, MAL_Block_Address:1
			SRL		Y
			RRC		X
			RRC		A	; 1st shift
			SRL		Y
			RRC		X
			RRC		A	; 2nd shift
			SRL		Y
			RRC		X
			RRC		A	; 3rd shift
			SRL		Y
			RRC		X
			RRC		A	; 4th shift
			SRL		Y
			RRC		X
			RRC		A	; 5th shift
			LD		SMC_Laddr:1, A
			LD		SMC_Laddr, X
		}	// The C line below costs too much
	//	SMC_Laddr = (unsigned int)(MAL_Block_Address >> 5);

		while (SMC_Laddr >= 1000) {
			SMC_Zone++;
			SMC_Laddr -= 1000;
		}
		SMC_Ppage = (unsigned char)MAL_Block_Address & 0x001F;
	}
	else {
		asm {
			LD		A, MAL_Block_Address:3
			LD		X, MAL_Block_Address:2
			LD		Y, MAL_Block_Address:1
			SRL		Y
			RRC		X
			RRC		A	; 1st shift
			SRL		Y
			RRC		X
			RRC		A	; 2nd shift
			SRL		Y
			RRC		X
			RRC		A	; 3rd shift
			SRL		Y
			RRC		X
			RRC		A	; 4th shift
			LD		SMC_Laddr:1, A
			LD		SMC_Laddr, X
		}	// The C line below costs too much
	//	SMC_Laddr = (unsigned int)(MAL_Block_Address >> 4);
		SMC_Ppage = (unsigned char)MAL_Block_Address & 0x000F;
	}

	if (SMC_Lookup_nCache0 == 0)	// Card < 64MB
		return;					// No cache management needed

	asm {
		LD		A, MAL_Block_Numbers:1
		LD		X, MAL_Block_Numbers
		ADD		A, SMC_Ppage
		JRNC	sub_1
		INC		X
sub_1:	SUB		A, #1
		JRNC	shift5
		DEC		X
shift5:
		SRL		X
		RRC		A		; 1st shift
		SRL		X
		RRC		A		; 2nd shift
		SRL		X
		RRC		A		; 3rd shift
		SRL		X
		RRC		A		; 4th shift
		SRL		X
		RRC		A		; 5th shift
		ADD		A, SMC_Laddr:1
		LD		EndBlock:1, A
		LD		A, X
		ADC		A, SMC_Laddr
		LD		EndBlock, A
	}	// The following C line costs too much
//	EndBlock = SMC_Laddr + ((SMC_Ppage + MAL_Block_Numbers - 1) >> 5);
	if (EndBlock >= 1000) {		// The access will cross the zone boundary
		unsigned char ZoneNext;

		ZoneNext = SMC_Zone + 1;
		if (SMC_Zone == SMC_Lookup_Zone0) {		// current zone hits table0
			if (ZoneNext == SMC_Lookup_Zone1)
				return;

			SMC_Lookup_Update1(ZoneNext);		// update lookup tabke 1 for ZoneNext
		}
		else if (SMC_Zone == SMC_Lookup_Zone1) {// current zone hits table1
			if (ZoneNext == SMC_Lookup_Zone0)
				return;

			SMC_Lookup_Update0(ZoneNext);		// update lookup table 0 for ZoneNext
		}
		else if (ZoneNext == SMC_Lookup_Zone0)	// next zone hits table0
			SMC_Lookup_Update1(SMC_Zone);		// update lookup table 1 for SMC_Zone
		else if (ZoneNext == SMC_Lookup_Zone1)	// next zone hits table1
			SMC_Lookup_Update0(SMC_Zone);		// updata lookup table 0 for SMC_Zone
		else {
			SMC_Lookup_Update0(SMC_Zone);		// updata lookup table 0 for SMC_Zone
			SMC_Lookup_Update1(ZoneNext);		// updata lookup table 1 for ZoneNext
		}
	}
	else {		// The access will not cross the zone boundary
		if (SMC_Zone == SMC_Lookup_Zone0 || SMC_Zone == SMC_Lookup_Zone1)
			return;

#ifdef USE_CACHE0
		if (SMC_Zone == 0 && SMC_Laddr < SMC_Lookup_nCache0) {	// Hit on cache of zone0
			if (EndBlock < SMC_Lookup_nCache0)
				return;
		}
#endif
		// Going to make the lookup table for the new zone
		if (SMC_Lookup_Count0 < SMC_Lookup_Count1)
			SMC_Lookup_Update0(SMC_Zone);
		else
			SMC_Lookup_Update1(SMC_Zone);
	}
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Launch the DTC again for reading
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_Read_Interrupt()
{
	_MAL_INC_Block_Param(SMC_Npage);
//	MAL_Block_Numbers -= SMC_Npage;
//	MAL_Block_Address += SMC_Npage;
	if (DTC_Error) {
		_MAL_DEC_Block_Param(malNpage);
	//	MAL_Block_Numbers += malNpage;
	//	MAL_Block_Address -= malNpage;

		MAL_Error = MAL_RD_ERR;
		MAL_Finish(FALSE);

		DTC_Current_Func = 0;
		return;
	}
	if (MAL_Block_Numbers == 0) {
		MAL_Error = MAL_GOOD;
		MAL_Finish(TRUE);

		DTC_Current_Func = 0;
		return;
	}

	// If the previous DTC was reading odd number of pages
	// Clear the buffer manager flags and start from buffer0
	if (SMC_Npage & 1) {
		while (BUFSR & 0x06);		// Wait both buffer are empty
		BUFSR = 0x01;				// Clear Buffer status
		BUFSR = 0;
	}

	// Launch the next burst reading
	SMC_INC_Logical_Addr();

	if (SMC_Cluster_Size > MAL_Block_Numbers)
		malNpage = (unsigned char)MAL_Block_Numbers;
	else
		malNpage = SMC_Cluster_Size;

	_MAL_BufMgr_Upload();		// Switch to UPLOAD mode

	SMC_Npage = malNpage;
	DTC_Current_Func = DTC_SMC_READ;
	if (SMC_Log2Phy() == FALSE) {
// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
		// When the specified location does not exist
		// Have to return all 0xFF in the data block.
		DTC_Read_FF();
		return;
	}

	if (SMC_Paddr & 0x0F) {			// This is a bad cluster
		MAL_Error = MAL_BAD_MEDIUM;	// Too many bad clusters
		MAL_Finish(FALSE);

		DTC_Current_Func = 0;
		return;
	}

//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, SMC_Npage);
//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
	SMC_Paddr_To_DTC_Addr();
	DTC_SMC_Read_USB( /* malPaddr, malNpage */ );
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	MAL_SMC_Read
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char SMC_Read(void)
{
	DTC_SMC_Address_bytes = SMC_Addr_Bytes;
	
// Get the logical cluster address
	SMC_Get_Logical_Addr();		// SMC_Zone:SMC_Laddr:SMC_Ppage = MAL_Block_Address
	MAL_Block_Finish = 0;

	malNpage = SMC_Cluster_Size - SMC_Ppage;
	if (malNpage > MAL_Block_Numbers)
		malNpage = (unsigned char)MAL_Block_Numbers;

	SMC_Npage = malNpage;
	DTC_Current_Func = DTC_SMC_READ;

	_MAL_BufMgr_Upload();		// Switch to UPLOAD mode

// Get the physical cluster address
	if (SMC_Log2Phy() == FALSE) {
		// When the specified location does not exist
		// Have to return all 0xFF in the data block.
		DTC_Read_FF();
		return MAL_GOOD;
	}

	if (SMC_Paddr & 0x0F) {			// This is a bad cluster
		MAL_Error = MAL_BAD_MEDIUM;	// Too many bad clusters
		MAL_Finish(FALSE);

		DTC_Current_Func = 0;
		return MAL_Error;
	}

//	Launch the DTC to copy the first data cluster
//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, SMC_Ppage);
	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, SMC_Ppage);
	DTC_SMC_Read_USB( /* malPaddr, malNpage */ );

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	MAL_Write();	MAL_Write();	MAL_Write();	MAL_Write();
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Launch the DTC again for writing
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_Write_Interrupt()
{
Label_SMC_Write_Interrupt:
			// Some DTC routine is expected to finish with interrupt,
			// but it returns when it finishes.
			// This label is used to simulate the re-enter as interrupt.
#if	ALLOW_ERROR
	if (SMC_Wstate & SMC_ERROR_FLAG) {
		SMC_Wstate &= ~SMC_ERROR_FLAG;

		// Mark the cluster of malRaddr as a bad cluster
		DTC_SMC_Mark_Bad(malRaddr & ~((SMC_Cluster_Size == 32)?0x1F:0x0F) );
	}
#endif

	if (SMC_Wstate & SMC_WRITE_FLAG) {
		if (DTC_Error)
			SMC_Npage -= malNpage;
		_MAL_INC_Block_Param(SMC_Npage);
	}

	DTC_Current_Func = DTC_SMC_WRITE;

	switch (SMC_Wstate) {
	case SMC_PREMARK:		// 0
	case SMC_PRECOPY:		// 1
	case SMC_PREHOLEMARK:	// 8 Never use
	case SMC_PREHOLECOPY:	// 9 Never use
#if	ALLOW_ERROR
		if (DTC_Error) {
			// Mark the cluster of malPaddr as a bad cluster
			DTC_SMC_Mark_Bad(malPaddr & ~((SMC_Cluster_Size == 32)?0x1F:0x0F) );
			SMC_Lookup_Map_Bad();

		//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
		//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
			SMC_Paddr_To_DTC_Addr();
			malNpage = SMC_Ppage;

			_MAL_BufMgr_Normal();
			if (SMC_Wstate & SMC_OLD_CLUSTER) {
				// This is a old logical cluster
				// Launch the DTC to copy several pages
				// Copy malNpage pages from malRaddr to malPaddr
				malRaddr &= ~((SMC_Cluster_Size == 32)? 0x1F : 0x0F);	// start from page 0
				DTC_SMC_Copy_Pages();
				// Now SMC_Wstate == SMC_PRECOPY
			}
			else {
				// This is a new logical cluster
				// Launch the DTC to mark several pages
				DTC_SMC_Mark_Pages();		// Mark the starting pages
				// Now SMC_Wstate == SMC_PREMARK

			}

			// Mask off these 2 lines if DTC interrupts
			DTC_Error = 0;
			goto Label_SMC_Write_Interrupt;

			return;
		}
#endif

		malNpage = SMC_Cluster_Size - SMC_Npage;
		if (malNpage > MAL_Block_Numbers) {
			malNpage = (unsigned char)MAL_Block_Numbers;
			SMC_Wstate |= SMC_HOLE_ACTION;
		}
		SMC_Npage = malNpage;

		// Launch DTC to write several pages;
		SMC_Wstate |= SMC_WRITE_FLAG;
		_MAL_BufMgr_Download();
		DTC_SMC_Write_USB(0);

		// Now SMC_Wstate = SMC_PRENEWWRITE or SMC_PREOLDWRITE or
		//     SMC_Wstate = SMC_HOLENEWWRITE or SMC_HOLEOLDWRITE
		return;

	case SMC_POSTNEWWRITE:	// 6
	case SMC_POSTOLDWRITE:	// 7
#if	ALLOW_ERROR
		if (DTC_Error) {
			malRaddr = malPaddr & ~((SMC_Cluster_Size == 32)? 0x1F : 0x0F);
			SMC_Lookup_Map_Bad();

			SMC_Wstate &= ~(SMC_FULL_ACTION | SMC_WRITE_FLAG);
			SMC_Wstate |= SMC_ERROR_FLAG;		// ready to mark malRaddr as bad

			malNpage = SMC_Npage;
			SMC_Ppage = SMC_Npage;				// next time writing start here
		//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
		//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
			SMC_Paddr_To_DTC_Addr();

			_MAL_BufMgr_Normal();
			DTC_SMC_Copy_Pages();

			// Mask off these 2 lines if DTC interrupts
			DTC_Error = 0;
			goto Label_SMC_Write_Interrupt;

			return;
			// Now SMC_Wstate = SMC_PREMARK or SMC_PRECOPY;
		}
#endif

		// All data from USB has been written. MAL_Block_Numbers must be 0

		malNpage = (unsigned char)(SMC_Cluster_Size - SMC_Npage);
		SMC_Ppage = SMC_Npage;
		SMC_Wstate &= ~SMC_WRITE_FLAG;		// Clear WRITE flag

Post_Mark_Copy:
		SMC_Npage = malNpage;
		if (SMC_Wstate & SMC_OLD_CLUSTER) {
			// This was an overwrite operation, copy the remain pages
		//	malRaddr = Map_DTC_Addr(SMC_Zone, SMC_Raddr, SMC_Ppage);
			Map_To_DTC_Addr(malRaddr, SMC_Zone, SMC_Raddr, SMC_Ppage);

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			_MAL_BufMgr_Normal();
			DTC_SMC_Copy_Pages();

			// Now SMC_Wstate = SMC_POSTCOPY;
		}
		else {
			// This was a new cluster operation, mark the remain pages

			// Launch the DTC to several several pages start from malPaddr
			DTC_SMC_Mark_Pages();

			// Now SMC_Wstate = SMC_POSTMARK;

		}
		// Mask off this line if DTC interrupts
		goto Label_SMC_Write_Interrupt;
		return;

	case SMC_HOLENEWWRITE:	// A
	case SMC_HOLEOLDWRITE:	// B
#if	ALLOW_ERROR
		if (DTC_Error) {
			malRaddr = malPaddr & ~((SMC_Cluster_Size == 32)? 0x1F : 0x0F);
			SMC_Lookup_Map_Bad();

			SMC_Wstate &= ~(SMC_FULL_ACTION | SMC_WRITE_FLAG);
			SMC_Wstate |= SMC_ERROR_FLAG;		// ready to mark malRaddr as bad

			malNpage = SMC_Ppage + SMC_Npage;
			SMC_Ppage += SMC_Npage - malNpage;	// next time writing start here
		//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
		//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
			SMC_Paddr_To_DTC_Addr();
			_MAL_BufMgr_Normal();
			DTC_SMC_Copy_Pages();

			// Mask off these 2 lines if DTC interrupts
			DTC_Error = 0;
			goto Label_SMC_Write_Interrupt;

			return;
			// Now SMC_Wstate = SMC_PREMARK or SMC_PRECOPY;
		}
#endif

		SMC_Ppage += SMC_Npage;
		SMC_Wstate = (SMC_Wstate & SMC_OLD_CLUSTER) | SMC_POST_ACTION;	// Keep OLD flag
		malNpage = SMC_Cluster_Size - SMC_Ppage;	// Pages left to be marked or copied

		goto Post_Mark_Copy;	// The following actions are same as above
	/*
		if (SMC_Wstate & SMC_OLD_CLUSTER) {
			// This was an overwrite operation, copy the remain pages
			malRaddr = Map_DTC_Addr(SMC_Zone, SMC_Raddr, SMC_Ppage);
			SMC_Ppage = malNpage;

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			SMC_Wstate = SMC_POSTCOPY;	// same as SMC_POSTHOLECOPY
			DTC_SMC_Copy_Pages(malRaddr, SMC_Laddr);
		}
		else {
			// This was a new cluster operation, mark the remain pages
			SMC_Ppage = malNpage;

			// Launch the DTC to several several pages start from malPaddr
			SMC_Wstate = SMC_POSTMARK;	// same as SMC_POSTHOLEMARK
			DTC_SMC_Mark_Pages(SMC_Laddr);
		}
		return;
	*/

	case SMC_POSTMARK:		// 4
	case SMC_POSTCOPY:		// 5
	case SMC_POSTHOLEMARK:	// C
	case SMC_POSTHOLECOPY:	// D
	/*	// These four cases always have the MAL_Block_Numbers == 0
		if (SMC_Wstate & SMC_OLD_CLUSTER)
			DTC_SMC_Erase(SMC_Raddr);	// Erase the dirty cluster
		SMC_Update_Lookup();

		// All data from the USB has been written to the SMC
		MAL_Error = MAL_GOOD;
		MAL_Finish(TRUE);

		DTC_Current_Func = 0;
		return;
	*/
	case SMC_PRENEWWRITE:	// 2
	case SMC_PREOLDWRITE:	// 3
	case SMC_FULLNEWWRITE:	// E
	case SMC_FULLOLDWRITE:	// F
#if	ALLOW_ERROR
		if (DTC_Error) {
			malRaddr = malPaddr & ~((SMC_Cluster_Size)? 0x1F : 0x0F);
			SMC_Lookup_Map_Bad();

			SMC_Wstate &= ~(SMC_FULL_ACTION | SMC_WRITE_FLAG);
			SMC_Wstate |= SMC_ERROR_FLAG;		// ready to mark malRaddr as bad

			SMC_Npage = malNpage = SMC_Cluster_Size - malNpage;
			SMC_Ppage = SMC_Npage;
		//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
		//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
			SMC_Paddr_To_DTC_Addr();
			_MAL_BufMgr_Normal();
			DTC_SMC_Copy_Pages();

			// Mask off these 2 lines if DTC interrupts
			DTC_Error = 0;
			goto Label_SMC_Write_Interrupt;

			return;
			// Now SMC_Wstate = SMC_PREMARK or SMC_PRECOPY;
		}
#endif

		// Now we have finished one cluster
		SMC_Update_Lookup();

		if (MAL_Block_Numbers == 0) {
			// All data from the USB has been written to the SMC
			MAL_Error = MAL_GOOD;
			MAL_Finish(TRUE);

			DTC_Current_Func = 0;
			return;
		}

#if ALLOW_OUT_RANGE
		if (Mal_Addr_Out_Range & 0x02) {
			SMC_Wstate = SMC_OUT_RANGE;
			goto Write_Out_Range;
		}
#endif
		// Further more data to be written to the media
		SMC_INC_Logical_Addr();

		SMC_Wstate = SMC_FULL_ACTION | SMC_WRITE_FLAG;
		if (SMC_Log2Phy()) {
			// This is an existing cluster
			SMC_Wstate |= SMC_OLD_CLUSTER;
			SMC_Raddr = SMC_Paddr;			// old cluster
			SMC_Paddr = SMC_Get_Free();		// new cluster
		}
		SMC_Paddr &= 0x7FFF;
		SMC_Ppage = 0;

		// the next writing must start from beginning of the cluster
		malNpage = SMC_Cluster_Size;
		if (malNpage > MAL_Block_Numbers) {
			SMC_Wstate &= ~0x08;		// change from SMC_FULL_ACTION to SMC_POST_ACTION
			malNpage = (unsigned char)MAL_Block_Numbers;
		}
	//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
		SMC_Npage = malNpage;
	//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
		SMC_Paddr_To_DTC_Addr();

		// Launch DTC to write malPpage pages to malPaddr
		_MAL_BufMgr_Download();
		DTC_SMC_Write_USB(MAL_Block_Finish & 1);

		// Now SMC_Wstate = SMC_POSTNEWWRITE or SMC_POSTOLDWRITE or
		//	   SMC_Wstate = SMC_FULLNEWWRITE or SMC_FULLOLDWRITE
		return;

#if ALLOW_OUT_RANGE
	case SMC_OUT_RANGE:
		if (MAL_Block_Numbers == 0) {
			// All data from the USB has been written to the SMC
			MAL_Error = MAL_GOOD;
			MAL_Finish(TRUE);

			DTC_Current_Func = 0;
			return;
		}

Write_Out_Range:
	// assume MAL_Block_Numbers < 256
	//	malNpage = SMC_Cluster_Size;
	//	if (malNpage > MAL_Block_Numbers)
	//		malNpage = (unsigned char)MAL_Block_Numbers;
		SMC_Npage = malNpage = (unsigned char)MAL_Block_Numbers;
		DTC_SMC_Dummy_Write(MAL_Block_Finish & 1);
		return;
#endif
	}

}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	MAL_SMC_Write
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char SMC_Write(void)
{
	DTC_SMC_Address_bytes = SMC_Addr_Bytes;

// Get the logical cluster address
	SMC_Get_Logical_Addr();		// SMC_Zone:SMC_Laddr:SMC_Ppage = MAL_Block_Address
	MAL_Block_Finish = 0;

#if ALLOW_OUT_RANGE
	if (Mal_Addr_Out_Range & 0x03) {
		DTC_Current_Func = DTC_SMC_WRITE;

		SMC_Wstate = SMC_OUT_RANGE;
	// assume MAL_Block_Numbers < 256
	//	malNpage = SMC_Cluster_Size - SMC_Ppage;
	//	if (malNpage > MAL_Block_Numbers)
	//		malNpage = (unsigned char)MAL_Block_Numbers;
		SMC_Npage = malNpage = (unsigned char)MAL_Block_Numbers;

		_MAL_BufMgr_Download();		// Switch to DOWNLOAD mode
		DTC_SMC_Dummy_Write(0);
		return MAL_GOOD;
	}
#endif

// Get the physical cluster address
	SMC_Wstate = 0;			// PRE actions, NEW cluster, no WRITE
	if (SMC_Log2Phy()) {
		// This is an existing cluster
		SMC_Wstate |= SMC_OLD_CLUSTER;	// PRECOPY may be necessary
		SMC_Raddr = SMC_Paddr;			// old cluster
		SMC_Paddr = SMC_Get_Free();		// new cluster
	}
	SMC_Paddr &= 0x7FFF;

//	malPaddr = Map_DTC_Addr(SMC_Zone, SMC_Paddr, 0);
//	Map_To_DTC_Addr(malPaddr, SMC_Zone, SMC_Paddr, 0);
	SMC_Paddr_To_DTC_Addr();
	DTC_Current_Func = DTC_SMC_WRITE;
	if (SMC_Ppage) {
		// the new pages are not start from beginning of the cluster 
		SMC_Npage = malNpage = SMC_Ppage;

		_MAL_BufMgr_Normal();		// switch back to normal mode first
		if (SMC_Wstate & SMC_OLD_CLUSTER) {
			// This is a old logical cluster
		//	malRaddr = Map_DTC_Addr(SMC_Zone, SMC_Raddr, 0);
			Map_To_DTC_Addr(malRaddr, SMC_Zone, SMC_Raddr, 0);

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			DTC_SMC_Copy_Pages();

			// Now SMC_Wstate == SMC_PRECOPY
		}
		else {
			// This is a new logical cluster

			// Launch the DTC to mark several pages
			DTC_SMC_Mark_Pages();		// Mark the starting pages

			// Now SMC_Wstate == SMC_PREMARK

		}

		// Mask off this line if DTC interrupts
		DTC_Error = 0;
		SMC_Write_Interrupt();
	}
	else {
		// the new pages are start from beginning of the cluster
		malNpage = SMC_Cluster_Size;
		if (malNpage > MAL_Block_Numbers) {
			// Do not write the whole cluster
			malNpage = (unsigned char)MAL_Block_Numbers;
			SMC_Wstate |= SMC_POST_ACTION | SMC_WRITE_FLAG;
		}
		else
			SMC_Wstate |= SMC_FULL_ACTION | SMC_WRITE_FLAG;

		SMC_Npage = malNpage;

		// Launch DTC to write malPpage pages to malPaddr
		_MAL_BufMgr_Download();		// Switch to DOWNLOAD mode
		DTC_SMC_Write_USB(0);

		// Now SMC_Wstate = SMC_POSTNEWWRITE or SMC_POSTOLDWRITE
		//     SMC_Wstate = SMC_FULLNEWWRITE or SMC_FULLOLDWRITE
	}

	return MAL_GOOD;
}

unsigned char SMC_Init()
{
	unsigned char MAL_Status;

	DTC_SMC_Init();

	MAL_Status = SMC_Read_Capacity();
	if (MAL_Status != MAL_GOOD)
		return MAL_Status;

	SMC_Lookup_Zone0 = SMC_Lookup_Zone1 = -1;	// There is no zone in both table
	SMC_Lookup_Update0(0);
	if (MAL_Capacity >= 32768) {
		// Scan the 2nd zone
		SMC_Lookup_Update1(1);
	}

#ifdef	FORCE_ERASE
	SMC_Format();
	while(1);
#endif

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Variables and functions for SMC formation
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char SMC_Format_State;
#define	STEP_CHECK		0x01
#define STEP_PRE_ERASE	0x02
#define STEP_WRITE		0x03
#define STEP_READ		0x04
#define STEP_POST_ERASE	0x05

//#define FORCE_ERASE
void SMC_Format_Interrupt()
{
Formation_loop:
// Here I need to refresh a timer to ensure that the DTC formatting does not deadlocked

	DTC_Current_Func = DTC_SMC_FORMAT;
	switch (SMC_Format_State) {
	case STEP_CHECK:
		if (DTC_SMC_Format_Chk() & 0x02) {
			asm nop;
#ifndef	FORCE_ERASE
			break;
#endif
		}
		SMC_Format_State++;	// going to move to STEP_PRE_ERASE
		DTC_SMC_Format_Erase();
		return;
	case STEP_PRE_ERASE:
		if (DTC_Error & 0x02)
			goto mark_bad_cluster;
		SMC_Format_State++;	// going to move to STEP_WRITE
		DTC_SMC_Format_Write();
		return;
	case STEP_WRITE:
		if (DTC_Error & 0x02)
			goto mark_bad_cluster;
		SMC_Format_State++;	// going to move to STEP_READ
		DTC_SMC_Format_Read();
		return;
	case STEP_READ:
		if (DTC_Error & 0x02)
			goto mark_bad_cluster;
		SMC_Format_State++;	// going to move to STEP_POST_ERASE
		DTC_SMC_Format_Erase();
		return;
	case STEP_POST_ERASE:
		if (DTC_Error & 0x02) {
mark_bad_cluster:
			DTC_SMC_Mark_Bad(malPaddr);

			malNpage = SMC_Cluster_Size;	// Pages in a cluster
			break;
		}

	}

format_next_cluster:
	MAL_Block_Numbers--;
	if (MAL_Block_Numbers == 0) {		// all clusters have been formated
		SMC_Format_State = 0;
		MAL_State = MAL_IDLE;
		DTC_Current_Func = 0;
		SMC_Init();
		return;
	}

	malPaddr += SMC_Cluster_Size;	// move to the next cluster
	SMC_Format_State = STEP_CHECK;
	goto Formation_loop;
}

unsigned char SMC_Format()
{
	unsigned char	CardID;

	// Know the card capacity
	CardID = DTC_SMC_ReadID();

	// MAL_Block_Numbers is used as number of blocks in the medium
	SMC_Cluster_Size = 16;
	if (CardID == 0xE3 || CardID == 0xE5)
		MAL_Block_Numbers = 0x200;		// 4MB
	else if (CardID == 0xE6)
		MAL_Block_Numbers = 0x400;		// 8MB
	else {
		SMC_Cluster_Size <<= 1;
		MAL_Block_Numbers = 0x400;
#define hMAL_Block_Numbers *((unsigned char *)&MAL_Block_Numbers)
		switch (CardID) {
		case 0x79:		// 128MB
			hMAL_Block_Numbers <<= 1;
		case 0x76:		// 64MB
			hMAL_Block_Numbers <<= 1;
		case 0x75:		// 32MB
			hMAL_Block_Numbers <<= 1;
		case 0x73:		// 16MB
			break;
		default:
			return MAL_CARD_UNKNOWN;
		}
	}

	MAL_Capacity = MAL_Block_Numbers;	// Number of clusters in the media
	if (MAL_Block_Numbers <= 2048)
		DTC_SMC_Address_bytes = 3;		// Less than 32MB
	else
		DTC_SMC_Address_bytes = 4;		// 64MB & 128MB

	malPaddr = 0;
	malNpage = SMC_Cluster_Size;	// Pages in a cluster
	SMC_Format_State = STEP_CHECK;

	// SMC_Format_Interrupt(1);	// I can not start with this,
								// because the compiler will treat the routine as non-interrupt
								// so that the variables will be allocated overlapped
	DTC_Current_Func = DTC_SMC_FORMAT;
	DTC_SMC_Format_Start();		// Use this way to start the procedure, it will generate an interrupt

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Interrupt from DTC stop
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void SMC_DTC_Int()
{
	DTC_Error = DTCSTATUS & 0x03;

	if (DTC_Current_Func == DTC_SMC_READ) {
		DTC_Current_Func = 0;

		malPaddr += malNpage - DTC_Page_Counter;
		malNpage = DTC_Page_Counter;
		if (DTC_Error == 0x01) {
			if (DTC_Page_Counter) {
				extern unsigned char SMC_ECC_Correct(char ECC_Buff_Nb);
				if (!SMC_ECC_Correct(DTC_Page_Counter))
					SMC_Read_Interrupt();	// Not correctable ECC error
				else {	// ECC correction is done
					DTC_SMC_Read_USB2();	// Lunch DTC to continue
					return;
				}
			}
			DTC_Error = 0;
			SMC_Read_Interrupt();
		}
		else		// DTC_Error == 2 || DTC_Error == 3
			SMC_Read_Interrupt();
		return;
	}
	else if (DTC_Current_Func == DTC_SMC_WRITE) {
		DTC_Current_Func = 0;
		DTC_Error--;
		if (DTC_Error == 0) {
			malPaddr += malNpage;
			malNpage = 0;
			SMC_Write_Interrupt();
			return;
		}
		// DTC_Error == 2 || DTC_Error == 3
		malPaddr += 4;	// Page where the error happen
		malNpage = 4;	// Pages left to read
		SMC_Write_Interrupt();
		return;
	}
	else if (DTC_Current_Func == DTC_SMC_FORMAT) {
		DTC_Current_Func = 0;
		SMC_Format_Interrupt();
	}
}

unsigned char SMC_Verify(void)
{
	return MAL_GOOD;
}

unsigned char SMC_Check_Write_Protect()
{
	return 0;
}

void SMC_Break()
{	
	DESELECT();		// Chip deselect
	if (MAL_State != MAL_IDLE) {
		// Stop the DTC execution despite its state
		Stop_DTC();		
		MAL_Finish(FALSE);
		MAL_State = MAL_IDLE;
		DTC_Current_Func = 0;
	}
}

#pragma NO_RETURN
void MAL_SMC_Funcs(void)
{
	// IMPORTANT: The sequence of this jump table can not be changed
	// New line can be appended at the end of the table
	asm {
		jp	SMC_Init				// 0
		jp	SMC_Read				// 1
		jp	SMC_Write				// 2
		jp	SMC_Verify				// 3
		jp	SMC_Format				// 4
		jp	SMC_Read_Capacity		// 5
		jp	SMC_Check_Write_Protect	// 6
		jp	SMC_Break				// 7
//		jp	SMC_DTC_Int				// 8
	}
}
