/**************** (c) 2001  STMicroelectronics **********************

PROJECT : ST7265 USB Mass Storage - SMC

VERSION :  V1.0 Beta2

CREATION DATE :  20/03/2001

AUTHOR : MICROCONTROLLER DIVISION / Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : DTC programs for SMC

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_USB_Mass_Upld[]= {
#include "smc_dtc_upload_end.hex"
};	  // SMC_DTC_USB_Mass_Upld

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_USB_Mass_Dwld[]= {
#include "smc_dtc_download_end.hex"
};	  // SMC_DTC_USB_Mass_Dwld

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Play[]= {
#include "SMC_DTC_Play_End.hex"
};	  // SMC_DTC_Play

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Map_Zone[]= {
#include "smc_dtc_mapzone_end.hex"
};	  // SMC_DTC_Map_Zone

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Format[] = {
#include "smc_dtc_format_end.hex"
};	// SMC_DTC_Format

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Code0[]= {
#include "smc_dtc_code0_end.hex"
};	  // SMC_DTC_Code0

/*
#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Map_Range[] = {	// For playback
#include "smc_dtc_maprange_end.hex"
};

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Play_Read[] = {	// For playback
#include "smc_dtc_play_read_end.hex"
};
*/

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Copy_Pages[]= {
 //----------------------
 // dtc_smc_copy_page.fsm
 //----------------------
  
 //--------------------------
 //init_write_number_of_block
 //--------------------------
  
 0xa0,   //   0 LD MSB 0
 0xb1,   //   1 LD LSB 1
 0x81,   //   2 LD X // X<=1
  
 //-----------------
 //init_dtc_ctrl_reg
 //-----------------
  
 0xa1,   //   3 LD MSB 1 // data_flash port = output   
 0xb9,   //   4 LD LSB 9 // DATA_FLASH Port driven by FCI 
 0x8d,   //   5 LD CTRL_FCI // PARALLEL Port driven by FCI
  
 //-------------------------------
 //command_latch_cycle (Read1 CMD)
 //-------------------------------
  
 0xa0,   //   6 LD MSB 0
 0xb0,   //   7 LD LSB 0
 0x8c,   //   8 LD DATA_FLASH
  
 0xa0,   //   9 LD MSB 0
 0xba,   //   a LD LSB 10
 0x90,   //   b LD DR_PARALLEL
 0xbb,   //   c LD LSB 11
 0x90,   //   d LD DR_PARALLEL
 0xb9,   //   e LD LSB 9
 0x90,   //   f LD DR_PARALLEL
 0xbb,   //  10 LD LSB 11
 0x90,   //  11 LD DR_PARALLEL
 0xba,   //  12 LD LSB 10
 0x90,   //  13 LD DR_PARALLEL
  
 //-------------------------
 // read_address_latch_cycle
 //-------------------------
  
 //read_address_latch_cycle_nb_Bytes
 //---------------------------------
  
 0xa0,   //  14 LD MSB 0
 0xb0,   //  15 LD LSB 0
 0x85,   //  16 LD ADR_BUFFER01		// buffer 0 address ( 15..8 )
  
 0xae,   //  17 LD MSB 14
 0xb6,   //  18 LD LSB 06
 0x84,   //  19 LD ADR_BUFFER00		// buffer 0 address ( 0..7 )
  
 0xdb,   //  1a LD A DATA_BUFFER0
 0x82,   //  1b LD Y
  
 0xae,   //  1c LD MSB 14
 0xb2,   //  1d LD LSB 02
 0x84,   //  1e LD ADR_BUFFER00
  
 0xa0,   //  1f LD MSB 0
 0xba,   //  20 LD LSB 10
 0x90,   //  21 LD DR_PARALLEL
  
 0xbe,   //  22 LD LSB 14
 0x90,   //  23 LD DR_PARALLEL
  
 // read_loop_send_address
 // -----------------
 // :read_loop_send_address
  
 0xdb,   //  24 LD A DATA_BUFFER0
 0x8c,   //  25 LD DATA_FLASH
  
 0xa0,   //  26 LD MSB 0
 0xbc,   //  27 LD LSB 12
 0x90,   //  28 LD DR_PARALLEL
  
 0xbe,   //  29 LD LSB 14
 0x90,   //  2a LD DR_PARALLEL
  
 0x27,   //  2b ADDER16 ADR_BUFFER0
  
 0x3c,   //  2c DECY
 0xc2,   //  2d LD A Y
 0x8,   //  2e CP A=>X
 // JP :read_loop_send_address
 0x6b,   //  2f JP  -11
  
 0xba,   //  30 LD LSB 10
 0x90,   //  31 LD DR_PARALLEL
  
 //---------------------
 //wait_read1_addr_ready
 //---------------------
  
 //init_timeout
 //------------
 0xb0,   //  32 LD LSB 00
 0x85,   //  33 LD ADR_BUFFER01		// buffer 0 address ( 8..15 )
 0x84,   //  34 LD ADR_BUFFER00		// buffer 0 address ( 0..7 )
 0x88,   //  35 LD CMP00
 0xaf,   //  36 LD MSB 15
 0x89,   //  37 LD CMP01
  
 // :wait_read1_addr_ready
 //---------------------
 0x27,   //  38 ADDER16 ADR_BUFFER0
 0xd,   //  39 CP ADR_BUFFER0<CMP0
 // JP :read1_addr_no_timeout
 0x42,   //  3a JP  2
 0x7,   //  3b STATUS STOP ERROR // timeout >20ms
  
 // :read1_addr_no_timeout
 //---------------------
 0xd0,   //  3c LD A DR_PARALLEL
 0x33,   //  3d EXCHANGE
 0x28,   //  3e BCLR1 //test R/B
 // JP :wait_read1_addr_ready
 0x67,   //  3f JP  -7
  
 // -------------------------------------------
 // START ADDRESS FOR read_dat 528 Bytes Buff 0
 // -------------------------------------------
  
 //init_read_dat_sec_reg
 //---------------------
  
 0xa2,   //  40 LD MSB 2	// DATA_FLASH port = intput 
 0xb9,   //  41 LD LSB 9 	// DATA_FLASH Port driven by FCI 
 0x8d,   //  42 LD CTRL_FCI 	// PARALLEL Port driven by FCI
  
 0xa0,   //  43 LD MSB 0
 0xb1,   //  44 LD LSB 1
 0x87,   //  45 LD ADR_BUFFER11 // buffer 1 address ( 15..8 )
  
 0xb0,   //  46 LD LSB 0
 0x86,   //  47 LD ADR_BUFFER10 // buffer 1 address ( 7..0 )
  
 0xb3,   //  48 LD LSB 3
 0x8b,   //  49 LD CMP11 // cmp1 value ( 15..8 )
  
 0xa1,   //  4a LD MSB 1
 0xb0,   //  4b LD LSB 0
 0x8a,   //  4c LD CMP10 // cmp1 value ( 7..0 )
  
 // read_dat_sec
 //-------------
 // :read_dat_sec
  
 0xa0,   //  4d LD MSB 0
 0xb2,   //  4e LD LSB 2
 0x90,   //  4f LD DR_PARALLEL
  
 0xba,   //  50 LD LSB 10
 0x90,   //  51 LD DR_PARALLEL
  
 0xcc,   //  52 LD A DATA_FLASH // load DATA_FLASH
 0x9c,   //  53 LD DATA_BUFFER1
  
 0x2f,   //  54 ADDER16 ADR_BUFFER1
 0xf,   //  55 CP ADR_BUFFER1<CMP1
 // JP :read_dat_sec
 0x69,   //  56 JP  -9
  
 //---------------------
 //wait_read_block_ready
 //---------------------
  
 //init_timeout
 //------------
 0xa0,   //  57 LD MSB 0
 0xb0,   //  58 LD LSB 00
 0x85,   //  59 LD ADR_BUFFER01		// buffer 0 address ( 8..15 )
 0x84,   //  5a LD ADR_BUFFER00		// buffer 0 address ( 0..7 )
 0x88,   //  5b LD CMP00
 0xaf,   //  5c LD MSB 15
 0x89,   //  5d LD CMP01
  
 // :wait_read_block_ready
 //---------------------
 0x27,   //  5e ADDER16 ADR_BUFFER0
 0xd,   //  5f CP ADR_BUFFER0<CMP0
 // JP :wait_read_block_no_timeout
 0x42,   //  60 JP  2
 0x7,   //  61 STATUS STOP ERROR // timeout >20ms
  
 // :wait_read_block_no_timeout
 //--------------------------
 0xd0,   //  62 LD A DR_PARALLEL
 0x33,   //  63 EXCHANGE
 0x28,   //  64 BCLR1 //test R/B
 // JP :wait_read_block_ready
 0x67,   //  65 JP  -7
  
 //-----------------
 //init_dtc_ctrl_reg
 //-----------------
  
 0xa1,   //  66 LD MSB 1 // data_flash port = output   
 0xb9,   //  67 LD LSB 9 // DATA_FLASH Port driven by FCI 
 0x8d,   //  68 LD CTRL_FCI // PARALLEL Port driven by FCI

  
 //-----------------------------
 //command_latch_cycle (SDI CMD)
 //-----------------------------
  
 0xa8,   //  69 LD MSB 8
 0xb0,   //  6a LD LSB 0
 0x8c,   //  6b LD DATA_FLASH
  
 0xa0,   //  6c LD MSB 0
 0xba,   //  6d LD LSB 10
 0x90,   //  6e LD DR_PARALLEL
 0xbb,   //  6f LD LSB 11
 0x90,   //  70 LD DR_PARALLEL
 0xb9,   //  71 LD LSB 9
 0x90,   //  72 LD DR_PARALLEL
 0xbb,   //  73 LD LSB 11
 0x90,   //  74 LD DR_PARALLEL
 0xba,   //  75 LD LSB 10
 0x90,   //  76 LD DR_PARALLEL
  
 //--------------------
 // address_latch_cycle
 //--------------------
  
 // :address_latch_cycle_nb_Bytes
 //----------------------------
  
 0xa0,   //  77 LD MSB 00
 0xb0,   //  78 LD LSB 00
 0x85,   //  79 LD ADR_BUFFER01		// buffer 0 address ( 8..15 )
  
 0xae,   //  7a LD MSB 14
 0xb6,   //  7b LD LSB 06
 0x84,   //  7c LD ADR_BUFFER00
  
 0xdb,   //  7d LD A DATA_BUFFER0
 0x82,   //  7e LD Y
  
 0xae,   //  7f LD MSB 14
 0xb7,   //  80 LD LSB 07
 0x84,   //  81 LD ADR_BUFFER00
  
 0xa0,   //  82 LD MSB 0
 0xba,   //  83 LD LSB 10
 0x90,   //  84 LD DR_PARALLEL
  
 0xbe,   //  85 LD LSB 14
 0x90,   //  86 LD DR_PARALLEL
  
 // loop_send_address
 // -----------------
 // :loop_send_address
  
 0xdb,   //  87 LD A DATA_BUFFER0
 0x8c,   //  88 LD DATA_FLASH
  
 0xa0,   //  89 LD MSB 0
 0xbc,   //  8a LD LSB 12
 0x90,   //  8b LD DR_PARALLEL
  
 0xbe,   //  8c LD LSB 14
 0x90,   //  8d LD DR_PARALLEL
  
 0x27,   //  8e ADDER16 ADR_BUFFER0
  
 0x3c,   //  8f DECY
 0xc2,   //  90 LD A Y
 0x8,   //  91 CP A=>X
 // JP :loop_send_address
 0x6b,   //  92 JP  -11
  
 0xba,   //  93 LD LSB 10
 0x90,   //  94 LD DR_PARALLEL
  
 // -------------------------
 // write_dat 512 Bytes Buff 0
 // -------------------------
  
 //init_write_dat_buff0
 //--------------------
  
 0xa0,   //  95 LD MSB 0
 0xb1,   //  96 LD LSB 1
 0x87,   //  97 LD ADR_BUFFER11 // buffer 1 address ( 15..8 )
  
 0xb0,   //  98 LD LSB 0
 0x86,   //  99 LD ADR_BUFFER10 // buffer 1 address ( 7..0 )
  
 // :write_dat_sec
 //-------------
  
 0xb8,   //  9a LD LSB 8
 0x90,   //  9b LD DR_PARALLEL
  
 0xdc,   //  9c LD A DATA_BUFFER1
 0x8c,   //  9d LD DATA_FLASH 
  
 0xa0,   //  9e LD MSB 0
 0xba,   //  9f LD LSB 10
 0x90,   //  a0 LD DR_PARALLEL
  
 0x2f,   //  a1 ADDER16 ADR_BUFFER1
 0xf,   //  a2 CP ADR_BUFFER1<CMP1
 // JP :write_dat_sec
 0x69,   //  a3 JP  -9
  
 //----------------------------
 // :Page_Pgm_command_latch_cycle
 //----------------------------
  
 0xa1,   //  a4 LD MSB 1
 0xb0,   //  a5 LD LSB 0
 0x8c,   //  a6 LD DATA_FLASH
  
 0xa0,   //  a7 LD MSB 0
 0xba,   //  a8 LD LSB 10
 0x90,   //  a9 LD DR_PARALLEL
 0xbb,   //  aa LD LSB 11
 0x90,   //  ab LD DR_PARALLEL
 0xb9,   //  ac LD LSB 9
 0x90,   //  ad LD DR_PARALLEL
 0xbb,   //  ae LD LSB 11
 0x90,   //  af LD DR_PARALLEL
 0xba,   //  b0 LD LSB 10
 0x90,   //  b1 LD DR_PARALLEL
  
 //---------------------------
 // read_status & check_status
 //---------------------------
  
 //wait_card_ready
 //---------------
  
 //init_timeout
 //------------
 0xb0,   //  b2 LD LSB 00
 0x85,   //  b3 LD ADR_BUFFER01
 0x84,   //  b4 LD ADR_BUFFER00
 0x88,   //  b5 LD CMP00
 0xaf,   //  b6 LD MSB 15
 0x89,   //  b7 LD CMP01
  
 // :wait_card_ready
 //---------------
 0x27,   //  b8 ADDER16 ADR_BUFFER0
 0xd,   //  b9 CP ADR_BUFFER0<CMP0
 // JP :no_timeout
 0x42,   //  ba JP  2
 0x7,   //  bb STATUS STOP ERROR // timeout 20ms
  
 // :no_timeout
 //----------
 0xd0,   //  bc LD A DR_PARALLEL
 0x33,   //  bd EXCHANGE
 0x28,   //  be BCLR1 //test R/B
 // JP :wait_card_ready
 0x67,   //  bf JP  -7
  
 // :read_status_command_latch_cycle
 //-------------------------------
  
 0xa7,   //  c0 LD MSB 7
 0xb0,   //  c1 LD LSB 0
 0x8c,   //  c2 LD DATA_FLASH
  
 0xa0,   //  c3 LD MSB 0
 0xba,   //  c4 LD LSB 10
 0x90,   //  c5 LD DR_PARALLEL
 0xbb,   //  c6 LD LSB 11
 0x90,   //  c7 LD DR_PARALLEL
 0xb9,   //  c8 LD LSB 9
 0x90,   //  c9 LD DR_PARALLEL
 0xbb,   //  ca LD LSB 11
 0x90,   //  cb LD DR_PARALLEL
 0xba,   //  cc LD LSB 10
 0x90,   //  cd LD DR_PARALLEL
  
 // :init_read_status_seq
 //---------------------
  
 0xa0,   //  ce LD MSB 0
 0xb9,   //  cf LD LSB 9 // DATA_FLASH Port driven by FCI  
 0x8d,   //  d0 LD CTRL_FCI // PARALLEL Port driven by FCI
  
 // :read_status_seq
 //----------------
  
 0xa0,   //  d1 LD MSB 0
 0xb2,   //  d2 LD LSB 2
 0x90,   //  d3 LD DR_PARALLEL
 0x0,   //  d4 NOP
 0xcc,   //  d5 LD A DATA_FLASH // load DATA_FLASH
  
 // : check_status
 //-------------
 0x33,   //  d6 EXCHANGE
 0x2a,   //  d7 BCLR3
 // JP :error_status
 0x45,   //  d8 JP  5
 0x2b,   //  d9 BCLR4
 // JP :error_status
 0x43,   //  da JP  3
 0x9,   //  db CP A<X
 // JP :no_error
 0x42,   //  dc JP  2
  
 // :error_status
 //------------
 0x5,   //  dd STATUS STOP
  
 // :no_error
 //--------
 0xa0,   //  de LD MSB 0
 0xba,   //  df LD LSB 10
 0x90,   //  e0 LD DR_PARALLEL
  
 //------------
 //end_of_block
 //------------
  
 //inc_addr
 //--------
  
 0xb0,   //  e1 LD LSB 0
 0xa0,   //  e2 LD MSB 0
 0x85,   //  e3 LD ADR_BUFFER01 // buffer 0 address ( 8..15 )
  
 0xae,   //  e4 LD MSB 14
 0xb3,   //  e5 LD LSB 03
 0x84,   //  e6 LD ADR_BUFFER00 // buffer 0 address ( 0..7 )
  
 0xdb,   //  e7 LD A DATA_BUFFER0
 0x2,   //  e8 CLC
 0x25,   //  e9 ADDER8 X
 0x9b,   //  ea LD DATA_BUFFER0
  
 0xae,   //  eb LD MSB 14
 0xb8,   //  ec LD LSB 08
 0x84,   //  ed LD ADR_BUFFER00 // buffer 0 address ( 0..7 )
  
 0xdb,   //  ee LD A DATA_BUFFER0
 0x2,   //  ef CLC
 0x25,   //  f0 ADDER8 X
 0x9b,   //  f1 LD DATA_BUFFER0
  
 0xbf,   //  f2 LD LSB 15
 0xaf,   //  f3 LD MSB 15
 0x84,   //  f4 LD ADR_BUFFER00 // buffer 0 address ( 7..0 )
  
 0xdb,   //  f5 LD A DATA_BUFFER0
 0x02,	// CLC
 0x24,   //  f6 SUB8 X
 0x9b,   //  f7 LD DATA_BUFFER0
  
 0x8,   //  f8 CP A=>X
 // JP :process_continue
 0x42,   //  f9 JP  2
 0x5,   //  fa STATUS STOP // end of process
  
 // :process_continue
  
 0xa0,   //  fb LD MSB 0
 0xb3,   //  fc LD LSB 3
 0xb,   //  fd CP ALWAYS
 0x60,   //  fe BRANCH
};	  // SMC_DTC_Copy_Pages

#pragma CONST_SEG SMC_DTC_CODE
const unsigned char SMC_DTC_Mark_Pages[]= {
 //----------------------
 // dtc_smc_copy_page.fsm
 //----------------------
  
 //--------------------------
 //init_write_number_of_block
 //--------------------------
  
 0xa0,   //   0 LD MSB 0
 0xb1,   //   1 LD LSB 1
 0x81,   //   2 LD X // X<=1
  
 //-----------------
 //init_dtc_ctrl_reg
 //-----------------
  
 0xa1,   //   3 LD MSB 1 // data_flash port = output   
 0xb9,   //   4 LD LSB 9 // DATA_FLASH Port driven by FCI 
 0x8d,   //   5 LD CTRL_FCI // PARALLEL Port driven by FCI
  
 //-------------------------------
 //command_latch_cycle (Read2 CMD)
 //-------------------------------
  
 0xa5,   //   6 LD MSB 5
 0xb0,   //   7 LD LSB 0
 0x8c,   //   8 LD DATA_FLASH
  
 0xa0,   //   9 LD MSB 0
 0xba,   //   a LD LSB 10
 0x90,   //   b LD DR_PARALLEL
 0xbb,   //   c LD LSB 11
 0x90,   //   d LD DR_PARALLEL
 0xb9,   //   e LD LSB 9
 0x90,   //   f LD DR_PARALLEL
 0xbb,   //  10 LD LSB 11
 0x90,   //  11 LD DR_PARALLEL
 0xba,   //  12 LD LSB 10
 0x90,   //  13 LD DR_PARALLEL
  
 //-----------------
 //init_dtc_ctrl_reg
 //-----------------
  
 0xa1,   //  14 LD MSB 1 // data_flash port = output   
 0xb9,   //  15 LD LSB 9 // DATA_FLASH Port driven by FCI 
 0x8d,   //  16 LD CTRL_FCI // PARALLEL Port driven by FCI
  
 //-------------------------------
 //command_latch_cycle (SDI CMD)
 //-------------------------------
  
 0xa8,   //  17 LD MSB 8
 0xb0,   //  18 LD LSB 0
 0x8c,   //  19 LD DATA_FLASH
  
 0xa0,   //  1a LD MSB 0
 0xba,   //  1b LD LSB 10
 0x90,   //  1c LD DR_PARALLEL
 0xbb,   //  1d LD LSB 11
 0x90,   //  1e LD DR_PARALLEL
 0xb9,   //  1f LD LSB 9
 0x90,   //  20 LD DR_PARALLEL
 0xbb,   //  21 LD LSB 11
 0x90,   //  22 LD DR_PARALLEL
 0xba,   //  23 LD LSB 10
 0x90,   //  24 LD DR_PARALLEL
  
 //-------------------------
 // read_address_latch_cycle
 //-------------------------
  
 //read_address_latch_cycle_nb_Bytes
 //---------------------------------
  
 0xa0,   //  25 LD MSB 0
 0xb0,   //  26 LD LSB 0
 0x85,   //  27 LD ADR_BUFFER01		// buffer 0 address ( 15..8 )
  
 0xae,   //  28 LD MSB 14
 0xb6,   //  29 LD LSB 06
 0x84,   //  2a LD ADR_BUFFER00		// buffer 0 address ( 0..7 )
  
 0xdb,   //  2b LD A DATA_BUFFER0
 0x82,   //  2c LD Y
  
 0xae,   //  2d LD MSB 14
 0xb2,   //  2e LD LSB 02
 0x84,   //  2f LD ADR_BUFFER00
  
 0xa0,   //  30 LD MSB 0
 0xba,   //  31 LD LSB 10
 0x90,   //  32 LD DR_PARALLEL
  
 0xbe,   //  33 LD LSB 14
 0x90,   //  34 LD DR_PARALLEL
  
 // read_loop_send_address
 // -----------------
 // :read_loop_send_address
  
 0xdb,   //  35 LD A DATA_BUFFER0
 0x8c,   //  36 LD DATA_FLASH
  
 0xa0,   //  37 LD MSB 0
 0xbc,   //  38 LD LSB 12
 0x90,   //  39 LD DR_PARALLEL
  
 0xbe,   //  3a LD LSB 14
 0x90,   //  3b LD DR_PARALLEL
  
 0x27,   //  3c ADDER16 ADR_BUFFER0
  
 0x3c,   //  3d DECY
 0xc2,   //  3e LD A Y
 0x8,   //  3f CP A=>X
 // JP :read_loop_send_address
 0x6b,   //  40 JP  -11
  
 0xba,   //  41 LD LSB 10
 0x90,   //  42 LD DR_PARALLEL
  
 //---------------------
 //wait_sdi_addr_ready
 //---------------------
  
 //init_timeout
 //------------
 0xb0,   //  43 LD LSB 00
 0x85,   //  44 LD ADR_BUFFER01		// buffer 0 address ( 8..15 )
 0x84,   //  45 LD ADR_BUFFER00		// buffer 0 address ( 0..7 )
 0x88,   //  46 LD CMP00
 0xaf,   //  47 LD MSB 15
 0x89,   //  48 LD CMP01
  
 // :wait_sdi_addr_ready
 //---------------------
 0x27,   //  49 ADDER16 ADR_BUFFER0
 0xd,   //  4a CP ADR_BUFFER0<CMP0
 // JP :sdi_addr_no_timeout
 0x42,   //  4b JP  2
 0x7,   //  4c STATUS STOP ERROR // timeout >20ms
  
 // :sdi_addr_no_timeout
 //---------------------
 0xd0,   //  4d LD A DR_PARALLEL
 0x33,   //  4e EXCHANGE
 0x28,   //  4f BCLR1 //test R/B
 // JP :wait_sdi_addr_ready
 0x67,   //  50 JP  -7
  
 //------------
 // write_spare
 //------------
  
 //init_write_spare
 //----------------
  
 0xa0,   //  51 LD MSB 0
 0xb0,   //  52 LD LSB 0
 0x85,   //  53 LD ADR_BUFFER01		// buffer 0 address ( 15..8 )
 0x89,   //  54 LD CMP01
  
 0xae,   //  55 LD MSB 14
 0xb7,   //  56 LD LSB 07
 0x84,   //  57 LD ADR_BUFFER00
  
 0xaf,   //  58 LD MSB 15
 0x88,   //  59 LD CMP00
  
 // :write_spare
 //-----------
  
 0xdb,   //  5a LD A DATA_BUFFER0
 0x8c,   //  5b LD DATA_FLASH
  
 0xa0,   //  5c LD MSB 0
 0xb8,   //  5d LD LSB 8
 0x90,   //  5e LD DR_PARALLEL
  
 0xba,   //  5f LD LSB 10
 0x90,   //  60 LD DR_PARALLEL
  
 0x27,   //  61 ADDER16 ADR_BUFFER0
 0xd,   //  62 CP ADR_BUFFER0<CMP0
 // JP :write_spare
 0x69,   //  63 JP  -9
  
 //----------------------------
 // :Page_Pgm_command_latch_cycle
 //----------------------------
  
 0xa1,   //  64 LD MSB 1
 0xb0,   //  65 LD LSB 0
 0x8c,   //  66 LD DATA_FLASH
  
 0xa0,   //  67 LD MSB 0
 0xba,   //  68 LD LSB 10
 0x90,   //  69 LD DR_PARALLEL
 0xbb,   //  6a LD LSB 11
 0x90,   //  6b LD DR_PARALLEL
 0xb9,   //  6c LD LSB 9
 0x90,   //  6d LD DR_PARALLEL
 0xbb,   //  6e LD LSB 11
 0x90,   //  6f LD DR_PARALLEL
 0xba,   //  70 LD LSB 10
 0x90,   //  71 LD DR_PARALLEL
  
 //---------------------------
 // read_status & check_status
 //---------------------------
  
 //wait_card_ready
 //---------------
  
 //init_timeout
 //------------
 0xb0,   //  72 LD LSB 00
 0x85,   //  73 LD ADR_BUFFER01
 0x84,   //  74 LD ADR_BUFFER00
 0x88,   //  75 LD CMP00
 0xaf,   //  76 LD MSB 15
 0x89,   //  77 LD CMP01
  
 // :wait_card_ready
 //---------------
 0x27,   //  78 ADDER16 ADR_BUFFER0
 0xd,   //  79 CP ADR_BUFFER0<CMP0
 // JP :no_timeout
 0x42,   //  7a JP  2
 0x7,   //  7b STATUS STOP ERROR // timeout 20ms
  
 // :no_timeout
 //----------
 0xd0,   //  7c LD A DR_PARALLEL
 0x33,   //  7d EXCHANGE
 0x28,   //  7e BCLR1 //test R/B
 // JP :wait_card_ready
 0x67,   //  7f JP  -7
  
 // :read_status_command_latch_cycle
 //-------------------------------
  
 0xa7,   //  80 LD MSB 7
 0xb0,   //  81 LD LSB 0
 0x8c,   //  82 LD DATA_FLASH
  
 0xa0,   //  83 LD MSB 0
 0xba,   //  84 LD LSB 10
 0x90,   //  85 LD DR_PARALLEL
 0xbb,   //  86 LD LSB 11
 0x90,   //  87 LD DR_PARALLEL
 0xb9,   //  88 LD LSB 9
 0x90,   //  89 LD DR_PARALLEL
 0xbb,   //  8a LD LSB 11
 0x90,   //  8b LD DR_PARALLEL
 0xba,   //  8c LD LSB 10
 0x90,   //  8d LD DR_PARALLEL
  
 // :init_read_status_seq
 //---------------------
  
 0xa0,   //  8e LD MSB 0
 0xb9,   //  8f LD LSB 9 // DATA_FLASH Port driven by FCI  
 0x8d,   //  90 LD CTRL_FCI // PARALLEL Port driven by FCI
  
 // :read_status_seq
 //----------------
  
 0xa0,   //  91 LD MSB 0
 0xb2,   //  92 LD LSB 2
 0x90,   //  93 LD DR_PARALLEL
 0x0,   //  94 NOP
 0xcc,   //  95 LD A DATA_FLASH // load DATA_FLASH
  
 // : check_status
 //-------------
 0x33,   //  96 EXCHANGE
 0x2a,   //  97 BCLR3
 // JP :error_status
 0x45,   //  98 JP  5
 0x2b,   //  99 BCLR4
 // JP :error_status
 0x43,   //  9a JP  3
 0x9,   //  9b CP A<X
 // JP :no_error
 0x42,   //  9c JP  2
  
 // :error_status
 //------------
 0x5,   //  9d STATUS STOP
  
 // :no_error
 //--------
 0xa0,   //  9e LD MSB 0
 0xba,   //  9f LD LSB 10
 0x90,   //  a0 LD DR_PARALLEL
  
 //------------
 //end_of_block
 //------------
  
 //inc_addr
 //--------
  
 0xb0,   //  a1 LD LSB 0
 0xa0,   //  a2 LD MSB 0
 0x85,   //  a3 LD ADR_BUFFER01 // buffer 0 address ( 8..15 )
  
 0xae,   //  a4 LD MSB 14
 0xb3,   //  a5 LD LSB 03
 0x84,   //  a6 LD ADR_BUFFER00 // buffer 0 address ( 0..7 )
  
 0xdb,   //  a7 LD A DATA_BUFFER0
 0x2,   //  a8 CLC
 0x25,   //  a9 ADDER8 X
 0x9b,   //  aa LD DATA_BUFFER0
  
 0xbf,   //  ab LD LSB 15
 0xaf,   //  ac LD MSB 15
 0x84,   //  ad LD ADR_BUFFER00 // buffer 0 address ( 7..0 )
  
 0xdb,   //  ae LD A DATA_BUFFER0
 0x2,   //  af CLC
 0x24,   //  b0 SUB8 X
 0x9b,   //  b1 LD DATA_BUFFER0
  
 0x8,   //  b2 CP A=>X
 // JP :process_continue
 0x42,   //  b3 JP  2
 0x5,   //  b4 STATUS STOP // end of process
  
 // :process_continue
  
 0xa1,   //  b5 LD MSB 1
 0xb4,   //  b6 LD LSB 4
 0xb,   //  b7 CP ALWAYS
 0x60,   //  b8 BRANCH
};	  // SMC_DTC_Mark_Pages

/*** (c) 1998   STMicroelectronics ****************** END OF FILE ***/
