/**************** (c) 2001  STMicroelectronics **********************

PROJECT : ST7265 USB Mass Storage - SMC

VERSION :  V1.0 Beta2

CREATION DATE :  20/03/2001

AUTHOR : MICROCONTROLLER DIVISION / Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : DTC programs for SMC

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef DTC_code_H
#define DTC_code_H

/* DTC_code */
#pragma CONST_SEG SMC_DTC_CODE
extern const unsigned char SMC_DTC_Code0[];
extern const unsigned char SMC_DTC_USB_Mass_Upld[];
extern const unsigned char SMC_DTC_USB_Mass_Dwld[];
extern const unsigned char SMC_DTC_Play[];
extern const unsigned char SMC_DTC_Map_Zone[];
extern const unsigned char SMC_DTC_Format[];
extern const unsigned char SMC_DTC_Copy_Pages[];
extern const unsigned char SMC_DTC_Mark_Pages[];

extern const unsigned char SMC_DTC_Map_Range[];	// For playback
extern const unsigned char SMC_DTC_Play_Read[];	// For playback

#define	CODE_DTC_PLAY	0x01
#define CODE_DTC_WRITE	0x02
#define CODE_WRITE_USB	0x03
#define CODE_READ_USB	0x04
#define CODE_MAP_ZONE	0x05
#define CODE_SMC_FORMAT	0x06
#define CODE_COPY_PAGES 0x07
#define CODE_MARK_PAGES 0x08
#define	CODE_DTC_CODE0	0x09

#define CODE_MAP_RANGE	0x0A	// For playback
#define CODE_PLAY_READ	0x0B	// For playback


/************************************************/
/* Starting Addresses of SMC Process in DTC_RAM */
/************************************************/

/* Starting Addresses of SMC Code0 Lib */
#define SMC_DTC_Code_Init_SMC_Mode        0x00   // SMC_Init_Upld Address in DTC_RAM
#define SMC_DTC_Code_Dummy_Write		0x14	// Simulate the writing

/* Starting Addresses of SMC Play Lib */
#define SMC_DTC_Play_Read0				0x00
#define SMC_DTC_Play_Read1				0x03
#define SMC_DTC_Play_Write0				0x4b
#define SMC_DTC_Play_Write1				0x4e
#define SMC_DTC_Play_Send_Cmd			0x8b
#define SMC_DTC_Play_Send_Addr			0xA5
#define SMC_DTC_Play_Read_ID			0xC0	// Read the device ID
#define SMC_DTC_Play_Read_Status		0xE0	// Read the status byte

/* Starting Address of SMC_DTC_USB_Upload */
#define SMC_DTC_USB_Upload			0x00	// Read data page and upload to USB
#define SMC_DTC_USB_Upload2			0xA0	// Read data page and upload to USB after ECC correction
#define SMC_DTC_USB_Upload_FF		0xB6	// pload all FF to USB

/* Starting Address of SMC_DTC_USB_Download */
#define SMC_DTC_USB_DownErase		0x09	// Erase a physical cluster after download
#define SMC_DTC_USB_Download_Buf0	0x00	// Write data page downloaded from the USB, start from Buffer0
#define SMC_DTC_USB_Download_Buf1	0x06	// Write data page downloaded from the USB, start from Buffer1

/* Starting Address of SMC_DTC_Format */
#define SMC_DTC_Format_Cmd_Read0		0x11	// Send command of sequencial read for further reading
#define SMC_DTC_Format_Cmd_Erase		0x14	// Send command and address for erase the cluster
#define SMC_DTC_Format_Cmd_Check		0x1A	// Send command and address for check the redundant area
#define SMC_DTC_Format_Cmd_Read			0x1D	// Send command and address for read the cluster
#define SMC_DTC_Format_Write_0			0x22	// Write all 0's to the every page of the cluster
#define SMC_DTC_Format_Erase_Wait		0x74	// Send command to erase the cluster and wait erasing finishes
#define SMC_DTC_Format_Read_0			0x9D	// Read every page of the cluster and check with 0's
#define SMC_DTC_Format_Check			0xBD	// Read redundant area & check if it can be used

#endif
/*** (c) 1998   STMicroelectronics ****************** END OF FILE ***/




