/****************** (c) 1999  STMicroelectronics *****************************

PROJECT : USB - ST7

VERSION : SMC_Mass.h	1.0 Beta2

CREATION DATE :

AUTHOR : CMG / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

REM: 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef DTC_MASS_H
#define DTC_MASS_H

/********************************************/
/*			SMC Command set					*/
/********************************************/
#define   Sequential_Data_Input   0x80
#define   Read1A                  0x00
#define   Read1B                  0x01
#define   Read2                   0x50
#define   Reset                   0xFF
#define   Page_Pgm                0x10
#define   Block_Erase1            0x60
#define   Block_Erase2            0xD0
#define   ID_Read                 0x90
#define   Read_Status             0x70

/********************************************************/
/*		DTC parameter exchange area for SMC				*/
/********************************************************/
#define SMC_RespFrame_AddrBeg	0x022  //Buffer_RAM[USER AREA]
#define SMC_ECC_Calc     	    0x038  //Buffer_RAM[USER AREA]

#define DTC_SMC_Command			Buffer_Param[0x20]	// The command byte
#define DTC_SMC_Address_bytes	Buffer_Param[0x26]	// Number of address bytes to be latched
#define DTC_Page_Counter		Buffer_Param[0x3F]	// Number of pages to be processed

#define CopyStartAddr(Addr) {	\
		Buffer_Param[SMC_RespFrame_AddrBeg] = ((unsigned char *)(&(Addr)))[3];	\
		Buffer_Param[SMC_RespFrame_AddrBeg+1] = ((unsigned char *)(&(Addr)))[2];	\
		Buffer_Param[SMC_RespFrame_AddrBeg+2] = ((unsigned char *)(&(Addr)))[1];	\
		Buffer_Param[SMC_RespFrame_AddrBeg+3] = ((unsigned char *)(&(Addr)))[0];	\
}
#define CopyStartAddr8(Addr) { /* Shift 'Addr' left 8 bits */	\
		Buffer_Param[SMC_RespFrame_AddrBeg] = 0;	\
		Buffer_Param[SMC_RespFrame_AddrBeg+1] = ((unsigned char *)(&(Addr)))[3];	\
		Buffer_Param[SMC_RespFrame_AddrBeg+2] = ((unsigned char *)(&(Addr)))[2];	\
		Buffer_Param[SMC_RespFrame_AddrBeg+3] = ((unsigned char *)(&(Addr)))[1];	\
}

// Definition for access the spare area of the DTC parameter
typedef union
{
	struct Fields
	{ 
		unsigned long Reserved_Field;
		unsigned char Data_Status_Byte;
		unsigned char Block_Status_Byte;
		unsigned short Block_Address_Field_1;
		unsigned char ECC_Field_2[3];
		unsigned short Block_Address_Field_2;
		unsigned char ECC_Field_1[3];
	} Field;
	unsigned char Byte_No[16];  
} REDUNDANT_AREA;
#define Spare_Area		((REDUNDANT_AREA*)(&Buffer_Param[0x27]))->Field


/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
//		Functions exported from SMC_Mass
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
extern void DTC_SMC_Init(void);
extern void DTC_SMC_Map_Zone(unsigned short *SMC_Lookup_Table);
extern unsigned char DTC_Read_FF(void);
extern unsigned char DTC_SMC_Read_USB(void);	// Upload
extern unsigned char DTC_SMC_Read_USB2(void);	// Upload after ECC correction
extern unsigned char DTC_SMC_Copy_Pages(void);
extern unsigned char DTC_SMC_Write_USB(unsigned char buf_no);
extern unsigned char DTC_SMC_Erase(void);
extern unsigned char DTC_SMC_ReadID(void);
extern unsigned char DTC_SMC_Mark_Pages(void);
extern unsigned char vDTC_SMC_Mark_Bad();
extern unsigned long SMC_Bad_Paddr;
//#define DTC_SMC_Mark_Bad(addr)	{ SMC_Bad_Paddr=addr; vDTC_SMC_Mark_Bad(); }
extern unsigned char DTC_SMC_Mark_Bad(unsigned long SMC_Bad_Paddr);
extern unsigned char SMC_Read_Buffer(unsigned char iBuffer);
extern unsigned char SMC_Write_Buffer(unsigned char iBuffer);

// Functions for SMC format
extern unsigned char DTC_SMC_Format_Chk(void);
extern void DTC_SMC_Format_Start(void);
extern void DTC_SMC_Format_Erase(void);
extern void DTC_SMC_Format_Write(void);
extern void DTC_SMC_Format_Read(void);
#endif
