/*-*-*-*-*-*-*-*-*-*-* (C) 2002 STMicroelectronics *-*-*-*-*-*-*-*-*-*-*-*-*-*

PROJECT  : ST7265 MemoryStick Media Access Library
COMPILER : ST7 C

MODULE  :  MAL_MS.c
VERSION :

CREATION DATE :  23/01/2002

AUTHOR :

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

DESCRIPTION :

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*

Modification:

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

#include "define.h" 
#include "lib_bits.h"
#include "Map_7265.h"
#include "Mconfig.h"		// Media configuration
#include "MSL.h"
#include "MAL_Map.h"
#include "MAL.h"
#include "MS_Mass.h"
#include "DTC_Func.h"

/*-*-*-*-*-*-*-*-*-*-*-*-*-* Variable declaration *-*-*-*-*-*-*-*-*-*-*-*-*-*/
#pragma DATA_SEG SHORT MAL_RAM0	// Frequently used variable
// MS_Wstate keeps track the state of the MS writing procedure
// Bits definition:
//	bit0	= 0 actions on new cluster
//			= 1 actions on old cluster
//	bit1-0	= 00 MARKing
//			= 01 COPYing
//			= 10 WRITE to new cluster
//			= 11 WRITE to old cluster
//	bit3-2	= 00 PRE actions
//			= 01 POST actions
//			= 10 HOLE actions
//			= 11 HOLE or FULL actions
static unsigned char	MS_Wstate;		// the state of the Memory Stick writing procedure
#define MS_OLD_CLUSTER			0x01
#define	MS_WRITE_FLAG			0x02
#define MS_PRE_ACTION			0x00
#define MS_POST_ACTION			0x04
#define MS_HOLE_ACTION			0x08
#define MS_FULL_ACTION			0x0C
#define MS_ERROR_FLAG			0x10
#if ALLOW_OUT_RANGE
#define MS_OUT_RANGE			(0x20 | MS_WRITE_FLAG)
#endif

#define MS_PREMARK			(MS_PRE_ACTION | !MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// 0
#define MS_PRECOPY			(MS_PRE_ACTION | !MS_WRITE_FLAG | MS_OLD_CLUSTER)	// 1
#define MS_PRENEWWRITE		(MS_PRE_ACTION | MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// 2
#define MS_PREOLDWRITE		(MS_PRE_ACTION | MS_WRITE_FLAG | MS_OLD_CLUSTER)	// 3
#define MS_POSTMARK			(MS_POST_ACTION | !MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// 4
#define MS_POSTCOPY			(MS_POST_ACTION | !MS_WRITE_FLAG | MS_OLD_CLUSTER)	// 5
#define MS_POSTNEWWRITE		(MS_POST_ACTION | MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// 6
#define MS_POSTOLDWRITE		(MS_POST_ACTION | MS_WRITE_FLAG | MS_OLD_CLUSTER)	// 7
#define MS_PREHOLEMARK		(MS_HOLE_ACTION | !MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// 8
#define MS_PREHOLECOPY		(MS_HOLE_ACTION | !MS_WRITE_FLAG | MS_OLD_CLUSTER)	// 9
#define MS_HOLENEWWRITE		(MS_HOLE_ACTION | MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// A
#define MS_HOLEOLDWRITE		(MS_HOLE_ACTION | MS_WRITE_FLAG | MS_OLD_CLUSTER)	// B
#define MS_POSTHOLEMARK		(MS_FULL_ACTION | !MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// C
#define MS_POSTHOLECOPY		(MS_FULL_ACTION | !MS_WRITE_FLAG | MS_OLD_CLUSTER)	// D
#define MS_FULLNEWWRITE		(MS_FULL_ACTION | MS_WRITE_FLAG | !MS_OLD_CLUSTER)	// E
#define MS_FULLOLDWRITE		(MS_FULL_ACTION | MS_WRITE_FLAG | MS_OLD_CLUSTER)	// F

static unsigned char MS_Block_Size;	// Size of a cluster

#define LOOKUP_THRESHOLD	100
static unsigned char MS_Segment;
static unsigned char MS_Lookup1_Seg;	// Segment No in Lookup table1
static unsigned char MS_Lookup2_Seg;	// Segment No in Lookup table2
static unsigned char MS_Lookup3_Seg;	// Segment No in Lookup table3
static unsigned char MS_Lookup_Count1;	// Visit count of table1
static unsigned char MS_Lookup_Count2;	// Visit count of table2
static unsigned char MS_Lookup_Count3;	// Visit count of table3
static unsigned short *MS_Lookup_pTable;// The pointer of the current table

typedef struct ls {
	unsigned short longH;
	unsigned short longL;
} LONG_SHORT;

extern LONG_SHORT	malPaddr;
extern LONG_SHORT	malRaddr;
extern unsigned char	malNpage;

#define MS_Paddr	malPaddr.longL
#define MS_Raddr	malRaddr.longL
static unsigned char MS_Npage;
static unsigned char MS_Ppage;
unsigned char malPpage;

unsigned short	MS_Logical;			// Absolute logical address
unsigned short	MS_Laddr;			// Relative logical address within segment

#pragma DATA_SEG MAL_RAM
static unsigned char DTC_Error;
static unsigned char MS_Capacity;		// Card capacity in MB
static unsigned char MS_DTC_Current_Func;
#define MS_FUNC_READ_USB		0x01
#define MS_FUNC_WRITE_USB		0x02
#define MS_FUNC_FORMAT			0x03

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* functions *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#pragma DATA_SEG DEFAULT_RAM	// After here, all variable will be in non-Zero page


#pragma CODE_SEG MS_CODE
/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* functions *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
extern void MS_Scan_Lookup_Table(unsigned short *MS_Lookup_Table, unsigned char segment);
#define MS_Lookup_Table0 SMC_Lookup_Table0
#define MS_Lookup_Table1 (SMC_Lookup_Table0 + 512)
#define MS_Lookup_Table2 SMC_Lookup_Table1
#define MS_Lookup_Table3 (SMC_Lookup_Table1 + 512)

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* functions *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// Build the lookup table for the given segment and clear its reference counter
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-* functions *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
void MS_Lookup_Update1(unsigned char Segment)
{
	MS_Lookup1_Seg = Segment;
	MS_Scan_Lookup_Table(MS_Lookup_pTable = MS_Lookup_Table1, Segment);
	MS_Lookup_Count1 = 0;
}

void MS_Lookup_Update2(unsigned char Segment)
{
	MS_Lookup2_Seg = Segment;
	MS_Scan_Lookup_Table(MS_Lookup_pTable = MS_Lookup_Table2, Segment);
	MS_Lookup_Count2 = 0;
}

void MS_Lookup_Update3(unsigned char Segment)
{
	MS_Lookup3_Seg = Segment;
	MS_Scan_Lookup_Table(MS_Lookup_pTable = MS_Lookup_Table3, Segment);
	MS_Lookup_Count3 = 0;
}

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// Increase the logical address.
// To adjust the current segment number if it is necessary
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
static void MS_INC_Logical_Addr(void)
{
	MS_Ppage = 0;	// start from page 0 of the next block
	MS_Laddr++;
	MS_Logical++;
	if (MS_Laddr >= 494) {
		if (MS_Segment == 0) {
			MS_Segment = 1;
			MS_Laddr = 0;
		}
		else if (MS_Laddr >= 496) {
			MS_Segment++;
			MS_Laddr = 0;
		}
	}
}

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// This function is called once for each MS_Read or MS_Write requests
// Convert the MAL_Block_Address to logical block address by shift it
// It is converted into MS_Logical, MS_Segment, MS_Laddr, MS_Ppage
// After the address conversion, MAL_Block_Numbers is checked to ensure
// that the lookup table for all blocks are in the memory.
// The lookup table will be built if the lookup table for the current logical
// block is not in the memory or the the lookup tbale for the last logical
// block in this operation (MS_READ or MS_WRITE) is not in the memory)
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
void MS_Get_Logical_Addr()
{
	unsigned short EndBlock;

	MS_Segment = 0;
	if (MS_Block_Size == 32) {
		asm {
			LD		A, MAL_Block_Address:3
			LD		X, MAL_Block_Address:2
			LD		Y, MAL_Block_Address:1
			SRL		Y
			RRC		X
			RRC		A	; 1st shift
			SRL		Y
			RRC		X
			RRC		A	; 2nd shift
			SRL		Y
			RRC		X
			RRC		A	; 3rd shift
			SRL		Y
			RRC		X
			RRC		A	; 4th shift
			SRL		Y
			RRC		X
			RRC		A	; 5th shift
			LD		MS_Laddr:1, A
			LD		MS_Laddr, X
		}	// The C line below costs too much
	//	MS_Laddr = (unsigned int)(MAL_Block_Address >> 5);

		MS_Logical = MS_Laddr;
		if (MS_Laddr >= 494) {
			MS_Laddr -= 494;
			MS_Segment++;
			while (MS_Laddr >= 496) {
				MS_Segment++;
				MS_Laddr -= 496;
			}
		}
		MS_Ppage = (unsigned char)MAL_Block_Address & 0x001F;
	}
	else {
		asm {
			LD		A, MAL_Block_Address:3
			LD		X, MAL_Block_Address:2
			LD		Y, MAL_Block_Address:1
			SRL		Y
			RRC		X
			RRC		A	; 1st shift
			SRL		Y
			RRC		X
			RRC		A	; 2nd shift
			SRL		Y
			RRC		X
			RRC		A	; 3rd shift
			SRL		Y
			RRC		X
			RRC		A	; 4th shift
			LD		MS_Laddr:1, A
			LD		MS_Laddr, X
		}	// The C line below costs too much
	//	MS_Laddr = (unsigned int)(MAL_Block_Address >> 4);
		MS_Logical = MS_Laddr;
		if (MS_Laddr >= 494) {
			MS_Laddr -= 494;
			MS_Segment = 1;
		}
		MS_Ppage = (unsigned char)MAL_Block_Address & 0x000F;
	}

	if (MS_Capacity <= 32)
		return;					// All lookup table can be in the memory

	asm {
		LD		A, MAL_Block_Numbers:1
		LD		X, MAL_Block_Numbers
		ADD		A, MS_Ppage
		JRNC	sub_1
		INC		X
sub_1:	SUB		A, #1
		JRNC	shift5
		DEC		X
shift5:
		SRL		X
		RRC		A		; 1st shift
		SRL		X
		RRC		A		; 2nd shift
		SRL		X
		RRC		A		; 3rd shift
		SRL		X
		RRC		A		; 4th shift
		SRL		X
		RRC		A		; 5th shift
		ADD		A, MS_Laddr:1
		LD		EndBlock:1, A
		LD		A, X
		ADC		A, MS_Laddr
		LD		EndBlock, A
	}	// The following C line costs too much
//	EndBlock = MS_Laddr + ((MS_Ppage + MAL_Block_Numbers - 1) >> 5);

	if ((EndBlock >= 496) || (EndBlock >= 494 && MS_Segment == 0)) {
		// The access will cross the segment boundary
		unsigned char SegNext;
		unsigned char Hit_Flag = 0;	// Bit 7: MS_Segment hits in the lookup table
									// Bit 6: Next segment hits in the lookup table
									// Bit 3-2: The most visited segment
									// Bit 1-0: The least visited segment

		SegNext = MS_Segment + 1;
		if (SegNext == MS_Lookup1_Seg || SegNext == MS_Lookup2_Seg
									  || SegNext == MS_Lookup3_Seg)
			Hit_Flag |= 0x40;
		if (MS_Segment == 0 || MS_Segment == MS_Lookup1_Seg
							|| MS_Segment == MS_Lookup2_Seg
							|| MS_Segment == MS_Lookup3_Seg)
			Hit_Flag |= 0x80;


		if (Hit_Flag == 0xC0)
			return;

		if (MS_Lookup_Count1 >= MS_Lookup_Count2) {
			if (MS_Lookup_Count1 >= MS_Lookup_Count3) {
				Hit_Flag |= 1 << 2;
				if (MS_Lookup_Count2 >= MS_Lookup_Count3)
					Hit_Flag |= 3;
				else
					Hit_Flag |= 2;
			}
			else {
				Hit_Flag |= 3 << 2;
				Hit_Flag |= 2;
			}
		}
		else {
			if (MS_Lookup_Count2 >= MS_Lookup_Count3) {
				Hit_Flag |= 2 << 2;
				if (MS_Lookup_Count1 >= MS_Lookup_Count3)
					Hit_Flag |= 3;
				else
					Hit_Flag |= 1;
			}
			else {
				Hit_Flag |= 3 << 2;
				Hit_Flag |= 1;
			}
		}

		switch (Hit_Flag & 0xC0) {
		case 0x00:	// Both segments are not hit
			// Keep the lookup table of the Most visited segment
			switch (Hit_Flag & 0x0C) {
			case 1 << 2:
				MS_Lookup_Update2(MS_Segment);
				MS_Lookup_Update3(SegNext);
				break;
			case 2 << 2:
				MS_Lookup_Update1(MS_Segment);
				MS_Lookup_Update3(SegNext);
				break;
			case 3 << 2:
				MS_Lookup_Update1(MS_Segment);
				MS_Lookup_Update2(SegNext);
				break;
			}
			break;
		case 0x40:	// Current segment is not hit
			// Swap-out the least visited segment
			switch (Hit_Flag & 0x03) {
			case 1:
				MS_Lookup_Update1(MS_Segment);
				break;
			case 2:
				MS_Lookup_Update2(MS_Segment);
				break;
			case 3:
				MS_Lookup_Update3(MS_Segment);
				break;
			}
			break;
		case 0x80:	// Next segment is not hit
			// Swap-out the least visited segment
			switch (Hit_Flag & 0x03) {
			case 1:
				MS_Lookup_Update1(SegNext);
				break;
			case 2:
				MS_Lookup_Update2(SegNext);
				break;
			case 3:
				MS_Lookup_Update3(SegNext);
				break;
			}
			break;
		}
	}
	else {
		// see if the new address hits in the lookup table
		if (MS_Segment == 0 || MS_Segment == MS_Lookup1_Seg
							|| MS_Segment == MS_Lookup2_Seg
							|| MS_Segment == MS_Lookup3_Seg)
			return;

		// The new address does not hit in the lookup table.
		// Look for the less visited lookup table and update it to the new segment
		if (MS_Lookup_Count1 <= MS_Lookup_Count2 && MS_Lookup_Count1 <= MS_Lookup_Count3) {
			MS_Lookup_Update1(MS_Segment);
			return;
		}
		if (MS_Lookup_Count2 <= MS_Lookup_Count1 && MS_Lookup_Count2 <= MS_Lookup_Count3) {
			MS_Lookup_Update2(MS_Segment);
			return;
		}
		if (MS_Lookup_Count3 <= MS_Lookup_Count1 && MS_Lookup_Count3 <= MS_Lookup_Count2) {
			MS_Lookup_Update3(MS_Segment);
			return;
		}
	}
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
#define MS_Get_Free()	MS_Lookup_pTable[496]

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
// Assign the physical block MS_Paddr to the logical block MS_Laddr
// Erase the physical block MS_Raddr if its content was copied to MS_Paddr
// and assign the erased block to logical position 496 in the lookup table
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
void MS_Update_Lookup()
{
#if ALLOW_OUT_RANGE
	if (Mal_Addr_Out_Range & 0x01)
		return;
#endif
	MS_Lookup_pTable[MS_Laddr] = MS_Paddr;

	if (MS_Wstate & MS_OLD_CLUSTER) {
		MS_Paddr = MS_Raddr;
		MS_DTC_Erase();		// Erase the dirty block of malPaddr

		// Return this block to the lookup table
		MS_Lookup_pTable[496] = MS_Raddr | 0x8000;
	}
}

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// Get the physical address of the current logical block to MS_Paddr
// Return non-zero if the physical block is not blank
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
unsigned char MS_Log2Phy()
{
	if (MS_Segment == 0) {	// Hit on table0
		MS_Lookup_pTable = MS_Lookup_Table0;
		// decrease the visit counter of another table
		if (MS_Lookup_Count1)
			MS_Lookup_Count1--;
		if (MS_Lookup_Count2)
			MS_Lookup_Count2--;
		if (MS_Lookup_Count3)
			MS_Lookup_Count3--;
	}
	else {
		if (MS_Segment == MS_Lookup1_Seg) {
			MS_Lookup_pTable = MS_Lookup_Table1;
			// increase the visit counter of this table
			if (MS_Lookup_Count1 != LOOKUP_THRESHOLD)
				MS_Lookup_Count1++;
			// decrease the visit counter of another table
			if (MS_Lookup_Count2)
				MS_Lookup_Count2--;
			if (MS_Lookup_Count3)
				MS_Lookup_Count3--;
		}
		else if (MS_Segment == MS_Lookup2_Seg) {
			MS_Lookup_pTable = MS_Lookup_Table2;
			// increase the visit counter of this table
			if (MS_Lookup_Count2 != LOOKUP_THRESHOLD)
				MS_Lookup_Count2++;
			// decrease the visit counter of another table
			if (MS_Lookup_Count1)
				MS_Lookup_Count1--;
			if (MS_Lookup_Count3)
				MS_Lookup_Count3--;
		}
		else if (MS_Segment == MS_Lookup3_Seg) {
			MS_Lookup_pTable = MS_Lookup_Table3;
			// increase the visit counter of this table
			if (MS_Lookup_Count3 != LOOKUP_THRESHOLD)
				MS_Lookup_Count3++;
			// decrease the visit counter of another table
			if (MS_Lookup_Count1)
				MS_Lookup_Count1--;
			if (MS_Lookup_Count2)
				MS_Lookup_Count2--;
		}
	}

	MS_Paddr = MS_Lookup_pTable[MS_Laddr];
	return ((MS_Paddr & 0x8000) == 0);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Launch the DTC again for reading pages from another block
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MS_Read_Interrupt()
{
Start_MS_Read_Interrupt:
	_MAL_INC_Block_Param(MS_Npage);
	if (DTC_Error) {
		_MAL_DEC_Block_Param(malNpage);

		MAL_Error = MAL_RD_ERR;
		MAL_Finish(FALSE);
		MS_DTC_Current_Func = 0;
		return;
	}
	if (MAL_Block_Numbers == 0) {
		MAL_Error = MAL_GOOD;
		MAL_Finish(TRUE);
		MS_DTC_Current_Func = 0;
		return;
	}

	// Launch the next burst reading
	MS_INC_Logical_Addr();

	if (MS_Block_Size > MAL_Block_Numbers)
		malNpage = (unsigned char)MAL_Block_Numbers;
	else
		malNpage = MS_Block_Size;

	_MAL_BufMgr_Upload();		// Switch to UPLOAD mode

	MS_Npage = malNpage;
	if (!MS_Log2Phy()) {
// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
		// When the specified location does not exist
		// Have to return all 0xFF in the data block.
		DTC_MS_Read_FF();
		return;
	}

	if (MS_Paddr & 0x4000) {		// This is a bad cluster
		MAL_Error = MAL_BAD_MEDIUM;	// Too many bad clusters
		MAL_Finish(FALSE);
		MS_DTC_Current_Func = 0;
		return;
	}

	malPpage = 0;					// Start from page 0. Because this is a new block

	MS_DTC_Read_USB( /* malPaddr, malNpage */ );
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Read(void)
{
// Get the logical block address
	MS_Get_Logical_Addr();		// MS_Segment:MS_Laddr:MS_Ppage = MAL_Block_Address
	MAL_Block_Finish = 0;

	malNpage = MS_Block_Size - MS_Ppage;
	if (malNpage > MAL_Block_Numbers)
		malNpage = (unsigned char)MAL_Block_Numbers;

	MS_Npage = malNpage;

	_MAL_BufMgr_Upload();		// Switch to UPLOAD mode

	MS_DTC_Current_Func = MS_FUNC_READ_USB;
// Get the physical block address
	if (!MS_Log2Phy()) {
		// When the specified location does not exist
		// Have to return all 0xFF in the data block.
		DTC_MS_Read_FF();
		return MAL_GOOD;
	}

	if (MS_Paddr & 0x4000) {		// This is a bad cluster
		MAL_Error = MAL_BAD_MEDIUM;	// Too many bad clusters
		MAL_Finish(FALSE);

		MS_DTC_Current_Func = 0;
		return MAL_Error;
	}

//	Launch the DTC to copy the first data block
	malPpage = MS_Ppage;

	MS_DTC_Read_USB( /* malPaddr, malNpage */ );

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
	Launch the DTC again for
		writing another of a block
		writing another block
		or finish the writing
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MS_Write_Interrupt()
{
Label_MS_Write_Interrupt:
			// Some DTC routine is expected to finish with interrupt,
			// but it returns when it finishes.
			// This label is used to simulate the re-enter as interrupt.

#if	ALLOW_ERROR
	if (MS_Wstate & MS_ERROR_FLAG) {
		MS_Wstate &= ~MS_ERROR_FLAG;

		// Mark the cluster of malRaddr as a bad cluster
		DTC_MS_Mark_Bad(malRaddr & ~((MS_Block_Size == 32)?0x1F:0x0F) );
	}
#endif

	if (MS_Wstate & MS_WRITE_FLAG) {
		if (DTC_Error)
			MS_Npage -= malNpage;
		_MAL_INC_Block_Param(MS_Npage);
	}

	MS_DTC_Current_Func = MS_FUNC_WRITE_USB;

	switch (MS_Wstate) {
	case MS_PREMARK:		// 0
	case MS_PRECOPY:		// 1
	case MS_PREHOLEMARK:	// 8 Never use
	case MS_PREHOLECOPY:	// 9 Never use
#if	ALLOW_ERROR					// TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED
		if (DTC_Error) {
			// Mark the cluster of malPaddr as a bad cluster
			DTC_MS_Mark_Bad(malPaddr & ~((MS_Block_Size == 32)?0x1F:0x0F) );
			MS_Lookup_Map_Bad();

			malNpage = MS_Ppage;

		//	_MAL_BufMgr_Normal();
			if (MS_Wstate & MS_OLD_CLUSTER) {
				// This is a old logical cluster
				// Launch the DTC to copy several pages
				// Copy malNpage pages from malRaddr to malPaddr
				malRaddr &= ~((MS_Block_Size == 32)? 0x1F : 0x0F);	// start from page 0
				MS_DTC_wCopyPages();
				// Now MS_Wstate == MS_PRECOPY
			}
			else {
				// This is a new logical cluster
				// Launch the DTC to mark several pages
				MS_DTC_wMarkPages(0xFFFF);		// Mark the starting pages
				// Now MS_Wstate == MS_PREMARK

			}

			// Mask off these 2 lines if DTC interrupts
		//	DTC_Error = 0;
		//	goto Label_MS_Write_Interrupt;

			return;
		}
#endif

		malPpage = MS_Ppage;
		malNpage = MS_Block_Size - MS_Npage;
		if (malNpage > MAL_Block_Numbers) {
			malNpage = (unsigned char)MAL_Block_Numbers;
			MS_Wstate |= MS_HOLE_ACTION;
		}
		MS_Npage = malNpage;

		// Launch DTC to write several pages;
		MS_Wstate |= MS_WRITE_FLAG;
		_MAL_BufMgr_Download();
		MS_DTC_Write_USB(0);

		// Now MS_Wstate = MS_PRENEWWRITE or MS_PREOLDWRITE or
		//     MS_Wstate = MS_HOLENEWWRITE or MS_HOLEOLDWRITE
		return;

	case MS_POSTNEWWRITE:	// 6
	case MS_POSTOLDWRITE:	// 7
#if	ALLOW_ERROR					// TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED
		if (DTC_Error) {
			malRaddr = malPaddr & ~((MS_Block_Size == 32)? 0x1F : 0x0F);
			MS_Lookup_Map_Bad();

			MS_Wstate &= ~(MS_FULL_ACTION | MS_WRITE_FLAG);
			MS_Wstate |= MS_ERROR_FLAG;		// ready to mark malRaddr as bad

			malNpage = MS_Npage;
			MS_Ppage = MS_Npage;				// next time writing start here

			MS_DTC_wCopyPages();

			// Mask off these 2 lines if DTC interrupts
		//	DTC_Error = 0;
		//	goto Label_MS_Write_Interrupt;

			return;
			// Now MS_Wstate = MS_PREMARK or MS_PRECOPY;
		}
#endif

		// All data from USB has been written. MAL_Block_Numbers must be 0

		malNpage = (unsigned char)(MS_Block_Size - MS_Npage);
		MS_Ppage = MS_Npage;
		MS_Wstate &= ~MS_WRITE_FLAG;		// Clear WRITE flag

Post_Mark_Copy:
		MS_Npage = malNpage;
		malPpage = MS_Ppage;		// start page number
		if (MS_Wstate & MS_OLD_CLUSTER) {
			// This was an overwrite operation, copy the remain pages

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			MS_DTC_wCopyPages();

			// Now MS_Wstate = MS_POSTCOPY;
		}
		else {
			// This was a new block operation, mark the remain pages

			// Launch the DTC to several several pages start from malPaddr
			MS_DTC_wMarkPages(0xFFFF);

			// Now MS_Wstate = MS_POSTMARK;
		}
		// Mask off this line if DTC interrupts
	//	goto Label_MS_Write_Interrupt;
		return;

	case MS_HOLENEWWRITE:	// A
	case MS_HOLEOLDWRITE:	// B
#if	ALLOW_ERROR					// TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED
		if (DTC_Error) {
			malRaddr = malPaddr & ~((MS_CBlock_Size == 32)? 0x1F : 0x0F);
			MS_Lookup_Map_Bad();

			MS_Wstate &= ~(MS_FULL_ACTION | MS_WRITE_FLAG);
			MS_Wstate |= MS_ERROR_FLAG;		// ready to mark malRaddr as bad

			malNpage = MS_Ppage + MS_Npage;
			MS_Ppage += MS_Npage - malNpage;	// next time writing start here

			MS_DTC_wCopyPages();

			// Mask off these 2 lines if DTC interrupts
		//	DTC_Error = 0;
		//	goto Label_MS_Write_Interrupt;

			return;
			// Now MS_Wstate = MS_PREMARK or MS_PRECOPY;
		}
#endif

		MS_Ppage += MS_Npage;
		MS_Wstate = (MS_Wstate & MS_OLD_CLUSTER) | MS_POST_ACTION;	// Keep OLD flag
		malNpage = MS_Block_Size - MS_Ppage;	// Pages left to be marked or copied

		goto Post_Mark_Copy;	// The following actions are same as above
	/*
		if (MS_Wstate & MS_OLD_CLUSTER) {
			// This was an overwrite operation, copy the remain pages
			malRaddr = Map_DTC_Addr(MS_Zone, MS_Raddr, MS_Ppage);
			MS_Ppage = malNpage;

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			MS_Wstate = MS_POSTCOPY;	// same as MS_POSTHOLECOPY
			MS_DTC_wCopyPages(malRaddr, MS_Laddr);
		}
		else {
			// This was a new block operation, mark the remain pages
			MS_Ppage = malNpage;

			// Launch the DTC to several several pages start from malPaddr
			MS_Wstate = MS_POSTMARK;	// same as MS_POSTHOLEMARK
			MS_DTC_wMarkPages(0xFFFF);
		}
		return;
	*/

	case MS_POSTMARK:		// 4
	case MS_POSTCOPY:		// 5
	case MS_POSTHOLEMARK:	// C
	case MS_POSTHOLECOPY:	// D
	/*	// These four cases always have the MAL_Block_Numbers == 0
		if (MS_Wstate & MS_OLD_CLUSTER)
			MS_DTC_Erase(MS_Raddr);	// Erase the dirty cluster
		MS_Update_Lookup();

		// All data from the USB has been written to the MS
		MAL_Error = MAL_GOOD;
		MAL_Finish(TRUE);

		MS_DTC_Current_Func = 0;
		return;
	*/
	case MS_PRENEWWRITE:	// 2
	case MS_PREOLDWRITE:	// 3
	case MS_FULLNEWWRITE:	// E
	case MS_FULLOLDWRITE:	// F
#if	ALLOW_ERROR					// TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED ** TO BE DEBUGGED
		if (DTC_Error) {
			malRaddr = malPaddr & ~((MS_Block_Size)? 0x1F : 0x0F);
			MS_Lookup_Map_Bad();

			MS_Wstate &= ~(MS_FULL_ACTION | MS_WRITE_FLAG);
			MS_Wstate |= MS_ERROR_FLAG;		// ready to mark malRaddr as bad

			MS_Npage = malNpage = MS_Block_Size - malNpage;
			MS_Ppage = MS_Npage;

			MS_DTC_wCopyPages();

			// Mask off these 2 lines if DTC interrupts
		//	DTC_Error = 0;
		//	goto Label_MS_Write_Interrupt;

			return;
			// Now MS_Wstate = MS_PREMARK or MS_PRECOPY;
		}
#endif

		// Now we have finished one block
		MS_Update_Lookup();

		if (MAL_Block_Numbers == 0) {
			// All data from the USB has been written to the Memory Stick
			MAL_Error = MAL_GOOD;
			MAL_Finish(TRUE);

			MS_DTC_Current_Func = 0;
			return;
		}

#if ALLOW_OUT_RANGE
		if (Mal_Addr_Out_Range & 0x02) {
			MS_Wstate = MS_OUT_RANGE;
			goto Write_Out_Range;
		}
#endif
		// Further more data to be written to the media
		MS_INC_Logical_Addr();

		MS_Wstate = MS_FULL_ACTION | MS_WRITE_FLAG;
		if (MS_Log2Phy()) {
			// This is an existing blcok
			MS_Wstate |= MS_OLD_CLUSTER;
			MS_Raddr = MS_Paddr;			// old blcok
			MS_Paddr = MS_Get_Free();		// new blcok
		}
		MS_Paddr &= 0x7FFF;
		malPpage = MS_Ppage = 0;

		// the next writing must start from beginning of the block
		malNpage = MS_Block_Size;
		if (malNpage > MAL_Block_Numbers) {
			MS_Wstate &= ~0x08;		// change from MS_FULL_ACTION to MS_POST_ACTION
			malNpage = (unsigned char)MAL_Block_Numbers;
		}
		MS_Npage = malNpage;

		// Launch DTC to write malPpage pages to malPaddr
		_MAL_BufMgr_Download();
		MS_DTC_Write_USB(MAL_Block_Finish&1);

		// Now MS_Wstate = MS_POSTNEWWRITE or MS_POSTOLDWRITE or
		//	   MS_Wstate = MS_FULLNEWWRITE or MS_FULLOLDWRITE
		return;

#if ALLOW_OUT_RANGE
	case MS_OUT_RANGE:
		if (MAL_Block_Numbers == 0) {
			// All data from the USB has been written to the MS
			MAL_Error = MAL_GOOD;
			MAL_Finish(TRUE);

			MS_DTC_Current_Func = 0;
			return;
		}

Write_Out_Range:
	// assume MAL_Block_Numbers < 256
	//	malNpage = MS_Block_Size;
	//	if (malNpage > MAL_Block_Numbers)
	//		malNpage = (unsigned char)MAL_Block_Numbers;
		MS_Npage = malNpage = (unsigned char)MAL_Block_Numbers;
		DTC_MS_Dummy_Write(MAL_Block_Finish & 1);
		return;
#endif
	}

}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Write(void)
{
// Get the logical block address
	MS_Get_Logical_Addr();		// MS_Segment:MS_Laddr:MS_Ppage = MAL_Block_Address
	MAL_Block_Finish = 0;

// Get the physical block address
	MS_Wstate = 0;			// PRE actions, NEW block, no WRITE
	if (MS_Log2Phy()) {
		// This is an existing block
		MS_Wstate |= MS_OLD_CLUSTER;	// PRECOPY may be necessary
		MS_Raddr = MS_Paddr;			// old block
		MS_Paddr = MS_Get_Free();		// new block
	}
	MS_Paddr &= 0x7FFF;

	MS_DTC_Current_Func = MS_FUNC_WRITE_USB;

	if (MS_Ppage) {
		// the new pages are not start from beginning of the block 
		malNpage = MS_Npage = MS_Ppage;
		malPpage = 0;

	//	_MAL_BufMgr_Normal();		// switch back to normal mode first
		if (MS_Wstate & MS_OLD_CLUSTER) {
			// This is a old logical block

			// Launch the DTC to copy several pages
			// Copy malNpage pages from malRaddr to malPaddr
			MS_DTC_wCopyPages();

			// Now MS_Wstate == MS_PRECOPY
		}
		else {
			// This is a new logical block

			// Launch the DTC to mark several pages
			MS_DTC_wMarkPages(0xFFFF);		// Mark the starting pages

			// Now MS_Wstate == MS_PREMARK
		}

		// Mask off this line if DTC interrupts in MS_DTC_wCopyPages() & MS_DTC_wMarkPages(0xFFFF);
	//	DTC_Error = 0;
	//	MS_Write_Interrupt();
	}
	else {
		// the new pages are start from beginning of the block
		malPpage = 0;
		malNpage = MS_Block_Size;
		if (malNpage > MAL_Block_Numbers) {
			// Do not write the whole block
			malNpage = (unsigned char)MAL_Block_Numbers;
			MS_Wstate |= MS_POST_ACTION | MS_WRITE_FLAG;
		}
		else
			MS_Wstate |= MS_FULL_ACTION | MS_WRITE_FLAG;

		MS_Npage = malNpage;

		// Launch DTC to write malPpage pages to malPaddr
		_MAL_BufMgr_Download();		// Switch to DOWNLOAD mode
		MS_DTC_Write_USB(0);

		// Now MS_Wstate = MS_POSTNEWWRITE or MS_POSTOLDWRITE
		//     MS_Wstate = MS_FULLNEWWRITE or MS_FULLOLDWRITE
	}

	return MAL_GOOD;
}

#pragma CONST_SEG MS_CONST

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
// Tables for logical format
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
const unsigned char MBR[6][16] = {
	0x80, 0x01, 0x0C, 0x00, 0x01, 0x01, 0x10, 0xF5, 0x1B, 0x00, 0x00, 0x00, 0xA5, 0x1E, 0x00, 0x00,	// 4MB
	0x80, 0x01, 0x0A, 0x00, 0x01, 0x01, 0x50, 0xED, 0x19, 0x00, 0x00, 0x00, 0xA7, 0x3D, 0x00, 0x00,	// 8MB
	0x80, 0x01, 0x0A, 0x00, 0x01, 0x03, 0x50, 0xED, 0x19, 0x00, 0x00, 0x00, 0x67, 0x7B, 0x00, 0x00,	// 16MB
	0x80, 0x01, 0x04, 0x00, 0x01, 0x03, 0xD0, 0xDD, 0x13, 0x00, 0x00, 0x00, 0x6D, 0xF7, 0x00, 0x00,	// 32MB
	0x80, 0x02, 0x08, 0x00, 0x01, 0x07, 0xD0, 0xDD, 0x27, 0x00, 0x00, 0x00, 0xD9, 0xEE, 0x01, 0x00,	// 64MB
	0x80, 0x02, 0x02, 0x00, 0x06, 0x0F, 0xD0, 0xDD, 0x21, 0x00, 0x00, 0x00, 0xDF, 0xDD, 0x03, 0x00	// 128MB
//                                                  -----------+----------  -----------+----------
// x86 default boot partition|     |     |     |               |                       |
// Start Head No.      |     |     |     |     |               |                       |
// Start Sector No.    |     |     |     |     |               |                       |
// Start Cylinder No.--+     |     |     |     |               |                       |
// Partition type -----------+     |     |     |               |                       |
// End Head No. -------------------+     |     |               |                       |
// End Sector No.------------------------+     |               |                       |
// End Cylinder No.----------------------------+               |                       |
// Start Sector (LBA) -----------------------------------------+                       |
// Number of Sectors  -----------------------------------------------------------------+
};

const unsigned char PBR[6][22] = {
	0x10, 0x01, 0x00, 0x02, 0x00, 0x02, 0xA5, 0x1E, 0xF8, 0x02, 0x00, 0x10, 0x00, 0x02, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,// 0x00,	// 4MB
	0x10, 0x01, 0x00, 0x02, 0x00, 0x02, 0xA7, 0x3D, 0xF8, 0x03, 0x00, 0x10, 0x00, 0x02, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,// 0x00,	// 8MB
	0x20, 0x01, 0x00, 0x02, 0x00, 0x02, 0x67, 0x7B, 0xF8, 0x03, 0x00, 0x10, 0x00, 0x04, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,// 0x00,	// 16MB
	0x20, 0x01, 0x00, 0x02, 0x00, 0x02, 0x6D, 0xF7, 0xF8, 0x06, 0x00, 0x10, 0x00, 0x04, 0x00, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,// 0x00,	// 32MB
	0x20, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0xF8, 0x0C, 0x00, 0x10, 0x00, 0x08, 0x00, 0x27, 0x00, 0x00, 0x00, 0xD9, 0xEE, 0x01,// 0x00,	// 64MB
	0x20, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0xF8, 0x1F, 0x00, 0x10, 0x00, 0x10, 0x00, 0x21, 0x00, 0x00, 0x00, 0xDF, 0xDD, 0x03 // 0x00	// 128MB
//	----  ----------  ----  ----------  ----------  ----  ----------  ----------  ----------  ----------------------  ----------------------
//	Jump code (0xE9, 0x00, 0x00)
//	OEM name and version (ASCII 8 bytes "        ")
//	Number of bytes per sector (0x00, 0x02)
//	Number of sectors in a cluster|         |         |        |           |           |                 |                       |
//	Number of reserved sectors    |         |         |        |           |           |                 |                       |
//	Number of FATs ----+          |         |         |        |           |           |                 |                       |
//	Number of root directory entry+         |         |        |           |           |                 |                       |
//	Total sectors --------------------------+         |        |           |           |                 |                       |
//	Media ID -----------------------------------------+        |           |           |                 |                       |
//	Number of sectors in a FAT --------------------------------+           |           |                 |                       |
//	Number of sectors on a head (track) -----------------------------------+           |                 |                       |
//	Number of heads -------------------------------------------------------------------+                 |                       |
//	Number of hidden sectors ----------------------------------------------------------------------------+                       |
//	Total sectors ---------------------------------------------------------------------------------------------------------------+
//	Drive No (0x00)
//	Reserved (0x00)
//	Extension boot signature (0x29)
//	Volume ID (0x00, 0x00, 0x00, 0x00)
//	Volume label (ASCII 11 bytes 0x00)
//	File system type (ASCII 8 bytes "FAT12   " or "FAT16   "
};

const unsigned char Root_File[12] = {
	'M', 'E', 'M', 'S', 'T', 'I', 'C', 'K',
	'I', 'N', 'D',
	0x03
};

// Clear Buffer_0[]
void Clear_Buffer_0(void)
{
	asm {
		CLR		X
		CLR		A
Clear_Buffer:
		LD		(Buffer_0, X), A
		LD		(Buffer_0:256, X), A
		INC		X
		JRNE	Clear_Buffer
	}
}

// Write the MBR, PBR, FAT, root directory and the dummy file
void Logical_Format(unsigned char iCard)
{
	unsigned char iBlock;
// MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR MBR

	Clear_Buffer_0();
	asm {
		LD		A, iCard
		SWAP	A			// iCard * 16
		ADD		A, #15
		LD		X, A
		LD		Y, #15
Copy_MBR:
		LD		A, (MBR, X)
		LD		(Buffer_0:0x1BE, Y), A
		DEC		X
		DEC		Y
		JRPL	Copy_MBR
	}
	// MBR signature
	Buffer_0[510] = 0x55;
	Buffer_0[511] = 0xAA;
	// Write MBR to physical block 2 and page 0
	MS_Paddr = 2;
	malPpage = 0;
	MS_Logical = 0;
	MS_DTC_Write_Page(0);

// PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR PBR
	Clear_Buffer_0();
	Buffer_0[0x00] = 0xE9;	// Jump code
	Buffer_0[0x03] = ' ';
	Buffer_0[0x04] = ' ';
	Buffer_0[0x05] = ' ';
	Buffer_0[0x06] = ' ';
	Buffer_0[0x07] = ' ';
	Buffer_0[0x08] = ' ';
	Buffer_0[0x09] = ' ';
	Buffer_0[0x0A] = ' ';	// OEM name and version (ASCII 8 bytes)
	Buffer_0[0x0C] = 0x02;	// Number of bytes per secctor
	asm {
		LD		X, iCard
		LD		A, #22
		MUL		X, A

		ADD		A, #21
		LD		X, A

		LD		A, (PBR:-12, X)
		DEC		A
		LD		iBlock, A
		PUSH	A

		LD		Y, #21
Copy_PBR:
		LD		A, (PBR, X)
		LD		(Buffer_0:13, Y), A
		DEC		X
		DEC		Y
		JRPL	Copy_PBR
	}
	Buffer_0[0x26] = 0x29;	// Extension boot signature
	Buffer_0[0x36] = 'F';
	Buffer_0[0x37] = 'A';
	Buffer_0[0x38] = 'T';
	Buffer_0[0x39] = '1';
	Buffer_0[0x3A] = (iCard != 5) ? '2' : '6';
	Buffer_0[0x3B] = ' ';
	Buffer_0[0x3C] = ' ';
	Buffer_0[0x3D] = ' ';	// File system type (ASCII 8 bytes)
	// PBR signature
	Buffer_0[510] = 0x55;
	Buffer_0[511] = 0xAA;
	// Write PBR to physical block 2 and page ??
	asm {
		LD		X, iCard
		SWAP	X
		LD		A, (MBR:8, X)
		LD		malPpage, A
	}

	if (iCard < 2) {
		malPpage &= 0x0F;
		MS_Paddr++;
		MS_Logical++;
	}
	else if (iCard > 3) {
		malPpage &= 0x1F;
		MS_Paddr++;
		MS_Logical++;
	}

	if (malPpage) {
		malNpage = malPpage;
		malPpage = 0;
		MS_DTC_Mark_Pages(0xFFFF);
	}
	MS_DTC_Write_Page(0);

// FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1 FAT1
	Clear_Buffer_0();
	Buffer_0[0] = 0xF8;
	Buffer_0[1] = 0xFF;
	Buffer_0[2] = 0xFF;
	if (iCard == 5)				// 128M, FAT16
		Buffer_0[3] = 0xFF;
	malPpage++;
	MS_DTC_Write_Page(0);

	Clear_Buffer_0();
	for ( ; iBlock; iBlock--) {
		malPpage++;
		if (malPpage == 32) {
			malPpage = 0;
			MS_Paddr++;
			MS_Logical++;
		}
		MS_DTC_Write_Page(0);
	}

// FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2 FAT2
	Clear_Buffer_0();
	Buffer_0[0] = 0xF8;
	Buffer_0[1] = 0xFF;
	Buffer_0[2] = 0xFF;
	if (iCard == 5)
		Buffer_0[3] = 0xFF;
	malPpage++;
	MS_DTC_Write_Page(0);

	Clear_Buffer_0();
	asm {
		POP		A
		LD		iBlock, A
	}
	for ( ; iBlock; iBlock--) {
		malPpage++;
		MS_DTC_Write_Page(0);
	}

// ROOT Directory
	asm {
		LD		X, #11
Copy_Root:
		LD		A, (Root_File, X)
		LD		(Buffer_0, X), A
		DEC		X
		JRPL	Copy_Root
	}
	MS_Paddr++;
	MS_Logical++;
	malPpage = 0;
	MS_DTC_Write_Page(0);

	Clear_Buffer_0();
	for (iBlock = 1; iBlock < 32; iBlock++) {
		malPpage++;
		if (iCard < 2 && malPpage == 16) {
			malPpage = 0;
			MS_Paddr++;
			MS_Logical++;
		}
		MS_DTC_Write_Page(0);
	}

	// Always keep the lookup table for segment 0
	MS_Scan_Lookup_Table(MS_Lookup_pTable = MS_Lookup_Table0, 0);
	// Preload the other lookup tables
	if (iCard != 0) {
		MS_Lookup_Update1(1);
		if (iCard >= 3) {
			MS_Lookup_Update2(2);
			MS_Lookup_Update3(3);
		}
	}
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Read_Capacity(void)
{
	unsigned char	TNS_Index1;

	malPpage = 2;
	MS_Paddr = 0;
Read_Boot_Block:
    MS_DTC_Read_Page(0);
	TNS_Index1 = Buffer_0[0x111];

	MAL_Capacity = 0;
	MS_Block_Size = 32;				// 32 pages per physical block

	if (TNS_Index1 == 0x1E) {		// 4MB
		MAL_Capacity = 7904;	// 8000;
		MS_Capacity = 4;
		MS_Block_Size = 16;			// 16 pages
	}
	else if (TNS_Index1 == 0x3D){	// 8MB
		MAL_Capacity = 15840;	// 16000;
		MS_Capacity = 8;
		MS_Block_Size = 16;			// 16 pages
	}
	else if (TNS_Index1 == 0x7B) {	// 16MB
		MAL_Capacity = 31680;	// 32000;
		MS_Capacity = 16;
	}
	else if (TNS_Index1 == 0xF7) {	// 32MB
		MAL_Capacity = 63424;	// 64000;
		MS_Capacity = 32;
	}
	else if (TNS_Index1 == 0xEF) {	// 64MB
		MAL_Capacity = 126848;	// 128000;
		MS_Capacity = 64;
	}
	else if (TNS_Index1 == 0xDF) {	// 128MB
		MAL_Capacity = 253696;	// 256000;
		MS_Capacity = 128;
	}
	else {
		if (MS_Paddr == 0) {
			MS_Paddr = 1;
			goto Read_Boot_Block;
		}

		return MAL_CARD_UNKNOWN;
	}

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void Erase_All()	// For debugging
{
	for (MS_Paddr = 2; MS_Paddr < 2048; MS_Paddr++)
		MS_DTC_Erase();		

	Logical_Format(3);
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Format(void)
{
	unsigned char status;
	status = MS_Read_Capacity();
	if (status != MAL_GOOD)
		return status;

	malNpage = MS_Block_Size;
	switch (MS_Capacity) {
	case 4:
		MAL_Block_Numbers = 512;
		break;
	case 8:
	case 16:
		MAL_Block_Numbers = 1024;
		break;
	case 32:
		MAL_Block_Numbers = 2048;
		break;
	case 64:
		MAL_Block_Numbers = 4096;
		break;
	case 128:
		MAL_Block_Numbers = 8192;
		break;
	default:
		return MAL_CARD_UNKNOWN;
	}

	MAL_Capacity = MAL_Block_Numbers;
	MAL_Block_Numbers--;

	MS_DTC_Current_Func = MS_FUNC_FORMAT;
	Format_One_Block();

	return MAL_GOOD;
}

// To format another block
void Format_Int(void)
{
	if (DTC_Error & 0x02) {
		if (MS_Retry_Format())
			return;

		MS_DTC_Erase();
		malPpage = 0;
		malNpage = MS_Block_Size;
	//	MS_Paddr = MAL_Block_Numbers;
		MS_DTC_Mark_Pages(0x0FFF);
	}

	MAL_Block_Numbers--;
	if (MAL_Block_Numbers < 2) {
		switch (MS_Capacity) {
		case 4:
			Logical_Format(0);
			break;
		case 8:
			Logical_Format(1);
			break;
		case 16:
			Logical_Format(2);
			break;
		case 32:
			Logical_Format(3);
			break;
		case 64:
			Logical_Format(4);
			break;
		case 128:
			Logical_Format(5);
			break;
		}

		MAL_Block_Numbers = 0;		// Mark the end of format
		MS_DTC_Current_Func = 0;
		MAL_State = MAL_IDLE;
	}
	else {
		malNpage = MS_Block_Size;
		Format_One_Block();
	}
}

unsigned char MS_Verify(void)
{
//	Erase_All();	// For debugging
	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Init(void)
{
	if (MS_Read_Capacity() != MAL_GOOD)
		return MAL_GOOD;

	// Always keep the lookup table for segment 0
	MS_Scan_Lookup_Table(MS_Lookup_pTable = MS_Lookup_Table0, 0);
	// Preload the other lookup tables
	if (MS_Capacity > 4) {
		MS_Lookup_Update1(1);
		if (MS_Capacity > 16) {
			MS_Lookup_Update2(2);
			MS_Lookup_Update3(3);
		}
	}

	return MAL_GOOD;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
unsigned char MS_Check_Write_Protect()
{
	return (MS_DTC_Read_Status() >> 8) & 0x01;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MS_Break()
{
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
void MS_DTC_Int()
{
	DTC_Error = DTCSTATUS & 0x03;

	switch (MS_DTC_Current_Func) {
		// MS_Read interrupts
		case MS_FUNC_READ_USB:
			if (DTC_Error == 0x01) 				// DTC stop with no Error
				DTC_Error = 0;
			else {		// DTC stop with Error
				if (MS_Retry_Read_USB())
					return;
				DTC_Error = 1;
			}

			MS_Read_Interrupt();
			return;

		// MS_write interrupts
		case MS_FUNC_WRITE_USB:
			if (DTC_Error == 0x01)				// DTC stop with no Error
				DTC_Error = 0;
			else {
				if (MS_Retry_Write_USB())
					return;

				DTC_Error = 1;
			}

			MS_Write_Interrupt();
			return;

		// MS_Format interrupts
		case MS_FUNC_FORMAT:
			Format_Int();
			return;
		default:
				return;
	}
}

#pragma NO_RETURN
void MAL_MS_Funcs(void)
{
	// IMPORTANT: The sequence of this jump table can not be changed
	// New line can be appended at the end of the table
	asm {
		jp	MS_Init					// 0
		jp	MS_Read					// 1
		jp	MS_Write				// 2
		jp	MS_Verify				// 3
		jp	MS_Format				// 4
		jp	MS_Read_Capacity		// 5
		jp	MS_Check_Write_Protect	// 6
		jp	MS_Break				// 7
		jp	MS_DTC_Int				// 8
	}
}
