/**************** (c) 2002  STMicroelectronics **********************

PROJECT : ST7265 USB Mass Storage - MS

VERSION :

CREATION DATE :  23/01/2002

AUTHOR :

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : DTC programs for SMC

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/

#ifndef MS_DTC_H
#define MS_DTC_H

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC_Upld[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC_Dwld[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC_Format[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC_Search[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char MS_DTC_Read_FF[];

#pragma CONST_SEG MS_DTC_CODE
const unsigned char DTC_Reg[];

#define CODE_DTC_MS_UPLOAD		0x11
#define CODE_DTC_MS_DOWNLOAD	0x12
#define CODE_DTC_MS_READ_FF		0x13
#define CODE_DTC_MS_SCAN		0x14
#define CODE_DTC_MS				0x15
#define CODE_DTC_MS_FORMAT		0x16
#define CODE_DTC_MS_SEARCH		0x17

/************************************************/
/* Starting Addresses of MS Process in DTC_RAM  */
/************************************************/

#define Run_MS_DTC				0x12
#define Run_MS_DTC_REG			0x00
#define Run_MS_DTC_Dwld			0x0E
#define Run_MS_DTC_Upld			0x0E
#define Run_MS_DTC_Format		0x0E
#define Run_MS_DTC_Search		0x0D

// When there is an error in the DTC execution
// the DTCPC value identifies the error type

#define Err_MS_Dwld_INT_Timeout	0x0E	// Timeout on wait INT signal
#define Err_MS_Dwld_RDY_Timeout	0xA9	// Timeout on wait RDY signal
#define Err_MS_Dwld_Read_CRC	0xE7	// CRC error on read packet
#define Err_MS_Dwld_INT			0xEC	// ERR bit of INT register is set

#define Err_MS_Upld_INT_Timeout	0x0E	// Timeout on wait INT signal
#define Err_MS_Upld_RDY_Timeout	0x7D	// Timeout on wait RDY signal
#define Err_MS_Upld_Read_CRC	0xE2	// CRC error on read packet
#define Err_MS_Upld_INT			0xFC	// ERR bit of INT register is set

#define Err_MS_Format_INT_Timeout	0x0E	// Timeout on wait INT signal
#define Err_MS_Format_RDY_Timeout	0x9D	// Timeout on wait RDY signal
#define Err_MS_Format_Read_CRC		0xE9	// CRC error on read packet
#define Err_MS_Format_INT			0xF1	// ERR bit of INT register is set
#define Err_MS_Format_Page			0x00	// Error on comparing page CRC

#endif

/*** (c) 1998   STMicroelectronics ****************** END OF FILE ***/




