/****************** (c) 2002  STMicroelectronics *****************************

PROJECT : ST7

VERSION : MS_Mass.c

CREATION DATE :

AUTHOR :

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

REM: 

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS :

******************************************************************************/
#include "Map_7265.h"
#include "MAL_Map.h"
#include "MAL_MS.h"
#include "DTC_Func.h"
#include "MS_DTC.h"
#include "MS_Mass.h"
#include "lib_bits.h"

extern unsigned char DTC_Code_Number;

#pragma CODE_SEG MS_CODE

/*-----------------------------------------------------------------------------
ROUTINE NAME : DTC_MS_Read_FF
INPUT/OUTPUT : none/none
DESCRIPTION  :
-----------------------------------------------------------------------------*/
void DTC_MS_Read_FF(void)
{
	if (DTC_Code_Number != CODE_DTC_MS_READ_FF) {
		DTC_Load_Code(MS_DTC_Read_FF);
		DTC_Code_Number = CODE_DTC_MS_READ_FF;
	}

	BUFSR = 0x01;		// Clear Buffer status
	BUFSR = 0;

	Buffer_Param[0x3F] = malNpage;	// Nb of Sectors processed
	
	Enable_DTC_Int();
	DTC_Process(0);
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////

#include "define.h"

void Load_MS_DTC_Code(void)
{
	if (DTC_Code_Number != CODE_DTC_MS) {
		// Set MemoryStick CRC Polynomia
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0
		SetBit(DTCCTRL,5);		// POLY_LOAD = 1
		DTCCRC_RESERVED = 0x05;	// Write CRC_LSB
		SetBit(DTCCTRL,6);		// POLY_H = 1
		DTCCRC_RESERVED = 0x80;	// Write CRC_MSB
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0

		DTC_Load_Code(MS_DTC);
		DTC_Code_Number = CODE_DTC_MS;
	}
}

void Load_MS_DTC_Upld(void)
{
	if (DTC_Code_Number != CODE_DTC_MS_UPLOAD) {
		// Set MemoryStick CRC Polynomia
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0
		SetBit(DTCCTRL,5);		// POLY_LOAD = 1
		DTCCRC_RESERVED = 0x05;	// Write CRC_LSB
		SetBit(DTCCTRL,6);		// POLY_H = 1
		DTCCRC_RESERVED = 0x80;	// Write CRC_MSB
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0

		DTC_Load_Code(MS_DTC_Upld);
		DTC_Code_Number = CODE_DTC_MS_UPLOAD;
	}
}

// DTC_Dwld_Flag is used to flag what is the operation of MS_DTC_Dwld
static unsigned char Retry_Counter;
static unsigned char DTC_Dwld_Flag;
#define DTC_DWLD_ERASE	1
#define DTC_DWLD_COPY	2
#define DTC_DWLD_MARK	3
#define DTC_DWLD_WRITE	4

void Load_MS_DTC_Dwld(void)
{
	if (DTC_Code_Number != CODE_DTC_MS_DOWNLOAD) {
		// Set MemoryStick CRC Polynomia
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0
		SetBit(DTCCTRL,5);		// POLY_LOAD = 1
		DTCCRC_RESERVED = 0x05;	// Write CRC_LSB
		SetBit(DTCCTRL,6);		// POLY_H = 1
		DTCCRC_RESERVED = 0x80;	// Write CRC_MSB
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0

		DTC_Load_Code(MS_DTC_Dwld);
		DTC_Code_Number = CODE_DTC_MS_DOWNLOAD;

		DTC_Dwld_Flag = 0;
	}
}

void Read_DTC_Registers(void)
{
	extern unsigned char DTC_RAM[256];	// RAM DTC
	unsigned char *pDTC_Code;

	DTCCTRL |= DTC_LOAD;		// Start the ram load processes
	asm {
		LD		X, #0x24
load_code:
		LD		A, (DTC_Reg, X)
		LD		(DTC_RAM, X), A
		DEC		X
		JRPL	load_code
	}

	DTCCTRL &= (~DTC_LOAD);		// Stop the ram load processus

	DTC_Process(0);
	asm {
		LD		X, #10
loop_wait:
		DEC		X
		JRPL	loop_wait
		LD		A, DTCSTATUS	// Load the status reg to clear the flag
	}

	// reload the previous code
	switch (DTC_Code_Number) {
	case CODE_DTC_MS_UPLOAD:
		pDTC_Code = MS_DTC_Upld;
		break;
	case CODE_DTC_MS_DOWNLOAD:
		pDTC_Code = MS_DTC_Dwld;
		break;
	case CODE_DTC_MS_FORMAT:
		pDTC_Code = MS_DTC_Format;
		break;
	case CODE_DTC_MS_SEARCH:
		pDTC_Code = MS_DTC_Search;
		break;
	case CODE_DTC_MS:
		pDTC_Code = MS_DTC;
		break;
	}

	DTCCTRL |= DTC_LOAD;		// Start the ram load processes
	asm {
		LD		X, #0x24
reload_code:
		LD		A, ([pDTC_Code.w], X)
		LD		(DTC_RAM, X), A
		DEC		X
		JRNE	reload_code
	}
	DTC_RAM[0] = *pDTC_Code;
	DTCCTRL &= (~DTC_LOAD);		// Stop the ram load processus
}

// Sample of ROM contents
// 16M: 01, 01, 02, 01, 10, 10, 02, 10, 00, 10, 21, 21, 01, FF, FF, FF
// 32M: 04, 01, 02, 01, 20, 10, 02, 10, 00, 20, 21, 21, 01, FF, FF, FF
// 64M: 03, 01, 02, 02, 40, 10, 02, 10, 00, 40, 21, 21, 01, FF, FF, FF
// 128M:04, 01, 02, 01, 40, 10, 02, 10, 00, 80, 21, 21, 01, FF, FF, FF
//											**
// Do not know the format.		This sounds the capacity.
const unsigned char Read_ROM_Param[] = {
	SET_CMD,
	1,
	RESET,
// 3
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,
	0x03,
	0x10,
	0x01,
// 9
	WRITE_REG,
	1,					// 1 bytes to be written
	0x40,				// SystemParameterReg
// 12
	READ_PAGE_DATA,
	0x01,				// Bulk read
	0x01,				// Start segment
	0x03,				// End segment
	0
};

void MS_DTC_Read_ROM(void)
{
	Load_MS_DTC_Code();

	asm {
		LD		X, #16	// sizeof(Read_ROM_Param) - 1
Copy_Param:
		LD		A, (Read_ROM_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}
	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address
	No_DTC_Int();
	DTC_Process(Run_MS_DTC);
	DTC_Wait_Stop();
}

const unsigned char Read_Status_Param[] = {
	SET_CMD,
	1,
	RESET,
// 3
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,
	0x03,
	0x10,
	0x06,
// 9
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 14
	0x00
};

// Return StatusReg0 on HIBYTE & StatusReg1 on LOBYTE
unsigned short MS_DTC_Read_Status(void)
{
	Load_MS_DTC_Code();

	asm {
		LD		X, #14	// sizeof(Read_Status_Param) - 1
Copy_Param:
		LD		A, (Read_Status_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address

	No_DTC_Int();
	DTC_Process(Run_MS_DTC);
	DTC_Wait_Stop();

	// INT_Register = Buffer_Param[11];
	// StatusRegister0 = Buffer_Param[12];
	// StatusRegister1 = Buffer_Param[13];
	return *((unsigned short*)(Buffer_Param + 12));
}

const unsigned char Read_Page_Param[] = {
	SET_CMD,
	1,
	RESET,
// 3
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,
	0x03,
	0x10,
	0x06,
// 9
	WRITE_REG,
	6,					// 6 bytes to be written
	0x80,				// SystemParameterReg
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x20,				// CommandParamReg: Page Access
	0x00,				// PageAdrReg
// 17
	SET_CMD,
	1,
	BLOCK_READ,
// 20
	0xFF,				// Wait on INT
	0x3A,				// Timeout in 5ms
	0x98,				// Timeout in 5ms
// 23
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 28
	READ_PAGE_DATA,
	0x00,				// Bulk read
	0x01,				// Start segment
	0
};

unsigned char MS_DTC_Read_Page(unsigned char buf01)
{
	Load_MS_DTC_Code();

	asm {
		LD		X, #31	// sizeof(Read_Page_Param) - 1
Copy_Param:
		LD		A, (Read_Page_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}
	Buffer_Param[13] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[14] = ((unsigned char *)(&(malPaddr)))[3];
	Buffer_Param[16] = malPpage;

	if (buf01)
		Buffer_Param[30] = 0x03;	// start segment

	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address

	No_DTC_Int();
	DTC_Process(Run_MS_DTC);
	DTC_Wait_Stop();

	// INT_Register = Buffer_Param[25];
	// StatusRegister0 = Buffer_Param[26];
	// StatusRegister1 = Buffer_Param[27];
}

const unsigned char Write_Page_Param[] = {
	SET_CMD,
	1,
	RESET,
// 3
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,
	0x03,
	0x10,
	0x0A,
// 9
	WRITE_REG,
	10,					// 6 bytes to be written
	0x80,				// SystemParameterReg
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x20,				// CommandParamReg: Page Access
	0x00,				// PageAdrReg
	0xFF,				// OverwriteFlag
	0xFF,				// ManagementFlag
	0x00,				// Logical Address
	0x00,				// Logical Address
// 21
	WRITE_PAGE_DATA,
	0x00,				// Page write
	0x01,				// Start segment
// 24
	SET_CMD,
	1,
	BLOCK_WRITE,
// 27
	0xFF,				// Wait on INT
	0x75,				// Timeout in 10ms
	0x30,				// Timeout in 10ms
// 30
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes

	0
};

unsigned char MS_DTC_Write_Page(unsigned char buf01)
{
	Load_MS_DTC_Code();

	asm {
		LD		X, #35	// sizeof(Write_Page_Param) - 1
Copy_Param:
		LD		A, (Write_Page_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}
	Buffer_Param[13] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[14] = ((unsigned char *)(&(malPaddr)))[3];
	Buffer_Param[16] = malPpage;

	Buffer_Param[19] = MS_Logical >> 8;
	Buffer_Param[20] = MS_Logical;

	if (buf01)
		Buffer_Param[23] = 0x03;	// start segment

	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address

	No_DTC_Int();
	DTC_Process(Run_MS_DTC);
	DTC_Wait_Stop();

	// INT_Register = Buffer_Param[33];
	// StatusRegister0 = Buffer_Param[34];
	// StatusRegister1 = Buffer_Param[35];
}

const unsigned char wErase_Param[] = {
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x04,				// Write 4 registers
// 6
	WRITE_REG,
	4,					// 4 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
// 12
	SET_CMD,
	1,
	BLOCK_ERASE,
// 15
	0xFF,				// Wait on INT
// 16
	GET_INT,
	0x55,				// Reserve 1 bytes
// 18
	0x00,				// End of the loop
	0xC0 + 21,			// Virtual pointer for loop control
	0x01,				// Loop counter
	0x00,				// N/A. The pointer of the repeat parameter list
	0x00				// Finish the execution
};

unsigned char MS_DTC_wErase(void)
{
	Load_MS_DTC_Dwld();

	asm {
		LD		X, #22	// sizeof(wErase_Param) - 1
Copy_Param:
		LD		A, (wErase_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];

	Buffer_Param[0x3f] = 0xC0;		// DTC pointer of the parameter list

	DTC_Dwld_Flag = DTC_DWLD_ERASE;

	No_DTC_Int();
	DTC_Process(Run_MS_DTC_Dwld);
	for (Retry_Counter = 0; Retry_Counter < 4; ) {
		if (DTC_Wait_Stop() & 0x02) {
			if (MS_Retry_Write_USB() == 0)
				return 1;		// Error on erase
		}
		else
			break;
	}

	if ((Buffer_Param[17] & 0xC0) == 0x80)
		return 0;
	else
		return 1;		// Error on erase
}

const unsigned char Block_Erase_Param[] = {
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x04,				// Write 4 registers
// 6
	WRITE_REG,
	4,					// 4 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
// 12
	SET_CMD,
	1,
	BLOCK_ERASE,
// 15
	0xFF,				// Wait on INT
	0xFF,				// Timeout in maximum value, about 21.84ms
	0xFF,				// Timeout in maximum value, about 21.84ms
// 18
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes

	0
};

unsigned char MS_DTC_Erase(void)
{
	// TESTING PROTECTION; TO DO NOT ERASE THE BOOT BLOCKS
	if (malPaddr == 0 || malPaddr == 1)
		return;

	if (DTC_Code_Number != CODE_DTC_MS)
		return MS_DTC_wErase();

	asm {
		LD		X, #23	// sizeof(Block_Erase_Param) - 1
Copy_Param:
		LD		A, (Block_Erase_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}
	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];

	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address

	No_DTC_Int();
	DTC_Process(Run_MS_DTC);
	if (DTC_Wait_Stop() & 0x02)
		return 1;		// Error on erase

	if ((Buffer_Param[20] & 0xC0) == 0x80)
		return 0;
	else
		return 1;		// Error on erase
	// INT_Register = Buffer_Param[20];
	// StatusRegister0 = Buffer_Param[21];
	// StatusRegister1 = Buffer_Param[22];
}

const unsigned char Mark_Pages_Param[] = {
	SET_R_W_REG_ADRS,
	4,
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 6
	WRITE_REG,
	10,					// 10 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x40,				// 1-page access of Extra Data Area only
	0x00,				// Page Number
	0xFF,				// OverWriteFlag: BKST=1, PGS0,1=3, UDST=1
	0xFF,				// ManagementFlag: SCMS0,1=3, ATFLG=1, SYSFLG=1
	0x00,				// High byte of logical address
	0x00,				// Low byte of logical address
// 18
	SET_CMD,
	1,
	BLOCK_WRITE,
// 21
	0xFF,				// Wait on INT
	0x75,				// Timeout in 10ms
	0x30,				// Timeout in 10ms
// 24
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 29
	0
};

const unsigned char wMark_Pages_Param[] = {
	SET_R_W_REG_ADRS,
	4,
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 6
	WRITE_REG,
	10,					// 10 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
	0x40,				// CommandParamReg: 1-page access of ExtraDataArea only
	0x00,				// Page Number					<<<<<<<<<<<<<<<
	0xFF,
	0xFF,
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
// 18
	SET_CMD,
	1,
	BLOCK_WRITE,
// 21
	0xFF,				// Wait on INT
// 22
	GET_INT,
	0x55,				// Reserve 1 bytes
// 24
	0x00,				// End of the loop
	0xC0 + 13,			// Address of page number for loop control
	0x20,				// Loop counter
	0xC0 + 6,			// The pointer of the repeat parameter list
	0x00				// Finish the execution
};

void MS_DTC_wMarkPages(unsigned short Flag)
{
	Load_MS_DTC_Dwld();

	asm {
		LD		X, #28	// sizeof(wMark_Pages_Param) - 1
Copy_Param:
		LD		A, (wMark_Pages_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];

	Buffer_Param[13] = malPpage;	// Starting page
//	Buffer_Param[14] = Flag >> 8;	// OverWriteFlag
//	Buffer_Param[15] = Flag;		// ManagementFlag
	Buffer_Param[16] = MS_Logical >> 8;
	Buffer_Param[17] = MS_Logical;

	Buffer_Param[26] = malNpage;	// Number of pages as loop counter

	Buffer_Param[0x3f] = 0xC0;		// DTC pointer of the parameter list

	DTC_Dwld_Flag = DTC_DWLD_MARK;

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Dwld);

	Retry_Counter = 0;
}

void MS_DTC_Mark_Pages(unsigned short Flag)
{
	if (DTC_Code_Number != CODE_DTC_MS)
		Load_MS_DTC_Code();

	asm {
		LD		X, #29	// sizeof(Mark_Pages_Param) - 1
Copy_Param:
		LD		A, (Mark_Pages_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	No_DTC_Int();
//	Buffer_Param[14] = Flag >> 8;	// OverWriteFlag
//	Buffer_Param[15] = Flag;		// ManagementFlag

	Buffer_Param[16] = MS_Logical>>8;	// High byte of logical address
	Buffer_Param[17] = MS_Logical;		// Low byte of logical address
	Buffer_Param[0x3f] = 0xC0;			// Parameter list start address
	for ( ; malNpage; malNpage--, malPpage++) {
		Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
		Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];
		Buffer_Param[13] = malPpage;
		DTC_Process(Run_MS_DTC);
		DTC_Wait_Stop();
	}
}

const unsigned char wCopy_Page_Param[] = {
// Read out the page to internal PageBuffer
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 6
	WRITE_REG,
	10,
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
	0x20,				// CommandParamReg: 1-page access of Data Area + Extra Data Area
	0x00,				// Page Number					<<<<<<<<<<<<<<<
	0xFF,
	0xFF,
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
// 18
	SET_CMD,
	1,
	BLOCK_READ,
// 21
	0xFF,				// Wait on INT
// 22
	GET_INT,
	0x55,				// Reserve 1 bytes
// 24
// Write the page back to the new block from internal PageBuffer
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x12,				// Write Start from REG 12h
	0x02,				// Write 2 registers
// 30
	WRITE_REG,
	2,
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
// 34
	SET_CMD,
	1,
	BLOCK_WRITE,
// 37
	0xFF,				// Wait on INT
// 38
	GET_INT,
	0x55,				// Reserve 1 bytes
// 40
	0x00,				// End of the loop
	0xC0 + 13,			// Address of page number for loop control
	0x20,				// Loop counter
	0xC0,				// The pointer of the repeat parameter list
	0x00				// Finish the execution
};

void MS_DTC_wCopyPages(void)
{
	Load_MS_DTC_Dwld();

	asm {
		LD		X, #44	// sizeof(wCopy_Page_Param) - 1
Copy_Param:
		LD		A, (wCopy_Page_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	Buffer_Param[10] = ((unsigned char *)(&(malRaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malRaddr)))[3];

	Buffer_Param[32] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[33] = ((unsigned char *)(&(malPaddr)))[3];

	Buffer_Param[13] = malPpage;
	Buffer_Param[16] = MS_Logical >> 8;
	Buffer_Param[17] = MS_Logical;

	Buffer_Param[42] = malNpage;	// Number of pages as loop counter

	Buffer_Param[0x3f] = 0xC0;		// DTC pointer of the parameter list

	DTC_Dwld_Flag = DTC_DWLD_COPY;

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Dwld);

	Retry_Counter = 0;
}

const unsigned char Copy_Page_Param[] = {
	// Read out the page to internal PageBuffer
//	SET_CMD,
//	1 ,
//	RESET,

	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x06,				// Write 6 registers
// 6
	WRITE_REG,
	6,
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x20,				// Command parameter: 1-page access of Data Area + Extra Data Area
	0x00,				// Page Number
// 14
	SET_CMD,
	1,
	BLOCK_READ,
// 17
	0xFF,				// Wait on INT
	0x3A,				// Timeout in 5ms
	0x98,				// Timeout in 5ms
// 20
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 25
	// Write the page back to the new block from internal PageBuffer
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 31
	WRITE_REG,
	10,
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x20,				// Command parameter: 1-page access of Data Area + Extra Data Area
	0x00,				// Page Number
	0xFF,
	0xFF,
	0x00,				// Logical Address
	0x00,				// Logical Address
// 43
	SET_CMD,
	1,
	BLOCK_WRITE,
// 46
	0xFF,				// Wait on INT
	0x75,				// Timeout in 10ms
	0x30,				// Timeout in 10ms
// 49
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 54
	0					// Finish the procedure
};

void MS_DTC_Copy_Pages(void)
{
	if (DTC_Code_Number != CODE_DTC_MS)
		Load_MS_DTC_Code();

	asm {
		LD		X, #54	// sizeof(Copy_Page_Param) - 1
Copy_Param:
		LD		A, (Copy_Page_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	// Set the block address read from
	Buffer_Param[10] = ((unsigned char *)(&(malRaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malRaddr)))[3];

	// Set the block address write to
	Buffer_Param[35] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[36] = ((unsigned char *)(&(malPaddr)))[3];

	Buffer_Param[41] = MS_Logical >> 8;
	Buffer_Param[42] = MS_Logical;

	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address
	No_DTC_Int();
	for ( ; malNpage; malNpage--, malPpage++) {
		Buffer_Param[13] =
		Buffer_Param[38] = malPpage;

		DTC_Process(Run_MS_DTC);
		DTC_Wait_Stop();
	}
}

const unsigned char Read_USB1_Param[] = {	// Read one page only
	SET_R_W_REG_ADRS,
	4,
	0x16,				// Read start from REG 16H
	0x04,				// Read 4 registers
	0x10,				// Write Start from REG 10H
	0x06,				// Write 6 registers
// 6
	WRITE_REG,
	6,					// 6 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
	0x20,				// CommandParamReg: Page Access
	0x00,				// Page Number					<<<<<<<<<<<<<<<
// 14
	SET_CMD,
	1,
	BLOCK_READ,
// 17
	0xFF,				// Wait on INT
// 18
	GET_INT,
	1,
	0x55,				// Reserve 1 bytes
// 21
	READ_REG,
	4,
	0x55,
	0x55,
	0x55,
	0x55,				// Reserve 4 bytes
// 27
	READ_PAGE_DATA,
	0,					// This is a page read
	0x05,				// 0101b = Start from buffer0; 0011b = Start from buffer1
// 30
	0x00,				// End of the loop
	0x01,				// Number of pages. Only read one page
// 32
	0x00,				// No loop body
	0x00				// End of the parameter lists
};

const unsigned char Read_USB_Param[] = {
	SET_R_W_REG_ADRS,
	4,
	0x16,				// Read start from REG 16H
	0x04,				// Read 4 registers
	0x10,				// Write Start from REG 10H
	0x06,				// Write 6 registers
// 6
	WRITE_REG,
	6,					// 6 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
	0x00,				// CommandParamReg: Block Access
	0x00,				// Page Number					<<<<<<<<<<<<<<<
// 14
	SET_CMD,
	1,
	BLOCK_READ,
// 17
	0xFF,				// Wait on INT
// 18
	GET_INT,
	1,
	0x55,				// Reserve 1 bytes
// 21
	READ_REG,
	4,
	0x55,
	0x55,
	0x55,
	0x55,				// Reserve 4 bytes
// 27					// REPEAT POINT - REPEAT POINT - REPEAT POINT
	READ_PAGE_DATA,
	0,					// This is a page read
	0x05,				// 0101b = Start from buffer0; 0011b = Start from buffer1
// 30
	0xFF,				// Wait on INT
// 31
	GET_INT,
	1,
	0x55,				// Reserve 1 bytes
// 34
	READ_REG,
	4,
	0x55,
	0x55,
	0x55,
	0x55,				// Reserve 4 bytes
// 40
	0x00,				// End of the loop
	0x20,				// Number of pages
	0xC0+27,			// Start address of the loop body
// 43
	SET_CMD,
	1,
	BLOCK_END,
// 46
	READ_PAGE_DATA,
	0,					// This is a page read
	0x03,				// Default is buffer 1. 0101b = buffer0; 0011b = buffer1
// 49
	0xFF,				// Wait on INT
// 50
	GET_INT,
	1,
	0x55,				// Reserve 1 bytes
// 53
	0x00,				// End of the loop
	0x01,				// Number of pages. This is the last page
	0x00,				// No loop body
	0x00				// End of the parameter lists
};

void MS_DTC_Read_USB(void)
{
	Load_MS_DTC_Upld();

	if (malNpage != 1) {
		asm {
			LD		X, #56	// sizeof(Read_USB_Param) - 1
Copy_Param:
			LD		A, (Read_USB_Param, X)
			LD		(Buffer_Param, X), A
			DEC		X
			JRPL	Copy_Param
		}
		Buffer_Param[41] = malNpage-1;
		if (malNpage & 1)				// Check where is the last page (buf0/1)
			Buffer_Param[48] = 0x05;	// Start from buffer0
	}
	else {
		asm {
			LD		X, #33	// sizeof(Read_USB1_Param) - 1
Copy1_Param:
			LD		A, (Read_USB1_Param, X)
			LD		(Buffer_Param, X), A
			DEC		X
			JRPL	Copy1_Param
		}
	}

	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];
	Buffer_Param[13] = malPpage;

	Buffer_Param[0x3f] = 0xC0;		// DTC pointer of the parameter list

	// Always start from Buffer0
	while (BUFSR & 0x06);		// Wait both buffer are empty
	BUFSR = 0x01;				// Clear Buffer status
	BUFSR = 0;

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Upld);

	Retry_Counter = 0;
}

const unsigned char Read_USB_Get_Status[] = {
	SET_R_W_REG_ADRS,
	4,
	0x01,				// Read start from REG 01H
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10H
	0x06,				// Write 6 registers
// 6
	READ_REG,
	3,
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 11
	SET_R_W_REG_ADRS,
	4,
	0x16,				// Read start from REG 16H
	0x04,				// Read 4 registers
	0x10,				// Write Start from REG 10H
	0x06,				// Write 6 registers
// 17
	0x00,				// End of the loop
	0x01,				// Number of pages. Only read one page
// 19
	0x00,				// No loop body
	0x00				// End of the parameter lists
};

unsigned char MS_Retry_Read_USB(void)
{
	unsigned char Err_DTCPC;
	unsigned char ADR00;

	if (Retry_Counter >= 3)
		return 0;

	Err_DTCPC = DTCPC;
	No_DTC_Int();
	Read_DTC_Registers();

	ADR00 = Buffer_Param[-15];
	if (Err_DTCPC == Err_MS_Upld_RDY_Timeout) {
		if (ADR00 == (0xC0 + 6))			// Error on SET_R_W_REG_ADRS
			Buffer_Param[0x3f] = 0xC0;		// Retry SET_R_W_REG_ADRS
		else if (ADR00 == (0xC0 + 14))		// Error on WRITE_REG
			Buffer_Param[0x3f] = 0xC0 + 6;	// Retry WRITE_REG
		else if (ADR00 == (0xC0 + 17))		// Error on SET_CMD(BLOCK_READ)
			Buffer_Param[0x3f] = 0xC0 + 14;	// Retry SET_CMD(BLOCK_WRITE)
		else if (ADR00 == (0xC0 + 46))		// Error on SET_CMD(BLOCK_END)
			Buffer_Param[0x3f] = 0xC0 + 43;	// Retry SET_CMD(BLOCK_END)
		else
			return 0;
	}
	else if (Err_DTCPC == Err_MS_Upld_Read_CRC) {
		if (ADR00 == (0xC0 + 30)) {			// Error on READ_PAGE_DATA
Retry_Read_Pages:
			// Reset the card for retry
			Buffer_Param[0] = SET_CMD;
			Buffer_Param[1] = 1;
			Buffer_Param[2] = RESET;
			Buffer_Param[3] = 0x00;			// End of the loop
			Buffer_Param[4] = 0x01;			// Number of pages. Only read one page
			Buffer_Param[5] = 0x00;			// End of the parameter lists
			Buffer_Param[0x3f] = 0xC0;
			DTC_Process(Run_MS_DTC_Upld);

			if (malNpage != 1) {
				malPpage += malNpage - (Buffer_Param[41] + 1);
				malNpage = Buffer_Param[41] + 1;
			}
			DTC_Wait_Stop();
			MS_DTC_Read_USB();
			return 1;
		}
		else if (ADR00 == (0xC0 + 49)) {	// Error on READ_PAGE_DATA
			malPpage += malNpage - 1;
			malNpage = 1;
			goto Retry_Read_Pages;			// Retry the last page
		}
		// Below cases are errors on reading registers
		// Just try to read the register again
		else if (ADR00 == (0xC0 + 21))		// Error on GET_INT
			Buffer_Param[0x3f] = 0xC0 + 18;	// Retry parameter address
		else if (ADR00 == (0xC0 + 27))		// Error on READ_REG
			Buffer_Param[0x3f] = 0xC0 + 21;	// Retry parameter address
		else if (ADR00 == (0xC0 + 34))		// Error on GET_INT
			Buffer_Param[0x3f] = 0xC0 + 31;	// Retry parameter address
		else if (ADR00 == (0xC0 + 40))		// Error on READ_REG
			Buffer_Param[0x3f] = 0xC0 + 34;	// Retry parameter address
		else if (ADR00 == (0xC0 + 53))		// Error on GET_INT
			Buffer_Param[0x3f] = 0xC0 + 50;	// Retry parameter address
		else
			return 0;
	}
	else if (Err_DTCPC == Err_MS_Upld_INT) {
		// See if the error is recoverable (ECC error)
		asm {
			LD		X, #20	// sizeof(Read_USB_Get_Status) - 1
Copy_Param:
			LD		A, (Read_USB_Get_Status, X)
			LD		(Buffer_Param:-32, X), A
			DEC		X
			JRPL	Copy_Param
		}
		Buffer_Param[0x3f] = 0xA0;
		DTC_Process(Run_MS_DTC_Upld);
		DTC_Wait_Stop();

		if ( (Buffer_Param[8-32] & 0x60) == 0x60	// ERR=1 & BREQ=1
			&& (Buffer_Param[10-32] & 0x15) == 0 ) {	// UCDT|UCEX|UCFG=0
			Buffer_Param[0x3f] = ADR00;
		}
		else
			return 0;
	}
	else if (Err_DTCPC == Err_MS_Upld_INT_Timeout)
		// This could be caused by defected blocks
		return 0;
	else
		return 0;

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Upld);			// Retry the operation
	Retry_Counter++;
	return 1;
}

const unsigned char Write_USB_Param[] = {
	SET_R_W_REG_ADRS,
	4,
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 6
	WRITE_REG,
	10,					// 10 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]	<<<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<<
	0x00,				// CommandParamReg: Block Access
	0x00,				// Page Number					<<<<<<<<<<<<<<<
	0xFF,				// OverwriteFlag
	0xFF,				// ManagementFlag
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
	0x00,				// Logical Address				<<<<<<<<<<<<<<<
// 18
	SET_CMD,
	1,
	BLOCK_WRITE,
// 21
	0xFF,				// Wait on INT
// 22
	GET_INT,
	0x55,				// Reserve 1 bytes
// 24					// REPEAT POINT - REPEAT POINT - REPEAT POINT
	WRITE_PAGE_DATA,
	0,
	0x05,				// Buffer flag. 0x05=Buffer0; 0x03=Buffer1
// 27
	0xFF,				// Wait on INT
// 28
	GET_INT,
	0x55,				// Reserve 1 bytes
// 30
	0x00,				// End of the loop
	0xC0 + 13,			// Address of page number for loop control
	0x20,				// Number of pages
	0xC0 + 24,			// The pointer of the repeat parameter list
// 34
	SET_CMD,
	1,
	BLOCK_END,
// 37
	0xFF,
// 38
	GET_INT,
	0x55,				// Reserve 1 bytes
// 40
	0x00,				// End of the loop
	0xC0 + 43,			// Virtual pointer for loop control
	0x01,				// Number of page. Alway is 1
	0x00,				// N/A. The pointer of the repeat parameter list
	0x00				// Finish the execution
};

void MS_DTC_Write_USB(unsigned char buf01)
{
	Load_MS_DTC_Dwld();

	asm {
		LD		X, #44	// sizeof(Write_USB_Param) - 1
Copy_Param:
		LD		A, (Write_USB_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}

	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];
	Buffer_Param[13] = malPpage;
	Buffer_Param[16] = MS_Logical >> 8;
	Buffer_Param[17] = MS_Logical;

	Buffer_Param[32] = malNpage;	// Number of pages
	if (buf01)
		Buffer_Param[26] = 0x03;	// Start from buffer_1

	Buffer_Param[0x3f] = 0xC0;		// DTC pointer of the parameter list

	DTC_Dwld_Flag = DTC_DWLD_WRITE;

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Dwld);

	Retry_Counter = 0;
}

unsigned char MS_Retry_Write_USB(void)
{
	unsigned char Err_DTCPC;
	unsigned char ADR00;

	if (Retry_Counter >= 3)
		return 0;

	Err_DTCPC = DTCPC;
	Read_DTC_Registers();

	ADR00 = Buffer_Param[-15];
	if (Err_DTCPC == Err_MS_Dwld_RDY_Timeout) {
		if (DTC_Dwld_Flag == DTC_DWLD_WRITE) {
			if (ADR00 == (0xC0+6))				// Error on SET_R_W_REG_ADRS
				Buffer_Param[0x3f] = 0xC0;		// Retry SET_R_W_REG_ADRS
			else if (ADR00 == (0xC0+18))		// Error on WRITE_REG
				Buffer_Param[0x3f] = 0xC0 + 6;	// Retry WRITE_REG
			else if (ADR00 == (0xC0+21))		// Error on SET_CMD(BLOCK_WRITE)
				Buffer_Param[0x3f] = 0xC0 + 18;	// Retry SET_CMD(BLOCK_WRITE)
			else if (ADR00 == (0xC0+27)) {		// Error on write a page
				if (Buffer_Param[26] == 0x03)	// Retry on the same buffer (0 or 1)
					Buffer_Param[26] = 0x05;
				else
					Buffer_Param[26] = 0x03;

				Buffer_Param[0x3f] = 0xC0 + 24;	// Retry parameter address
			}
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_COPY) {
			if (ADR00 == (0xC0+6))				// Error on SET_R_W_REG_ADRS
				Buffer_Param[0x3f] = 0xC0;		// Retry SET_R_W_REG_ADRS
			else if (ADR00 == (0xC0+18))		// Error on WRITE_REG
				Buffer_Param[0x3f] = 0xC0 + 6;	// Retry WRITE_REG
			else if (ADR00 == (0xC0+21))		// Error on SET_CMD(BLOCK_READ)
				Buffer_Param[0x3f] = 0xC0 + 18;	// Retry SET_CMD(BLOCK_READ)
			else if (ADR00 == (0xC0+30))		// Error on SET_R_W_REG_ADRS
				Buffer_Param[0x3f] = 0xC0 + 24;	// Retry SET_R_W_REG_ADRS
			else if (ADR00 == (0xC0+34))		// Error on WRITE_REG
				Buffer_Param[0x3f] = 0xC0 + 30;	// Retry WRITE_REG
			else if (ADR00 == (0xC0+37))		// Error on SET_CMD(BLOCK_WRITE)
				Buffer_Param[0x3f] = 0xC0 + 34;	// Retry SET_CMD(BLOCK_WRITE)
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_MARK) {
			if (ADR00 == (0xC0+6))				// Error on SET_R_W_REG_ADRS
				Buffer_Param[0x3f] = 0xC0;		// Retry SET_R_W_REG_ADRS
			else if (ADR00 == (0xC0+18))		// Error on WRITE_REG
				Buffer_Param[0x3f] = 0xC0 + 6;	// Retry WRITE_REG
			else if (ADR00 == (0xC0+21))		// Error on SET_CMD(BLOCK_WRITE)
				Buffer_Param[0x3f] = 0xC0 + 18;	// Retry SET_CMD(BLOCK_WRITE)
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_ERASE) {
			if (ADR00 == (0xC0+6))				// Error on SET_R_W_REG_ADRS
				Buffer_Param[0x3f] = 0xC0;		// Retry SET_R_W_REG_ADRS
			else if (ADR00 == (0xC0+12))		// Error on WRITE_REG
				Buffer_Param[0x3f] = 0xC0 + 6;	// Retry WRITE_REG
			else if (ADR00 == (0xC0+15))		// Error on SET_CMD(BLOCK_ERASE)
				Buffer_Param[0x3f] = 0xC0 + 12;	// Retry SET_CMD(BLOCK_ERASE)
			else
				return 0;
		}
		else
			return 0;
	}
	else if (Err_DTCPC == Err_MS_Dwld_Read_CRC) {
		if (DTC_Dwld_Flag == DTC_DWLD_WRITE) {
			if (ADR00 == (0xC0+24))
				Buffer_Param[0x3f] = 0xC0 + 22;	// Retry parameter address
			else if (ADR00 == (0xC0+30))
				Buffer_Param[0x3f] = 0xC0 + 28;	// Retry parameter address
			else if (ADR00 == (0xC0+40))
				Buffer_Param[0x3f] = 0xC0 + 38;	// Retry parameter address
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_COPY) {
			if (ADR00 == (0xC0+24))				// Error on GET_INT
				Buffer_Param[0x3f] = 0xC0 + 22;	// Retry GET_INT
			else if (ADR00 == (0xC0+40))		// Error on GET_INT
				Buffer_Param[0x3f] = 0xC0 + 38;	// Retry GET_INT
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_MARK) {
			if (ADR00 == (0xC0+24))				// Error on GET_INT
				Buffer_Param[0x3f] = 0xC0 + 22;	// Retry GET_INT
			else
				return 0;
		}
		else if (DTC_Dwld_Flag == DTC_DWLD_ERASE) {
			if (ADR00 == (0xC0+18))				// Error on GET_INT
				Buffer_Param[0x3f] = 0xC0 + 16;	// Retry GET_INT
			else
				return 0;
		}
		else
			return 0;
	}
//	else if (Err_DTCPC == Err_MS_Dwld_INT_Timeout)
//		return 0;
//	else if (Err_DTCPC == Err_MS_Dwld_INT)
//		return 0;
	else
		return 0;

	DTC_Process(Run_MS_DTC_Dwld);	// Retry the operation
	Retry_Counter++;
	return 1;
}

const unsigned char Read_Extra_Param[] = {
	SET_R_W_REG_ADRS,
	4,
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x06,				// Write 6 registers
// 6
	WRITE_REG,
	6,					// 6 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8]
	0x00,				// BlockAdrReg0: BlockAdr[7:0]
	0x40,				// 1-page access of Extra Data Area only
	0x00,				// Page Number
// 14
	SET_CMD,
	1,
	BLOCK_READ,
// 17
	0xFF,				// Wait on INT
	0x4E,				// Timeout in 5ms
	0x20,				// Timeout in 5ms
// 20
	READ_REG,
	3,					// Read 3 bytes
	0x55,
	0x55,
	0x55,				// Reserve 3 bytes
// 25
	SET_R_W_REG_ADRS,
	4,
	0x16,				// Read start from REG 16h
	0x04,				// Read 4 registers
	0x10,				// Write Start from REG 10h
	0x06,				// Write 10 registers
// 31
	READ_REG,
	4,					// Read 4 bytes
	0x55,
	0x55,
	0x55,
	0x55,				// Reserve 4 bytes
// 37
	0
};

const unsigned short Logical_Start_Block[16] = {
	0,     494,  990, 1486,		// segment 0-3
	1982, 2478, 2974, 3470,		// segment 4-7
	3966, 4462, 4958, 5454,		// segment 8-11
	5950, 6446, 6942, 7438		// segment 12-15
};

#define INT_Register	Buffer_Param[22]
#define StatusRegister0	Buffer_Param[23]
#define StatusRegister1	Buffer_Param[24]
#define OverWriteFlag	Buffer_Param[33]
#define ManagementFlag	Buffer_Param[34]
#define LogicalAddressH	Buffer_Param[35]
#define LogicalAddressL	Buffer_Param[36]
#define BLOCK_NO_USE	0x0F
#define BLOCK_FREE		0xFF
#define BLOCK_GOOD		0x00
void MS_Scan_Lookup_Table(unsigned short *MS_Lookup_Table, unsigned char segment)
{
	unsigned short Logical_Block;	// This variable can be omitted
	unsigned short Physical_Block;
	unsigned char *ppBlock;
	unsigned short *pBad;

	Load_MS_DTC_Code();

	asm {
		LD		X, #37	// sizeof(Read_Extra_Param) - 1
Copy_Param:
		LD		A, (Read_Extra_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param
	}
	Buffer_Param[0x3f] = 0xC0;		// Parameter list start address

	ppBlock = Buffer_0;
	if (segment == 0) {
		Physical_Block = 2;		// skip the boot block
		ppBlock = Buffer_0 + 2;

		// Mark the first 2 block as can not be used
		Buffer_0[0] = BLOCK_NO_USE;
		Buffer_0[1] = BLOCK_NO_USE;
	}
	else
		Physical_Block = (unsigned short)segment * 512;	// starting block of the segment

	// Initialize the whole lookup table as 0xFFXX
	asm {
		LD		A, MS_Lookup_Table
		PUSH	A			// Save the pointer
		LD		Y, #4
		CLR		X
		LD		A, #0xFF
loop_init_lookup_table:
		LD		([MS_Lookup_Table.w], X), A
		INC		X
		INC		X
		JRNE	loop_init_lookup_table
		INC		MS_Lookup_Table
		DEC		Y
		JRNE	loop_init_lookup_table
		POP		A
		LD		MS_Lookup_Table, A
	}

	No_DTC_Int();
	for ( ; ppBlock != (Buffer_0 + 512); ppBlock++, Physical_Block++) {

	    Buffer_Param[10] = HIBYTE(Physical_Block);	// Block address 8-15
		Buffer_Param[11] = LOBYTE(Physical_Block);	// Block address 0-7
		DTC_Process(Run_MS_DTC);

		if (DTC_Wait_Stop() & 0x02) {	// On Error, retry
			DTC_Process(Run_MS_DTC);
			if (DTC_Wait_Stop() & 0x02)
				return;		// On error, return fail
		}

		// Check INT register that CMDNK=0, CED=1 & ERR=0
		if ( INT_Register & 0x01)				// CMDNK = 1 ?
			goto Mark_No_Use_Block;
		if ( (INT_Register & 0xC0) == 0xC0) {	// CED&ERR=1 ?
			// Check StatusReg1
			if (StatusRegister1 & 0x05)			// UCEX|UCFG=1?
				goto Mark_No_Use_Block;
		}
		else if (( INT_Register & 0xC0) != 0x80)	// CED = 1 ?
			goto Mark_No_Use_Block;

		// Here we have the good ExtraData content
		// Check OverWrite flag
		if ( (OverWriteFlag & 0xE0) != 0xE0)	// BKST=1 && PGST=11?
			goto Mark_No_Use_Block;	// Later defective block or uncorrectable error

		// Check Management flag
		if ( (ManagementFlag & 0x0C) != 0x0C) {	// ATFLG&SYSFLG=1?
Mark_No_Use_Block:
			*ppBlock = BLOCK_NO_USE;			// Mark this block as bad
			continue;	// This block is a boot block or a translation table
		}

		asm {
			LD		X, Buffer_Param[35]	// LogicalAddressH
			LD		A, Buffer_Param[36]	// LogicalAddressL
		//	LD	Logical_Block, X
		//	LD	Logical_Block:1, A
	logical_mapping:
			CP		X, #0xFF
			JRNE	logical_map
			CP		A, #0xFF
			JREQ	end_logical_mapping
	logical_map:
		// Get the logical address offset in this segment
			LD		Y, segment
			SLA		Y
			SUB		A, (Logical_Start_Block:1, Y)
			LD		Logical_Block:1, A
			PUSH	A
			LD		A, X
			SBC		A, (Logical_Start_Block, Y)
			LD		Logical_Block, A	// High byte of the Logical_Block
			POP		X					// Low byte of the Logical_Block	

		// Assign the physical address to that element
			SLA		X
			RLC		A
			LD		Y, MS_Lookup_Table			// Save it to Y register
			ADD		A, MS_Lookup_Table
			LD		MS_Lookup_Table, A

			INC		X
			LD		A, Physical_Block:1
			LD		([MS_Lookup_Table.w], X), A
			DEC		X
			LD		A, Physical_Block
			LD		([MS_Lookup_Table.w], X), A

			LD		MS_Lookup_Table, Y			// Restore it from Y

			// mark this physical block as allocated
			CLR		A
	end_logical_mapping:
			LD		[ppBlock.w], A
		}
	}

	// After mapping, each item in Buffer_0 has the following meaning
	// = 0x00 (BLOCK_GOOD)		the physical block is allocated
	// = 0xFF (BLOCK_FREE)		the physical block is free
	// = 0x0F (BLOCK_NO_USE)	the physical block can not be used
	pBad = MS_Lookup_Table + 512;		// all bad blocks are grouped in the end of the lookup table
	ppBlock = Buffer_0;
	Physical_Block = segment * 512;

	for ( ; MS_Lookup_Table < pBad; MS_Lookup_Table++) {
		if ( HIBYTE(*MS_Lookup_Table) == 0xFF) {	// This logical block is not allocated
			Search_free_block:
				if (*ppBlock == 0xFF) {
					*MS_Lookup_Table = Physical_Block | 0x8000;
		//	*ppBlock = 0;	// Test
					ppBlock++;
					Physical_Block++;
					continue;			// A free physical block is allocated
				}
				if (*ppBlock == 0x0F) {	// Meet a bad physical block
		//	*ppBlock = 0;	// Test
					*(--pBad) = Physical_Block | 0x4000;
				}

				ppBlock++;
				Physical_Block++;
			if (ppBlock != Buffer_0 + 512)
				goto Search_free_block;
			else {
				asm NOP;		// if we are here, there must be sth wrong
				break;
			}
		}
	}

	asm NOP
}

const unsigned char Format_Block_Param[] = {

// STEP 1. Erase the block
// =======================
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x04,				// Write 4 registers
// 6
	WRITE_REG,
	4,					// 4 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8] <<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<
// 12
	SET_CMD,
	1,
	BLOCK_ERASE,
// 15
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 16
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes

// STEP 2. Read and verify the 1st page is 0xFF
// ===========================================
// 19
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x10,				// Write Start from REG 10h
	0x0A,				// Write 10 registers
// 25
	WRITE_REG,
	10,					// 10 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8] <<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]  <<<<<<<<<<<<<<
	0x20,				// CommandParamReg: Page Access
	0x00,				// PageAdrReg: Page 0
	0xFF,				// OverwriteFlag
	0xFF,				// ManagementFlag
	0x00,				// Logical Address
	0x00,				// Logical Address
// 37
	SET_CMD,
	1,
	BLOCK_READ,
// 40
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 41
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 44
	READ_PAGE_DATA,
	0x00,				// Page read
	0x82,
	0x2D,				// CRC value for all FF's

// STEP 3. Write all 0's to the 1st page
// =====================================
// 48
	WRITE_PAGE_DATA,
	0x00,				// Page write

// 50
	SET_CMD,
	1,
	BLOCK_WRITE,
// 53
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 54
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes

// STEP 4. Verify all 0's of the 1st page
// 57
	SET_CMD,
	1,
	BLOCK_READ,
// 60
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 61
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 64
	READ_PAGE_DATA,
	0x00,				// Page read
	0x00,
	0x00,				// CRC value for 0's

// 68
	SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x01,				// Read start from REG 01h
	0x03,				// Read 3 registers
	0x15,				// Write Start from REG 15h
	0x01,				// Write 1 register

// STEP 5. Set the page 1 as the current page
// STEP 6. Read and verify the current page is 0xFF
// ===============================================
// 74
	WRITE_REG,
	1,
	0x01,				// PageAdrReg: Page 1
// 77
	SET_CMD,
	1,
	BLOCK_READ,
// 80
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 81
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 84
	READ_PAGE_DATA,
	0x00,				// Page read, it must be all 0xFF's
	0x82,
	0x2D,				// CRC value for all FF's

// 7. Copy the 1st page to the current page
// ========================================
// 88
	WRITE_REG,
	1,					// 1 bytes to be written
	0x00,				// PageAdrReg: Page 0
// 91
	SET_CMD,
	1,
	BLOCK_READ,			// Read from page0
// 94
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 95
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 98
	WRITE_REG,
	1,					// 1 bytes to be written
	0x01,				// PageAdrReg: Page 1
// 101
	SET_CMD,
	1,
	BLOCK_WRITE,		// Write to the current page
// 104
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 105
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes

// 8. Read and verify the current page is 0's
// =========================================
// 108
	SET_CMD,
	1,
	BLOCK_READ,			// Read the current page
// 111
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 112
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 115
	READ_PAGE_DATA,
	0x00,				// Page read, it must be all 0's
	0x00,
	0x00,				// CRC value for 0's

// 9. Increase the current page number and repeat 6-9
// ==================================================
// 119
	0x00,				// Finish the parameter list
	0x20,				// Loop counter, Number of pages
	76,					// Address of page number for loop control
	100,				// Address of page number for loop control
	74,					// Address of the repeat parameter list

// 124
	SET_CMD,
	1,
	BLOCK_ERASE,
// 127
	0xFF,				// Wait on INT. Timeout value is set as maximum value, about 21.84ms
// 128
	GET_INT,
	1,					// Read 1 bytes
	0x55,				// Reserve 1 bytes
// 131
	0x00,
	0x01,				// Loop counter is 1
	76,					// Dummy count the page number
	100,				// Dummy count the page number
// 135
	0x00,				// No address for repeat
	0x00				// Stop the execution
};

extern unsigned int MAL_Block_Numbers;
void Format_One_Block(void)
{

	if (DTC_Code_Number != CODE_DTC_MS_FORMAT) {
		// Set MemoryStick CRC Polynomia
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0
		SetBit(DTCCTRL,5);		// POLY_LOAD = 1
		DTCCRC_RESERVED = 0x05;	// Write CRC_LSB
		SetBit(DTCCTRL,6);		// POLY_H = 1
		DTCCRC_RESERVED = 0x80;	// Write CRC_MSB
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0

		DTC_Load_Code(MS_DTC_Format);
		DTC_Code_Number = CODE_DTC_MS_FORMAT;

		// Parameter to reset the card for retry
		Buffer_0[0xf0] = SET_CMD;
		Buffer_0[0xf1] = 1;
		Buffer_0[0xf2] = RESET;
		Buffer_0[0xf3] = 0x00;		// End of the loop
		Buffer_0[0xf4] = 0x01;		// Loop counter is 1
		Buffer_0[0xf5] = 0xF7;		// Dummy count the page number
		Buffer_0[0xf6] = 0xF7;		// Dummy count the page number
		Buffer_0[0xf7] = 0x00;		// Dummy page number
		Buffer_0[0xf8] = 0x00;		// Stop the execution

		asm {
			LD		X, #136	// sizeof(Format_Block_Param) - 1
	Copy_Param:
			LD		A, (Format_Block_Param, X)
			LD		(Buffer_0, X), A
			DEC		X
			JRNE	Copy_Param
		}
	}

	Buffer_0[0] = Format_Block_Param[0];

	Buffer_0[10] = MAL_Block_Numbers >> 8;
	Buffer_0[29] = MAL_Block_Numbers >> 8;

	Buffer_0[11] = MAL_Block_Numbers;
	Buffer_0[30] = MAL_Block_Numbers;

	Buffer_0[76] = 1;			// Start from page 1
	Buffer_0[100] = 1;			// Start from page 1

	Buffer_0[120] = malNpage - 1;
	Buffer_0[132] = 1;			// No iteration for post erasing

	Buffer_0[0xff] = 0x00;		// Address of the parameter list (0x100)

	Retry_Counter = 0;
	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Format);
}

unsigned char MS_Retry_Format(void)
{
	unsigned char Err_DTCPC;
	unsigned char ADR00;

	if (Retry_Counter >= 3)
		return 0;
/*
	Err_DTCPC = DTCPC;
	Read_DTC_Registers();

	ADR00 = Buffer_Param[-15];
	if (Err_DTCPC == Err_MS_Format_RDY_Timeout) {
		if (ADR00 == 6)			// Error on SET_R_W_REG_ADRS
			ADR00 = 0;			// Retry SET_R_W_REG_ADRS
		else if (ADR00 == 12)	// Error on WRITE_REG
			ADR00 = 6;			// Retry WRITE_REG
		else if (ADR00 == 15)	// Error on SET_CMD(BLOCK_ERASE)
			ADR00 = 12;			// Retry SET_CMD(BLOCK_ERASE)
		else if (ADR00 == 25)	// Error on SET_R_W_REG_ADRS
			ADR00 = 19;			// Retry SET_R_W_REG_ADRS
		else if (ADR00 == 37)	// Error on WRITE_REG
			ADR00 = 25;			// Retry WRITE_REG
		else if (ADR00 == 40)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 37;			// Retry SET_CMD(BLOCK_READ)
		else if (ADR00 == 50)	// Error on WRITE_PAGE_DATA
			ADR00 = 48;			// Retry WRITE_PAGE_DATA
		else if (ADR00 == 53)	// Error on SET_CMD(BLOCK_WRITE)
			ADR00 = 50;			// Retry SET_CMD(BLOCK_WRITE)
		else if (ADR00 == 60)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 57;			// Retry SET_CMD(BLOCK_READ)
		else if (ADR00 == 74)	// Error on SET_R_W_REG_ADRS
			ADR00 = 68;			// Retry SET_R_W_REG_ADRS
		else if (ADR00 == 77)	// Error on WRITE_REG
			ADR00 = 74;			// Retry WRITE_REG
		else if (ADR00 == 80)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 77;			// Retry SET_CMD(BLOCK_READ)
		else if (ADR00 == 91)	// Error on WRITE_REG
			ADR00 = 88;			// Retry WRITE_REG
		else if (ADR00 == 94)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 91;			// Retry SET_CMD(BLOCK_READ)
		else if (ADR00 == 101)	// Error on WRITE_REG
			ADR00 = 98;			// Retry WRITE_REG
		else if (ADR00 == 104)	// Error on SET_CMD(BLOCK_WRITE)
			ADR00 = 101;		// Retry SET_CMD(BLOCK_WRITE)
		else if (ADR00 == 111)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 108;		// Retry SET_CMD(BLOCK_READ)
		else if (ADR00 == 127)	// Error on SET_CMD(BLOCK_READ)
			ADR00 = 124;		// Retry SET_CMD(BLOCK_READ)

		else if (ADR00 == 46) 	// Error on READ_PAGE_DATA
			ADR00 = 44;
		else if (ADR00 == 66) 	// Error on READ_PAGE_DATA
			ADR00 = 64;
		else if (ADR00 == 86) 	// Error on READ_PAGE_DATA
			ADR00 = 84;
		else if (ADR00 == 117)	// Error on READ_PAGE_DATA
			ADR00 = 115;
		else
			return 0;
	}
	else if (Err_DTCPC == Err_MS_Format_Read_CRC) {
		if (ADR00 == 19)		// Error on GET_INT
			ADR00 = 16;			// Retry GET_INT
		else if (ADR00 == 44)	// Error on GET_INT
			ADR00 = 41;			// Retry GET_INT
		else if (ADR00 == 57)	// Error on GET_INT
			ADR00 = 54;			// Retry GET_INT
		else if (ADR00 == 64)	// Error on GET_INT
			ADR00 = 61;			// Retry GET_INT
		else if (ADR00 == 84)	// Error on GET_INT
			ADR00 = 81;			// Retry GET_INT
		else if (ADR00 == 98)	// Error on GET_INT
			ADR00 = 95;			// Retry GET_INT
		else if (ADR00 == 108)	// Error on GET_INT
			ADR00 = 105;		// Retry GET_INT
		else if (ADR00 == 115)	// Error on GET_INT
			ADR00 = 112;		// Retry GET_INT
		else if (ADR00 == 131)	// Error on GET_INT
			ADR00 = 128;		// Retry GET_INT
		else if (ADR00 == 46) 	// Error on READ_PAGE_DATA
			ADR00 = 44;			// Read 0xFF of page 0
		else if (ADR00 == 66) 	// Error on READ_PAGE_DATA
			ADR00 = 64;			// Read 0x00 of page 0
		else if (ADR00 == 86) 	// Error on READ_PAGE_DATA
			ADR00 = 84;			// Read 0xFF of page N
		else if (ADR00 == 117)	// Error on READ_PAGE_DATA
			ADR00 = 115;		// Read 0x00 of page N
		else
			return 0;
	}
//	else if (Err_DTCPC == Err_MS_Format_INT_Timeout)
//	else if (Err_DTCPC == Err_MS_Format_Page)
//	else if (Err_DTCPC == Err_MS_Format_INT)
	else
		return 0;
*/
	// Reset the card for retry
	Buffer_0[0xf4] = 0x01;		// Loop counter is 1
	Buffer_0[0xff] = 0xF0;	// Reset parameter list

	No_DTC_Int();
	DTC_Process(Run_MS_DTC_Format);
	DTC_Wait_Stop();

	Buffer_0[76] = 1;
	Buffer_0[100] = 1;

	Buffer_0[120] = malNpage - 1;

	Buffer_0[0xff] = 0;		// Retry format the same block

	Enable_DTC_Int();
	DTC_Process(Run_MS_DTC_Format);
	Retry_Counter++;
	return 1;
}

const unsigned char Search_Address_Param[] = {
    SET_R_W_REG_ADRS,
	4,					// 4 bytes to be written
	0x16,				// Read start from REG 16H
	0x04,				// Read 4 registers
	0x10,				// Write Start from REG 10H
	0x06,				// Write 6 registers
// 6
	WRITE_REG,
	6,					// 6 bytes to be written
	0x80,				// System Parameter: Block address mode
	0x00,				// BlockAdrReg2: BlockAdr[23:16]
	0x00,				// BlockAdrReg1: BlockAdr[15:8] <<<<<<<<<<<<<<
	0x00,				// BlockAdrReg0: BlockAdr[7:0]	<<<<<<<<<<<<<<
	0x40,				// CommandParamReg: 1-page access of Extra Data Area only
	0x00,				// Page Number
// 14
	SET_CMD,
	1,
	BLOCK_READ,
// 17
	0x00,				// Wait on INT
// 18
	GET_INT,			// Read INT register
	1,
	0x55,				// Reserve 1 bytes
// 21
	READ_REG,
	4,
	0x55,
	0x55,
	0x55,
	0x55,				// Reserve 4 bytes
// 27
	0x00,				// Number of logical addresses to be mapped
//////////////////////////////////////////////////////////////////
//
// Some addresses for search, maximum 8 logical addresses
//
//////////////////////////////////////////////////////////////////
// 28+??
	0x00,				// Counter of the logical address list
	0x00,				// The end condition of the physical address
	0xC0 + 11,			// Pointer of the lowest byte of physical address
};

// Search the physical mapping of the logical address list
// malPaddr is the start address of the segment
// malNpage is the number of addresses in the Adr_list
unsigned char MS_DTC_Search_Addrs(unsigned short *Adr_list)
{
	if (DTC_Code_Number != CODE_DTC_MS_SEARCH) {
		// Set MemoryStick CRC Polynomia
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0
		SetBit(DTCCTRL,5);		// POLY_LOAD = 1
		DTCCRC_RESERVED = 0x05;	// Write CRC_LSB
		SetBit(DTCCTRL,6);		// POLY_H = 1
		DTCCRC_RESERVED = 0x80;	// Write CRC_MSB
		ClrBit(DTCCTRL,6);		// POLY_H = 0
		ClrBit(DTCCTRL,5);		// POLY_LOAD = 0

		DTC_Load_Code(MS_DTC_Search);
		DTC_Code_Number = CODE_DTC_MS_SEARCH;
	}

	Buffer_Param[0] = Adr_list[0];
	asm {
		LD		X, #27	// sizeof(Search_Address_Param) - 1
Copy_Param:
		LD		A, (Search_Address_Param, X)
		LD		(Buffer_Param, X), A
		DEC		X
		JRPL	Copy_Param

		LD		X, malNpage
		SLL		X

		LD		A, malNpage
		LD		(Buffer_Param:28, X), A	// Counter of the logical address list
//		LD		(Buffer_Param:29, X), A	// The end condition of the physical address
		LD		A, Search_Address_Param:30
		LD		(Buffer_Param:30, X), A	// Pointer of the lowest byte of physical address

		DEC		X
Copy_Adr_List:
		LD		A, ([Adr_list.w], X)
		LD		(Buffer_Param:28, X), A
		DEC		X
		JRPL	Copy_Adr_List
	}
	Buffer_Param[27] = malNpage;

	Buffer_Param[10] = ((unsigned char *)(&(malPaddr)))[2];
	Buffer_Param[11] = ((unsigned char *)(&(malPaddr)))[3];

	No_DTC_Int();
	DTC_Process(Run_MS_DTC_Search);
	DTC_Wait_Stop();
}

const unsigned short Address_List[] = {
	0x0103, 0x102
};

void MS_DTC_Test(void)
{
	malPaddr = 0x100;
	malNpage = 2;
	MS_DTC_Search_Addrs(Address_List);
	asm NOP;
}
/****** (c) 1999   STMicroelectronics *************** END OF FILE *************/
