/**************** (c) 2000  STMicroelectronics **********************

PROJECT : USB - ST7 FULL SPEED

VERSION :  v 0.96

CREATION DATE :  01/12/2000

AUTHOR : MICROCONTROLLER DIVISION / ST Rousset

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

MODIFICATIONS : 

******************************************************************************/

#ifndef CONDCOMP_H
#define CONDCOMP_H

#define USE_ST7265
//#define USE_ST72SCR

//#define USE_SOF_COUNTER 
//#define USE_SOF_INT
#define PIMC_COMPATIBILITY
//#define USE_ALTERNATE_SETTING 

// If you want to send more than MAX_EP1_PACKET_SIZE bytes on EP1, use this function
//#define XMIT_LONG_DATA_EP1

// If you want to send more than MAX_EP2_PACKET_SIZE bytes on EP2, use this function
//#define XMIT_LONG_DATA_EP2 

// for not continuous descriptors data 
//#define NOT_CONTINUOUS_DATA

// For test only
//#define OBS_MODE   

//efine USE_HID_REQUEST

#ifdef USE_ST7265
	#define MAX_PACKET_SIZE		16		// Maximum payload on EP0
	#define MAX_EP1_PACKET_SIZE	16		// Maximum payload on EP1
	#define MAX_EP2_PACKET_SIZE	64		// Maximum payload on EP2
#endif
#ifdef USE_ST72SCR
	#define MAX_PACKET_SIZE		8		// Maximum payload on EP0
	#define MAX_EP1_PACKET_SIZE	8		// Maximum payload on EP1
	#define MAX_EP2_PACKET_SIZE	64		// Maximum payload on EP2
	#define MAX_EP3_PACKET_SIZE	8		// Maximum payload on EP3
	#define MAX_EP4_PACKET_SIZE	8		// Maximum payload on EP4
	#define MAX_EP5_PACKET_SIZE	8		// Maximum payload on EP5
#endif

/********************************************************************************************/
/*					DO  NOT  MODIFY  NOR  REMOVE  FOLLOWING SECTION							*/
/********************************************************************************************/
#ifdef USE_ST7265
#define MAP_FILE	"map_7265.h"
#endif

#ifdef USE_ST72SCR
#define MAP_FILE	"map_72SCR.h"
#endif

/********************************************************************/

#endif

/**************** (c) 2000  STMicroelectronics **********************/
