/*****************************************************
 hidef.h - ANSI-C library: machine dependent stuff
 ----------------------------------------------------
   Copyright (c) HIWARE AG, Basel, Switzerland
               All rights reserved               
                  Do not modify!
 *****************************************************/

#ifndef _H_HIDEF_
#define _H_HIDEF_

#ifdef __cplusplus
extern "C" {
#endif

#define _FAR far

/**** Version for STMicroelectronics ST7 */

#include "stddef.h"
#include "stdtypes.h"

#define CLOCKS_PER_SEC 4000000 /* has to be user defined */
#pragma NO_STRING_CONSTR  /* allow '#' in HLI below */

#define HALTX(z)           {__asm LD A,#z; __asm TRAP; }
#define HALT_0             {__asm CLR A; __asm TRAP;}
#define HALT_AND_QUIT      {__asm LD A,#32; __asm TRAP; }
#define EnableInterrupts   {__asm RIM;}
#define DisableInterrupts  {__asm SIM;}

#define INIT_SP_FROM_STARTUP_DESC() __asm RSP;

void SaveLong(char *mem);
/** save the space in the zeropage used for long arithmetic to the mem location */
/** The pointer mem must point to a memory location of atleast 24 bytes */
void RestoreLong(char *mem);void SaveLong(char *mem);

void SaveFloat(char *mem);
/** save the space in the zeropage used for float arithmetic to the mem location */
/** The pointer mem must point to a memory location of atleast 23 bytes */
void RestoreFloat(char *mem);void SaveLong(char *mem);

		

#ifdef __cplusplus
 }
#endif

#endif

/*****************************************************/
/* end hidef.h */
